/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.SortedSet;
import java.util.TreeSet;
import net.java.sip.communicator.impl.protocol.irc.IrcStatusEnum;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;

public class ChatRoomMemberIrcImpl
implements ChatRoomMember {
    private static final Logger LOGGER = Logger.getLogger(ChatRoomMemberIrcImpl.class);
    private final ChatRoom chatRoom;
    private String contactID;
    private final String ident;
    private final String hostname;
    private final ProtocolProviderServiceIrcImpl parentProvider;
    private final SortedSet<ChatRoomMemberRole> roles = new TreeSet<ChatRoomMemberRole>();
    private IrcStatusEnum status;

    public ChatRoomMemberIrcImpl(ProtocolProviderServiceIrcImpl parentProvider, ChatRoom chatRoom, String contactID, String ident, String hostname, ChatRoomMemberRole chatRoomMemberRole, IrcStatusEnum status) {
        if (parentProvider == null) {
            throw new IllegalArgumentException("parent protocol provider cannot be null");
        }
        this.parentProvider = parentProvider;
        if (chatRoom == null) {
            throw new IllegalArgumentException("chat room instance cannot be null");
        }
        this.chatRoom = chatRoom;
        if (contactID == null) {
            throw new IllegalArgumentException("contact ID cannot be null");
        }
        this.contactID = contactID;
        if (ident == null) {
            throw new IllegalArgumentException("ident cannot be null");
        }
        this.ident = ident;
        if (hostname == null) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
        this.hostname = hostname;
        if (chatRoomMemberRole == null) {
            throw new IllegalArgumentException("member role cannot be null");
        }
        this.roles.add(chatRoomMemberRole);
        if (status == null) {
            throw new IllegalArgumentException("status cannot be null");
        }
        this.status = status;
    }

    public ChatRoom getChatRoom() {
        return this.chatRoom;
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.parentProvider;
    }

    public String getContactAddress() {
        return this.contactID;
    }

    public String getIdent() {
        return this.ident;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getName() {
        return this.contactID;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("newName cannot be null");
        }
        this.contactID = newName;
    }

    public ChatRoomMemberRole getRole() {
        return this.roles.first();
    }

    public void setRole(ChatRoomMemberRole chatRoomMemberRole) {
        LOGGER.debug((Object)"Ignoring request to set member role.");
    }

    void addRole(ChatRoomMemberRole role) {
        this.roles.add(role);
    }

    void removeRole(ChatRoomMemberRole role) {
        this.roles.remove(role);
    }

    public byte[] getAvatar() {
        return null;
    }

    public Contact getContact() {
        return this.parentProvider.getPersistentPresence().findContactByID(this.contactID);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.contactID.hashCode();
        result = 31 * result + ((Object)((Object)this.parentProvider)).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChatRoomMemberIrcImpl other = (ChatRoomMemberIrcImpl)obj;
        if (!this.contactID.equals(other.contactID)) {
            return false;
        }
        return ((Object)((Object)this.parentProvider)).equals((Object)other.parentProvider);
    }

    public PresenceStatus getPresenceStatus() {
        return this.status;
    }

    IrcStatusEnum setPresenceStatus(IrcStatusEnum status) {
        IrcStatusEnum previous = this.status;
        this.status = status;
        return previous;
    }

    public String getDisplayName() {
        return null;
    }
}

