/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import net.java.sip.communicator.impl.protocol.irc.Color;

public abstract class ControlChar {
    private final String tag;

    private ControlChar(String htmlTag) {
        this.tag = htmlTag;
    }

    public String getTag() {
        return this.tag;
    }

    public String getHtmlStart() {
        return "<" + this.tag + ">";
    }

    public String getHtmlEnd() {
        return "</" + this.tag + ">";
    }

    static abstract class Normal
    extends ControlChar {
        public static final char CODE = '\u000f';

        private Normal() {
            super(null);
        }
    }

    static class ColorFormat
    extends ControlChar {
        public static final char CODE = '\u0003';
        private final Color foreground;
        private final Color background;

        ColorFormat(Color foreground, Color background) {
            super("font");
            this.foreground = foreground;
            this.background = background;
        }

        @Override
        public String getHtmlStart() {
            StringBuilder result = new StringBuilder("<");
            result.append(this.getTag());
            if (this.foreground != null) {
                result.append(" color=\"");
                result.append(this.foreground.getHtml());
                result.append("\"");
            }
            if (this.background != null) {
                result.append(" bgcolor=\"");
                result.append(this.background.getHtml());
                result.append("\"");
            }
            result.append('>');
            return result.toString();
        }
    }

    static class Underline
    extends ControlChar {
        public static final char CODE = '\u001f';

        Underline() {
            super("u");
        }
    }

    static class Italics
    extends ControlChar {
        public static final char CODE = '\u0016';

        Italics() {
            super("i");
        }
    }

    static class Bold
    extends ControlChar {
        public static final char CODE = '\u0002';

        Bold() {
            super("b");
        }
    }
}

