/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.jabberaccregwizz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccRegWizzActivator;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccountRegistrationForm;
import net.java.sip.communicator.plugin.jabberaccregwizz.Resources;
import net.java.sip.communicator.plugin.jabberaccregwizz.ValidatingPanel;
import net.java.sip.communicator.service.certificate.CertificateConfigEntry;
import net.java.sip.communicator.service.protocol.jabber.JabberAccountID;
import org.apache.commons.lang3.StringUtils;

public class ConnectionPanel
extends TransparentPanel
implements ValidatingPanel {
    private static final long serialVersionUID = 0L;
    private final TransparentPanel mainPanel = new TransparentPanel();
    private final JPanel advancedOpPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private final JPanel serverOpPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private final JPanel labelsAdvOpPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
    private final JPanel valuesAdvOpPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
    private final JCheckBox sendKeepAliveBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.ENABLE_KEEP_ALIVE"));
    private final JCheckBox googleContactsBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.ENABLE_GOOGLE_CONTACTS_SOURCE"));
    private final JLabel resourceLabel = new JLabel(Resources.getString("plugin.jabberaccregwizz.RESOURCE"));
    private final JTextField resourceField = new JTextField(JabberAccountID.getDefaultStr((String)"RESOURCE"));
    private final JLabel priorityLabel = new JLabel(Resources.getString("plugin.jabberaccregwizz.PRIORITY"));
    private final JTextField priorityField = new JTextField(JabberAccountID.getDefaultStr((String)"RESOURCE_PRIORITY"));
    private final JCheckBox serverAutoCheckBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.OVERRIDE_SERVER_DEFAULT_OPTIONS"), JabberAccountID.getDefaultBool((String)"IS_SERVER_OVERRIDDEN"));
    private final JLabel serverLabel = new JLabel(Resources.getString("plugin.jabberaccregwizz.SERVER"));
    private final JTextField serverField = new JTextField();
    private final JLabel portLabel = new JLabel(Resources.getString("service.gui.PORT"));
    private final JTextField portField = new JTextField(JabberAccountID.getDefaultStr((String)"SERVER_PORT"));
    private final JCheckBox autoGenerateResource = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.AUTORESOURCE"), JabberAccountID.getDefaultBool((String)"AUTO_GENERATE_RESOURCE"));
    JCheckBox allowNonSecureBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.ALLOW_NON_SECURE"), JabberAccountID.getDefaultBool((String)"ALLOW_NON_SECURE"));
    JCheckBox disableCarbon = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.DISABLE_CARBON"), JabberAccountID.getDefaultBool((String)"CARBON_DISABLED"));
    private JComboBox dtmfMethodBox = new JComboBox<Object>(new Object[]{Resources.getString("plugin.jabberaccregwizz.DTMF_AUTO"), Resources.getString("plugin.sipaccregwizz.DTMF_RTP"), Resources.getString("plugin.sipaccregwizz.DTMF_INBAND")});
    private JTextField dtmfMinimalToneDurationValue = new JTextField();
    private final JLabel certificateLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.CLIENT_CERTIFICATE"));
    private final JComboBox certificate = new JComboBox();
    private final JabberAccountRegistrationForm parentForm;

    public ConnectionPanel(JabberAccountRegistrationForm parentForm) {
        super((LayoutManager)new BorderLayout());
        this.parentForm = parentForm;
        parentForm.addValidatingPanel(this);
        this.mainPanel.setLayout((LayoutManager)new BoxLayout((Container)this.mainPanel, 1));
        this.portField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                ConnectionPanel.this.setNextButtonAccordingToPortAndPriority();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                ConnectionPanel.this.setNextButtonAccordingToPortAndPriority();
            }
        });
        this.priorityField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                ConnectionPanel.this.setNextButtonAccordingToPortAndPriority();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                ConnectionPanel.this.setNextButtonAccordingToPortAndPriority();
            }
        });
        this.serverAutoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPanel.this.enablesServerAutoConfigure(ConnectionPanel.this.serverAutoCheckBox.isSelected());
            }
        });
        this.serverAutoCheckBox.setSelected(parentForm.getRegistration().isServerOverridden());
        this.enablesServerAutoConfigure(this.serverAutoCheckBox.isSelected());
        this.labelsAdvOpPanel.add(this.serverLabel);
        this.labelsAdvOpPanel.add(this.portLabel);
        this.labelsAdvOpPanel.add(this.certificateLabel);
        this.valuesAdvOpPanel.add(this.serverField);
        this.valuesAdvOpPanel.add(this.portField);
        this.valuesAdvOpPanel.add(this.certificate);
        this.initCertificateAliases(null);
        this.serverOpPanel.add((Component)this.serverAutoCheckBox, "North");
        this.serverOpPanel.add((Component)this.labelsAdvOpPanel, "West");
        this.serverOpPanel.add((Component)this.valuesAdvOpPanel, "Center");
        this.serverOpPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.jabberaccregwizz.SERVER_OPTIONS")));
        TransparentPanel checkBoxesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        checkBoxesPanel.add(this.googleContactsBox);
        checkBoxesPanel.add(this.allowNonSecureBox);
        checkBoxesPanel.add(this.disableCarbon);
        TransparentPanel resourcePanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        resourcePanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.jabberaccregwizz.RESOURCE")));
        resourcePanel.add((Component)this.autoGenerateResource, "North");
        TransparentPanel resSubPanelLabel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        TransparentPanel resSubPanelValue = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        resSubPanelLabel.add(this.resourceLabel);
        resSubPanelLabel.add(this.priorityLabel);
        resSubPanelValue.add(this.resourceField);
        resSubPanelValue.add(this.priorityField);
        resourcePanel.add((Component)resSubPanelLabel, "West");
        resourcePanel.add((Component)resSubPanelValue, "Center");
        this.googleContactsBox.setSelected(true);
        this.advancedOpPanel.add((Component)checkBoxesPanel, "North");
        this.advancedOpPanel.add((Component)this.serverOpPanel, "Center");
        this.advancedOpPanel.add((Component)resourcePanel, "South");
        if (this.autoGenerateResource.isSelected()) {
            this.resourceField.setEnabled(false);
        }
        this.autoGenerateResource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPanel.this.resourceField.setEnabled(!ConnectionPanel.this.autoGenerateResource.isSelected());
            }
        });
        this.mainPanel.add((Component)this.advancedOpPanel);
        this.mainPanel.add(this.createDTMFPanel());
        String serverAddress = parentForm.getServerAddress();
        if (StringUtils.isNotEmpty((CharSequence)serverAddress)) {
            this.serverField.setText(serverAddress);
        }
        this.add((Component)this.mainPanel, "North");
    }

    private Component createDTMFPanel() {
        TransparentPanel emptyLabelPanel = new TransparentPanel();
        TransparentPanel dtmfLabels = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 5, 5));
        JLabel dtmfMethodLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.DTMF_METHOD"));
        JLabel minimalDTMFToneDurationLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.DTMF_MINIMAL_TONE_DURATION"));
        dtmfLabels.add(dtmfMethodLabel);
        dtmfLabels.add(minimalDTMFToneDurationLabel);
        dtmfLabels.add((Component)emptyLabelPanel);
        TransparentPanel dtmfValues = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 5, 5));
        this.dtmfMethodBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isEnabled = false;
                String selectedItem = (String)ConnectionPanel.this.dtmfMethodBox.getSelectedItem();
                if (selectedItem != null && (selectedItem.equals(Resources.getString("plugin.sipaccregwizz.DTMF_AUTO")) || selectedItem.equals(Resources.getString("plugin.sipaccregwizz.DTMF_RTP")))) {
                    isEnabled = true;
                }
                ConnectionPanel.this.dtmfMinimalToneDurationValue.setEnabled(isEnabled);
            }
        });
        JLabel dtmfMinimalToneDurationExampleLabel = new JLabel(Resources.getString("plugin.sipaccregwizz.DTMF_MINIMAL_TONE_DURATION_INFO"));
        dtmfMinimalToneDurationExampleLabel.setForeground(Color.GRAY);
        dtmfMinimalToneDurationExampleLabel.setFont(dtmfMinimalToneDurationExampleLabel.getFont().deriveFont(8));
        dtmfMinimalToneDurationExampleLabel.setMaximumSize(new Dimension(40, 35));
        dtmfMinimalToneDurationExampleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        dtmfValues.add(this.dtmfMethodBox);
        dtmfValues.add(this.dtmfMinimalToneDurationValue);
        dtmfValues.add(dtmfMinimalToneDurationExampleLabel);
        TransparentPanel dtmfPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        dtmfPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.sipaccregwizz.DTMF")));
        dtmfPanel.add((Component)dtmfLabels, "West");
        dtmfPanel.add((Component)dtmfValues, "Center");
        return dtmfPanel;
    }

    String getServerAddress() {
        return this.serverField.getText();
    }

    void setServerAddress(String serverAddress) {
        this.serverField.setText(serverAddress);
    }

    String getServerPort() {
        return this.portField.getText();
    }

    void setServerPort(String serverPort) {
        this.portField.setText(serverPort);
    }

    String getResource() {
        return this.resourceField.getText();
    }

    void setResource(String resource) {
        this.resourceField.setText(resource);
    }

    String getPriority() {
        return this.priorityField.getText();
    }

    void setPriority(String priority) {
        this.priorityField.setText(priority);
    }

    boolean isSendKeepAlive() {
        return this.sendKeepAliveBox.isSelected();
    }

    void setSendKeepAlive(boolean isSendKeepAlive) {
        this.sendKeepAliveBox.setSelected(isSendKeepAlive);
    }

    boolean isGoogleContactsEnabled() {
        return this.googleContactsBox.isSelected();
    }

    void setGoogleContactsEnabled(boolean isEnabled) {
        this.googleContactsBox.setSelected(isEnabled);
    }

    private void setNextButtonAccordingToPortAndPriority() {
        try {
            Integer.parseInt(this.getServerPort());
            Integer.parseInt(this.getPriority());
            this.parentForm.reValidateInput();
        }
        catch (NumberFormatException ex) {
            this.parentForm.reValidateInput();
        }
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    void setAutogenerateResource(boolean value) {
        this.autoGenerateResource.setSelected(value);
        this.resourceField.setEnabled(!value);
    }

    boolean isAutogenerateResourceEnabled() {
        return this.autoGenerateResource.isSelected();
    }

    void setAllowNonSecure(boolean value) {
        this.allowNonSecureBox.setSelected(value);
    }

    boolean isAllowNonSecure() {
        return this.allowNonSecureBox.isSelected();
    }

    void setDisableCarbon(boolean value) {
        this.disableCarbon.setSelected(value);
    }

    boolean isCarbonDisabled() {
        return this.disableCarbon.isSelected();
    }

    String getDTMFMethod() {
        Object selItem = this.dtmfMethodBox.getSelectedItem();
        if (selItem == null) {
            return null;
        }
        String selString = selItem.toString();
        if (selString.equals(Resources.getString("plugin.sipaccregwizz.DTMF_RTP"))) {
            return "RTP_DTMF";
        }
        if (selString.equals(Resources.getString("plugin.sipaccregwizz.DTMF_INBAND"))) {
            return "INBAND_DTMF";
        }
        return "AUTO_DTMF";
    }

    void setDTMFMethod(String dtmfMethod) {
        if (dtmfMethod == null) {
            this.dtmfMethodBox.setSelectedItem(0);
        } else {
            String selString = dtmfMethod.equals("RTP_DTMF") ? Resources.getString("plugin.sipaccregwizz.DTMF_RTP") : (dtmfMethod.equals("INBAND_DTMF") ? Resources.getString("plugin.sipaccregwizz.DTMF_INBAND") : Resources.getString("plugin.jabberaccregwizz.DTMF_AUTO"));
            this.dtmfMethodBox.setSelectedItem(selString);
        }
    }

    String getDtmfMinimalToneDuration() {
        return this.dtmfMinimalToneDurationValue.getText();
    }

    void setDtmfMinimalToneDuration(String dtmfMinimalToneDuration) {
        this.dtmfMinimalToneDurationValue.setText(dtmfMinimalToneDuration);
    }

    void setServerOverridden(boolean isServerOverridden) {
        this.serverAutoCheckBox.setSelected(isServerOverridden);
        this.enablesServerAutoConfigure(this.serverAutoCheckBox.isSelected());
    }

    boolean isServerOverridden() {
        return this.serverAutoCheckBox.isSelected();
    }

    void enablesServerAutoConfigure(boolean isEnable) {
        this.serverAutoCheckBox.setSelected(isEnable);
        this.serverField.setEnabled(isEnable);
        this.portField.setEnabled(isEnable);
        this.parentForm.reValidateInput();
    }

    public void setClientTlsCertificateId(String certificateId) {
        this.initCertificateAliases(certificateId);
    }

    String getClientTlsCertificateId() {
        if (this.certificate.getSelectedItem() != null && this.certificate.getSelectedItem() instanceof CertificateConfigEntry) {
            return ((CertificateConfigEntry)this.certificate.getSelectedItem()).getId();
        }
        return null;
    }

    private void initCertificateAliases(String id) {
        this.certificate.removeAllItems();
        this.certificate.insertItemAt(Resources.getString("plugin.sipaccregwizz.NO_CERTIFICATE"), 0);
        this.certificate.setSelectedIndex(0);
        for (CertificateConfigEntry e : JabberAccRegWizzActivator.getCertificateService().getClientAuthCertificateConfigs()) {
            this.certificate.addItem(e);
            if (!e.getId().equals(id)) continue;
            this.certificate.setSelectedItem(e);
        }
    }
}

