/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.jabberaccregwizz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.jabberaccregwizz.Resources;
import net.java.sip.communicator.service.protocol.JingleNodeDescriptor;
import net.java.sip.communicator.service.protocol.StunServerDescriptor;
import net.java.sip.communicator.util.NetworkUtils;
import org.apache.commons.lang3.StringUtils;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class IceConfigPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private final JCheckBox iceBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.USE_ICE"));
    private final JCheckBox autoDiscoverBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.AUTO_DISCOVER_STUN"));
    private final JCheckBox defaultStunBox = new SIPCommCheckBox(Resources.getResources().getI18NString("plugin.jabberaccregwizz.USE_DEFAULT_STUN_SERVER", new String[]{Resources.getResources().getSettingsString("service.gui.APPLICATION_NAME")}));
    private final ServerTableModel tableModel = new ServerTableModel();
    private final JTable table = new JTable(this.tableModel);
    private final JCheckBox jnBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.USE_JINGLE_NODES"));
    private final JCheckBox jnAutoDiscoverBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.AUTO_DISCOVER_JN"));
    private final JCheckBox upnpBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.USE_UPNP"));
    private final ServerTableModel jnTableModel = new ServerTableModel();
    private final JTable jnTable = new JTable(this.jnTableModel);

    public IceConfigPanel() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.iceBox.setAlignmentX(0.0f);
        this.autoDiscoverBox.setAlignmentX(0.0f);
        this.defaultStunBox.setAlignmentX(0.0f);
        this.iceBox.setSelected(true);
        this.autoDiscoverBox.setSelected(true);
        this.defaultStunBox.setSelected(true);
        this.jnBox.setSelected(true);
        this.jnAutoDiscoverBox.setSelected(true);
        this.upnpBox.setSelected(true);
        TransparentPanel checkBoxPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
        checkBoxPanel.add(this.iceBox);
        checkBoxPanel.add(this.upnpBox);
        checkBoxPanel.add(this.autoDiscoverBox);
        checkBoxPanel.add(this.defaultStunBox);
        this.add((Component)checkBoxPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(this.createAdditionalServersComponent());
        checkBoxPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
        checkBoxPanel.add(this.jnBox);
        checkBoxPanel.add(this.jnAutoDiscoverBox);
        this.add((Component)checkBoxPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(this.createAdditionalJingleNodesComponent());
    }

    private Component createAdditionalServersComponent() {
        this.table.setPreferredScrollableViewportSize(new Dimension(450, 60));
        this.tableModel.addColumn(Resources.getString("plugin.jabberaccregwizz.IP_ADDRESS") + "/" + Resources.getString("service.gui.PORT"));
        this.tableModel.addColumn(Resources.getString("plugin.jabberaccregwizz.SUPPORT_TURN"));
        this.table.setDefaultRenderer(StunServerDescriptor.class, new ServerCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.table);
        JButton addButton = new JButton(Resources.getString("service.gui.ADD"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StunConfigDialog stunDialog = new StunConfigDialog(false);
                stunDialog.setModal(true);
                stunDialog.setVisible(true);
            }
        });
        final JButton editButton = new JButton(Resources.getString("service.gui.EDIT"));
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IceConfigPanel.this.table.getSelectedRow() < 0) {
                    return;
                }
                StunServerDescriptor stunServer = (StunServerDescriptor)IceConfigPanel.this.tableModel.getValueAt(IceConfigPanel.this.table.getSelectedRow(), 0);
                if (stunServer != null) {
                    String userName = StringUtils.toEncodedString((byte[])stunServer.getUsername(), (Charset)StandardCharsets.UTF_8);
                    String password = StringUtils.toEncodedString((byte[])stunServer.getPassword(), (Charset)StandardCharsets.UTF_8);
                    StunConfigDialog dialog = new StunConfigDialog(stunServer.getAddress(), stunServer.getPort(), stunServer.isTurnSupported(), userName, password);
                    dialog.setModal(true);
                    dialog.setVisible(true);
                }
            }
        });
        JButton deleteButton = new JButton(Resources.getString("service.gui.DELETE"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IceConfigPanel.this.tableModel.removeRow(IceConfigPanel.this.table.getSelectedRow());
            }
        });
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        buttonsPanel.add((Component)addButton);
        buttonsPanel.add((Component)editButton);
        buttonsPanel.add((Component)deleteButton);
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        mainPanel.setBorder((Border)BorderFactory.createTitledBorder(Resources.getString("plugin.jabberaccregwizz.ADDITIONAL_STUN_SERVERS")));
        mainPanel.add((Component)scrollPane);
        mainPanel.add((Component)buttonsPanel, (Object)"South");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getComponent().isEnabled() && evt.getButton() == 1 && evt.getClickCount() == 2) {
                    editButton.doClick();
                }
            }
        });
        return mainPanel;
    }

    protected boolean isUseIce() {
        return this.iceBox.isSelected();
    }

    protected void setUseIce(boolean isUseIce) {
        this.iceBox.setSelected(isUseIce);
    }

    protected boolean isAutoDiscoverStun() {
        return this.autoDiscoverBox.isSelected();
    }

    protected void setAutoDiscoverStun(boolean isAutoDiscover) {
        this.autoDiscoverBox.setSelected(isAutoDiscover);
    }

    protected boolean isUseDefaultStunServer() {
        return this.defaultStunBox.isSelected();
    }

    protected void setUseDefaultStunServer(boolean isDefaultStun) {
        this.defaultStunBox.setSelected(isDefaultStun);
    }

    protected List<StunServerDescriptor> getAdditionalStunServers() {
        LinkedList<StunServerDescriptor> serversList = new LinkedList<StunServerDescriptor>();
        Vector<Vector> serverRows = this.tableModel.getDataVector();
        for (Vector row : serverRows) {
            serversList.add((StunServerDescriptor)row.elementAt(0));
        }
        return serversList;
    }

    protected void addStunServer(StunServerDescriptor stunServer) {
        this.tableModel.addRow(new Object[]{stunServer, stunServer.isTurnSupported()});
    }

    protected void removeAllStunServer() {
        for (int i = this.tableModel.getRowCount(); i != 0; --i) {
            this.tableModel.removeRow(0);
        }
    }

    protected void modifyStunServer(StunServerDescriptor stunServer) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            StunServerDescriptor server = (StunServerDescriptor)this.tableModel.getValueAt(i, 0);
            if (stunServer != server) continue;
            this.tableModel.setValueAt(stunServer, i, 0);
            this.tableModel.setValueAt(stunServer.isTurnSupported(), i, 1);
            return;
        }
    }

    protected StunServerDescriptor getStunServer(String address, int port) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            StunServerDescriptor stunServer = (StunServerDescriptor)this.tableModel.getValueAt(i, 0);
            if (!stunServer.getAddress().equalsIgnoreCase(address) || stunServer.getPort() != port) continue;
            return stunServer;
        }
        return null;
    }

    private Component createAdditionalJingleNodesComponent() {
        this.jnTable.setPreferredScrollableViewportSize(new Dimension(450, 60));
        this.jnTableModel.addColumn(Resources.getString("plugin.jabberaccregwizz.JID_ADDRESS"));
        this.jnTableModel.addColumn(Resources.getString("plugin.jabberaccregwizz.RELAY_SUPPORT"));
        this.jnTable.setDefaultRenderer(JingleNodeDescriptor.class, new ServerCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.jnTable);
        JButton addButton = new JButton(Resources.getString("service.gui.ADD"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JNConfigDialog jnDialog = new JNConfigDialog(false);
                jnDialog.setModal(true);
                jnDialog.setVisible(true);
            }
        });
        final JButton editButton = new JButton(Resources.getString("service.gui.EDIT"));
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IceConfigPanel.this.jnTable.getSelectedRow() < 0) {
                    return;
                }
                JingleNodeDescriptor jn = (JingleNodeDescriptor)IceConfigPanel.this.jnTableModel.getValueAt(IceConfigPanel.this.jnTable.getSelectedRow(), 0);
                if (jn != null) {
                    JNConfigDialog dialog = new JNConfigDialog(jn.getJID(), jn.isRelaySupported());
                    dialog.setModal(true);
                    dialog.setVisible(true);
                }
            }
        });
        JButton deleteButton = new JButton(Resources.getString("service.gui.DELETE"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IceConfigPanel.this.jnTableModel.removeRow(IceConfigPanel.this.jnTable.getSelectedRow());
            }
        });
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        buttonsPanel.add((Component)addButton);
        buttonsPanel.add((Component)editButton);
        buttonsPanel.add((Component)deleteButton);
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        mainPanel.setBorder((Border)BorderFactory.createTitledBorder(Resources.getString("plugin.jabberaccregwizz.ADDITIONAL_JINGLE_NODES")));
        mainPanel.add((Component)scrollPane);
        mainPanel.add((Component)buttonsPanel, (Object)"South");
        this.jnTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getComponent().isEnabled() && evt.getButton() == 1 && evt.getClickCount() == 2) {
                    editButton.doClick();
                }
            }
        });
        return mainPanel;
    }

    protected boolean isUseJingleNodes() {
        return this.jnBox.isSelected();
    }

    protected void setUseJingleNodes(boolean isUseJN) {
        this.jnBox.setSelected(isUseJN);
    }

    protected boolean isAutoDiscoverJingleNodes() {
        return this.jnAutoDiscoverBox.isSelected();
    }

    protected void setAutoDiscoverJingleNodes(boolean isAutoDiscover) {
        this.jnAutoDiscoverBox.setSelected(isAutoDiscover);
    }

    protected List<JingleNodeDescriptor> getAdditionalJingleNodes() {
        LinkedList<JingleNodeDescriptor> serversList = new LinkedList<JingleNodeDescriptor>();
        Vector<Vector> serverRows = this.jnTableModel.getDataVector();
        for (Vector row : serverRows) {
            serversList.add((JingleNodeDescriptor)row.elementAt(0));
        }
        return serversList;
    }

    protected JingleNodeDescriptor getJingleNodes(Jid previousJID) {
        for (int i = 0; i < this.jnTableModel.getRowCount(); ++i) {
            JingleNodeDescriptor jn = (JingleNodeDescriptor)this.jnTableModel.getValueAt(i, 0);
            if (!jn.getJID().equals((CharSequence)previousJID)) continue;
            return jn;
        }
        return null;
    }

    protected void addJingleNodes(JingleNodeDescriptor jingleNode) {
        this.jnTableModel.addRow(new Object[]{jingleNode, jingleNode.isRelaySupported()});
    }

    protected void removeAllJingleNodes() {
        for (int i = this.jnTableModel.getRowCount(); i != 0; --i) {
            this.jnTableModel.removeRow(0);
        }
    }

    protected void modifyJingleNodes(JingleNodeDescriptor jingleNode) {
        for (int i = 0; i < this.jnTableModel.getRowCount(); ++i) {
            JingleNodeDescriptor node = (JingleNodeDescriptor)this.jnTableModel.getValueAt(i, 0);
            if (jingleNode != node) continue;
            this.jnTableModel.setValueAt(jingleNode, i, 0);
            this.jnTableModel.setValueAt(jingleNode.isRelaySupported(), i, 1);
            return;
        }
    }

    protected boolean isUseUPNP() {
        return this.upnpBox.isSelected();
    }

    protected void setUseUPNP(boolean isUseUPNP) {
        this.upnpBox.setSelected(isUseUPNP);
    }

    private class JNConfigDialog
    extends SIPCommDialog {
        private static final long serialVersionUID = 0L;
        private final JPanel mainPanel;
        private final JTextField addressField;
        private final JCheckBox supportRelayCheckBox;
        private JEditorPane errorMessagePane;
        private final boolean isEditMode;
        private Jid previousJID;

        public JNConfigDialog(Jid address, boolean isRelaySupport) {
            this(true);
            this.previousJID = address;
            this.addressField.setText(address.toString());
            this.supportRelayCheckBox.setSelected(isRelaySupport);
        }

        public JNConfigDialog(boolean editMode) {
            super(false);
            this.mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
            this.addressField = new JTextField();
            this.supportRelayCheckBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.RELAY_SUPPORT"));
            this.previousJID = null;
            this.isEditMode = editMode;
            this.setTitle(Resources.getString(!editMode ? "plugin.jabberaccregwizz.ADD_JINGLE_NODE" : "plugin.jabberaccregwizz.EDIT_JINGLE_NODE"));
            JLabel addressLabel = new JLabel(Resources.getString("plugin.jabberaccregwizz.JID_ADDRESS"));
            TransparentPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
            labelsPanel.add((Component)addressLabel);
            labelsPanel.add((Component)new JLabel());
            TransparentPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
            valuesPanel.add((Component)this.addressField);
            valuesPanel.add((Component)this.supportRelayCheckBox);
            JButton addButton = new JButton(Resources.getString("service.gui.OK"));
            JButton cancelButton = new JButton(Resources.getString("service.gui.CANCEL"));
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Jid address;
                    try {
                        address = JidCreate.from((String)JNConfigDialog.this.addressField.getText());
                    }
                    catch (XmppStringprepException e1) {
                        JNConfigDialog.this.loadErrorMessage(Resources.getString("plugin.jabberaccregwizz.NO_STUN_ADDRESS"));
                        return;
                    }
                    JingleNodeDescriptor jnServer = null;
                    jnServer = JNConfigDialog.this.isEditMode ? IceConfigPanel.this.getJingleNodes(JNConfigDialog.this.previousJID) : IceConfigPanel.this.getJingleNodes(address);
                    String errorMessage = null;
                    if (jnServer != null && !JNConfigDialog.this.isEditMode) {
                        errorMessage = Resources.getString("plugin.jabberaccregwizz.STUN_ALREADY_EXIST");
                    }
                    if (errorMessage != null) {
                        JNConfigDialog.this.loadErrorMessage(errorMessage);
                        return;
                    }
                    if (!JNConfigDialog.this.isEditMode) {
                        jnServer = new JingleNodeDescriptor(address, JNConfigDialog.this.supportRelayCheckBox.isSelected());
                        IceConfigPanel.this.addJingleNodes(jnServer);
                    } else {
                        jnServer.setAddress(address);
                        jnServer.setRelay(JNConfigDialog.this.supportRelayCheckBox.isSelected());
                        IceConfigPanel.this.modifyJingleNodes(jnServer);
                    }
                    JNConfigDialog.this.dispose();
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JNConfigDialog.this.dispose();
                }
            });
            TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
            buttonsPanel.add((Component)addButton);
            buttonsPanel.add((Component)cancelButton);
            this.mainPanel.add((Component)labelsPanel, "West");
            this.mainPanel.add((Component)valuesPanel, "Center");
            this.mainPanel.add((Component)buttonsPanel, "South");
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.getContentPane().add((Component)this.mainPanel, "North");
            this.pack();
        }

        private void loadErrorMessage(String errorMessage) {
            if (this.errorMessagePane == null) {
                this.errorMessagePane = new JEditorPane();
                this.errorMessagePane.setOpaque(false);
                this.errorMessagePane.setForeground(Color.RED);
                this.mainPanel.add((Component)this.errorMessagePane, "North");
            }
            this.errorMessagePane.setText(errorMessage);
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
            this.pack();
            this.setSize(this.getWidth(), this.getHeight() + this.errorMessagePane.getHeight());
        }

        protected void close(boolean escaped) {
        }
    }

    private static class PortVerifier
    extends InputVerifier {
        private PortVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            if (!(input instanceof JTextField)) {
                return false;
            }
            JTextField portField = (JTextField)input;
            String portStr = portField.getText();
            int port = -1;
            if (portStr == null || portStr.trim().length() == 0) {
                return true;
            }
            try {
                port = Integer.parseInt(portStr);
            }
            catch (Throwable t) {
                return false;
            }
            return NetworkUtils.isValidPortNumber((int)port);
        }
    }

    private class ServerTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 0L;

        private ServerTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private static class ServerCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 0L;
        private Color unselectedForeground;
        private Color unselectedBackground;

        private ServerCellRenderer() {
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof StunServerDescriptor) {
                StunServerDescriptor stunServer = (StunServerDescriptor)value;
                this.setText(stunServer.getAddress() + "/" + stunServer.getPort());
                if (isSelected) {
                    super.setForeground(table.getSelectionForeground());
                    super.setBackground(table.getSelectionBackground());
                } else {
                    super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                    super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
                }
            } else if (value instanceof JingleNodeDescriptor) {
                JingleNodeDescriptor jn = (JingleNodeDescriptor)value;
                this.setText(jn.getJID().toString());
                if (isSelected) {
                    super.setForeground(table.getSelectionForeground());
                    super.setBackground(table.getSelectionBackground());
                } else {
                    super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                    super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
                }
            } else {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return this;
        }
    }

    private class StunConfigDialog
    extends SIPCommDialog {
        private static final long serialVersionUID = 0L;
        private final JPanel mainPanel;
        private final JTextField addressField;
        private final JTextField portField;
        private final PortVerifier portVerifier;
        private final JCheckBox supportTurnCheckBox;
        private final JTextField usernameField;
        private final JPasswordField passwordField;
        private JEditorPane errorMessagePane;
        private final boolean isEditMode;
        private static final String DEFAULT_STUN_PORT = "3478";
        private String previousServer;
        private int previousPort;

        public StunConfigDialog(String address, int port, boolean isSupportTurn, String username, String password) {
            this(true);
            this.addressField.setText(address);
            this.portField.setText(Integer.toString(port));
            this.supportTurnCheckBox.setSelected(isSupportTurn);
            this.usernameField.setText(username);
            this.passwordField.setText(password);
            this.previousServer = address;
            this.previousPort = port;
            if (isSupportTurn) {
                this.usernameField.setEnabled(true);
                this.passwordField.setEnabled(true);
            }
        }

        public StunConfigDialog(boolean editMode) {
            super(false);
            this.mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
            this.addressField = new JTextField();
            this.portField = new JTextField();
            this.portVerifier = new PortVerifier();
            this.supportTurnCheckBox = new SIPCommCheckBox(Resources.getString("plugin.jabberaccregwizz.SUPPORT_TURN"));
            this.usernameField = new JTextField();
            this.passwordField = new JPasswordField();
            this.previousServer = null;
            this.previousPort = 0;
            this.isEditMode = editMode;
            this.setTitle(Resources.getString(!editMode ? "plugin.jabberaccregwizz.ADD_STUN_SERVER" : "plugin.jabberaccregwizz.EDIT_STUN_SERVER"));
            JLabel addressLabel = new JLabel(Resources.getString("plugin.jabberaccregwizz.IP_ADDRESS"));
            JLabel portLabel = new JLabel(Resources.getString("service.gui.PORT"));
            JLabel usernameLabel = new JLabel(Resources.getString("plugin.jabberaccregwizz.TURN_USERNAME"));
            JLabel passwordLabel = new JLabel(Resources.getString("service.gui.PASSWORD"));
            TransparentPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
            labelsPanel.add((Component)new JLabel());
            labelsPanel.add((Component)addressLabel);
            labelsPanel.add((Component)portLabel);
            labelsPanel.add((Component)usernameLabel);
            labelsPanel.add((Component)passwordLabel);
            TransparentPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
            this.usernameField.setEnabled(false);
            this.passwordField.setEnabled(false);
            this.portField.setText(DEFAULT_STUN_PORT);
            valuesPanel.add((Component)this.supportTurnCheckBox);
            valuesPanel.add((Component)this.addressField);
            valuesPanel.add((Component)this.portField);
            valuesPanel.add((Component)this.usernameField);
            valuesPanel.add((Component)this.passwordField);
            this.portField.setInputVerifier(this.portVerifier);
            JButton addButton = new JButton(Resources.getString("service.gui.OK"));
            JButton cancelButton = new JButton(Resources.getString("service.gui.CANCEL"));
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String address = StunConfigDialog.this.addressField.getText();
                    String portStr = StunConfigDialog.this.portField.getText();
                    StunServerDescriptor stunServer = null;
                    if (!StunConfigDialog.this.portVerifier.verify(StunConfigDialog.this.portField)) {
                        StunConfigDialog.this.loadErrorMessage(Resources.getSettingsString("plugin.jabberaccregwizz.PORT_FIELD_INVALID"));
                        return;
                    }
                    int port = -1;
                    if (portStr != null && portStr.trim().length() > 0) {
                        port = Integer.parseInt(StunConfigDialog.this.portField.getText());
                    }
                    String username = StunConfigDialog.this.usernameField.getText();
                    char[] password = StunConfigDialog.this.passwordField.getPassword();
                    String errorMessage = null;
                    if (address == null || address.length() <= 0) {
                        errorMessage = Resources.getString("plugin.jabberaccregwizz.NO_STUN_ADDRESS");
                    }
                    if ((username == null || username.length() <= 0) && StunConfigDialog.this.supportTurnCheckBox.isSelected()) {
                        errorMessage = Resources.getString("plugin.jabberaccregwizz.NO_STUN_USERNAME");
                    }
                    if ((stunServer = StunConfigDialog.this.isEditMode ? IceConfigPanel.this.getStunServer(StunConfigDialog.this.previousServer, StunConfigDialog.this.previousPort) : IceConfigPanel.this.getStunServer(address, port)) != null && !StunConfigDialog.this.isEditMode) {
                        errorMessage = Resources.getString("plugin.jabberaccregwizz.STUN_ALREADY_EXIST");
                    }
                    if (errorMessage != null) {
                        StunConfigDialog.this.loadErrorMessage(errorMessage);
                        return;
                    }
                    if (!StunConfigDialog.this.isEditMode) {
                        stunServer = new StunServerDescriptor(address, port, StunConfigDialog.this.supportTurnCheckBox.isSelected(), username, new String(password));
                        IceConfigPanel.this.addStunServer(stunServer);
                    } else {
                        stunServer.setAddress(address);
                        stunServer.setPort(port);
                        stunServer.setTurnSupported(StunConfigDialog.this.supportTurnCheckBox.isSelected());
                        stunServer.setUsername(username);
                        stunServer.setPassword(new String(password));
                        IceConfigPanel.this.modifyStunServer(stunServer);
                    }
                    StunConfigDialog.this.dispose();
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StunConfigDialog.this.dispose();
                }
            });
            this.supportTurnCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        StunConfigDialog.this.usernameField.setEnabled(true);
                        StunConfigDialog.this.passwordField.setEnabled(true);
                    } else {
                        StunConfigDialog.this.usernameField.setEnabled(false);
                        StunConfigDialog.this.passwordField.setEnabled(false);
                    }
                }
            });
            TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
            buttonsPanel.add((Component)addButton);
            buttonsPanel.add((Component)cancelButton);
            this.mainPanel.add((Component)labelsPanel, "West");
            this.mainPanel.add((Component)valuesPanel, "Center");
            this.mainPanel.add((Component)buttonsPanel, "South");
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.getContentPane().add((Component)this.mainPanel, "North");
            this.pack();
        }

        private void loadErrorMessage(String errorMessage) {
            if (this.errorMessagePane == null) {
                this.errorMessagePane = new JEditorPane();
                this.errorMessagePane.setOpaque(false);
                this.errorMessagePane.setForeground(Color.RED);
                this.mainPanel.add((Component)this.errorMessagePane, "North");
            }
            this.errorMessagePane.setText(errorMessage);
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
            this.pack();
            this.setSize(this.getWidth(), this.getHeight() + this.errorMessagePane.getHeight());
        }

        protected void close(boolean escaped) {
        }
    }
}

