/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.jabberaccregwizz;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.jabberaccregwizz.AccountPanel;
import net.java.sip.communicator.plugin.jabberaccregwizz.FirstWizardPage;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccRegWizzActivator;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccountCreationForm;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccountCreationFormService;
import net.java.sip.communicator.plugin.jabberaccregwizz.Resources;
import net.java.sip.communicator.service.gui.DesktopAccountRegistrationWizard;
import net.java.sip.communicator.service.gui.WizardContainer;
import net.java.sip.communicator.service.gui.WizardPage;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.jabber.JabberAccountRegistration;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.ServiceReference;

public class JabberAccountRegistrationWizard
extends DesktopAccountRegistrationWizard {
    private static final Logger logger = Logger.getLogger(JabberAccountRegistrationWizard.class);
    private FirstWizardPage firstWizardPage;
    private JabberAccountRegistration registration;
    private ProtocolProviderService protocolProvider;
    private JabberAccountCreationForm createAccountService;

    public JabberAccountRegistrationWizard(WizardContainer wizardContainer) {
        this.setWizardContainer(wizardContainer);
        wizardContainer.setFinishButtonText(Resources.getString("service.gui.SIGN_IN"));
    }

    public byte[] getIcon() {
        return Resources.getImage(Resources.PROTOCOL_ICON);
    }

    public byte[] getPageImage() {
        return Resources.getImage(Resources.PAGE_IMAGE);
    }

    public String getProtocolName() {
        return Resources.getString("plugin.jabberaccregwizz.PROTOCOL_NAME");
    }

    public String getProtocolDescription() {
        return Resources.getString("plugin.jabberaccregwizz.PROTOCOL_DESCRIPTION");
    }

    public Iterator<WizardPage> getPages() {
        return this.getPages(new JabberAccountRegistration());
    }

    public Iterator<WizardPage> getPages(JabberAccountRegistration registration) {
        ArrayList<FirstWizardPage> pages = new ArrayList<FirstWizardPage>();
        this.registration = registration;
        if (this.firstWizardPage == null) {
            this.firstWizardPage = new FirstWizardPage(this);
        }
        pages.add(this.firstWizardPage);
        return pages.iterator();
    }

    public Iterator<Map.Entry<String, String>> getSummary() {
        Hashtable<String, String> summaryTable = new Hashtable<String, String>();
        summaryTable.put(Resources.getString("plugin.jabberaccregwizz.USERNAME"), this.registration.getUserID());
        summaryTable.put(Resources.getString("service.gui.REMEMBER_PASSWORD"), Boolean.toString(this.registration.isRememberPassword()));
        summaryTable.put(Resources.getString("plugin.jabberaccregwizz.SERVER"), this.registration.getServerAddress());
        summaryTable.put(Resources.getString("service.gui.PORT"), String.valueOf(this.registration.getServerPort()));
        summaryTable.put(Resources.getString("plugin.jabberaccregwizz.ENABLE_KEEP_ALIVE"), String.valueOf(this.registration.isSendKeepAlive()));
        summaryTable.put(Resources.getString("plugin.jabberaccregwizz.RESOURCE"), this.registration.getResource());
        summaryTable.put(Resources.getString("plugin.jabberaccregwizz.PRIORITY"), String.valueOf(this.registration.getPriority()));
        summaryTable.put(Resources.getString("plugin.sipaccregwizz.DTMF_METHOD"), this.registration.getDTMFMethod());
        summaryTable.put(Resources.getString("plugin.sipaccregwizz.DTMF_MINIMAL_TONE_DURATION"), this.registration.getDtmfMinimalToneDuration());
        return summaryTable.entrySet().iterator();
    }

    public ProtocolProviderService signin() throws OperationFailedException {
        this.firstWizardPage.commitPage();
        return this.firstWizardPage.isCommitted() ? this.signin(this.registration.getUserID(), this.registration.getPassword()) : null;
    }

    public ProtocolProviderService signin(final String userName, final String password) throws OperationFailedException {
        boolean rememberPassword;
        final AccountPanel accPanel = (AccountPanel)this.firstWizardPage.getSimpleForm();
        String accPanelUsername = accPanel.getUsername();
        boolean equals = false;
        boolean bl = rememberPassword = password != null;
        if (Objects.equals(accPanelUsername, userName)) {
            char[] passwordChars;
            char[] accPanelPasswordChars = accPanel.getPassword();
            char[] cArray = passwordChars = password == null ? null : password.toCharArray();
            equals = accPanelPasswordChars == null ? passwordChars == null || passwordChars.length == 0 : (passwordChars == null ? accPanelPasswordChars.length == 0 : Arrays.equals(accPanelPasswordChars, passwordChars));
            if (equals) {
                boolean accPanelRememberPassword = accPanel.isRememberPassword();
                boolean bl2 = equals = accPanelRememberPassword == rememberPassword;
            }
        }
        if (!equals) {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    accPanel.setUsername(userName);
                    accPanel.setPassword(password);
                    accPanel.setRememberPassword(rememberPassword);
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            accPanel.setUsername(userName);
                            accPanel.setPassword(password);
                            accPanel.setRememberPassword(rememberPassword);
                        }
                    });
                }
            }
            catch (Exception e) {
                if (e instanceof OperationFailedException) {
                    throw (OperationFailedException)((Object)e);
                }
                throw new OperationFailedException("Failed to set username and password on " + accPanel.getClass().getName(), 4, (Throwable)e);
            }
        }
        if (!this.firstWizardPage.isCommitted()) {
            this.firstWizardPage.commitPage();
        }
        if (!this.firstWizardPage.isCommitted()) {
            throw new OperationFailedException("Could not confirm data.", 1);
        }
        ProtocolProviderFactory factory = JabberAccRegWizzActivator.getJabberProtocolProviderFactory();
        return this.installAccount(factory, this.registration.getUserID(), password);
    }

    protected ProtocolProviderService installAccount(ProtocolProviderFactory providerFactory, String userName, String passwd) throws OperationFailedException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Preparing to install account for user " + userName));
        }
        Hashtable<String, String> accountProperties = new Hashtable<String, String>();
        String protocolIconPath = this.getProtocolIconPath();
        String accountIconPath = this.getAccountIconPath();
        this.registration.storeProperties(userName, passwd, protocolIconPath, accountIconPath, accountProperties);
        accountProperties.put("IS_PREFERRED_PROTOCOL", Boolean.toString(this.isPreferredProtocol()));
        accountProperties.put("PROTOCOL_NAME", this.getProtocol());
        if (this.isModification()) {
            providerFactory.modifyAccount(this.protocolProvider, accountProperties);
            this.setModification(false);
            return this.protocolProvider;
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Will install account for user " + userName + " with the following properties." + accountProperties));
            }
            AccountID accountID = providerFactory.installAccount(userName, accountProperties);
            ServiceReference serRef = providerFactory.getProviderForAccount(accountID);
            this.protocolProvider = (ProtocolProviderService)JabberAccRegWizzActivator.bundleContext.getService(serRef);
        }
        catch (IllegalArgumentException exc) {
            logger.warn((Object)exc.getMessage());
            throw new OperationFailedException("Username, password or server is null.", 11);
        }
        catch (IllegalStateException exc) {
            logger.warn((Object)exc.getMessage());
            throw new OperationFailedException("Account already exists.", 10);
        }
        catch (Throwable exc) {
            logger.warn((Object)exc.getMessage());
            throw new OperationFailedException("Failed to add account.", 1);
        }
        return this.protocolProvider;
    }

    public void loadAccount(ProtocolProviderService protocolProvider) {
        this.setModification(true);
        this.protocolProvider = protocolProvider;
        this.registration = new JabberAccountRegistration();
        this.firstWizardPage.loadAccount(protocolProvider);
    }

    public JabberAccountRegistration getRegistration() {
        if (this.registration == null) {
            this.registration = new JabberAccountRegistration();
        }
        return this.registration;
    }

    public Dimension getSize() {
        return new Dimension(300, 480);
    }

    public Object getFirstPageIdentifier() {
        return this.firstWizardPage.getIdentifier();
    }

    public Object getLastPageIdentifier() {
        return this.firstWizardPage.getIdentifier();
    }

    public String getUserNameExample() {
        return "Ex: johnsmith@jabber.org";
    }

    public void webSignup() {
    }

    public boolean isWebSignupSupported() {
        return false;
    }

    public Object getSimpleForm(boolean isCreateAccount) {
        return this.getSimpleForm(new JabberAccountRegistration(), isCreateAccount);
    }

    public Object getSimpleForm(JabberAccountRegistration registration, boolean isCreateAccount) {
        this.registration = registration;
        this.firstWizardPage = new FirstWizardPage(this);
        return this.firstWizardPage.getSimpleForm();
    }

    public String getProtocol() {
        return "Jabber";
    }

    public String getProtocolIconPath() {
        return null;
    }

    public String getAccountIconPath() {
        return null;
    }

    protected JabberAccountCreationFormService getCreateAccountService() {
        if (this.createAccountService == null) {
            this.createAccountService = new JabberAccountCreationForm();
        }
        return this.createAccountService;
    }

    protected String getUsernameLabel() {
        return Resources.getString("plugin.jabberaccregwizz.USERNAME");
    }

    protected String getCreateAccountButtonLabel() {
        return Resources.getString("plugin.jabberaccregwizz.NEW_ACCOUNT_TITLE");
    }

    protected String getCreateAccountLabel() {
        return Resources.getString("plugin.jabberaccregwizz.REGISTER_NEW_ACCOUNT_TEXT");
    }

    protected String getExistingAccountLabel() {
        return Resources.getString("plugin.jabberaccregwizz.EXISTING_ACCOUNT");
    }

    protected String getHomeLinkLabel() {
        return null;
    }

    public ProtocolProviderService getProtocolProvider() {
        if (this.isModification()) {
            return this.protocolProvider;
        }
        return null;
    }
}

