/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.input;

import com.google.gdata.data.ParseSource;
import com.google.gdata.data.introspection.IServiceDocument;
import com.google.gdata.data.introspection.ServiceDocument;
import com.google.gdata.model.Element;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.input.AtomServiceDataParser;
import com.google.gdata.wireformats.input.ElementParser;
import com.google.gdata.wireformats.input.InputParser;
import com.google.gdata.wireformats.input.InputProperties;
import java.io.IOException;

public class AtomServiceDualParser
implements InputParser<IServiceDocument> {
    private final InputParser<ServiceDocument> dataParser = new AtomServiceDataParser();
    private final InputParser<IServiceDocument> elementParser = ElementParser.of(AltFormat.ATOM_SERVICE, IServiceDocument.class);

    @Override
    public AltFormat getAltFormat() {
        return AltFormat.ATOM_SERVICE;
    }

    @Override
    public Class<IServiceDocument> getResultType() {
        return IServiceDocument.class;
    }

    @Override
    public <R extends IServiceDocument> R parse(ParseSource parseSource, InputProperties inProps, Class<R> resultClass) throws IOException, ServiceException {
        Preconditions.checkNotNull(parseSource, "parseSource");
        Preconditions.checkNotNull(inProps, "inProps");
        Preconditions.checkNotNull("resultClass", resultClass);
        if (Element.class.isAssignableFrom(resultClass)) {
            IServiceDocument iServiceDocument = (IServiceDocument)this.elementParser.parse(parseSource, inProps, resultClass);
        }
        if (!ServiceDocument.class.isAssignableFrom(resultClass)) {
            throw new IllegalArgumentException("Invalid result type:" + resultClass);
        }
        InputParser<ServiceDocument> castParser = this.dataParser;
        IServiceDocument result = (IServiceDocument)castParser.parse(parseSource, inProps, resultClass);
        return (R)result;
    }
}

