/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.googlecontacts;

import com.google.gdata.client.Service;
import com.google.gdata.client.contacts.ContactQuery;
import com.google.gdata.client.contacts.ContactsService;
import com.google.gdata.data.ILink;
import com.google.gdata.data.contacts.ContactEntry;
import com.google.gdata.data.contacts.ContactFeed;
import com.google.gdata.data.extensions.Email;
import com.google.gdata.data.extensions.Name;
import com.google.gdata.data.extensions.PhoneNumber;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsActivator;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsConnectionImpl;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsEntryImpl;
import net.java.sip.communicator.impl.googlecontacts.configform.AccountSettingsForm;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsConnection;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsEntry;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsService;
import net.java.sip.communicator.service.googlecontacts.GoogleEntryCallback;
import net.java.sip.communicator.service.googlecontacts.GoogleQuery;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;

public class GoogleContactsServiceImpl
implements GoogleContactsService {
    private static final Logger logger = Logger.getLogger(GoogleContactsServiceImpl.class);
    private static final String feedURL = "https://www.google.com/m8/feeds/contacts/default/full";
    public static final int MAX_RESULT = 20;
    public static final int MAX_NUMBER = 1000;
    private final List<GoogleContactsConnectionImpl> accounts = new ArrayList<GoogleContactsConnectionImpl>();
    static final String CONFIGURATION_PATH = "net.java.sip.communicator.impl.googlecontacts";

    public GoogleContactsServiceImpl() {
        new Thread(){

            @Override
            public void run() {
                GoogleContactsServiceImpl.this.loadConfig();
            }
        }.start();
    }

    public List<GoogleContactsConnectionImpl> getAccounts() {
        return this.accounts;
    }

    private void loadConfig() {
        ConfigurationService configService = GoogleContactsActivator.getConfigService();
        List list = configService.getPropertyNamesByPrefix(CONFIGURATION_PATH, true);
        for (Object configEntry : list) {
            String path = configEntry.toString();
            Object oen = configService.getProperty(path + ".enabled");
            boolean enabled = Boolean.parseBoolean((String)oen);
            String login = (String)configService.getProperty(path + ".account");
            String prefix = (String)configService.getProperty(path + ".prefix");
            if (prefix == null) {
                prefix = "";
            }
            GoogleContactsConnectionImpl cnx = (GoogleContactsConnectionImpl)this.getConnection(login);
            cnx.setEnabled(enabled);
            cnx.setPrefix(prefix);
            if (cnx == null) continue;
            if (cnx.connect() == GoogleContactsConnection.ConnectionStatus.ERROR_INVALID_CREDENTIALS) {
                cnx.setEnabled(false);
                AccountSettingsForm settings = new AccountSettingsForm();
                settings.setModal(true);
                settings.loadData(cnx);
                int ret = settings.showDialog();
                if (ret == 1) {
                    cnx = (GoogleContactsConnectionImpl)settings.getConnection();
                    cnx.setEnabled(enabled);
                    cnx.setPrefix(prefix);
                    this.saveConfig(cnx);
                }
            }
            this.accounts.add(cnx);
            if (!cnx.isEnabled()) continue;
            this.addContactSource(cnx, true);
        }
    }

    public void removeConfig(GoogleContactsConnection cnx) {
        ConfigurationService configService = GoogleContactsActivator.getConfigService();
        configService.removeProperty("net.java.sip.communicator.impl.googlecontacts.acc" + Math.abs(cnx.getLogin().hashCode()));
    }

    public void saveConfig(GoogleContactsConnection cnx) {
        ConfigurationService configService = GoogleContactsActivator.getConfigService();
        String login = cnx.getLogin();
        String path = "net.java.sip.communicator.impl.googlecontacts.acc" + Math.abs(login.hashCode());
        configService.setProperty(path, (Object)login);
        configService.setProperty(path + ".account", (Object)login);
        configService.setProperty(path + ".enabled", (Object)((GoogleContactsConnectionImpl)cnx).isEnabled());
        configService.setProperty(path + ".prefix", (Object)cnx.getPrefix());
    }

    @Override
    public List<GoogleContactsEntry> searchContact(GoogleContactsConnection cnx, GoogleQuery gQuery, int count, GoogleEntryCallback callback) {
        URL url = null;
        ContactFeed contactFeed = null;
        ContactQuery query = null;
        ArrayList<GoogleContactsEntry> ret = new ArrayList<GoogleContactsEntry>();
        boolean endOfContacts = false;
        int matchedContacts = 0;
        int index = 1;
        GoogleContactsConnectionImpl cnxImpl = (GoogleContactsConnectionImpl)cnx;
        if (count <= 0) {
            count = 20;
        }
        try {
            url = new URL(feedURL);
        }
        catch (MalformedURLException e) {
            logger.info((Object)"Malformed URL", (Throwable)e);
            return ret;
        }
        if (gQuery.isCancelled()) {
            return ret;
        }
        while (matchedContacts < count || endOfContacts) {
            query = new ContactQuery(url);
            query.setStartIndex(index);
            query.setMaxResults(1000);
            query.setSortOrder(ContactQuery.SortOrder.DESCENDING);
            if (gQuery.isCancelled()) {
                return ret;
            }
            try {
                contactFeed = cnxImpl.query(query);
            }
            catch (Exception e) {
                logger.warn((Object)"Problem occurred during Google Contacts query", (Throwable)e);
                return ret;
            }
            if (contactFeed.getEntries().size() == 0) {
                endOfContacts = true;
                break;
            }
            for (int i = 0; i < contactFeed.getEntries().size(); ++i) {
                if (gQuery.isCancelled()) {
                    return ret;
                }
                ContactEntry entry = (ContactEntry)contactFeed.getEntries().get(i);
                if (!this.filter(entry, gQuery.getQueryPattern())) continue;
                GoogleContactsEntry gcEntry = null;
                gcEntry = this.getGoogleContactsEntry(entry);
                ++matchedContacts;
                ret.add(gcEntry);
                if (callback != null) {
                    callback.callback(gcEntry);
                }
                if (matchedContacts >= count) break;
            }
            index += contactFeed.getEntries().size();
        }
        return ret;
    }

    private boolean filter(ContactEntry entry, Pattern filter) {
        Matcher m;
        Name name = entry.getName();
        if (name != null) {
            Matcher m2;
            if (name.hasFamilyName() && (m2 = filter.matcher(name.getFamilyName().getValue())).matches()) {
                return true;
            }
            if (name.hasGivenName() && (m2 = filter.matcher(name.getGivenName().getValue())).find()) {
                return true;
            }
            if (name.hasFullName() && (m2 = filter.matcher(name.getFullName().getValue())).find()) {
                return true;
            }
        }
        for (Email mail : entry.getEmailAddresses()) {
            m = filter.matcher(mail.getAddress());
            if (!m.find()) continue;
            return true;
        }
        for (PhoneNumber phone : entry.getPhoneNumbers()) {
            m = filter.matcher(phone.getPhoneNumber());
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    private GoogleContactsEntry getGoogleContactsEntry(ContactEntry entry) {
        GoogleContactsEntryImpl ret = new GoogleContactsEntryImpl();
        ret.setField(entry);
        return ret;
    }

    @Override
    public List<GoogleContactsEntry> getContacts() {
        return null;
    }

    @Override
    public GoogleContactsConnection getConnection(String login) {
        try {
            return new GoogleContactsConnectionImpl(login);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to obtain Google Contacts connection", (Throwable)e);
            return null;
        }
    }

    @Override
    public void addContactSource(GoogleContactsConnection cnx, boolean googleTalk) {
        GoogleContactsActivator.enableContactSource(cnx, googleTalk);
    }

    @Override
    public void addContactSource(String login) {
        GoogleContactsActivator.enableContactSource(login, false);
    }

    @Override
    public void removeContactSource(GoogleContactsConnection cnx) {
        GoogleContactsActivator.disableContactSource(cnx);
    }

    @Override
    public void removeContactSource(String login) {
        GoogleContactsActivator.disableContactSource(login);
    }

    public static byte[] downloadPhoto(ILink photoLink, ContactsService service) {
        try {
            if (photoLink != null) {
                Service.GDataRequest request = service.createLinkQueryRequest(photoLink);
                request.execute();
                InputStream in = request.getResponseStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int read = 0;
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                return out.toByteArray();
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Failed to retrieve photo of the contact", (Throwable)e);
        }
        return null;
    }
}

