/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.googlecontacts;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.java.sip.communicator.impl.googlecontacts.GoogleAPIClientToken;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsActivator;
import net.java.sip.communicator.impl.googlecontacts.UserResponseType;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommLinkButton;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.util.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jitsi.service.resources.ResourceManagementService;

public class OAuth2TokenStore {
    private static final Logger LOGGER = Logger.getLogger(OAuth2TokenStore.class);
    private static final String REFRESH_TOKEN_SYMBOL = "refresh_token";
    private static final String ACCESS_TOKEN_SYMBOL = "access_token";
    private static final String EXPIRES_IN_SYMBOL = "expires_in";
    private static final GenericUrl GOOGLE_OAUTH2_TOKEN_SERVER = new GenericUrl("https://accounts.google.com/o/oauth2/token");
    private static final String GOOGLE_API_CLIENT_ID = GoogleAPIClientToken.GOOGLE_API_CLIENT_ID;
    private static final String GOOGLE_API_CLIENT_SECRET = GoogleAPIClientToken.GOOGLE_API_CLIENT_SECRET;
    private static final String GOOGLE_API_OAUTH2_SCOPES = "profile%20email%20https://www.google.com/m8/feeds";
    private static final String GOOGLE_API_OAUTH2_REDIRECT_URI = "urn:ietf:wg:oauth:2.0:oob";
    private static final String GOOGLE_API_GRANT_TYPE = "authorization_code";
    private static final String APPROVAL_URL = String.format("https://accounts.google.com/o/oauth2/auth?scope=%s&redirect_uri=%s&response_type=code&client_id=%s", "profile%20email%20https://www.google.com/m8/feeds", "urn:ietf:wg:oauth:2.0:oob", GOOGLE_API_CLIENT_ID);
    private static final Gson GSON = new Gson();
    private final AtomicReference<Credential> store = new AtomicReference<Object>(null);

    public synchronized Credential get(String identity) throws FailedAcquireCredentialException {
        if (GOOGLE_API_CLIENT_ID == null || GOOGLE_API_CLIENT_SECRET == null) {
            throw new IllegalStateException("Missing client ID or client secret. It is not possible to use Google Contacts API without it.");
        }
        if (this.store.get() == null) {
            try {
                OAuth2TokenStore.acquireCredential(this.store, identity);
            }
            catch (IOException | RuntimeException | URISyntaxException e) {
                throw new FailedAcquireCredentialException(e);
            }
        }
        return this.store.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void acquireCredential(AtomicReference<Credential> store, String identity) throws URISyntaxException, ClientProtocolException, IOException {
        LOGGER.info((Object)("No credentials available yet. Requesting user to approve access to Contacts API for identity " + identity + " using URL: " + APPROVAL_URL));
        Class<OAuthApprovalDialog> clazz = OAuthApprovalDialog.class;
        synchronized (OAuthApprovalDialog.class) {
            TokenData token;
            String refreshToken = OAuth2TokenStore.restoreRefreshToken(identity);
            if (refreshToken == null) {
                OAuthApprovalDialog dialog = new OAuthApprovalDialog(identity);
                dialog.setVisible(true);
                switch (dialog.getResponse()) {
                    case CONFIRMED: {
                        token = dialog.getToken();
                        if (token == null || token.refreshToken == null) {
                            // ** MonitorExit[var3_2] (shouldn't be in output)
                            return;
                        }
                        OAuth2TokenStore.saveRefreshToken(token, identity);
                        break;
                    }
                    default: {
                        token = null;
                        break;
                    }
                }
            } else {
                token = new TokenData(null, refreshToken, 0L);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            store.set(OAuth2TokenStore.createCredential(store, token));
            return;
        }
    }

    private static String restoreRefreshToken(String identity) {
        CredentialsStorageService credentials = GoogleContactsActivator.getCredentialsService();
        return credentials.loadPassword("net.java.sip.communicator.impl.googlecontacts." + identity);
    }

    private static void saveRefreshToken(TokenData token, String identity) throws IOException {
        CredentialsStorageService credentials = GoogleContactsActivator.getCredentialsService();
        credentials.storePassword("net.java.sip.communicator.impl.googlecontacts." + identity, token.refreshToken);
    }

    public synchronized void refresh() throws IOException, FailedTokenRefreshException {
        Credential credential = this.store.get();
        if (credential == null) {
            throw new IllegalStateException("A credential instance should exist, but it does not. This is likely due to a bug.");
        }
        if (!credential.refreshToken()) {
            LOGGER.warn((Object)"Refresh of OAuth2 authentication token failed.");
            throw new FailedTokenRefreshException();
        }
    }

    private static Credential createCredential(final AtomicReference<Credential> store, TokenData data) throws URISyntaxException {
        Credential.Builder builder = new Credential.Builder(BearerToken.authorizationHeaderAccessMethod());
        builder.setTokenServerUrl(GOOGLE_OAUTH2_TOKEN_SERVER);
        builder.setTransport(new NetHttpTransport());
        builder.setJsonFactory(new JacksonFactory());
        builder.setClientAuthentication(new HttpExecuteInterceptor(){

            @Override
            public void intercept(HttpRequest request) throws IOException {
                Object data = ((UrlEncodedContent)request.getContent()).getData();
                if (data instanceof RefreshTokenRequest) {
                    RefreshTokenRequest content = (RefreshTokenRequest)data;
                    content.put("client_id", (Object)GOOGLE_API_CLIENT_ID);
                    content.put("client_secret", (Object)GOOGLE_API_CLIENT_SECRET);
                    LOGGER.info((Object)"Inserting client authentication data into refresh token request.");
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Request: " + content.toString()));
                    }
                } else {
                    LOGGER.debug((Object)"Unexpected type of request found.");
                }
            }
        });
        builder.addRefreshListener(new CredentialRefreshListener(){

            @Override
            public void onTokenResponse(Credential credential, TokenResponse tokenResponse) throws IOException {
                LOGGER.debug((Object)("Successful token refresh response: " + tokenResponse.toPrettyString()));
                store.set(credential);
            }

            @Override
            public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) throws IOException {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Failed token refresh response: " + tokenErrorResponse.toPrettyString()));
                }
                LOGGER.error((Object)("Failed to refresh OAuth2 token: " + tokenErrorResponse.getError() + ": " + tokenErrorResponse.getErrorDescription()));
            }
        });
        Credential credential = builder.build();
        credential.setAccessToken(data.accessToken);
        credential.setRefreshToken(data.refreshToken);
        credential.setExpiresInSeconds(data.expiration);
        return credential;
    }

    private static TokenData requestAuthenticationToken(String approvalCode) throws ClientProtocolException, IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(GOOGLE_OAUTH2_TOKEN_SERVER.toURI());
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("code", approvalCode), new BasicNameValuePair("client_id", GOOGLE_API_CLIENT_ID), new BasicNameValuePair("client_secret", GOOGLE_API_CLIENT_SECRET), new BasicNameValuePair("redirect_uri", GOOGLE_API_OAUTH2_REDIRECT_URI), new BasicNameValuePair("grant_type", GOOGLE_API_GRANT_TYPE)));
        post.setEntity((HttpEntity)entity);
        HttpResponse httpResponse = client.execute((HttpUriRequest)post);
        String responseJson = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            JsonElement description;
            JsonElement element = new JsonParser().parse(responseJson);
            if (element.isJsonObject() && (description = element.getAsJsonObject().get("error_description")) != null) {
                throw new IOException(description.getAsString());
            }
            throw new IOException(httpResponse.getStatusLine().getReasonPhrase());
        }
        return GSON.fromJson(responseJson, TokenData.class);
    }

    public static class FailedTokenRefreshException
    extends Exception {
        private static final long serialVersionUID = 3166027054735734199L;

        private FailedTokenRefreshException() {
            super("Failed to refresh OAuth2 token.");
        }
    }

    public static class FailedAcquireCredentialException
    extends Exception {
        private static final long serialVersionUID = 5810534617383420431L;

        private FailedAcquireCredentialException(Throwable cause) {
            super(cause);
        }
    }

    private static class TokenData {
        @SerializedName(value="access_token")
        private String accessToken;
        @SerializedName(value="refresh_token")
        private String refreshToken;
        @SerializedName(value="expires_in")
        private long expiration;

        TokenData() {
        }

        private TokenData(String accessToken, String refreshToken, long expirationTime) {
            this.accessToken = accessToken;
            if (refreshToken == null) {
                throw new NullPointerException("refresh token cannot be null");
            }
            this.refreshToken = refreshToken;
            if (expirationTime < 0L) {
                throw new IllegalArgumentException("Expiration time cannot be smaller than zero");
            }
            this.expiration = expirationTime;
        }

        void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        void setExpiration(long expiration) {
            this.expiration = expiration;
        }
    }

    private static class OAuthApprovalDialog
    extends SIPCommDialog
    implements ActionListener {
        private static final long serialVersionUID = 6792589736608633346L;
        private final SIPCommLinkButton link;
        private final SIPCommTextField code = new SIPCommTextField("");
        private final ResourceManagementService resources;
        private TokenData token;
        private UserResponseType response;

        public OAuthApprovalDialog(String identity) {
            super(false);
            this.code.setFont(this.code.getFont().deriveFont(1, 12.0f));
            this.code.setForeground(Color.BLACK);
            this.response = UserResponseType.CANCELLED;
            this.resources = GoogleContactsActivator.getResourceManagementService();
            String instructionsText = this.resources.getI18NString("impl.googlecontacts.INSTRUCTIONS");
            this.setTitle(this.resources.getI18NString("impl.googlecontacts.OAUTH_DIALOG_TITLE"));
            this.setMinimumSize(new Dimension(20, 20));
            this.setPreferredSize(new Dimension(650, 220));
            this.setBounds(10, 10, this.getWidth() - 20, this.getHeight() - 20);
            this.setModal(true);
            TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
            TransparentPanel instructionPanel = new TransparentPanel((LayoutManager)new BorderLayout());
            mainPanel.add((Component)instructionPanel, "North");
            TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new BorderLayout());
            mainPanel.add((Component)buttonPanel, "South");
            JLabel instructionLabel = new JLabel(instructionsText);
            instructionPanel.add((Component)instructionLabel, "Center");
            this.link = new SIPCommLinkButton(this.resources.getI18NString("impl.googlecontacts.HYPERLINK_TEXT", new String[]{identity}));
            this.link.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LOGGER.info((Object)("Requesting user for approval via web page: " + APPROVAL_URL));
                    GoogleContactsActivator.getBrowserLauncherService().openURL(APPROVAL_URL);
                }
            });
            instructionPanel.add((Component)this.link, "South");
            JLabel codeLabel = new JLabel(this.resources.getI18NString("impl.googlecontacts.CODE"));
            codeLabel.setOpaque(false);
            mainPanel.add((Component)codeLabel, "West");
            mainPanel.add((Component)this.code, "Center");
            JButton doneButton = new JButton(this.resources.getI18NString("service.gui.SAVE"));
            doneButton.setMnemonic('s');
            doneButton.addActionListener(this);
            buttonPanel.add((Component)doneButton, "East");
            this.add((Component)mainPanel);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.token = OAuth2TokenStore.requestAuthenticationToken(this.code.getText());
            }
            catch (IOException e1) {
                ErrorDialog dialog = ErrorDialog.create((Dialog)((Object)this), (String)this.resources.getI18NString("service.gui.ERROR"), (String)this.resources.getI18NString("impl.googlecontacts.INVALID_CODE", new String[]{e1.getMessage()}));
                dialog.setVisible(true);
                return;
            }
            this.response = UserResponseType.CONFIRMED;
            this.dispose();
        }

        public TokenData getToken() {
            return this.token;
        }

        public UserResponseType getResponse() {
            return this.response;
        }
    }
}

