/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.demuxcontactsource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.contactsource.AbstractContactQuery;
import net.java.sip.communicator.service.contactsource.ContactChangedEvent;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactQueryStatusEvent;
import net.java.sip.communicator.service.contactsource.ContactReceivedEvent;
import net.java.sip.communicator.service.contactsource.ContactRemovedEvent;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.ExtendedContactSourceService;
import net.java.sip.communicator.service.contactsource.ProtocolAwareContactSourceService;
import net.java.sip.communicator.service.contactsource.SortedGenericSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.utils.logging.Logger;

public class DemuxContactSource
implements ProtocolAwareContactSourceService {
    private final Logger logger = Logger.getLogger(DemuxContactSource.class);
    private final ContactSourceService contactSource;
    private Map<Class<? extends OperationSet>, ProtocolProviderService> preferredProtocolProviders;

    public DemuxContactSource(ContactSourceService contactSource) {
        this.contactSource = contactSource;
    }

    public void setPreferredProtocolProvider(Class<? extends OperationSet> opSetClass, ProtocolProviderService protocolProvider) {
        if (this.preferredProtocolProviders == null) {
            this.preferredProtocolProviders = new HashMap<Class<? extends OperationSet>, ProtocolProviderService>();
        }
        this.preferredProtocolProviders.put(opSetClass, protocolProvider);
    }

    public int getType() {
        return this.contactSource.getType();
    }

    public String getDisplayName() {
        return this.contactSource.getDisplayName();
    }

    public ContactQuery createContactQuery(String queryString) {
        ContactQuery sourceQuery;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Demux query contact source: " + this.contactSource + " for string " + queryString));
        }
        if (queryString == null) {
            queryString = "";
        }
        if ((sourceQuery = this.contactSource instanceof ExtendedContactSourceService ? ((ExtendedContactSourceService)this.contactSource).createContactQuery(Pattern.compile(Pattern.quote(queryString), 74)) : this.contactSource.createContactQuery(queryString)) != null) {
            return new DemuxContactQuery(sourceQuery);
        }
        return null;
    }

    public ContactQuery createContactQuery(String queryString, int contactCount) {
        ContactQuery sourceQuery = this.contactSource.createContactQuery(queryString, contactCount);
        if (sourceQuery != null) {
            return new DemuxContactQuery(sourceQuery);
        }
        return null;
    }

    public int getIndex() {
        return this.contactSource.getIndex();
    }

    private boolean isPreferredContactDetail(ContactDetail c) {
        for (Class<? extends OperationSet> opSetClass : this.preferredProtocolProviders.keySet()) {
            ProtocolProviderService preferredProvider = c.getPreferredProtocolProvider(opSetClass);
            if ((preferredProvider == null || !preferredProvider.equals(this.preferredProtocolProviders.get(opSetClass))) && (preferredProvider != null || c.getSupportedOperationSets() == null || !c.getSupportedOperationSets().contains(opSetClass))) continue;
            return true;
        }
        return false;
    }

    private class DemuxContactQuery
    extends AbstractContactQuery<ContactSourceService>
    implements ContactQueryListener {
        private final ContactQuery sourceQuery;
        private TreeSet<SourceContact> demuxContacts;

        public DemuxContactQuery(ContactQuery sourceQuery) {
            super((ContactSourceService)DemuxContactSource.this);
            this.demuxContacts = new TreeSet();
            this.sourceQuery = sourceQuery;
            sourceQuery.addContactQueryListener((ContactQueryListener)this);
        }

        public ContactSourceService getContactSource() {
            return DemuxContactSource.this;
        }

        public String getQueryString() {
            return this.sourceQuery.getQueryString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SourceContact> getQueryResults() {
            TreeSet<SourceContact> treeSet = this.demuxContacts;
            synchronized (treeSet) {
                return new LinkedList<SourceContact>(this.demuxContacts);
            }
        }

        public void cancel() {
            this.sourceQuery.cancel();
        }

        public void start() {
            this.sourceQuery.start();
        }

        public int getStatus() {
            return this.sourceQuery.getStatus();
        }

        public void contactReceived(ContactReceivedEvent event) {
            SourceContact sourceContact = event.getContact();
            for (ContactDetail detail : sourceContact.getContactDetails()) {
                if (DemuxContactSource.this.preferredProtocolProviders != null && !DemuxContactSource.this.isPreferredContactDetail(detail)) continue;
                SourceContact demuxContact = this.createSourceContact(sourceContact, detail);
                this.addContact(demuxContact);
                this.fireContactReceived(demuxContact);
            }
        }

        private SourceContact createSourceContact(SourceContact sourceContact, ContactDetail contactDetail) {
            ArrayList<ContactDetail> contactDetails = new ArrayList<ContactDetail>();
            contactDetails.add(contactDetail);
            SortedGenericSourceContact genericContact = new SortedGenericSourceContact((ContactQuery)this, (ContactSourceService)DemuxContactSource.this, sourceContact.getDisplayName(), contactDetails);
            String displayName = contactDetail.getDisplayName();
            if (StringUtils.isNotEmpty((CharSequence)displayName)) {
                genericContact.setDisplayDetails(displayName);
            } else {
                genericContact.setDisplayDetails(contactDetail.getDetail());
            }
            genericContact.setPresenceStatus(sourceContact.getPresenceStatus());
            genericContact.setImage(sourceContact.getImage());
            return genericContact;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addContact(SourceContact demuxContact) {
            TreeSet<SourceContact> treeSet = this.demuxContacts;
            synchronized (treeSet) {
                this.demuxContacts.add(demuxContact);
            }
        }

        public void queryStatusChanged(ContactQueryStatusEvent event) {
            this.fireQueryStatusChanged(event.getEventType());
        }

        public void contactRemoved(ContactRemovedEvent event) {
        }

        public void contactChanged(ContactChangedEvent event) {
        }
    }
}

