/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import net.java.sip.communicator.plugin.desktoputil.MoveableTableModel;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.utils.MediaType;

public class EncodingConfigurationTableModel
extends MoveableTableModel {
    private static final long serialVersionUID = 0L;
    private final EncodingConfiguration encodingConfiguration;
    private MediaFormat[] encodings;
    private final MediaType type;

    public EncodingConfigurationTableModel(int type, EncodingConfiguration encodingConfiguration) {
        if (encodingConfiguration == null) {
            throw new IllegalArgumentException("encodingConfiguration");
        }
        this.encodingConfiguration = encodingConfiguration;
        switch (type) {
            case 1: {
                this.type = MediaType.AUDIO;
                break;
            }
            case 2: {
                this.type = MediaType.VIDEO;
                break;
            }
            default: {
                throw new IllegalArgumentException("type");
            }
        }
    }

    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : super.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        return 2;
    }

    private MediaFormat[] getEncodings() {
        if (this.encodings != null) {
            return this.encodings;
        }
        MediaFormat[] availableEncodings = this.encodingConfiguration.getAllEncodings(this.type);
        int encodingCount = availableEncodings.length;
        if (encodingCount < 1) {
            this.encodings = MediaUtils.EMPTY_MEDIA_FORMATS;
        } else {
            HashMap<String, MediaFormat> availableEncodingSet = new HashMap<String, MediaFormat>();
            for (MediaFormat availableEncoding : availableEncodings) {
                availableEncodingSet.put(availableEncoding.getEncoding() + "/" + availableEncoding.getClockRateString(), availableEncoding);
            }
            availableEncodings = availableEncodingSet.values().toArray(MediaUtils.EMPTY_MEDIA_FORMATS);
            encodingCount = availableEncodings.length;
            this.encodings = new MediaFormat[encodingCount];
            System.arraycopy(availableEncodings, 0, this.encodings, 0, encodingCount);
            Arrays.sort(this.encodings, 0, encodingCount, new Comparator<MediaFormat>(){

                @Override
                public int compare(MediaFormat format0, MediaFormat format1) {
                    int ret = EncodingConfigurationTableModel.this.encodingConfiguration.getPriority(format1) - EncodingConfigurationTableModel.this.encodingConfiguration.getPriority(format0);
                    if (ret == 0 && (ret = format0.getEncoding().compareToIgnoreCase(format1.getEncoding())) == 0) {
                        ret = Double.compare(format1.getClockRate(), format0.getClockRate());
                    }
                    return ret;
                }
            });
        }
        return this.encodings;
    }

    private int[] getPriorities() {
        MediaFormat[] encodings = this.getEncodings();
        int count = encodings.length;
        int[] priorities = new int[count];
        for (int i = 0; i < count; ++i) {
            int priority = this.encodingConfiguration.getPriority(encodings[i]);
            priorities[i] = priority > 0 ? count - i : 0;
        }
        return priorities;
    }

    public int getRowCount() {
        return this.getEncodings().length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        MediaFormat encoding = this.getEncodings()[rowIndex];
        switch (columnIndex) {
            case 0: {
                return this.encodingConfiguration.getPriority(encoding) > 0;
            }
            case 1: {
                if (MediaType.VIDEO.equals((Object)encoding.getMediaType()) && 90000.0 == encoding.getClockRate()) {
                    return encoding.getEncoding();
                }
                return encoding.getEncoding() + "/" + encoding.getRealUsedClockRateString();
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public int move(int rowIndex, boolean up) {
        if (up) {
            if (rowIndex <= 0) {
                throw new IllegalArgumentException("rowIndex");
            }
            return this.move(rowIndex - 1, false) - 1;
        }
        if (rowIndex >= this.getRowCount() - 1) {
            throw new IllegalArgumentException("rowIndex");
        }
        int[] priorities = this.getPriorities();
        int nextRowIndex = rowIndex + 1;
        if (priorities[rowIndex] > 0) {
            priorities[rowIndex] = priorities.length - nextRowIndex;
        }
        if (priorities[nextRowIndex] > 0) {
            priorities[nextRowIndex] = priorities.length - rowIndex;
        }
        this.setPriorities(priorities);
        MediaFormat swap = this.encodings[rowIndex];
        this.encodings[rowIndex] = this.encodings[nextRowIndex];
        this.encodings[nextRowIndex] = swap;
        this.fireTableRowsUpdated(rowIndex, nextRowIndex);
        return nextRowIndex;
    }

    private void setPriorities(int[] priorities) {
        int count = this.encodings.length;
        if (priorities.length != count) {
            throw new IllegalArgumentException("priorities");
        }
        for (int i = 0; i < count; ++i) {
            this.encodingConfiguration.setPriority(this.encodings[i], priorities[i]);
        }
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && value instanceof Boolean) {
            int priority = (Boolean)value != false ? this.getPriorities().length - rowIndex : 0;
            MediaFormat encoding = this.encodings[rowIndex];
            this.fireTableCellUpdated(rowIndex, columnIndex);
            this.encodingConfiguration.setPriority(encoding, priority);
        }
    }
}

