/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.notification;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import net.java.sip.communicator.impl.notification.NotificationActivator;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.notification.NotificationData;
import net.java.sip.communicator.service.notification.SoundNotificationAction;
import net.java.sip.communicator.service.notification.SoundNotificationHandler;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.service.audionotifier.AbstractSCAudioClip;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.audionotifier.SCAudioClip;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.OSUtils;
import org.jitsi.utils.logging.Logger;

public class SoundNotificationHandlerImpl
implements SoundNotificationHandler {
    private static Logger logger = Logger.getLogger(SoundNotificationHandlerImpl.class);
    private boolean mute;
    private Map<SCAudioClip, NotificationData> playedClips = new WeakHashMap<SCAudioClip, NotificationData>();
    private static final String PROP_DISABLE_NOTIFICATION_DURING_CALL = "net.java.sip.communicator.impl.notification.disableNotificationDuringCall";

    public String getActionType() {
        return "SoundAction";
    }

    public boolean isMute() {
        return this.mute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void play(SoundNotificationAction action, NotificationData data, SCAudioClipDevice device) {
        UIService uiService;
        AudioNotifierService audioNotifService = NotificationActivator.getAudioNotifier();
        if (audioNotifService == null || StringUtils.isBlank((CharSequence)action.getDescriptor())) {
            return;
        }
        ConfigurationService cfg = NotificationActivator.getConfigurationService();
        if (cfg != null && cfg.getBoolean(PROP_DISABLE_NOTIFICATION_DURING_CALL, false) && SCAudioClipDevice.PLAYBACK.equals((Object)device) && !(uiService = NotificationActivator.getUIService()).getInProgressCalls().isEmpty()) {
            return;
        }
        PCSpeakerClip audio = null;
        switch (device) {
            case NOTIFICATION: 
            case PLAYBACK: {
                audio = audioNotifService.createAudio(action.getDescriptor(), SCAudioClipDevice.PLAYBACK.equals((Object)device));
                break;
            }
            case PC_SPEAKER: {
                if (OSUtils.IS_ANDROID) break;
                audio = new PCSpeakerClip();
            }
        }
        if (audio == null) {
            return;
        }
        Map<SCAudioClip, NotificationData> map = this.playedClips;
        synchronized (map) {
            this.playedClips.put((SCAudioClip)audio, data);
        }
        boolean played = false;
        try {
            Callable loopCondition = (Callable)data.getExtra("SoundNotificationHandler.loopCondition");
            audio.play(action.getLoopInterval(), loopCondition);
            played = true;
        }
        finally {
            Map<SCAudioClip, NotificationData> map2 = this.playedClips;
            synchronized (map2) {
                if (!played) {
                    this.playedClips.remove((Object)audio);
                }
            }
        }
    }

    public void setMute(boolean mute) {
        AudioNotifierService ans;
        this.mute = mute;
        if (mute && (ans = NotificationActivator.getAudioNotifier()) != null && ans.isMute() != this.mute) {
            ans.setMute(this.mute);
        }
    }

    public void start(SoundNotificationAction action, NotificationData data) {
        if (this.isMute()) {
            return;
        }
        boolean playOnlyOnPlayback = true;
        AudioNotifierService audioNotifService = NotificationActivator.getAudioNotifier();
        if (audioNotifService != null) {
            playOnlyOnPlayback = audioNotifService.audioOutAndNotificationsShareSameDevice();
        }
        if (playOnlyOnPlayback) {
            if (action.isSoundNotificationEnabled() || action.isSoundPlaybackEnabled()) {
                this.play(action, data, SCAudioClipDevice.PLAYBACK);
            }
        } else {
            if (action.isSoundNotificationEnabled()) {
                this.play(action, data, SCAudioClipDevice.NOTIFICATION);
            }
            if (action.isSoundPlaybackEnabled()) {
                this.play(action, data, SCAudioClipDevice.PLAYBACK);
            }
        }
        if (action.isSoundPCSpeakerEnabled()) {
            this.play(action, data, SCAudioClipDevice.PC_SPEAKER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(NotificationData data) {
        AudioNotifierService audioNotifService = NotificationActivator.getAudioNotifier();
        if (audioNotifService != null) {
            ArrayList<SCAudioClip> clipsToStop = new ArrayList<SCAudioClip>();
            Map<SCAudioClip, NotificationData> map = this.playedClips;
            synchronized (map) {
                Iterator<Map.Entry<SCAudioClip, NotificationData>> i = this.playedClips.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<SCAudioClip, NotificationData> e = i.next();
                    if (e.getValue() != data) continue;
                    clipsToStop.add(e.getKey());
                    i.remove();
                }
            }
            for (SCAudioClip clip : clipsToStop) {
                try {
                    clip.stop();
                }
                catch (Throwable t) {
                    logger.error((Object)"Error stopping audio clip", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaying(NotificationData data) {
        AudioNotifierService audioNotifService = NotificationActivator.getAudioNotifier();
        if (audioNotifService != null) {
            Map<SCAudioClip, NotificationData> map = this.playedClips;
            synchronized (map) {
                for (Map.Entry<SCAudioClip, NotificationData> e : this.playedClips.entrySet()) {
                    if (e.getValue() != data) continue;
                    return e.getKey().isStarted();
                }
            }
        }
        return false;
    }

    private static enum SCAudioClipDevice {
        NOTIFICATION,
        PC_SPEAKER,
        PLAYBACK;

    }

    private static class PCSpeakerClip
    extends AbstractSCAudioClip {
        private Method beepMethod = null;
        private Object toolkit = null;

        public PCSpeakerClip() {
            super(null, NotificationActivator.getAudioNotifier());
            try {
                Method getDefaultToolkitMethod = Class.forName("java.awt.Toolkit").getMethod("getDefaultToolkit", new Class[0]);
                this.toolkit = getDefaultToolkitMethod.invoke(null, new Object[0]);
                this.beepMethod = this.toolkit.getClass().getMethod("beep", new Class[0]);
            }
            catch (Throwable t) {
                logger.error((Object)"Cannot load awt.Toolkit", t);
            }
        }

        protected boolean runOnceInPlayThread() {
            try {
                if (this.beepMethod != null) {
                    this.beepMethod.invoke(this.toolkit, new Object[0]);
                }
                return true;
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                return false;
            }
        }
    }
}

