/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.jdic;

import com.apple.eawt.Application;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.java.sip.communicator.impl.osdependent.OsDependentActivator;
import net.java.sip.communicator.impl.osdependent.PopupMessageHandlerTrayIconImpl;
import net.java.sip.communicator.impl.osdependent.Resources;
import net.java.sip.communicator.impl.osdependent.jdic.TrayMenuFactory;
import net.java.sip.communicator.impl.osdependent.systemtray.SystemTray;
import net.java.sip.communicator.impl.osdependent.systemtray.TrayIcon;
import net.java.sip.communicator.impl.osdependent.windows.TaskBarList3;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.systray.AbstractSystrayService;
import net.java.sip.communicator.service.systray.PopupMessageHandler;
import net.java.sip.communicator.service.systray.event.SystrayPopupMessageEvent;
import net.java.sip.communicator.service.systray.event.SystrayPopupMessageListener;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.tuple.Pair;
import org.jitsi.util.OSUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class SystrayServiceJdicImpl
extends AbstractSystrayService {
    private final SystemTray systray;
    private TrayIcon trayIcon;
    private Object menu;
    private static final Logger logger = Logger.getLogger(SystrayServiceJdicImpl.class);
    private ImageIcon currentIcon;
    private ImageIcon logoIcon;
    private ImageIcon logoIconOffline;
    private ImageIcon logoIconAway;
    private ImageIcon logoIconExtendedAway;
    private ImageIcon logoIconFFC;
    private ImageIcon logoIconDND;
    private ImageIcon logoIconWhite;
    private URL dockIconOnline;
    private URL dockIconOffline;
    private URL dockIconAway;
    private URL dockIconExtendedAway;
    private URL dockIconFFC;
    private URL dockIconDND;
    private Image originalDockImage;
    private boolean initialized;
    private final SystrayPopupMessageListener popupMessageListener;

    public SystrayServiceJdicImpl() {
        SystemTray systray;
        block4: {
            super(OsDependentActivator.bundleContext);
            this.originalDockImage = null;
            this.initialized = false;
            this.popupMessageListener = new SystrayPopupMessageListenerImpl();
            try {
                systray = SystemTray.getSystemTray();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                systray = null;
                if (GraphicsEnvironment.isHeadless()) break block4;
                logger.error((Object)"Failed to create a systray!", t);
            }
        }
        this.systray = systray;
        if (this.systray != null) {
            this.initSystray();
        }
    }

    @Override
    public Map<String, String> getSystrayModes() {
        return new HashMap<String, String>(){
            {
                this.put("disabled", "service.systray.mode.DISABLED");
                if (java.awt.SystemTray.isSupported()) {
                    this.put("native", "service.systray.mode.NATIVE");
                }
                if (!OSUtils.IS_MAC && !OSUtils.IS_WINDOWS) {
                    this.put("appindicator", "service.systray.mode.APPINDICATOR");
                    this.put("appindicator_static", "service.systray.mode.APPINDICATOR_STATIC");
                }
            }
        };
    }

    @Override
    public String getActiveSystrayMode() {
        return SystemTray.getSystemTrayMode();
    }

    private void initSystray() {
        UIService uiService = OsDependentActivator.getUIService();
        if (uiService == null) {
            try {
                OsDependentActivator.bundleContext.addServiceListener((ServiceListener)new DelayedInitSystrayServiceListener(), "(objectClass=" + UIService.class.getName() + ')');
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            return;
        }
        Pair<Object, Object> createdMenu = TrayMenuFactory.createTrayMenu(this, this.systray.useSwingPopupMenu(), this.systray.supportsDynamicMenu());
        this.menu = createdMenu.getLeft();
        boolean isMac = OSUtils.IS_MAC;
        this.logoIcon = Resources.getImage("service.systray.TRAY_ICON_WINDOWS");
        this.logoIconOffline = Resources.getImage("service.systray.TRAY_ICON_WINDOWS_OFFLINE");
        this.logoIconAway = Resources.getImage("service.systray.TRAY_ICON_WINDOWS_AWAY");
        this.logoIconExtendedAway = Resources.getImage("service.systray.TRAY_ICON_WINDOWS_EXTENDED_AWAY");
        this.logoIconFFC = Resources.getImage("service.systray.TRAY_ICON_WINDOWS_FFC");
        this.logoIconDND = Resources.getImage("service.systray.TRAY_ICON_WINDOWS_DND");
        if (isMac) {
            this.logoIcon = Resources.getImage("service.systray.TRAY_ICON_MACOSX");
            this.logoIconWhite = Resources.getImage("service.systray.TRAY_ICON_MACOSX_WHITE");
        }
        this.currentIcon = isMac ? this.logoIcon : this.logoIconOffline;
        this.trayIcon = this.systray.createTrayIcon(this.currentIcon, Resources.getApplicationString("service.gui.APPLICATION_NAME"), this.menu);
        this.trayIcon.setIconAutoSize(true);
        if (isMac) {
            this.dockIconOnline = Resources.getImageURL("service.systray.DOCK_ICON_ONLINE");
            this.dockIconOffline = Resources.getImageURL("service.systray.DOCK_ICON_OFFLINE");
            this.dockIconAway = Resources.getImageURL("service.systray.DOCK_ICON_AWAY");
            this.dockIconExtendedAway = Resources.getImageURL("service.systray.DOCK_ICON_EXTENDED_AWAY");
            this.dockIconFFC = Resources.getImageURL("service.systray.DOCK_ICON_FFC");
            this.dockIconDND = Resources.getImageURL("service.systray.DOCK_ICON_DND");
        }
        final Object defaultActionItem = createdMenu.getRight();
        if (isMac) {
            TrayMenuFactory.addPopupMenuListener(this.menu, new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    ImageIcon newIcon = SystrayServiceJdicImpl.this.logoIconWhite;
                    SystrayServiceJdicImpl.this.trayIcon.setIcon(newIcon);
                    SystrayServiceJdicImpl.this.currentIcon = newIcon;
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    ImageIcon newIcon = SystrayServiceJdicImpl.this.logoIcon;
                    SystrayServiceJdicImpl.this.getTrayIcon().setIcon(newIcon);
                    SystrayServiceJdicImpl.this.currentIcon = newIcon;
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    this.popupMenuWillBecomeInvisible(e);
                }
            });
        }
        PopupMessageHandlerTrayIconImpl pmh = null;
        if (!isMac) {
            pmh = new PopupMessageHandlerTrayIconImpl(this.trayIcon);
            this.addPopupHandler(pmh);
            OsDependentActivator.bundleContext.registerService(PopupMessageHandler.class.getName(), (Object)pmh, null);
        }
        this.initHandlers();
        if (this.getActivePopupMessageHandler() == null && pmh != null) {
            this.setActivePopupMessageHandler(pmh);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SystrayServiceJdicImpl.this.systray.addTrayIcon(SystrayServiceJdicImpl.this.trayIcon);
                SystrayServiceJdicImpl.this.trayIcon.setDefaultAction(defaultActionItem);
            }
        });
        this.initialized = true;
        uiService.setMainWindowCanHide(true);
    }

    @Override
    public void setSystrayIcon(int imageType) {
        if (!this.checkInitialized()) {
            return;
        }
        boolean isMac = OSUtils.IS_MAC;
        ImageIcon systrayIconToSet = null;
        switch (imageType) {
            case 0: {
                systrayIconToSet = isMac && TrayMenuFactory.isVisible(this.menu) ? this.logoIconWhite : this.logoIcon;
                break;
            }
            case 2: {
                if (isMac) break;
                systrayIconToSet = this.logoIconOffline;
                break;
            }
            case 3: {
                if (isMac) break;
                systrayIconToSet = this.logoIconAway;
                break;
            }
            case 6: {
                if (isMac) break;
                systrayIconToSet = this.logoIconExtendedAway;
                break;
            }
            case 4: {
                if (isMac) break;
                systrayIconToSet = this.logoIconFFC;
                break;
            }
            case 5: {
                if (isMac) break;
                systrayIconToSet = this.logoIconDND;
            }
        }
        if (systrayIconToSet != null) {
            this.trayIcon.setIcon(systrayIconToSet);
            this.currentIcon = systrayIconToSet;
        }
        if (isMac) {
            URL dockIconURLToSet;
            switch (imageType) {
                case 0: {
                    dockIconURLToSet = this.dockIconOnline;
                    break;
                }
                case 2: {
                    dockIconURLToSet = this.dockIconOffline;
                    break;
                }
                case 3: {
                    dockIconURLToSet = this.dockIconAway;
                    break;
                }
                case 6: {
                    dockIconURLToSet = this.dockIconExtendedAway;
                    break;
                }
                case 4: {
                    dockIconURLToSet = this.dockIconFFC;
                    break;
                }
                case 5: {
                    dockIconURLToSet = this.dockIconDND;
                    break;
                }
                default: {
                    dockIconURLToSet = null;
                }
            }
            try {
                Application application = Application.getApplication();
                if (this.originalDockImage == null) {
                    this.originalDockImage = application.getDockIconImage();
                }
                if (dockIconURLToSet != null) {
                    application.setDockIconImage(Toolkit.getDefaultToolkit().getImage(dockIconURLToSet));
                } else if (this.originalDockImage != null) {
                    application.setDockIconImage(this.originalDockImage);
                }
            }
            catch (Exception e) {
                logger.error((Object)"failed to change dock icon", (Throwable)e);
            }
        }
    }

    @Override
    public boolean checkInitialized() {
        return this.initialized;
    }

    @Override
    public void setNotificationCount(int count) {
        if (OSUtils.IS_MAC) {
            Application application = Application.getApplication();
            if (count > 0) {
                application.setDockIconBadge(new Integer(count).toString());
            } else {
                application.setDockIconBadge(null);
            }
        } else if (OSUtils.IS_WINDOWS) {
            UIService uiService = OsDependentActivator.getUIService();
            if (uiService == null) {
                return;
            }
            ExportedWindow mainWindow = uiService.getExportedWindow(ExportedWindow.MAIN_WINDOW);
            if (mainWindow == null || !(mainWindow.getSource() instanceof Component)) {
                return;
            }
            BufferedImage img = null;
            if (count > 0) {
                img = this.createOverlayImage(new Integer(count).toString());
            }
            try {
                TaskBarList3.getInstance().SetOverlayIcon((Component)mainWindow.getSource(), img, null);
            }
            catch (Exception ex) {
                logger.error((Object)"Could not set the notification count.", (Throwable)ex);
            }
        }
    }

    private BufferedImage createOverlayImage(String text) {
        int size = 16;
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(new Color(0, 0, 0, 102));
        g.fillRoundRect(0, 0, size, size, size, size);
        int mainRadius = 14;
        g.setPaint(new Color(255, 98, 89));
        g.fillRoundRect(size / 2 - mainRadius / 2, size / 2 - mainRadius / 2, mainRadius, mainRadius, size, size);
        Font font = g.getFont();
        g.setFont(new Font(font.getName(), 1, 9));
        FontMetrics fontMetrics = g.getFontMetrics();
        int textWidth = fontMetrics.stringWidth(text);
        g.setColor(Color.white);
        g.drawString(text, size / 2 - textWidth / 2, size / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
        return image;
    }

    public TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    @Override
    public PopupMessageHandler setActivePopupMessageHandler(PopupMessageHandler newHandler) {
        PopupMessageHandler oldHandler = this.getActivePopupHandler();
        if (oldHandler != null) {
            oldHandler.removePopupMessageListener(this.popupMessageListener);
        }
        if (newHandler != null) {
            newHandler.addPopupMessageListener(this.popupMessageListener);
        }
        return super.setActivePopupMessageHandler(newHandler);
    }

    private class DelayedInitSystrayServiceListener
    implements ServiceListener {
        private DelayedInitSystrayServiceListener() {
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            UIService uiService;
            if (serviceEvent.getType() == 1 && (uiService = OsDependentActivator.getUIService()) != null) {
                OsDependentActivator.bundleContext.removeServiceListener((ServiceListener)this);
                if (!SystrayServiceJdicImpl.this.initialized && SystrayServiceJdicImpl.this.systray != null) {
                    SystrayServiceJdicImpl.this.initSystray();
                }
            }
        }
    }

    private static class SystrayPopupMessageListenerImpl
    implements SystrayPopupMessageListener {
        private SystrayPopupMessageListenerImpl() {
        }

        @Override
        public void popupMessageClicked(SystrayPopupMessageEvent evt) {
            Object o = evt.getTag();
            if (o instanceof Contact) {
                OsDependentActivator.getUIService().getChat((Contact)o).setChatVisible(true);
            }
        }
    }
}

