/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.systemtray.appindicator;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleState;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.sip.communicator.impl.osdependent.systemtray.TrayIcon;
import net.java.sip.communicator.impl.osdependent.systemtray.appindicator.AppIndicator1;
import net.java.sip.communicator.impl.osdependent.systemtray.appindicator.Gobject;
import net.java.sip.communicator.impl.osdependent.systemtray.appindicator.Gtk;
import org.jitsi.utils.logging.Logger;

class AppIndicatorTrayIcon
implements TrayIcon {
    private static final Logger logger = Logger.getLogger(AppIndicatorTrayIcon.class);
    private static Gobject gobject = Gobject.INSTANCE;
    private static Gtk gtk = Gtk.INSTANCE;
    private static AppIndicator1 ai = AppIndicator1.INSTANCE;
    private ImageIcon mainIcon;
    private String title;
    private JPopupMenu popup;
    private Map<String, String> extractedFiles = new HashMap<String, String>();
    private PopupMenuPeer popupPeer;
    private AppIndicator1.AppIndicator appIndicator;
    private PopupMenuPeer defaultMenuPeer;

    public AppIndicatorTrayIcon(ImageIcon mainIcon, String title, JPopupMenu popup) {
        this.mainIcon = mainIcon;
        this.title = title;
        this.popup = popup;
        this.popupPeer = null;
    }

    public void createTray() {
        gtk.gdk_threads_enter();
        try {
            this.setupGtkMenu();
        }
        finally {
            gtk.gdk_threads_leave();
        }
        new Thread(){

            @Override
            public void run() {
                gtk.gtk_main();
            }
        }.start();
    }

    private void setupGtkMenu() {
        File iconFile = new File(this.imageIconToPath(this.mainIcon));
        this.appIndicator = ai.app_indicator_new_with_path("jitsi", iconFile.getName().replaceFirst("[.][^.]+$", ""), AppIndicator1.APP_INDICATOR_CATEGORY.COMMUNICATIONS.ordinal(), iconFile.getParent());
        ai.app_indicator_set_title(this.appIndicator, this.title);
        ai.app_indicator_set_icon_full(this.appIndicator, iconFile.getAbsolutePath(), "Jitsi");
        this.popupPeer = new PopupMenuPeer(null, this.popup);
        this.popupPeer.gtkMenu = gtk.gtk_menu_new();
        this.createGtkMenuItems(this.popupPeer, this.popup.getComponents());
        gtk.gtk_widget_show_all(this.popupPeer.gtkMenu);
        ai.app_indicator_set_menu(this.appIndicator, this.popupPeer.gtkMenu);
        ai.app_indicator_set_status(this.appIndicator, AppIndicator1.APP_INDICATOR_STATUS.ACTIVE.ordinal());
    }

    private void cleanMenu(PopupMenuPeer peer) {
        assert (!peer.isDefaultMenuItem);
        for (PopupMenuPeer p : peer.children) {
            this.cleanMenu(p);
        }
        if (peer.gtkSignalHandler > 0L) {
            gobject.g_signal_handler_disconnect(peer.gtkMenuItem, peer.gtkSignalHandler);
        }
        gtk.gtk_widget_destroy(peer.gtkMenuItem);
        peer.gtkImageBuffer = null;
        if (peer.menuItem instanceof JMenu) {
            ((JMenu)peer.menuItem).removeContainerListener(peer);
            ((JMenu)peer.menuItem).getPopupMenu().removeContainerListener(peer);
        }
    }

    private void createGtkMenuItems(PopupMenuPeer parent, Component[] components) {
        for (Component em : components) {
            PopupMenuPeer peer = new PopupMenuPeer(parent, em);
            if (em instanceof JPopupMenu.Separator) {
                logger.debug((Object)"Creating separator");
                peer.gtkMenuItem = gtk.gtk_separator_menu_item_new();
            }
            if (em instanceof JMenuItem) {
                this.createGtkMenuItem(peer);
            }
            if (em instanceof JMenu && peer.gtkMenuItem != null) {
                JMenu m = (JMenu)em;
                logger.debug((Object)("Creating submenu on " + m.getText()));
                peer.gtkMenu = gtk.gtk_menu_new();
                this.createGtkMenuItems(peer, m.getMenuComponents());
                gtk.gtk_menu_item_set_submenu(peer.gtkMenuItem, peer.gtkMenu);
            }
            if (peer.gtkMenuItem == null) continue;
            parent.children.add(peer);
            gtk.gtk_menu_shell_append(parent.gtkMenu, peer.gtkMenuItem);
        }
    }

    private void createGtkMenuItem(PopupMenuPeer peer) {
        JMenuItem m = (JMenuItem)peer.menuItem;
        logger.debug((Object)("Creating item for " + m.getClass().getName() + ": " + m.getText()));
        if (m instanceof JCheckBoxMenuItem) {
            peer.gtkMenuItem = gtk.gtk_check_menu_item_new_with_label(m.getText());
            JCheckBoxMenuItem cb = (JCheckBoxMenuItem)m;
            gtk.gtk_check_menu_item_set_active(peer.gtkMenuItem, cb.isSelected() ? 1 : 0);
        } else {
            peer.gtkMenuItem = gtk.gtk_image_menu_item_new_with_label(m.getText());
            if (m.getIcon() instanceof ImageIcon) {
                ImageIcon ii = (ImageIcon)m.getIcon();
                this.imageIconToGtkWidget(peer, ii);
                if (peer.gtkImage != null) {
                    gtk.gtk_image_menu_item_set_image(peer.gtkMenuItem, peer.gtkImage);
                    gtk.gtk_image_menu_item_set_always_show_image(peer.gtkMenuItem, 1);
                }
            }
        }
        if (peer.gtkMenuItem == null) {
            logger.debug((Object)("Could not create menu item for " + m.getText()));
            return;
        }
        MenuItemChangeListener micl = new MenuItemChangeListener(peer);
        m.addPropertyChangeListener(micl);
        m.addChangeListener(micl);
        if (!(m instanceof JMenu)) {
            gtk.gtk_widget_set_sensitive(peer.gtkMenuItem, m.isEnabled() ? 1 : 0);
            peer.signalHandler = new MenuItemSignalHandler(peer);
            peer.gtkSignalHandler = gobject.g_signal_connect_data(peer.gtkMenuItem, "activate", peer.signalHandler, null, null, 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String imageIconToPath(ImageIcon ii) {
        String path;
        if (ii.getDescription() != null && (path = this.extractedFiles.get(ii.getDescription())) != null) {
            return path;
        }
        try {
            File f = File.createTempFile("jitsi-appindicator", ".png");
            f.deleteOnExit();
            try (FileImageOutputStream fios = new FileImageOutputStream(f);){
                if (!ImageIO.write((RenderedImage)this.getBufferedImage(ii), "png", fios)) {
                    String string2 = null;
                    return string2;
                }
                if (ii.getDescription() != null) {
                    this.extractedFiles.put(ii.getDescription(), f.getAbsolutePath());
                }
                String string = f.getAbsolutePath();
                return string;
            }
        }
        catch (IOException e) {
            logger.debug((Object)("Failed to extract image: " + ii.getDescription()), (Throwable)e);
            return null;
        }
    }

    BufferedImage getBufferedImage(ImageIcon ii) {
        Image img = ii.getImage();
        if (img == null) {
            return null;
        }
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    private void imageIconToGtkWidget(PopupMenuPeer peer, ImageIcon ii) {
        BufferedImage bi = this.getBufferedImage(ii);
        if (bi == null) {
            return;
        }
        int[] pixels = bi.getRGB(0, 0, bi.getWidth(), bi.getHeight(), null, 0, bi.getWidth());
        peer.gtkImageBuffer = new Memory((long)(pixels.length * 4));
        for (int i = 0; i < pixels.length; ++i) {
            peer.gtkImageBuffer.setInt((long)(i * 4), pixels[i] & 0xFF000000 | pixels[i] << 16 | pixels[i] & 0xFF00 | pixels[i] >>> 16 & 0xFF);
        }
        peer.gtkPixbuf = gtk.gdk_pixbuf_new_from_data((Pointer)peer.gtkImageBuffer, 0, 1, 8, bi.getWidth(), bi.getHeight(), bi.getWidth() * 4, null, null);
        peer.gtkImage = gtk.gtk_image_new_from_pixbuf(peer.gtkPixbuf);
        gobject.g_object_unref(peer.gtkPixbuf);
    }

    @Override
    public void setDefaultAction(Object menuItem) {
        PopupMenuPeer peer;
        if (this.defaultMenuPeer != null) {
            gobject.g_object_unref(this.defaultMenuPeer.gtkMenuItem);
        }
        if ((peer = this.findMenuItem(this.popupPeer, menuItem)) != null && peer.gtkMenuItem != null) {
            gtk.gdk_threads_enter();
            try {
                this.defaultMenuPeer = peer;
                gobject.g_object_ref(peer.gtkMenuItem);
                ai.app_indicator_set_secondary_activate_target(this.appIndicator, peer.gtkMenuItem);
            }
            finally {
                gtk.gdk_threads_leave();
            }
        }
    }

    private PopupMenuPeer findMenuItem(PopupMenuPeer peer, Object menuItem) {
        if (peer.menuItem == menuItem) {
            logger.debug((Object)("Setting default action to: " + ((JMenuItem)menuItem).getText() + " @" + peer.gtkMenuItem));
            return peer;
        }
        for (PopupMenuPeer p : peer.children) {
            PopupMenuPeer found = this.findMenuItem(p, menuItem);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public void addBalloonActionListener(ActionListener listener) {
    }

    @Override
    public void displayMessage(String caption, String text, TrayIcon.MessageType messageType) {
    }

    @Override
    public void setIcon(ImageIcon icon) throws NullPointerException {
        this.mainIcon = icon;
        if (this.appIndicator != null) {
            gtk.gdk_threads_enter();
            try {
                ai.app_indicator_set_icon(this.appIndicator, this.imageIconToPath(icon));
            }
            finally {
                gtk.gdk_threads_leave();
            }
        }
    }

    @Override
    public void setIconAutoSize(boolean autoSize) {
    }

    private void printMenu(Component[] components, int indent) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        String p = String.format("%0" + indent * 4 + "d", 0).replace('0', ' ');
        for (Component em : components) {
            JMenuItem m;
            if (em instanceof JPopupMenu.Separator) {
                logger.debug((Object)(p + "-----------------------"));
            }
            if (em instanceof JMenuItem) {
                m = (JMenuItem)em;
                logger.debug((Object)(p + em.getClass().getName() + ": " + m.getText()));
            }
            if (!(em instanceof JMenu)) continue;
            m = (JMenu)em;
            this.printMenu(((JMenu)m).getMenuComponents(), indent + 1);
        }
    }

    private static class MenuItemSignalHandler
    implements Gobject.SignalHandler,
    Runnable {
        private PopupMenuPeer peer;

        MenuItemSignalHandler(PopupMenuPeer peer) {
            this.peer = peer;
        }

        @Override
        public void signal(Pointer widget, Pointer data) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            JMenuItem menu = (JMenuItem)this.peer.menuItem;
            if (menu instanceof JCheckBoxMenuItem) {
                logger.debug((Object)("Checking selected state on: " + menu.getText()));
                if (menu.isSelected() == this.isGtkSelected()) {
                    return;
                }
            }
            for (ActionListener l : menu.getActionListeners()) {
                logger.debug((Object)("Invoking " + l + " on " + menu.getText()));
                l.actionPerformed(new ActionEvent(menu, 0, "activate"));
            }
        }

        private boolean isGtkSelected() {
            gtk.gdk_threads_enter();
            try {
                boolean bl = gtk.gtk_check_menu_item_get_active(this.peer.gtkMenuItem) == 1;
                return bl;
            }
            finally {
                gtk.gdk_threads_leave();
            }
        }
    }

    private static class MenuItemChangeListener
    implements PropertyChangeListener,
    ChangeListener {
        private PopupMenuPeer peer;
        private JMenuItem menu;

        public MenuItemChangeListener(PopupMenuPeer peer) {
            this.peer = peer;
            this.menu = (JMenuItem)peer.menuItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.menu.getText() + "::" + evt.getPropertyName()));
            }
            switch (evt.getPropertyName()) {
                case "text": {
                    gtk.gdk_threads_enter();
                    try {
                        gtk.gtk_menu_item_set_label(this.peer.gtkMenuItem, evt.getNewValue().toString());
                        break;
                    }
                    finally {
                        gtk.gdk_threads_leave();
                    }
                }
                case "AccessibleState": {
                    gtk.gdk_threads_enter();
                    try {
                        gtk.gtk_widget_set_sensitive(this.peer.gtkMenuItem, AccessibleState.ENABLED.equals(evt.getNewValue()) ? 1 : 0);
                        break;
                    }
                    finally {
                        gtk.gdk_threads_leave();
                    }
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            logger.debug((Object)(this.menu.getText() + " -> " + this.menu.isSelected()));
            gtk.gdk_threads_enter();
            try {
                gtk.gtk_check_menu_item_set_active(this.peer.gtkMenuItem, this.menu.isSelected() ? 1 : 0);
            }
            finally {
                gtk.gdk_threads_leave();
            }
        }
    }

    private class PopupMenuPeer
    implements ContainerListener {
        public List<PopupMenuPeer> children = new ArrayList<PopupMenuPeer>();
        public Pointer gtkMenuItem;
        public Pointer gtkMenu;
        public Pointer gtkImage;
        public Memory gtkImageBuffer;
        public Pointer gtkPixbuf;
        public Component menuItem;
        public MenuItemSignalHandler signalHandler;
        public long gtkSignalHandler;
        public boolean isDefaultMenuItem;

        public PopupMenuPeer(PopupMenuPeer parent, Component em) {
            this.menuItem = em;
            if (em instanceof JMenu) {
                ((JMenu)em).getPopupMenu().addContainerListener(this);
                ((JMenu)em).addContainerListener(this);
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.isDefaultMenuItem) {
                gobject.g_object_unref(this.gtkMenuItem);
            }
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            AppIndicatorTrayIcon.this.printMenu(AppIndicatorTrayIcon.this.popup.getComponents(), 1);
            gtk.gdk_threads_enter();
            try {
                AppIndicatorTrayIcon.this.createGtkMenuItems(this, new Component[]{e.getChild()});
                gtk.gtk_widget_show_all(((AppIndicatorTrayIcon)AppIndicatorTrayIcon.this).popupPeer.gtkMenu);
            }
            finally {
                gtk.gdk_threads_leave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void componentRemoved(ContainerEvent e) {
            AppIndicatorTrayIcon.this.printMenu(AppIndicatorTrayIcon.this.popup.getComponents(), 1);
            for (PopupMenuPeer c : this.children) {
                if (c.menuItem != e.getChild()) continue;
                gtk.gdk_threads_enter();
                try {
                    AppIndicatorTrayIcon.this.cleanMenu(c);
                }
                finally {
                    gtk.gdk_threads_leave();
                }
                this.children.remove(c);
                break;
            }
        }
    }
}

