/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.reconnectplugin;

import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.plugin.reconnectplugin.ReconnectPluginActivator;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;

public class PPReconnectWrapper
implements RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(PPReconnectWrapper.class);
    private final ProtocolProviderService provider;
    private RegistrationState localState = null;
    private final Object localStateMutex = new Object();
    private Timer timer = null;
    private boolean currentlyUnregistering = false;
    private Long reconnectOnNextUnregisteredDelay = null;
    private ReconnectTask currentReconnect = null;
    private final Object reconnectTaskMutex = new Object();

    public PPReconnectWrapper(ProtocolProviderService provider) {
        this.provider = provider;
        this.timer = new Timer("Reconnect timer p:" + provider.getAccountID().getAccountUniqueID(), true);
        provider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
    }

    public ProtocolProviderService getProvider() {
        return this.provider;
    }

    public void clear() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.provider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        this.cancelReconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        RegistrationState state = evt.getNewState();
        if (!(evt.getSource() instanceof ProtocolProviderService) || !state.equals((Object)RegistrationState.REGISTERED) && !state.equals((Object)RegistrationState.UNREGISTERED) && !state.equals((Object)RegistrationState.CONNECTION_FAILED)) {
            return;
        }
        ProtocolProviderService pp = (ProtocolProviderService)evt.getSource();
        Object object = this.localStateMutex;
        synchronized (object) {
            if (state.equals((Object)this.localState)) {
                return;
            }
            this.localState = state;
            if (this.reconnectOnNextUnregisteredDelay != null) {
                long delay = this.reconnectOnNextUnregisteredDelay;
                this.reconnectOnNextUnregisteredDelay = null;
                if ((state.equals((Object)RegistrationState.UNREGISTERED) || state.equals((Object)RegistrationState.CONNECTION_FAILED)) && !evt.isUserRequest() && this.currentlyUnregistering) {
                    this.currentlyUnregistering = false;
                    this.createReconnect(delay);
                    return;
                }
            }
            boolean isServerReturnedErroneousInputEvent = state.equals((Object)RegistrationState.CONNECTION_FAILED) && evt.getReasonCode() == 10;
            try {
                if (state.equals((Object)RegistrationState.REGISTERED)) {
                    ReconnectPluginActivator.addReconnectEnabledProvider(this);
                    this.cancelReconnect();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Got Registered for " + pp));
                        ReconnectPluginActivator.traceCurrentPPState();
                    }
                } else if (state.equals((Object)RegistrationState.CONNECTION_FAILED) && !isServerReturnedErroneousInputEvent) {
                    if (!ReconnectPluginActivator.hasAtLeastOneSuccessfulConnection(pp)) {
                        ReconnectPluginActivator.notifyConnectionFailed(evt);
                        return;
                    }
                    if (this.currentlyUnregistering) {
                        this.currentlyUnregistering = false;
                        return;
                    }
                    if (ReconnectPluginActivator.anyConnectedInterfaces()) {
                        this.reconnect(this.currentReconnect != null ? this.currentReconnect.delay : -1L);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Got Connection Failed for " + pp), (Throwable)new Exception("tracing exception"));
                        ReconnectPluginActivator.traceCurrentPPState();
                    }
                } else if (state.equals((Object)RegistrationState.UNREGISTERED) || isServerReturnedErroneousInputEvent) {
                    this.currentlyUnregistering = false;
                    if (evt.isUserRequest() || isServerReturnedErroneousInputEvent) {
                        this.clear();
                        ReconnectPluginActivator.removeReconnectEnabledProviders(this);
                    }
                    this.cancelReconnect();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Got Unregistered for " + pp));
                        ReconnectPluginActivator.traceCurrentPPState();
                    }
                }
            }
            catch (Throwable ex) {
                logger.error((Object)"Error dispatching protocol registration change", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelReconnect() {
        Object object = this.reconnectTaskMutex;
        synchronized (object) {
            if (this.currentReconnect != null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Cancel reconnect " + this.currentReconnect));
                }
                this.currentReconnect.cancel();
                this.currentReconnect = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReconnect(long delay) {
        Object object = this.reconnectTaskMutex;
        synchronized (object) {
            if (this.currentReconnect == null) {
                this.currentReconnect = this.scheduleReconnectIfNeeded(delay, this.provider);
            } else {
                logger.warn((Object)("Reconnect with delay:" + this.currentReconnect.delay + " already scheduled for " + this.provider + " attempted schedule with delay:" + delay));
            }
        }
    }

    void reconnect() {
        this.cancelReconnect();
        this.reconnect(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(long previousDelay) {
        long delay = previousDelay != -1L ? Math.min(previousDelay * 2L, 300000L) : (long)(2.0 + Math.random() * 4.0) * 1000L;
        if (this.provider.getRegistrationState().equals((Object)RegistrationState.UNREGISTERING) || this.provider.getRegistrationState().equals((Object)RegistrationState.UNREGISTERED) || this.provider.getRegistrationState().equals((Object)RegistrationState.CONNECTION_FAILED)) {
            this.createReconnect(delay);
        } else {
            Object object = this.localStateMutex;
            synchronized (object) {
                this.reconnectOnNextUnregisteredDelay = delay;
                this.unregister();
            }
        }
    }

    void unregister() {
        this.currentlyUnregistering = true;
        this.cancelReconnect();
        try {
            this.provider.unregister();
        }
        catch (Throwable t) {
            logger.error((Object)("Error unregistering pp:" + this.provider), t);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("[provider=").append(this.provider).append(", currentlyUnregistering=").append(this.currentlyUnregistering).append(", currentReconnect=").append(this.currentReconnect).append(", reconnectOnNextUnregisteredDelay=").append(this.reconnectOnNextUnregisteredDelay).append("]");
        return builder.toString();
    }

    private ReconnectTask scheduleReconnectIfNeeded(long delay, ProtocolProviderService pp) {
        ReconnectTask task = new ReconnectTask();
        task.delay = delay;
        if (this.timer == null) {
            return null;
        }
        if (!ReconnectPluginActivator.anyConnectedInterfaces()) {
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Reconnect " + pp + " after " + task.delay + " ms."));
        }
        this.timer.schedule((TimerTask)task, task.delay);
        return task;
    }

    private class ReconnectTask
    extends TimerTask {
        long delay;

        private ReconnectTask() {
        }

        @Override
        public void run() {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Start reconnecting " + PPReconnectWrapper.this.provider));
                }
                PPReconnectWrapper.this.provider.register(ReconnectPluginActivator.getUIService().getDefaultSecurityAuthority(PPReconnectWrapper.this.provider));
            }
            catch (OperationFailedException ex) {
                logger.error((Object)"cannot re-register provider will keep going", (Throwable)ex);
            }
        }

        public String toString() {
            return ReconnectTask.class.getSimpleName() + " [delay=" + this.delay + ", provider=" + PPReconnectWrapper.this.provider + "]";
        }
    }
}

