/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.reconnectplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import net.java.sip.communicator.plugin.reconnectplugin.PPReconnectWrapper;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.netaddr.event.ChangeEvent;
import net.java.sip.communicator.service.netaddr.event.NetworkConfigurationChangeListener;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ReconnectPluginActivator
implements BundleActivator,
ServiceListener,
NetworkConfigurationChangeListener {
    private static final Logger logger = Logger.getLogger(ReconnectPluginActivator.class);
    private static BundleContext bundleContext = null;
    private static UIService uiService;
    private static ResourceManagementService resourcesService;
    private static ConfigurationService configurationService;
    private static NotificationService notificationService;
    private NetworkAddressManagerService networkAddressManagerService = null;
    private static final Map<PPReconnectWrapper, List<String>> reconnectEnabledProviders;
    private static final Set<String> connectedInterfaces;
    static final int RECONNECT_DELAY_MIN = 2;
    static final int RECONNECT_DELAY_MAX = 4;
    static final int MAX_RECONNECT_DELAY = 300;
    public static final String NETWORK_NOTIFICATIONS = "NetworkNotifications";
    public static final String ATLEAST_ONE_CONNECTION_PROP = "net.java.sip.communicator.plugin.reconnectplugin.ATLEAST_ONE_SUCCESSFUL_CONNECTION";
    private Timer delayedNetworkDown;
    private static final long NETWORK_DOWN_THRESHOLD = 30000L;

    public void start(BundleContext bundleContext) throws Exception {
        try {
            logger.logEntry();
            ReconnectPluginActivator.bundleContext = bundleContext;
        }
        finally {
            logger.logExit();
        }
        bundleContext.addServiceListener((ServiceListener)this);
        this.networkAddressManagerService = (NetworkAddressManagerService)ServiceUtils.getService((BundleContext)bundleContext, NetworkAddressManagerService.class);
        this.networkAddressManagerService.addNetworkConfigurationChangeListener((NetworkConfigurationChangeListener)this);
        ServiceReference[] protocolProviderRefs = null;
        try {
            protocolProviderRefs = bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)"Error while retrieving service refs", (Throwable)ex);
            return;
        }
        if (protocolProviderRefs != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + protocolProviderRefs.length + " already installed providers."));
            }
            for (int i = 0; i < protocolProviderRefs.length; ++i) {
                ProtocolProviderService provider = (ProtocolProviderService)bundleContext.getService(protocolProviderRefs[i]);
                this.handleProviderAdded(provider);
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    public static UIService getUIService() {
        if (uiService == null) {
            ServiceReference uiReference = bundleContext.getServiceReference(UIService.class.getName());
            uiService = (UIService)bundleContext.getService(uiReference);
        }
        return uiService;
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            ServiceReference serviceReference = bundleContext.getServiceReference(ResourceManagementService.class.getName());
            if (serviceReference == null) {
                return null;
            }
            resourcesService = (ResourceManagementService)bundleContext.getService(serviceReference);
        }
        return resourcesService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configurationService = (ConfigurationService)bundleContext.getService(confReference);
        }
        return configurationService;
    }

    public static NotificationService getNotificationService() {
        if (notificationService == null) {
            ServiceReference serviceReference = bundleContext.getServiceReference(NotificationService.class.getName());
            notificationService = (NotificationService)bundleContext.getService(serviceReference);
            notificationService.registerDefaultNotificationForEvent(NETWORK_NOTIFICATIONS, "PopupMessageAction", null, null);
        }
        return notificationService;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        ServiceReference serviceRef = serviceEvent.getServiceReference();
        if (serviceRef.getBundle().getState() == 16) {
            return;
        }
        Object sService = bundleContext.getService(serviceRef);
        if (sService instanceof NetworkAddressManagerService) {
            switch (serviceEvent.getType()) {
                case 1: {
                    if (this.networkAddressManagerService != null) break;
                    this.networkAddressManagerService = (NetworkAddressManagerService)sService;
                    this.networkAddressManagerService.addNetworkConfigurationChangeListener((NetworkConfigurationChangeListener)this);
                    break;
                }
                case 4: {
                    ((NetworkAddressManagerService)sService).removeNetworkConfigurationChangeListener((NetworkConfigurationChangeListener)this);
                }
            }
            return;
        }
        if (!(sService instanceof ProtocolProviderService)) {
            return;
        }
        switch (serviceEvent.getType()) {
            case 1: {
                this.handleProviderAdded((ProtocolProviderService)sService);
                break;
            }
            case 4: {
                this.handleProviderRemoved((ProtocolProviderService)sService);
            }
        }
    }

    private void handleProviderAdded(ProtocolProviderService provider) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("New protocol provider is coming " + provider));
        }
        new PPReconnectWrapper(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProviderRemoved(ProtocolProviderService provider) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Provider modified forget every instance of it " + provider));
        }
        if (ReconnectPluginActivator.hasAtLeastOneSuccessfulConnection(provider)) {
            ReconnectPluginActivator.setAtLeastOneSuccessfulConnection(provider, false);
        }
        Map<PPReconnectWrapper, List<String>> map = reconnectEnabledProviders;
        synchronized (map) {
            Iterator<PPReconnectWrapper> iter = reconnectEnabledProviders.keySet().iterator();
            while (iter.hasNext()) {
                PPReconnectWrapper wrapper = iter.next();
                if (!wrapper.getProvider().equals(provider)) continue;
                iter.remove();
                wrapper.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addReconnectEnabledProvider(PPReconnectWrapper wrapper) {
        ProtocolProviderService pp = wrapper.getProvider();
        Map<PPReconnectWrapper, List<String>> map = reconnectEnabledProviders;
        synchronized (map) {
            if (!ReconnectPluginActivator.hasAtLeastOneSuccessfulConnection(pp)) {
                ReconnectPluginActivator.setAtLeastOneSuccessfulConnection(pp, true);
            }
            reconnectEnabledProviders.put(wrapper, new ArrayList<String>(connectedInterfaces));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeReconnectEnabledProviders(PPReconnectWrapper wrapper) {
        Map<PPReconnectWrapper, List<String>> map = reconnectEnabledProviders;
        synchronized (map) {
            reconnectEnabledProviders.remove(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void configurationChanged(ChangeEvent event) {
        if (event.getType() == 1) {
            if (!ReconnectPluginActivator.anyConnectedInterfaces()) {
                LinkedList<PPReconnectWrapper> wrappers;
                this.onNetworkUp();
                Map<PPReconnectWrapper, List<String>> map = reconnectEnabledProviders;
                synchronized (map) {
                    wrappers = new LinkedList<PPReconnectWrapper>(reconnectEnabledProviders.keySet());
                }
                wrappers.stream().forEach(PPReconnectWrapper::reconnect);
            }
            connectedInterfaces.add((String)event.getSource());
        } else if (event.getType() == 0) {
            String ifaceName = (String)event.getSource();
            connectedInterfaces.remove(ifaceName);
            if (ReconnectPluginActivator.anyConnectedInterfaces()) {
                List wrappers;
                Map<PPReconnectWrapper, List<String>> map = reconnectEnabledProviders;
                synchronized (map) {
                    wrappers = reconnectEnabledProviders.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(ifaceName)).map(entry -> (PPReconnectWrapper)entry.getKey()).collect(Collectors.toList());
                }
                wrappers.stream().forEach(PPReconnectWrapper::reconnect);
            } else {
                LinkedList<PPReconnectWrapper> wrappers;
                Map<PPReconnectWrapper, List<String>> map = reconnectEnabledProviders;
                synchronized (map) {
                    wrappers = new LinkedList<PPReconnectWrapper>(reconnectEnabledProviders.keySet());
                }
                wrappers.stream().forEach(PPReconnectWrapper::unregister);
                this.onNetworkDown();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Event received " + event + " src=" + event.getSource()));
            ReconnectPluginActivator.traceCurrentPPState();
        }
    }

    static boolean anyConnectedInterfaces() {
        return !connectedInterfaces.isEmpty();
    }

    static void traceCurrentPPState() {
        logger.trace((Object)("connectedInterfaces: " + connectedInterfaces));
        logger.trace((Object)("reconnectEnabledProviders: " + reconnectEnabledProviders.keySet()));
        logger.trace((Object)"----");
    }

    private static void notify(String title, String i18nKey, String[] params, Object tag) {
        HashMap<String, Object> extras = new HashMap<String, Object>();
        extras.put("PopupMessageNotificationHandler.tag", tag);
        ReconnectPluginActivator.getNotificationService().fireNotification(NETWORK_NOTIFICATIONS, title, ReconnectPluginActivator.getResources().getI18NString(i18nKey, params), null, extras);
    }

    static void notifyConnectionFailed(RegistrationStateChangeEvent evt) {
        if (!evt.getNewState().equals((Object)RegistrationState.CONNECTION_FAILED)) {
            return;
        }
        ProtocolProviderService pp = (ProtocolProviderService)evt.getSource();
        if (evt.getReasonCode() == 3) {
            ReconnectPluginActivator.notify(ReconnectPluginActivator.getResources().getI18NString("service.gui.ERROR"), "service.gui.NON_EXISTING_USER_ID", new String[]{pp.getAccountID().getService()}, pp.getAccountID());
        } else {
            ReconnectPluginActivator.notify(ReconnectPluginActivator.getResources().getI18NString("service.gui.ERROR"), "plugin.reconnectplugin.CONNECTION_FAILED_MSG", new String[]{pp.getAccountID().getUserID(), pp.getAccountID().getService()}, pp.getAccountID());
        }
    }

    static boolean hasAtLeastOneSuccessfulConnection(ProtocolProviderService pp) {
        String value = (String)ReconnectPluginActivator.getConfigurationService().getProperty("net.java.sip.communicator.plugin.reconnectplugin.ATLEAST_ONE_SUCCESSFUL_CONNECTION." + pp.getAccountID().getAccountUniqueID());
        return value != null && value.equals(Boolean.TRUE.toString());
    }

    private static void setAtLeastOneSuccessfulConnection(ProtocolProviderService pp, boolean value) {
        ReconnectPluginActivator.getConfigurationService().setProperty("net.java.sip.communicator.plugin.reconnectplugin.ATLEAST_ONE_SUCCESSFUL_CONNECTION." + pp.getAccountID().getAccountUniqueID(), (Object)Boolean.valueOf(value).toString());
    }

    private void onNetworkUp() {
        if (this.delayedNetworkDown != null) {
            this.delayedNetworkDown.cancel();
            this.delayedNetworkDown = null;
        }
    }

    private void onNetworkDown() {
        if (!OSUtils.IS_ANDROID) {
            this.notifyNetworkDown();
        } else if (this.delayedNetworkDown == null) {
            this.delayedNetworkDown = new Timer();
            this.delayedNetworkDown.schedule(new TimerTask(){

                @Override
                public void run() {
                    ReconnectPluginActivator.this.notifyNetworkDown();
                }
            }, 30000L);
        }
    }

    private void notifyNetworkDown() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Network is down!");
        }
        ReconnectPluginActivator.notify("", "plugin.reconnectplugin.NETWORK_DOWN", new String[0], this);
    }

    static {
        configurationService = null;
        reconnectEnabledProviders = new HashMap<PPReconnectWrapper, List<String>>();
        connectedInterfaces = new HashSet<String>();
    }
}

