/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.jivesoftware.smack.util.SHA1;

public class StringUtils {
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    public static final String UTF8 = "UTF-8";
    public static final String USASCII = "US-ASCII";
    public static final String QUOTE_ENCODE = "&quot;";
    public static final String APOS_ENCODE = "&apos;";
    public static final String AMP_ENCODE = "&amp;";
    public static final String LT_ENCODE = "&lt;";
    public static final String GT_ENCODE = "&gt;";
    public static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final ThreadLocal<Random> randGen = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private static final char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };

    @Deprecated
    public static CharSequence escapeForXML(CharSequence input) {
        return StringUtils.escapeForXml(input);
    }

    public static CharSequence escapeForXml(CharSequence input) {
        return StringUtils.escapeForXml(input, XmlEscapeMode.safe);
    }

    public static CharSequence escapeForXmlAttribute(CharSequence input) {
        return StringUtils.escapeForXml(input, XmlEscapeMode.forAttribute);
    }

    public static CharSequence escapeForXmlAttributeApos(CharSequence input) {
        return StringUtils.escapeForXml(input, XmlEscapeMode.forAttributeApos);
    }

    public static CharSequence escapeForXmlText(CharSequence input) {
        return StringUtils.escapeForXml(input, XmlEscapeMode.forText);
    }

    private static CharSequence escapeForXml(CharSequence input, XmlEscapeMode xmlEscapeMode) {
        if (input == null) {
            return null;
        }
        int len = input.length();
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        int last = 0;
        int i = 0;
        while (i < len) {
            String toAppend = null;
            char ch = input.charAt(i);
            block0 : switch (xmlEscapeMode) {
                case safe: {
                    switch (ch) {
                        case '<': {
                            toAppend = LT_ENCODE;
                            break block0;
                        }
                        case '>': {
                            toAppend = GT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            toAppend = AMP_ENCODE;
                            break block0;
                        }
                        case '\"': {
                            toAppend = QUOTE_ENCODE;
                            break block0;
                        }
                        case '\'': {
                            toAppend = APOS_ENCODE;
                            break block0;
                        }
                    }
                    break;
                }
                case forAttribute: {
                    switch (ch) {
                        case '<': {
                            toAppend = LT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            toAppend = AMP_ENCODE;
                            break block0;
                        }
                        case '\"': {
                            toAppend = QUOTE_ENCODE;
                            break block0;
                        }
                        case '\'': {
                            toAppend = APOS_ENCODE;
                            break block0;
                        }
                    }
                    break;
                }
                case forAttributeApos: {
                    switch (ch) {
                        case '<': {
                            toAppend = LT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            toAppend = AMP_ENCODE;
                            break block0;
                        }
                        case '\'': {
                            toAppend = APOS_ENCODE;
                            break block0;
                        }
                    }
                    break;
                }
                case forText: {
                    switch (ch) {
                        case '<': {
                            toAppend = LT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            toAppend = AMP_ENCODE;
                            break block0;
                        }
                    }
                }
            }
            if (toAppend != null) {
                if (i > last) {
                    out.append(input, last, i);
                }
                out.append((CharSequence)toAppend);
                last = ++i;
                continue;
            }
            ++i;
        }
        if (last == 0) {
            return input;
        }
        if (i > last) {
            out.append(input, last, i);
        }
        return out;
    }

    @Deprecated
    public static synchronized String hash(String data) {
        return org.jivesoftware.smack.util.SHA1.hex(data);
    }

    public static String encodeHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHARS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHARS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] toBytes(String string) {
        try {
            return string.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not supported by platform", e);
        }
    }

    public static String insecureRandomString(int length) {
        return StringUtils.randomString(length, randGen.get());
    }

    public static String randomString(int length) {
        return StringUtils.randomString(length, SECURE_RANDOM.get());
    }

    private static String randomString(int length, Random random) {
        if (length < 1) {
            return null;
        }
        byte[] randomBytes = new byte[length];
        random.nextBytes(randomBytes);
        char[] randomChars = new char[length];
        for (int i = 0; i < length; ++i) {
            randomChars[i] = StringUtils.getPrintableChar(randomBytes[i]);
        }
        return new String(randomChars);
    }

    private static char getPrintableChar(byte indexByte) {
        assert (numbersAndLetters.length < 254);
        int index = indexByte & 0xFF;
        return numbersAndLetters[index % numbersAndLetters.length];
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isNullOrEmpty(cs);
    }

    public static boolean isNullOrEmpty(CharSequence cs) {
        return cs == null || StringUtils.isEmpty(cs);
    }

    public static boolean isNotEmpty(CharSequence ... css) {
        for (CharSequence cs : css) {
            if (!StringUtils.isNullOrEmpty(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(CharSequence ... css) {
        for (CharSequence cs : css) {
            if (!StringUtils.isNotEmpty(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs.length() == 0;
    }

    public static String collectionToString(Collection<? extends Object> collection) {
        return StringUtils.toStringBuilder(collection, " ").toString();
    }

    public static StringBuilder toStringBuilder(Collection<? extends Object> collection, String delimiter) {
        StringBuilder sb = new StringBuilder(collection.size() * 20);
        Iterator<? extends Object> it = collection.iterator();
        while (it.hasNext()) {
            Object cs = it.next();
            sb.append(cs);
            if (!it.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb;
    }

    public static String returnIfNotEmptyTrimmed(String string) {
        if (string == null) {
            return null;
        }
        String trimmedString = string.trim();
        if (trimmedString.length() > 0) {
            return trimmedString;
        }
        return null;
    }

    public static boolean nullSafeCharSequenceEquals(CharSequence csOne, CharSequence csTwo) {
        return StringUtils.nullSafeCharSequenceComparator(csOne, csTwo) == 0;
    }

    public static int nullSafeCharSequenceComparator(CharSequence csOne, CharSequence csTwo) {
        if (csOne == null ^ csTwo == null) {
            return csOne == null ? -1 : 1;
        }
        if (csOne == null && csTwo == null) {
            return 0;
        }
        return csOne.toString().compareTo(csTwo.toString());
    }

    public static <CS extends CharSequence> CS requireNotNullOrEmpty(CS cs, String message) {
        if (StringUtils.isNullOrEmpty(cs)) {
            throw new IllegalArgumentException(message);
        }
        return cs;
    }

    public static String maybeToString(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        return cs.toString();
    }

    private static enum XmlEscapeMode {
        safe,
        forAttribute,
        forAttributeApos,
        forText;

    }
}

