/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.harvest.AbstractUdpListener;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.HarvestStatistics;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.socket.StunDatagramPacketFilter;
import org.ice4j.stack.StunStack;

public class SinglePortUdpHarvester
extends AbstractUdpListener
implements CandidateHarvester {
    private static final Logger logger = Logger.getLogger(SinglePortUdpHarvester.class.getName());
    private final Map<String, MyCandidate> candidates = new ConcurrentHashMap<String, MyCandidate>();
    private HarvestStatistics harvestStatistics = new HarvestStatistics();

    public static List<SinglePortUdpHarvester> createHarvesters(int port) {
        LinkedList<SinglePortUdpHarvester> harvesters = new LinkedList<SinglePortUdpHarvester>();
        for (TransportAddress address : AbstractUdpListener.getAllowedAddresses(port)) {
            try {
                harvesters.add(new SinglePortUdpHarvester(address));
            }
            catch (IOException ioe) {
                logger.info("Failed to create SinglePortUdpHarvester for address " + address + ": " + ioe);
            }
        }
        return harvesters;
    }

    public SinglePortUdpHarvester(TransportAddress localAddress) throws IOException {
        super(localAddress);
        logger.info("Initialized SinglePortUdpHarvester with address " + localAddress);
    }

    @Override
    public HarvestStatistics getHarvestStatistics() {
        return this.harvestStatistics;
    }

    @Override
    protected void maybeAcceptNewSession(AbstractUdpListener.Buffer buf, InetSocketAddress remoteAddress, String ufrag) {
        MyCandidate candidate = this.candidates.get(ufrag);
        if (candidate == null) {
            return;
        }
        try {
            AbstractUdpListener.MySocket newSocket = this.addSocket(remoteAddress);
            candidate.addSocket(newSocket, remoteAddress);
            newSocket.addBuffer(buf);
        }
        catch (SocketException se) {
            logger.info("Could not create a socket: " + se);
        }
        catch (IOException ioe) {
            logger.info("Failed to handle new socket: " + ioe);
        }
    }

    @Override
    public Collection<LocalCandidate> harvest(Component component) {
        IceMediaStream stream = component.getParentStream();
        Agent agent = stream.getParentAgent();
        String ufrag = agent.getLocalUfrag();
        if (stream.getComponentCount() != 1 || agent.getStreamCount() != 1) {
            logger.info("More than one Component for an Agent, cannot harvest.");
            return new LinkedList<LocalCandidate>();
        }
        MyCandidate candidate = new MyCandidate(component, ufrag);
        this.candidates.put(ufrag, candidate);
        component.addLocalCandidate(candidate);
        return new ArrayList<LocalCandidate>(Arrays.asList(candidate));
    }

    @Override
    public boolean isHostHarvester() {
        return true;
    }

    private class MyCandidate
    extends HostCandidate {
        private final String ufrag;
        private boolean freed;
        private final Map<SocketAddress, IceSocketWrapper> candidateSockets;
        private final Map<SocketAddress, DatagramSocket> sockets;

        private MyCandidate(Component component, String ufrag) {
            super(SinglePortUdpHarvester.this.localAddress, component);
            this.freed = false;
            this.candidateSockets = new HashMap<SocketAddress, IceSocketWrapper>();
            this.sockets = new HashMap<SocketAddress, DatagramSocket>();
            this.ufrag = ufrag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void free() {
            Map<SocketAddress, IceSocketWrapper> map = this;
            synchronized (map) {
                if (this.freed) {
                    return;
                }
                this.freed = true;
            }
            SinglePortUdpHarvester.this.candidates.remove(this.ufrag);
            map = this.sockets;
            synchronized (map) {
                StunStack stunStack = this.getStunStack();
                for (Map.Entry<SocketAddress, DatagramSocket> e : this.sockets.entrySet()) {
                    DatagramSocket socket = e.getValue();
                    if (stunStack != null) {
                        TransportAddress localAddress = new TransportAddress(socket.getLocalAddress(), socket.getLocalPort(), Transport.UDP);
                        TransportAddress remoteAddress = new TransportAddress((InetSocketAddress)e.getKey(), Transport.UDP);
                        stunStack.removeSocket(localAddress, remoteAddress);
                    }
                    socket.close();
                }
                this.sockets.clear();
            }
            map = this.candidateSockets;
            synchronized (map) {
                this.candidateSockets.clear();
            }
            super.free();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void addSocket(DatagramSocket socket, InetSocketAddress remoteAddress) throws IOException {
            if (this.freed) {
                throw new IOException("Candidate freed");
            }
            Component component = this.getParentComponent();
            if (component == null) {
                throw new IOException("No parent component");
            }
            IceProcessingState state = component.getParentStream().getParentAgent().getState();
            if (state == IceProcessingState.FAILED) {
                throw new IOException("Cannot add socket to an Agent in state FAILED.");
            }
            if (state != null && state.isOver() && logger.isLoggable(Level.FINE)) {
                logger.fine("Adding a socket to a completed Agent, state=" + (Object)((Object)state));
            }
            MultiplexingDatagramSocket multiplexing = new MultiplexingDatagramSocket(socket);
            IceUdpSocketWrapper candidateSocket = new IceUdpSocketWrapper(multiplexing);
            IceUdpSocketWrapper stunSocket = new IceUdpSocketWrapper(multiplexing.getSocket(new StunDatagramPacketFilter()));
            component.getParentStream().getParentAgent().getStunStack().addSocket(stunSocket, new TransportAddress(remoteAddress, Transport.UDP));
            component.getComponentSocket().add(multiplexing);
            Map<SocketAddress, Object> map = this.candidateSockets;
            synchronized (map) {
                this.candidateSockets.put(remoteAddress, candidateSocket);
            }
            map = this.sockets;
            synchronized (map) {
                this.sockets.put(remoteAddress, socket);
            }
        }

        @Override
        protected IceSocketWrapper getCandidateIceSocketWrapper(SocketAddress remoteAddress) {
            return this.candidateSockets.get(remoteAddress);
        }
    }
}

