/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.history;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import net.java.sip.communicator.impl.history.HistoryImpl;
import net.java.sip.communicator.impl.history.HistoryQueryImpl;
import net.java.sip.communicator.impl.history.HistoryReaderImpl;
import net.java.sip.communicator.service.history.HistoryQuery;
import net.java.sip.communicator.service.history.InteractiveHistoryReader;
import net.java.sip.communicator.service.history.records.HistoryRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InteractiveHistoryReaderImpl
implements InteractiveHistoryReader {
    private final HistoryImpl history;

    public InteractiveHistoryReaderImpl(HistoryImpl history) {
        this.history = history;
    }

    @Override
    public HistoryQuery findByKeyword(String keyword, String field, int recordCount) {
        return this.findByKeywords(new String[]{keyword}, field, recordCount);
    }

    @Override
    public HistoryQuery findByKeywords(String[] keywords, String field, int recordCount) {
        return this.find(null, null, keywords, field, false, recordCount);
    }

    private HistoryQuery find(final Date startDate, final Date endDate, final String[] keywords, final String field, final boolean caseSensitive, final int resultCount) {
        StringBuilder queryString = new StringBuilder();
        for (String s : keywords) {
            queryString.append(' ');
            queryString.append(s);
        }
        final HistoryQueryImpl query = new HistoryQueryImpl(queryString.toString());
        new Thread(){

            @Override
            public void run() {
                InteractiveHistoryReaderImpl.this.find(startDate, endDate, keywords, field, caseSensitive, resultCount, query);
            }
        }.start();
        return query;
    }

    private void find(Date startDate, Date endDate, String[] keywords, String field, boolean caseSensitive, int resultCount, HistoryQueryImpl query) {
        Vector<String> filelist = HistoryReaderImpl.filterFilesByDate(this.history.getFileList(), startDate, endDate, true);
        Iterator<String> fileIterator = filelist.iterator();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        while (fileIterator.hasNext() && resultCount > 0 && !query.isCanceled()) {
            String filename = fileIterator.next();
            Document doc = this.history.getDocumentForFile(filename);
            if (doc == null) continue;
            NodeList nodes = doc.getElementsByTagName("record");
            for (int i = nodes.getLength() - 1; i >= 0 && !query.isCanceled(); --i) {
                NodeList propertyNodes;
                HistoryRecord record;
                Date timestamp;
                Node node = nodes.item(i);
                String ts = node.getAttributes().getNamedItem("timestamp").getNodeValue();
                try {
                    timestamp = sdf.parse(ts);
                }
                catch (ParseException e) {
                    timestamp = new Date(Long.parseLong(ts));
                }
                if (!HistoryReaderImpl.isInPeriod(timestamp, startDate, endDate) || (record = HistoryReaderImpl.filterByKeyword(propertyNodes = node.getChildNodes(), timestamp, keywords, field, caseSensitive)) == null) continue;
                query.addHistoryRecord(record);
                --resultCount;
            }
        }
        if (query.isCanceled()) {
            query.setStatus(1);
        } else {
            query.setStatus(0);
        }
    }
}

