/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.sipaccregwizz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTabbedPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.wizard.EncodingsPanel;
import net.java.sip.communicator.plugin.desktoputil.wizard.SecurityPanel;
import net.java.sip.communicator.plugin.sipaccregwizz.AccountPanel;
import net.java.sip.communicator.plugin.sipaccregwizz.ConnectionPanel;
import net.java.sip.communicator.plugin.sipaccregwizz.NewAccount;
import net.java.sip.communicator.plugin.sipaccregwizz.PresencePanel;
import net.java.sip.communicator.plugin.sipaccregwizz.Resources;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccRegWizzActivator;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccountCreationFormService;
import net.java.sip.communicator.plugin.sipaccregwizz.SIPAccountRegistrationWizard;
import net.java.sip.communicator.plugin.sipaccregwizz.ValidatingPanel;
import net.java.sip.communicator.service.protocol.sip.SIPAccountRegistration;
import net.java.sip.communicator.service.protocol.sip.SipAccountID;
import org.apache.commons.lang3.StringUtils;

public class SIPAccountRegistrationForm
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private final AccountPanel accountPanel;
    private final ConnectionPanel connectionPanel;
    private final SecurityPanel securityPanel;
    private final PresencePanel presencePanel;
    private final EncodingsPanel encodingsPanel;
    private boolean isModification;
    private final SIPAccountRegistrationWizard wizard;
    private final JTabbedPane tabbedPane = new SIPCommTabbedPane();
    private List<ValidatingPanel> validatingPanels = new ArrayList<ValidatingPanel>();

    public SIPAccountRegistrationForm(SIPAccountRegistrationWizard wizard) {
        super((LayoutManager)new BorderLayout());
        this.wizard = wizard;
        this.accountPanel = new AccountPanel(this);
        this.connectionPanel = new ConnectionPanel(this);
        this.securityPanel = new SecurityPanel(this.getRegistration().getSecurityRegistration(), true);
        this.presencePanel = new PresencePanel(this);
        this.encodingsPanel = new EncodingsPanel();
    }

    void init() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.accountPanel.initAdvancedForm();
        SIPAccountCreationFormService createService = this.getCreateAccountService();
        if (createService != null) {
            createService.clear();
        }
        if (!SIPAccRegWizzActivator.isAdvancedAccountConfigDisabled()) {
            if (this.accountPanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("service.gui.ACCOUNT"), (Component)((Object)this.accountPanel));
            }
            if (this.connectionPanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("service.gui.CONNECTION"), (Component)((Object)this.connectionPanel));
            }
            if (this.securityPanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("service.gui.SECURITY"), (Component)this.securityPanel);
            }
            if (this.presencePanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("service.gui.PRESENCE"), (Component)((Object)this.presencePanel));
            }
            if (this.encodingsPanel.getParent() != this.tabbedPane) {
                this.tabbedPane.addTab(Resources.getString("plugin.jabberaccregwizz.ENCODINGS"), (Component)this.encodingsPanel);
            }
            if (this.tabbedPane.getParent() != this) {
                this.add(this.tabbedPane, "North");
            }
            this.tabbedPane.setSelectedIndex(0);
        } else {
            this.add((Component)((Object)this.accountPanel), "North");
        }
    }

    String setServerFieldAccordingToUIN(String userName) {
        String serverAddress = SipAccountID.getServerFromUserName((String)userName);
        this.connectionPanel.setServerFieldAccordingToUIN(serverAddress);
        return serverAddress;
    }

    private void setNextFinishButtonEnabled(boolean isEnabled) {
        SIPAccRegWizzActivator.getUIService().getAccountRegWizardContainer().setNextFinishButtonEnabled(isEnabled);
    }

    void reValidateInput() {
        for (ValidatingPanel panel : this.validatingPanels) {
            if (panel.isValidated()) continue;
            this.setNextFinishButtonEnabled(false);
            return;
        }
        this.setNextFinishButtonEnabled(true);
    }

    public void addValidatingPanel(ValidatingPanel panel) {
        this.validatingPanels.add(panel);
    }

    static String getServerFromUserName(String userName) {
        int delimIndex = userName.indexOf("@");
        if (delimIndex != -1) {
            return userName.substring(delimIndex + 1);
        }
        return null;
    }

    public boolean isModification() {
        return this.isModification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean commitPage(SIPAccountRegistration registration) {
        String userID = null;
        char[] password = null;
        String serverAddress = null;
        String proxyAddress = null;
        String xcapRoot = null;
        if (this.accountPanel.isCreateAccount()) {
            NewAccount newAccount = this.getCreateAccountService().createAccount();
            if (newAccount == null) return false;
            userID = newAccount.getUserName();
            password = newAccount.getPassword();
            serverAddress = newAccount.getServerAddress();
            proxyAddress = newAccount.getProxyAddress();
            xcapRoot = newAccount.getXcapRoot();
            if (serverAddress == null) {
                serverAddress = this.setServerFieldAccordingToUIN(userID);
            }
            if (proxyAddress == null) {
                proxyAddress = serverAddress;
            }
        } else {
            userID = this.accountPanel.getUserID();
            if (SipAccountID.getServerFromUserName((String)userID) == null && registration.getDefaultDomain() != null) {
                userID = userID + "@" + registration.getDefaultDomain();
                this.setServerFieldAccordingToUIN(userID);
            }
            password = this.accountPanel.getPassword();
            serverAddress = this.connectionPanel.getServerAddress();
            proxyAddress = this.connectionPanel.getProxy();
        }
        if (userID == null || userID.trim().length() == 0) {
            throw new IllegalStateException("No user ID provided.");
        }
        registration.setUserID(userID);
        registration.setRememberPassword(this.accountPanel.isRememberPassword());
        registration.setPassword(new String(password));
        registration.setServerAddress(serverAddress);
        registration.setProxy(proxyAddress);
        String displayName = this.accountPanel.getDisplayName();
        registration.setDisplayName(displayName);
        String authName = this.connectionPanel.getAuthenticationName();
        if (authName != null && authName.length() > 0) {
            registration.setAuthorizationName(authName);
        }
        registration.setServerPort(this.connectionPanel.getServerPort());
        registration.setProxyPort(this.connectionPanel.getProxyPort());
        registration.setPreferredTransport(this.connectionPanel.getSelectedTransport());
        registration.setProxyAutoConfigure(this.connectionPanel.isProxyAutoConfigureEnabled());
        registration.setProxyForceBypassConfigure(this.connectionPanel.isProxyForceBypassConfigureEnabled());
        registration.setEnablePresence(this.presencePanel.isPresenceEnabled());
        registration.setForceP2PMode(this.presencePanel.isForcePeerToPeerMode());
        registration.setTlsClientCertificate(this.connectionPanel.getCertificateId());
        registration.setPollingPeriod(this.presencePanel.getPollPeriod());
        registration.setSubscriptionExpiration(this.presencePanel.getSubscriptionExpiration());
        registration.setKeepAliveMethod(this.connectionPanel.getKeepAliveMethod());
        registration.setKeepAliveInterval(this.connectionPanel.getKeepAliveInterval());
        registration.setDTMFMethod(this.connectionPanel.getDTMFMethod());
        registration.setDtmfMinimalToneDuration(this.connectionPanel.getDtmfMinimalToneDuration());
        SIPAccRegWizzActivator.getUIService().getAccountRegWizardContainer().setBackButtonEnabled(true);
        this.securityPanel.commitPanel(registration.getSecurityRegistration());
        if (xcapRoot != null) {
            registration.setXCapEnable(true);
            registration.setClistOptionServerUri(xcapRoot);
        } else {
            registration.setXCapEnable(this.presencePanel.isXCapEnable());
            registration.setXiVOEnable(this.presencePanel.isXiVOEnable());
            registration.setClistOptionServerUri(this.presencePanel.getClistOptionServerUri());
        }
        registration.setClistOptionUseSipCredentials(this.presencePanel.isClistOptionUseSipCredentials());
        registration.setClistOptionUser(this.presencePanel.getClistOptionUser());
        registration.setClistOptionPassword(new String(this.presencePanel.getClistOptionPassword()));
        registration.setMessageWaitingIndications(this.connectionPanel.isMessageWaitingEnabled());
        registration.setVoicemailURI(this.connectionPanel.getVoicemailURI());
        registration.setVoicemailCheckURI(this.connectionPanel.getVoicemailCheckURI());
        this.encodingsPanel.commitPanel(registration.getEncodingsRegistration());
        return true;
    }

    public void loadAccount(SIPAccountRegistration sipAccReg) {
        String password = sipAccReg.getPassword();
        String serverAddress = sipAccReg.getServerAddress();
        String displayName = sipAccReg.getAccountPropertyString((Object)"DISPLAY_NAME");
        String authName = sipAccReg.getAuthorizationName();
        String serverPort = sipAccReg.getServerPort();
        String proxyAddress = sipAccReg.getProxy();
        String proxyPort = sipAccReg.getProxyPort();
        String preferredTransport = sipAccReg.getPreferredTransport();
        boolean enablePresence = sipAccReg.isEnablePresence();
        boolean forceP2P = sipAccReg.isForceP2PMode();
        String clientTlsCertificateId = sipAccReg.getTlsClientCertificate();
        boolean proxyAutoConfigureEnabled = sipAccReg.isProxyAutoConfigure();
        boolean proxyForceBypassConfigureEnabled = sipAccReg.isProxyForceBypassConfigure();
        String pollingPeriod = sipAccReg.getPollingPeriod();
        String subscriptionPeriod = sipAccReg.getSubscriptionExpiration();
        String keepAliveMethod = sipAccReg.getKeepAliveMethod();
        String keepAliveInterval = sipAccReg.getKeepAliveInterval();
        String dtmfMethod = sipAccReg.getDTMFMethod();
        String dtmfMinimalToneDuration = sipAccReg.getDtmfMinimalToneDuration();
        String voicemailURI = sipAccReg.getVoicemailURI();
        String voicemailCheckURI = sipAccReg.getVoicemailCheckURI();
        boolean xCapEnable = sipAccReg.isXCapEnable();
        boolean xivoEnable = sipAccReg.isXiVOEnable();
        boolean isServerOverridden = sipAccReg.isServerOverridden();
        this.connectionPanel.setServerOverridden(isServerOverridden);
        this.accountPanel.setUserIDEnabled(false);
        this.accountPanel.setUserID(sipAccReg.getId());
        if (password != null) {
            this.accountPanel.setPassword(password);
            this.accountPanel.setRememberPassword(true);
        } else {
            this.accountPanel.setPassword("");
            this.accountPanel.setRememberPassword(false);
        }
        this.connectionPanel.setServerAddress(serverAddress);
        this.connectionPanel.setServerEnabled(isServerOverridden);
        this.accountPanel.setDisplayName(displayName);
        if (authName != null && authName.length() > 0) {
            this.connectionPanel.setAuthenticationName(authName);
        }
        this.connectionPanel.setCertificateId(clientTlsCertificateId);
        this.connectionPanel.enablesProxyAutoConfigure(proxyAutoConfigureEnabled);
        this.connectionPanel.enablesProxyForceBypassConfigure(proxyForceBypassConfigureEnabled);
        this.connectionPanel.setServerPort(serverPort);
        this.connectionPanel.setProxy(proxyAddress);
        this.connectionPanel.setSelectedTransport(preferredTransport);
        this.connectionPanel.setProxyPort(proxyPort);
        this.securityPanel.loadAccount(sipAccReg.getSecurityRegistration());
        this.presencePanel.reinit();
        this.presencePanel.setPresenceEnabled(enablePresence);
        this.presencePanel.setForcePeerToPeerMode(forceP2P);
        this.presencePanel.setPollPeriod(pollingPeriod);
        this.presencePanel.setSubscriptionExpiration(subscriptionPeriod);
        if (!enablePresence) {
            this.presencePanel.setPresenceOptionsEnabled(enablePresence);
        }
        this.connectionPanel.setKeepAliveMethod(keepAliveMethod);
        this.connectionPanel.setKeepAliveInterval(keepAliveInterval);
        this.connectionPanel.setDTMFMethod(dtmfMethod);
        this.connectionPanel.setDtmfMinimalToneDuration(dtmfMinimalToneDuration);
        boolean mwiEnabled = sipAccReg.isMessageWaitingIndicationsEnabled();
        this.connectionPanel.setMessageWaitingIndications(mwiEnabled);
        if (StringUtils.isNotEmpty((CharSequence)voicemailURI)) {
            this.connectionPanel.setVoicemailURI(voicemailURI);
        }
        if (StringUtils.isNotEmpty((CharSequence)voicemailCheckURI)) {
            this.connectionPanel.setVoicemailCheckURI(voicemailCheckURI);
        }
        if (xCapEnable) {
            this.presencePanel.setXCapEnable(xCapEnable);
            this.presencePanel.setClistOptionEnableEnabled(xCapEnable);
        } else if (xivoEnable) {
            this.presencePanel.setXiVOEnable(xivoEnable);
            this.presencePanel.setClistOptionEnableEnabled(xivoEnable);
        }
        boolean clistUseSipCredentials = sipAccReg.isClistOptionUseSipCredentials();
        this.presencePanel.setClistOptionUseSipCredentials(clistUseSipCredentials);
        this.presencePanel.setClistOptionUseSipCredentialsEnabled(clistUseSipCredentials);
        this.presencePanel.setClistOptionServerUri(sipAccReg.getClistOptionServerUri());
        this.presencePanel.setClistOptionUser(sipAccReg.getClistOptionUser());
        this.presencePanel.setClistOptionPassword(sipAccReg.getClistOptionPassword());
        this.encodingsPanel.loadAccount(sipAccReg.getEncodingsRegistration());
    }

    public Component getSimpleForm() {
        SIPAccountCreationFormService createAccountService = this.getCreateAccountService();
        if (createAccountService != null) {
            createAccountService.clear();
        }
        this.accountPanel.setSimpleForm(true);
        return this.accountPanel;
    }

    public void setModification(boolean isModification) {
        this.isModification = isModification;
    }

    public String getUsernameExample() {
        return this.wizard.getUserNameExample();
    }

    public void webSignup() {
        this.wizard.webSignup();
    }

    public String getWebSignupLinkName() {
        return this.wizard.getWebSignupLinkName();
    }

    public String getForgotPasswordLinkName() {
        return this.wizard.getForgotPasswordLinkName();
    }

    public String getForgotPasswordLink() {
        return this.wizard.getForgotPasswordLink();
    }

    public SIPAccountCreationFormService getCreateAccountService() {
        return this.wizard.getCreateAccountService();
    }

    protected String getUsernameLabel() {
        return this.wizard.getUsernameLabel();
    }

    public SIPAccountRegistration getRegistration() {
        return this.wizard.getRegistration();
    }

    protected String getExistingAccountLabel() {
        return this.wizard.getExistingAccountLabel();
    }

    protected String getCreateAccountLabel() {
        return this.wizard.getCreateAccountLabel();
    }

    void setCreateButtonSelected() {
        this.accountPanel.setCreateButtonSelected();
    }
}

