/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.busylampfield;

import java.util.HashSet;
import java.util.Set;
import net.java.sip.communicator.plugin.busylampfield.BLFContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyBLF;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.StringUtils;

public class BLFContactSourceService
implements ContactSourceService {
    private static final Logger logger = Logger.getLogger(BLFContactSourceService.class);
    public static final int BLF_TYPE = 3;
    private final String displayName;
    private BLFContactQuery ourContactQuery = null;
    private Set<OperationSetTelephonyBLF.Line> monitoredLines = new HashSet<OperationSetTelephonyBLF.Line>();
    private final int index;

    public BLFContactSourceService(String displayName, int index) {
        this.displayName = displayName;
        this.index = index;
    }

    public int getType() {
        return 3;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ContactQuery createContactQuery(String queryString) {
        return this.createContactQuery(queryString, 20);
    }

    public ContactQuery createContactQuery(String queryString, int contactCount) {
        if (StringUtils.isNotEmpty((CharSequence)queryString)) {
            return null;
        }
        if (this.ourContactQuery == null) {
            this.ourContactQuery = new BLFContactQuery(this, this.monitoredLines, queryString, contactCount);
        }
        return this.ourContactQuery;
    }

    public int getIndex() {
        return 1 + this.index;
    }

    void addLine(OperationSetTelephonyBLF.Line line) {
        this.monitoredLines.add(line);
        if (this.ourContactQuery != null) {
            this.ourContactQuery.addLine(line, true);
        }
    }

    void updateLineStatus(OperationSetTelephonyBLF.Line line, int status) {
        if (this.ourContactQuery == null) {
            return;
        }
        this.ourContactQuery.updateLineStatus(line, status);
    }
}

