/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class ServerStoredDetails {

    public static class AboutMeDetail
    extends StringDetail {
        public AboutMeDetail(String description) {
            super("Description", description);
        }
    }

    public static class JobTitleDetail
    extends StringDetail {
        public JobTitleDetail(String jobTitle) {
            super("Job Title", jobTitle);
        }
    }

    public static class BooleanDetail
    extends GenericDetail {
        public BooleanDetail(String detailName, boolean value) {
            super(detailName, new Boolean(value));
        }

        public boolean getBoolean() {
            return (Boolean)this.getDetailValue();
        }
    }

    public static class NumberDetail
    extends GenericDetail {
        public NumberDetail(String detailName, BigDecimal value) {
            super(detailName, value);
        }

        public BigDecimal getNumber() {
            return (BigDecimal)this.getDetailValue();
        }
    }

    public static class InterestDetail
    extends StringDetail {
        public InterestDetail(String value) {
            super("Interest", value);
        }

        public String getInterest() {
            return this.getString();
        }
    }

    public static class WorkEmailAddressDetail
    extends EmailAddressDetail {
        public WorkEmailAddressDetail(String value) {
            super("Work e-mail", value);
        }
    }

    public static class EmailAddressDetail
    extends StringDetail {
        public EmailAddressDetail(String value) {
            this("e-mail", value);
        }

        protected EmailAddressDetail(String detailDisplayName, String value) {
            super(detailDisplayName, value);
        }

        public String getEMailAddress() {
            return this.getString();
        }
    }

    public static class TimeZoneDetail
    extends GenericDetail {
        public TimeZoneDetail(String displayDetailName, TimeZone timeZone) {
            super(displayDetailName, timeZone);
        }

        public TimeZone getTimeZone() {
            return (TimeZone)this.getDetailValue();
        }
    }

    public static class BirthDateDetail
    extends CalendarDetail {
        public BirthDateDetail(Calendar date) {
            super("Birth Date", date);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof BirthDateDetail)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            BirthDateDetail other = (BirthDateDetail)obj;
            if (this.value == null && other.getDetailValue() == null) {
                return true;
            }
            if (this.value != null && other.getDetailValue() != null) {
                boolean yearEquals = ((Calendar)this.value).get(1) == ((Calendar)other.value).get(1);
                boolean monthEquals = ((Calendar)this.value).get(2) == ((Calendar)other.value).get(2);
                boolean dayEquals = ((Calendar)this.value).get(5) == ((Calendar)other.value).get(5);
                return yearEquals && monthEquals && dayEquals;
            }
            return false;
        }
    }

    public static class CalendarDetail
    extends GenericDetail {
        public CalendarDetail(String detailDisplayName, Calendar date) {
            super(detailDisplayName, date);
        }

        public Calendar getCalendar() {
            return (Calendar)this.getDetailValue();
        }
    }

    public static class GenderDetail
    extends StringDetail {
        public static final GenderDetail MALE = new GenderDetail("Male");
        public static final GenderDetail FEMALE = new GenderDetail("Female");

        public GenderDetail(String gender) {
            super("Gender", gender);
        }

        public String getGender() {
            return this.getString();
        }
    }

    public static class NicknameDetail
    extends NameDetail {
        public NicknameDetail(String name) {
            super("Nickname", name);
        }
    }

    public static class DisplayNameDetail
    extends NameDetail {
        public DisplayNameDetail(String name) {
            super("Display Name", name);
        }
    }

    public static class LastNameDetail
    extends NameDetail {
        public LastNameDetail(String lastName) {
            super("Last Name", lastName);
        }
    }

    public static class MiddleNameDetail
    extends NameDetail {
        public MiddleNameDetail(String middleName) {
            super("Middle Name", middleName);
        }
    }

    public static class FirstNameDetail
    extends NameDetail {
        public FirstNameDetail(String firstName) {
            super("First Name", firstName);
        }
    }

    public static class WorkOrganizationNameDetail
    extends NameDetail {
        public WorkOrganizationNameDetail(String workOrganizationName) {
            super("Work Organization Name", workOrganizationName);
        }
    }

    public static class NameDetail
    extends StringDetail {
        public NameDetail(String detailDisplayName, String name) {
            super(detailDisplayName, name);
        }

        public String getName() {
            return this.getString();
        }
    }

    public static class ImageDetail
    extends BinaryDetail {
        public ImageDetail(String detailDisplayName, byte[] image) {
            super(detailDisplayName, image);
        }
    }

    public static class BinaryDetail
    extends GenericDetail {
        public BinaryDetail(String displayDetailName, byte[] bytes) {
            super(displayDetailName, bytes);
        }

        public byte[] getBytes() {
            return (byte[])this.getDetailValue();
        }

        @Override
        public boolean equals(Object obj) {
            boolean nullOrEmpty;
            if (!(obj instanceof BinaryDetail)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            BinaryDetail other = (BinaryDetail)obj;
            boolean equalsDisplayName = this.detailDisplayName != null && other.getDetailDisplayName() != null && this.detailDisplayName.equals(other.getDetailDisplayName());
            boolean equalsNotNull = this.value != null && other.getDetailValue() != null && Arrays.equals(this.getBytes(), other.getBytes());
            boolean bl = nullOrEmpty = !(this.value != null && this.getBytes().length != 0 || other.getDetailValue() != null && other.getBytes().length != 0);
            return equalsDisplayName && (equalsNotNull || nullOrEmpty);
        }
    }

    public static class WorkPageDetail
    extends WebPageDetail {
        public WorkPageDetail(URL url) {
            super(url);
        }
    }

    public static class WebPageDetail
    extends URLDetail {
        public WebPageDetail(URL url) {
            super("Web Page", url);
        }
    }

    public static class URLDetail
    extends GenericDetail {
        public URLDetail(String name, URL url) {
            super(name, url);
        }

        public URL getURL() {
            return (URL)this.getDetailValue();
        }

        @Override
        public boolean equals(Object obj) {
            boolean bothNullValues;
            if (!(obj instanceof URLDetail)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            URLDetail other = (URLDetail)obj;
            boolean equalsDisplayName = this.detailDisplayName != null && other.getDetailDisplayName() != null && this.detailDisplayName.equals(other.getDetailDisplayName());
            boolean equalValues = this.value != null && other.getDetailValue() != null && this.value.equals(other.getDetailValue());
            boolean bl = bothNullValues = this.value == null && other.value == null;
            return equalsDisplayName && (equalValues || bothNullValues);
        }
    }

    public static class PagerDetail
    extends PhoneNumberDetail {
        public PagerDetail(String number) {
            super(number);
            this.detailDisplayName = "Pager";
        }
    }

    public static class WorkVideoDetail
    extends VideoDetail {
        public WorkVideoDetail(String number) {
            super(number);
        }
    }

    public static class VideoDetail
    extends PhoneNumberDetail {
        public VideoDetail(String number) {
            super(number);
            this.detailDisplayName = "Video";
        }
    }

    public static class FaxDetail
    extends PhoneNumberDetail {
        public FaxDetail(String number) {
            super(number);
            this.detailDisplayName = "Fax";
        }
    }

    public static class WorkMobilePhoneDetail
    extends MobilePhoneDetail {
        public WorkMobilePhoneDetail(String workMobile) {
            super(workMobile);
        }
    }

    public static class MobilePhoneDetail
    extends PhoneNumberDetail {
        public MobilePhoneDetail(String privateMobile) {
            super(privateMobile);
            this.detailDisplayName = "Mobile Phone";
        }
    }

    public static class WorkPhoneDetail
    extends PhoneNumberDetail {
        public WorkPhoneDetail(String workPhone) {
            super(workPhone);
            this.detailDisplayName = "Work Phone";
        }
    }

    public static class PhoneNumberDetail
    extends StringDetail {
        public PhoneNumberDetail(String number) {
            super("Phone", number);
        }

        public String getNumber() {
            return this.getString();
        }
    }

    public static class SpokenLanguageDetail
    extends LocaleDetail {
        public SpokenLanguageDetail(Locale language) {
            super("Language", language);
        }
    }

    public static class WorkCountryDetail
    extends CountryDetail {
        public WorkCountryDetail(Locale locale) {
            super(locale);
        }

        public WorkCountryDetail(String country) {
            super(country);
        }
    }

    public static class CountryDetail
    extends LocaleDetail {
        public CountryDetail(Locale locale) {
            super("Country", locale);
        }

        public CountryDetail(String country) {
            super("Country", null);
            this.value = country;
        }

        @Override
        public Locale getLocale() {
            if (this.value instanceof Locale) {
                return (Locale)this.value;
            }
            return null;
        }
    }

    public static class LocaleDetail
    extends GenericDetail {
        public LocaleDetail(String detailDisplayName, Locale locale) {
            super(detailDisplayName, locale);
        }

        public Locale getLocale() {
            return (Locale)this.getDetailValue();
        }
    }

    public static class WorkPostalCodeDetail
    extends PostalCodeDetail {
        public WorkPostalCodeDetail(String postalCode) {
            super(postalCode);
        }
    }

    public static class PostalCodeDetail
    extends StringDetail {
        public PostalCodeDetail(String postalCode) {
            super("Postal/Zip Code", postalCode);
        }

        public String getPostalCode() {
            return this.getString();
        }
    }

    public static class WorkProvinceDetail
    extends ProvinceDetail {
        public WorkProvinceDetail(String workProvince) {
            super(workProvince);
        }
    }

    public static class ProvinceDetail
    extends StringDetail {
        public ProvinceDetail(String province) {
            super("Region/Province/State", province);
        }

        public String getProvince() {
            return this.getString();
        }
    }

    public static class WorkCityDetail
    extends CityDetail {
        public WorkCityDetail(String cityName) {
            super(cityName);
        }
    }

    public static class CityDetail
    extends StringDetail {
        public CityDetail(String cityName) {
            super("City", cityName);
        }

        public String getCity() {
            return this.getString();
        }
    }

    public static class WorkAddressDetail
    extends AddressDetail {
        public WorkAddressDetail(String address) {
            super(address);
        }
    }

    public static class AddressDetail
    extends StringDetail {
        public AddressDetail(String address) {
            super("Address", address);
        }

        public String getAddress() {
            return this.getString();
        }
    }

    public static class StringDetail
    extends GenericDetail {
        public StringDetail(String detailDisplayName, String value) {
            super(detailDisplayName, value);
        }

        public String getString() {
            return (String)this.value;
        }
    }

    public static class GenericDetail {
        protected Object value = null;
        protected String detailDisplayName = null;

        public GenericDetail(String detailDisplayName, Object value) {
            this.value = value;
            this.detailDisplayName = detailDisplayName;
        }

        public Object getDetailValue() {
            return this.value;
        }

        public String getDetailDisplayName() {
            return this.detailDisplayName;
        }

        public String toString() {
            return this.value == null ? "" : this.value.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GenericDetail)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            GenericDetail other = (GenericDetail)obj;
            return this.detailDisplayName != null && other.getDetailDisplayName() != null && this.detailDisplayName.equals(other.getDetailDisplayName()) && (this.value != null && other.getDetailValue() != null && this.value.equals(other.getDetailValue()) || StringUtils.isEmpty((CharSequence)((String)this.value)) && StringUtils.isEmpty((CharSequence)((String)other.getDetailValue())));
        }

        public int hashCode() {
            return Objects.hash(this.detailDisplayName, this.value);
        }
    }
}

