/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.jabber;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.JingleNodeDescriptor;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;

public class JabberAccountID
extends AccountID {
    private static final String JBR_DEFAULTS_PREFIX = "net.java.sip.communicator.service.protocol.jabber.";
    public static final String ANONYMOUS_AUTH = "ANONYMOUS_AUTH";
    public static final String BOSH_URL = "BOSH_URL";
    public static final String GOOGLE_USER_SUFFIX = "gmail.com";
    public static final String GOOGLE_CONNECT_SRV = "talk.google.com";
    public static final String DEFAULT_STUN_PORT = "3478";
    public static final String SEND_KEEP_ALIVE = "SEND_KEEP_ALIVE";
    public static final String BYPASS_GTALK_CAPABILITIES = "BYPASS_GTALK_CAPABILITIES";
    public static final String GOOGLE_CONTACTS_ENABLED = "GOOGLE_CONTACTS_ENABLED";
    public static final String TELEPHONY_BYPASS_GTALK_CAPS = "TELEPHONY_BYPASS_GTALK_CAPS";
    public static final String OVERRIDE_PHONE_SUFFIX = "OVERRIDE_PHONE_SUFFIX";

    public JabberAccountID(String id, Map<String, String> accountProperties) {
        super(id, accountProperties, "Jabber", JabberAccountID.getServiceName(accountProperties));
    }

    public JabberAccountID() {
        this(null, new HashMap<String, String>());
    }

    public String getBoshUrl() {
        return this.getAccountPropertyString(BOSH_URL);
    }

    public void setBoshUrl(String boshPath) {
        this.putAccountProperty(BOSH_URL, boshPath);
    }

    public String getOverridePhoneSuffix() {
        return this.getAccountPropertyString(OVERRIDE_PHONE_SUFFIX);
    }

    @Override
    public String getSystemProtocolName() {
        return "Jabber";
    }

    public boolean getBypassGtalkCaps() {
        return this.getAccountPropertyBoolean(BYPASS_GTALK_CAPABILITIES, false);
    }

    public String getTelephonyDomainBypassCaps() {
        return this.getAccountPropertyString(TELEPHONY_BYPASS_GTALK_CAPS);
    }

    public boolean isAnonymousAuthUsed() {
        return this.getAccountPropertyBoolean(ANONYMOUS_AUTH, false);
    }

    public boolean isJingleDisabled() {
        return this.getAccountPropertyBoolean("CALLING_DISABLED", false);
    }

    public boolean isSendKeepAlive() {
        return this.getAccountPropertyBoolean(SEND_KEEP_ALIVE, true);
    }

    public boolean isGoogleContactsEnabled() {
        return this.getAccountPropertyBoolean(GOOGLE_CONTACTS_ENABLED, true);
    }

    public void setUseAnonymousAuth(boolean useAnonymousAuth) {
        this.putAccountProperty(ANONYMOUS_AUTH, useAnonymousAuth);
    }

    public void setOverridePhoneSufix(String phoneSuffix) {
        this.setOrRemoveIfEmpty(OVERRIDE_PHONE_SUFFIX, phoneSuffix);
    }

    public void setBypassGtalkCaps(boolean bypassGtalkCaps) {
        this.putAccountProperty(BYPASS_GTALK_CAPABILITIES, bypassGtalkCaps);
    }

    public void setTelephonyDomainBypassCaps(String text) {
        this.setOrRemoveIfEmpty(TELEPHONY_BYPASS_GTALK_CAPS, text);
    }

    public void setDisableJingle(boolean disabled) {
        this.putAccountProperty("CALLING_DISABLED", disabled);
    }

    public void setSendKeepAlive(boolean sendKeepAlive) {
        this.putAccountProperty(SEND_KEEP_ALIVE, sendKeepAlive);
    }

    public void setGoogleContactsEnabled(boolean enabled) {
        this.putAccountProperty(GOOGLE_CONTACTS_ENABLED, enabled);
    }

    public String getResource() {
        return this.getAccountPropertyString("RESOURCE");
    }

    public void setResource(String resource) {
        this.putAccountProperty("RESOURCE", resource);
    }

    public int getPriority() {
        return this.getAccountPropertyInt("RESOURCE_PRIORITY", 30);
    }

    public void setPriority(int priority) {
        this.putAccountProperty("RESOURCE_PRIORITY", priority);
    }

    public boolean isUseIce() {
        return this.getAccountPropertyBoolean("ICE_ENABLED", true);
    }

    public void setUseIce(boolean isUseIce) {
        this.putAccountProperty("ICE_ENABLED", isUseIce);
    }

    public void setAutoDiscoverStun(boolean isAutoDiscover) {
        this.putAccountProperty("AUTO_DISCOVER_STUN", isAutoDiscover);
    }

    public void setUseDefaultStunServer(boolean isUseDefaultStunServer) {
        this.putAccountProperty("USE_DEFAULT_STUN_SERVER", isUseDefaultStunServer);
    }

    public void setAutoDiscoverJingleNodes(boolean isAutoDiscover) {
        this.putAccountProperty("AUTO_DISCOVER_JINGLE_NODES", isAutoDiscover);
    }

    public boolean isAutoDiscoverJingleNodes() {
        return this.getAccountPropertyBoolean("AUTO_DISCOVER_JINGLE_NODES", true);
    }

    public void setUseJingleNodes(boolean isUseJingleNodes) {
        this.putAccountProperty("JINGLE_NODES_ENABLED", isUseJingleNodes);
    }

    public boolean isUseJingleNodes() {
        return this.getAccountPropertyBoolean("JINGLE_NODES_ENABLED", true);
    }

    public boolean isUseUPNP() {
        return this.getAccountPropertyBoolean("UPNP_ENABLED", true);
    }

    public void setUseUPNP(boolean isUseUPNP) {
        this.putAccountProperty("UPNP_ENABLED", isUseUPNP);
    }

    public boolean isAllowNonSecure() {
        return this.getAccountPropertyBoolean("ALLOW_NON_SECURE", false);
    }

    public void setAllowNonSecure(boolean isAllowNonSecure) {
        this.putAccountProperty("ALLOW_NON_SECURE", isAllowNonSecure);
    }

    public boolean isCarbonDisabled() {
        return this.getAccountPropertyBoolean("CARBON_DISABLED", false);
    }

    public void setDisableCarbon(boolean isCarbonEnabled) {
        this.putAccountProperty("CARBON_DISABLED", isCarbonEnabled);
    }

    public boolean isResourceAutogenerated() {
        return this.getAccountPropertyBoolean("AUTO_GENERATE_RESOURCE", true);
    }

    public void setResourceAutogenerated(boolean resourceAutogenerated) {
        this.putAccountProperty("AUTO_GENERATE_RESOURCE", resourceAutogenerated);
    }

    public String getSmsServerAddress() {
        return this.getAccountPropertyString("SMS_SERVER_ADDRESS");
    }

    public void setSmsServerAddress(String serverAddress) {
        this.setOrRemoveIfEmpty("SMS_SERVER_ADDRESS", serverAddress);
    }

    private static String getServiceName(Map<String, String> accountProperties) {
        return accountProperties.get("SERVER_ADDRESS");
    }

    public List<JingleNodeDescriptor> getJingleNodes() {
        JingleNodeDescriptor node;
        Map<String, String> accountProperties = this.getAccountProperties();
        ArrayList<JingleNodeDescriptor> serList = new ArrayList<JingleNodeDescriptor>();
        for (int i = 0; i < 100 && (node = JingleNodeDescriptor.loadDescriptor(accountProperties, "JINGLENODES" + i)) != null; ++i) {
            serList.add(node);
        }
        return serList;
    }

    public boolean isJingleNodesAutoDiscoveryEnabled() {
        return this.getAccountPropertyBoolean("AUTO_DISCOVER_JINGLE_NODES", true);
    }

    public boolean isJingleNodesSearchBuddiesEnabled() {
        return this.getAccountPropertyBoolean("JINGLE_NODES_SEARCH_BUDDIES", false);
    }

    public boolean isJingleNodesRelayEnabled() {
        return this.getAccountPropertyBoolean("JINGLE_NODES_ENABLED", true);
    }

    public boolean allowNonSecureConnection() {
        return this.getAccountPropertyBoolean("ALLOW_NON_SECURE", false);
    }

    @Override
    protected String getDefaultString(String key) {
        return JabberAccountID.getDefaultStr(key);
    }

    public static String getDefaultStr(String key) {
        String value = ProtocolProviderActivator.getConfigurationService().getString(JBR_DEFAULTS_PREFIX + key);
        if (value == null) {
            value = AccountID.getDefaultStr(key);
        }
        return value;
    }

    public static boolean getDefaultBool(String key) {
        return Boolean.parseBoolean(JabberAccountID.getDefaultStr(key));
    }
}

