/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.muc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.java.sip.communicator.impl.muc.MUCActivator;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import org.jitsi.utils.event.PropertyChangeNotifier;

public class ChatRoomWrapperImpl
extends PropertyChangeNotifier
implements ChatRoomWrapper {
    private final ChatRoomProviderWrapper parentProvider;
    private ChatRoom chatRoom;
    private final String chatRoomName;
    private final String chatRoomID;
    private static final String AUTOJOIN_PROPERTY_NAME = "autoJoin";
    private Boolean autoJoin = null;
    private Boolean persistent = null;
    private String passwordPrefix;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            MessageHistoryService mhs = MUCActivator.getMessageHistoryService();
            if (!mhs.isHistoryLoggingEnabled() || !mhs.isHistoryLoggingEnabled(ChatRoomWrapperImpl.this.getChatRoomID())) {
                MUCService.setChatRoomAutoOpenOption(ChatRoomWrapperImpl.this.getParentProvider().getProtocolProvider(), ChatRoomWrapperImpl.this.getChatRoomID(), MUCService.OPEN_ON_ACTIVITY);
            }
        }
    };

    public ChatRoomWrapperImpl(ChatRoomProviderWrapper parentProvider, String chatRoomID, String chatRoomName) {
        this.parentProvider = parentProvider;
        this.chatRoomID = chatRoomID;
        this.chatRoomName = chatRoomName;
        this.passwordPrefix = ConfigurationUtils.getChatRoomPrefix((String)this.getParentProvider().getProtocolProvider().getAccountID().getAccountUniqueID(), (String)chatRoomID) + ".password";
        MUCActivator.getConfigurationService().addPropertyChangeListener("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED", this.propertyListener);
        MUCActivator.getConfigurationService().addPropertyChangeListener("net.java.sip.communicator.service.msghistory.contact." + this.getChatRoomID(), this.propertyListener);
    }

    public ChatRoomWrapperImpl(ChatRoomProviderWrapper parentProvider, ChatRoom chatRoom) {
        this(parentProvider, chatRoom.getIdentifier(), chatRoom.getName());
        this.chatRoom = chatRoom;
    }

    @Override
    public ChatRoom getChatRoom() {
        return this.chatRoom;
    }

    @Override
    public void setChatRoom(ChatRoom chatRoom) {
        this.chatRoom = chatRoom;
    }

    @Override
    public String getChatRoomName() {
        return this.chatRoomName;
    }

    @Override
    public String getChatRoomID() {
        return this.chatRoomID;
    }

    @Override
    public ChatRoomProviderWrapper getParentProvider() {
        return this.parentProvider;
    }

    @Override
    public boolean isPersistent() {
        if (this.persistent == null) {
            if (this.chatRoom != null) {
                this.persistent = this.chatRoom.isPersistent();
            } else {
                return true;
            }
        }
        return this.persistent;
    }

    @Override
    public void setPersistent(boolean value) {
        this.persistent = value;
    }

    @Override
    public void savePassword(String password) {
        MUCActivator.getCredentialsStorageService().storePassword(this.passwordPrefix, password);
    }

    @Override
    public String loadPassword() {
        return MUCActivator.getCredentialsStorageService().loadPassword(this.passwordPrefix);
    }

    @Override
    public void removePassword() {
        MUCActivator.getCredentialsStorageService().removePassword(this.passwordPrefix);
    }

    @Override
    public boolean isAutojoin() {
        if (this.autoJoin == null) {
            String val = ConfigurationUtils.getChatRoomProperty((ProtocolProviderService)this.getParentProvider().getProtocolProvider(), (String)this.getChatRoomID(), (String)AUTOJOIN_PROPERTY_NAME);
            this.autoJoin = Boolean.valueOf(val);
        }
        return this.autoJoin;
    }

    @Override
    public void setAutoJoin(boolean value) {
        this.autoJoin = value;
        if (!this.isPersistent()) {
            this.setPersistent(true);
            ConfigurationUtils.saveChatRoom((ProtocolProviderService)this.getParentProvider().getProtocolProvider(), (String)this.getChatRoomID(), (String)this.getChatRoomID(), (String)this.getChatRoomName());
        }
        if (value) {
            ConfigurationUtils.updateChatRoomProperty((ProtocolProviderService)this.getParentProvider().getProtocolProvider(), (String)this.chatRoomID, (String)AUTOJOIN_PROPERTY_NAME, (String)Boolean.toString(this.autoJoin));
        } else {
            ConfigurationUtils.updateChatRoomProperty((ProtocolProviderService)this.getParentProvider().getProtocolProvider(), (String)this.chatRoomID, (String)AUTOJOIN_PROPERTY_NAME, null);
        }
        MUCActivator.getMUCService().fireChatRoomListChangedEvent(this, 3);
    }

    @Override
    public void removeListeners() {
        MUCActivator.getConfigurationService().removePropertyChangeListener("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED", this.propertyListener);
        MUCActivator.getConfigurationService().removePropertyChangeListener("net.java.sip.communicator.service.msghistory.contact." + this.getChatRoomID(), this.propertyListener);
    }

    public void firePropertyChange(String property) {
        super.firePropertyChange(property, null, null);
    }
}

