/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.impl.muc.ChatRoomListImpl;
import net.java.sip.communicator.impl.muc.ChatRoomSourceContact;
import net.java.sip.communicator.impl.muc.ChatRoomWrapperImpl;
import net.java.sip.communicator.impl.muc.MUCActivator;
import net.java.sip.communicator.impl.muc.ServerChatRoomContactSourceService;
import net.java.sip.communicator.plugin.desktoputil.AuthenticationWindow;
import net.java.sip.communicator.plugin.desktoputil.chat.ChatRoomJoinOptionsDialog;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.AuthenticationWindowService;
import net.java.sip.communicator.service.muc.ChatRoomListChangeListener;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapperListener;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomInvitation;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;

public class MUCServiceImpl
extends MUCService {
    private final ChatRoomListImpl chatRoomList = new ChatRoomListImpl();
    private static Logger logger = Logger.getLogger(MUCServiceImpl.class);

    @Override
    public void acceptInvitation(ChatRoomInvitation invitation) {
        ChatRoom chatRoom = invitation.getTargetChatRoom();
        byte[] password = invitation.getChatRoomPassword();
        String nickName = ConfigurationUtils.getChatRoomProperty((ProtocolProviderService)chatRoom.getParentProvider(), (String)chatRoom.getIdentifier(), (String)"userNickName");
        if (nickName == null) {
            String[] joinOptions = ChatRoomJoinOptionsDialog.getJoinOptions((boolean)true, (ProtocolProviderService)chatRoom.getParentProvider(), (String)chatRoom.getIdentifier(), (String)MUCActivator.getGlobalDisplayDetailsService().getDisplayName(chatRoom.getParentProvider()));
            nickName = joinOptions[0];
        }
        this.joinChatRoom(chatRoom, nickName, password);
    }

    public void addChatRoomListChangeListener(ChatRoomListChangeListener l) {
        this.chatRoomList.addChatRoomListChangeListener(l);
    }

    public void removeChatRoomListChangeListener(ChatRoomListChangeListener l) {
        this.chatRoomList.removeChatRoomListChangeListener(l);
    }

    @Override
    public void fireChatRoomListChangedEvent(ChatRoomWrapper chatRoomWrapper, int eventID) {
        this.chatRoomList.fireChatRoomListChangedEvent(chatRoomWrapper, eventID);
    }

    private void joinChatRoom(ChatRoomWrapper chatRoomWrapper, String nickName, byte[] password, boolean rememberPassword, boolean isFirstAttempt, String subject) {
        ChatRoom chatRoom = chatRoomWrapper.getChatRoom();
        if (chatRoom == null) {
            MUCActivator.getAlertUIService().showAlertDialog(MUCActivator.getResources().getI18NString("service.gui.WARNING"), MUCActivator.getResources().getI18NString("service.gui.CHAT_ROOM_NOT_CONNECTED", new String[]{chatRoomWrapper.getChatRoomName()}));
            return;
        }
        new JoinChatRoomTask((ChatRoomWrapperImpl)chatRoomWrapper, nickName, password, rememberPassword, isFirstAttempt, subject).start();
    }

    public void joinChatRoom(ChatRoomWrapper chatRoomWrapper, String nickName, byte[] password) {
        ChatRoom chatRoom;
        if (chatRoomWrapper.getChatRoom() == null) {
            chatRoomWrapper = this.createChatRoom(chatRoomWrapper.getChatRoomName(), chatRoomWrapper.getParentProvider().getProtocolProvider(), new ArrayList<String>(), "", false, false, true);
        }
        if ((chatRoom = chatRoomWrapper.getChatRoom()) == null) {
            MUCActivator.getAlertUIService().showAlertDialog(MUCActivator.getResources().getI18NString("service.gui.WARNING"), MUCActivator.getResources().getI18NString("service.gui.CHAT_ROOM_NOT_CONNECTED", new String[]{chatRoomWrapper.getChatRoomName()}));
            return;
        }
        new JoinChatRoomTask((ChatRoomWrapperImpl)chatRoomWrapper, nickName, password).start();
    }

    @Override
    public void joinChatRoom(ChatRoomWrapper chatRoomWrapper, String nickName, byte[] password, String subject) {
        ChatRoom chatRoom;
        if (chatRoomWrapper.getChatRoom() == null) {
            chatRoomWrapper = this.createChatRoom(chatRoomWrapper.getChatRoomName(), chatRoomWrapper.getParentProvider().getProtocolProvider(), new ArrayList<String>(), "", false, false, true);
        }
        if ((chatRoom = chatRoomWrapper.getChatRoom()) == null) {
            MUCActivator.getAlertUIService().showAlertDialog(MUCActivator.getResources().getI18NString("service.gui.WARNING"), MUCActivator.getResources().getI18NString("service.gui.CHAT_ROOM_NOT_CONNECTED", new String[]{chatRoomWrapper.getChatRoomName()}));
            return;
        }
        new JoinChatRoomTask((ChatRoomWrapperImpl)chatRoomWrapper, nickName, password, subject).start();
    }

    public void joinChatRoom(ChatRoomWrapper chatRoomWrapper) {
        ChatRoom chatRoom;
        if (chatRoomWrapper.getChatRoom() == null) {
            chatRoomWrapper = this.createChatRoom(chatRoomWrapper.getChatRoomName(), chatRoomWrapper.getParentProvider().getProtocolProvider(), new ArrayList<String>(), "", false, false, true);
        }
        if ((chatRoom = chatRoomWrapper.getChatRoom()) == null) {
            MUCActivator.getAlertUIService().showAlertDialog(MUCActivator.getResources().getI18NString("service.gui.WARNING"), MUCActivator.getResources().getI18NString("service.gui.CHAT_ROOM_NOT_CONNECTED", new String[]{chatRoomWrapper.getChatRoomName()}));
            return;
        }
        new JoinChatRoomTask((ChatRoomWrapperImpl)chatRoomWrapper, null, null).start();
    }

    public void joinChatRoom(ChatRoom chatRoom, String nickname, byte[] password) {
        ChatRoomWrapper chatRoomWrapper = this.chatRoomList.findChatRoomWrapperFromChatRoom(chatRoom);
        if (chatRoomWrapper == null) {
            ChatRoomProviderWrapper parentProvider = this.chatRoomList.findServerWrapperFromProvider(chatRoom.getParentProvider());
            chatRoomWrapper = new ChatRoomWrapperImpl(parentProvider, chatRoom);
            this.chatRoomList.addChatRoom(chatRoomWrapper);
        }
        this.joinChatRoom(chatRoomWrapper, nickname, password);
    }

    @Override
    public void joinChatRoom(String chatRoomName, ChatRoomProviderWrapper chatRoomProvider) {
        ChatRoom chatRoom;
        block5: {
            OperationSetMultiUserChat groupChatOpSet = (OperationSetMultiUserChat)chatRoomProvider.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class);
            chatRoom = null;
            try {
                chatRoom = groupChatOpSet.findRoom(chatRoomName);
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block5;
                logger.trace((Object)("Un exception occurred while searching for room:" + chatRoomName), (Throwable)e);
            }
        }
        if (chatRoom != null) {
            ChatRoomWrapper chatRoomWrapper = this.chatRoomList.findChatRoomWrapperFromChatRoom(chatRoom);
            if (chatRoomWrapper == null) {
                ChatRoomProviderWrapper parentProvider = this.chatRoomList.findServerWrapperFromProvider(chatRoom.getParentProvider());
                chatRoomWrapper = new ChatRoomWrapperImpl(parentProvider, chatRoom);
                this.chatRoomList.addChatRoom(chatRoomWrapper);
                this.fireChatRoomListChangedEvent(chatRoomWrapper, 1);
            }
            this.joinChatRoom(chatRoomWrapper);
        } else {
            MUCActivator.getAlertUIService().showAlertDialog(MUCActivator.getResources().getI18NString("service.gui.ERROR"), MUCActivator.getResources().getI18NString("service.gui.CHAT_ROOM_NOT_EXIST", new String[]{chatRoomName, chatRoomProvider.getProtocolProvider().getAccountID().getService()}));
        }
    }

    public ChatRoomWrapper createChatRoom(String roomName, ProtocolProviderService protocolProvider, Collection<String> contacts, String reason, boolean persistent, boolean isPrivate) {
        return this.createChatRoom(roomName, protocolProvider, contacts, reason, true, persistent, isPrivate);
    }

    @Override
    public ChatRoomWrapper createChatRoom(String roomName, ProtocolProviderService protocolProvider, Collection<String> contacts, String reason, boolean persistent) {
        return this.createChatRoom(roomName, protocolProvider, contacts, reason, true, persistent, false);
    }

    @Override
    public ChatRoomWrapper createChatRoom(String roomName, ProtocolProviderService protocolProvider, Collection<String> contacts, String reason, boolean join, boolean persistent, boolean isPrivate) {
        ChatRoomWrapper chatRoomWrapper = null;
        OperationSetMultiUserChat groupChatOpSet = (OperationSetMultiUserChat)protocolProvider.getOperationSet(OperationSetMultiUserChat.class);
        if (groupChatOpSet == null) {
            return null;
        }
        ChatRoom chatRoom = null;
        try {
            HashMap<String, Boolean> roomProperties = new HashMap<String, Boolean>();
            roomProperties.put("isPrivate", isPrivate);
            chatRoom = groupChatOpSet.createChatRoom(roomName, roomProperties);
            if (join) {
                chatRoom.join();
                for (String contact : contacts) {
                    chatRoom.invite(contact, reason);
                }
            }
        }
        catch (OperationFailedException ex) {
            logger.error((Object)"Failed to create chat room.", (Throwable)ex);
            MUCActivator.getAlertUIService().showAlertDialog(MUCActivator.getResources().getI18NString("service.gui.ERROR"), MUCActivator.getResources().getI18NString("service.gui.CREATE_CHAT_ROOM_ERROR", new String[]{protocolProvider.getProtocolDisplayName()}), (Throwable)ex);
        }
        catch (OperationNotSupportedException ex) {
            logger.error((Object)"Failed to create chat room.", (Throwable)ex);
            MUCActivator.getAlertUIService().showAlertDialog(MUCActivator.getResources().getI18NString("service.gui.ERROR"), MUCActivator.getResources().getI18NString("service.gui.CREATE_CHAT_ROOM_ERROR", new String[]{protocolProvider.getProtocolDisplayName()}), (Throwable)ex);
        }
        if (chatRoom != null) {
            ChatRoomProviderWrapper parentProvider = this.chatRoomList.findServerWrapperFromProvider(protocolProvider);
            chatRoomWrapper = this.chatRoomList.findChatRoomWrapperFromChatRoom(chatRoom);
            if (chatRoomWrapper == null) {
                chatRoomWrapper = new ChatRoomWrapperImpl(parentProvider, chatRoom);
                chatRoomWrapper.setPersistent(persistent);
                this.chatRoomList.addChatRoom(chatRoomWrapper);
            }
        }
        return chatRoomWrapper;
    }

    @Override
    public ChatRoomWrapper createPrivateChatRoom(ProtocolProviderService protocolProvider, Collection<String> contacts, String reason, boolean persistent) {
        return this.createChatRoom(null, protocolProvider, contacts, reason, persistent, true);
    }

    @Override
    public List<String> getExistingChatRooms(ChatRoomProviderWrapper chatRoomProvider) {
        List chatRooms;
        block7: {
            if (chatRoomProvider == null) {
                return null;
            }
            ProtocolProviderService protocolProvider = chatRoomProvider.getProtocolProvider();
            if (protocolProvider == null) {
                return null;
            }
            OperationSetMultiUserChat groupChatOpSet = (OperationSetMultiUserChat)protocolProvider.getOperationSet(OperationSetMultiUserChat.class);
            if (groupChatOpSet == null) {
                return null;
            }
            chatRooms = null;
            try {
                chatRooms = groupChatOpSet.getExistingChatRooms();
            }
            catch (OperationFailedException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Failed to obtain existing chat rooms for server: " + protocolProvider.getAccountID().getService()), (Throwable)e);
                }
            }
            catch (OperationNotSupportedException e) {
                if (!logger.isTraceEnabled()) break block7;
                logger.trace((Object)("Failed to obtain existing chat rooms for server: " + protocolProvider.getAccountID().getService()), (Throwable)e);
            }
        }
        return chatRooms;
    }

    @Override
    public void rejectInvitation(OperationSetMultiUserChat multiUserChatOpSet, ChatRoomInvitation invitation, String reason) throws OperationFailedException {
        multiUserChatOpSet.rejectInvitation(invitation, reason);
    }

    @Override
    public ChatRoomWrapper leaveChatRoom(ChatRoomWrapper chatRoomWrapper) {
        ChatRoomWrapper existChatRoomWrapper;
        ChatRoom chatRoom = chatRoomWrapper.getChatRoom();
        if (chatRoom == null) {
            ResourceManagementService resources = MUCActivator.getResources();
            MUCActivator.getAlertUIService().showAlertDialog(resources.getI18NString("service.gui.WARNING"), resources.getI18NString("service.gui.CHAT_ROOM_LEAVE_NOT_CONNECTED"));
            return null;
        }
        if (chatRoom.isJoined()) {
            chatRoom.leave();
        }
        if ((existChatRoomWrapper = this.chatRoomList.findChatRoomWrapperFromChatRoom(chatRoom)) == null) {
            return null;
        }
        ConfigurationUtils.updateChatRoomStatus((ProtocolProviderService)chatRoomWrapper.getParentProvider().getProtocolProvider(), (String)chatRoomWrapper.getChatRoomID(), (String)"Offline");
        return existChatRoomWrapper;
    }

    @Override
    public ChatRoomWrapper findChatRoomWrapperFromSourceContact(SourceContact contact) {
        if (!(contact instanceof ChatRoomSourceContact)) {
            return null;
        }
        ChatRoomSourceContact chatRoomContact = (ChatRoomSourceContact)contact;
        return this.chatRoomList.findChatRoomWrapperFromChatRoomID(chatRoomContact.getChatRoomID(), chatRoomContact.getProvider());
    }

    @Override
    public ChatRoomWrapper findChatRoomWrapperFromChatRoomID(String chatRoomID, ProtocolProviderService pps) {
        return this.chatRoomList.findChatRoomWrapperFromChatRoomID(chatRoomID, pps);
    }

    @Override
    public ChatRoomWrapper getChatRoomWrapperByChatRoom(ChatRoom chatRoom, boolean create) {
        ChatRoomWrapper chatRoomWrapper = this.chatRoomList.findChatRoomWrapperFromChatRoom(chatRoom);
        if (chatRoomWrapper == null && create) {
            ChatRoomProviderWrapper parentProvider = this.chatRoomList.findServerWrapperFromProvider(chatRoom.getParentProvider());
            chatRoomWrapper = new ChatRoomWrapperImpl(parentProvider, chatRoom);
            this.chatRoomList.addChatRoom(chatRoomWrapper);
        }
        return chatRoomWrapper;
    }

    @Override
    public void synchronizeOpSetWithLocalContactList(ProtocolProviderService protocolProvider, OperationSetMultiUserChat opSet) {
        ChatRoomProviderWrapper chatRoomProvider = this.findServerWrapperFromProvider(protocolProvider);
        if (chatRoomProvider == null) {
            chatRoomProvider = this.chatRoomList.addRegisteredChatProvider(protocolProvider);
        }
        if (chatRoomProvider != null) {
            chatRoomProvider.synchronizeProvider();
        }
    }

    @Override
    public Iterator<ChatRoomProviderWrapper> getChatRoomProviders() {
        return this.chatRoomList.getChatRoomProviders();
    }

    @Override
    public void removeChatRoom(ChatRoomWrapper chatRoomWrapper) {
        this.chatRoomList.removeChatRoom(chatRoomWrapper);
    }

    public void destroyChatRoom(ChatRoomWrapper chatRoomWrapper, String reason, String alternateAddress) {
        if (chatRoomWrapper.getChatRoom().destroy(reason, alternateAddress)) {
            MUCActivator.getUIService().closeChatRoomWindow(chatRoomWrapper);
            this.chatRoomList.removeChatRoom(chatRoomWrapper);
        } else if (!chatRoomWrapper.getChatRoom().isPersistent() && !chatRoomWrapper.getChatRoom().isJoined()) {
            this.chatRoomList.removeChatRoom(chatRoomWrapper);
        }
    }

    @Override
    public void addChatRoomProviderWrapperListener(ChatRoomProviderWrapperListener listener) {
        this.chatRoomList.addChatRoomProviderWrapperListener(listener);
    }

    @Override
    public void removeChatRoomProviderWrapperListener(ChatRoomProviderWrapperListener listener) {
        this.chatRoomList.removeChatRoomProviderWrapperListener(listener);
    }

    @Override
    public ChatRoomProviderWrapper findServerWrapperFromProvider(ProtocolProviderService protocolProvider) {
        return this.chatRoomList.findServerWrapperFromProvider(protocolProvider);
    }

    @Override
    public ChatRoomWrapper findChatRoomWrapperFromChatRoom(ChatRoom chatRoom) {
        return this.chatRoomList.findChatRoomWrapperFromChatRoom(chatRoom);
    }

    @Override
    public void openChatRoom(ChatRoomWrapper room) {
        if (room.getChatRoom() == null && (room = this.createChatRoom(room.getChatRoomName(), room.getParentProvider().getProtocolProvider(), new ArrayList<String>(), "", false, false, true)).getChatRoom().isJoined()) {
            room.getChatRoom().leave();
        }
        if (!room.getChatRoom().isJoined()) {
            String savedNick = ConfigurationUtils.getChatRoomProperty((ProtocolProviderService)room.getParentProvider().getProtocolProvider(), (String)room.getChatRoomID(), (String)"userNickName");
            String subject = null;
            if (savedNick == null) {
                String[] joinOptions = ChatRoomJoinOptionsDialog.getJoinOptions((ProtocolProviderService)room.getParentProvider().getProtocolProvider(), (String)room.getChatRoomID(), (String)MUCActivator.getGlobalDisplayDetailsService().getDisplayName(room.getParentProvider().getProtocolProvider()));
                savedNick = joinOptions[0];
                subject = joinOptions[1];
            }
            if (savedNick != null) {
                this.joinChatRoom(room, savedNick, null, subject);
            } else {
                return;
            }
        }
        MUCActivator.getUIService().openChatRoomWindow(room);
    }

    @Override
    public ContactSourceService getServerChatRoomsContactSourceForProvider(ChatRoomProviderWrapper pps) {
        return new ServerChatRoomContactSourceService(pps);
    }

    @Override
    public boolean isMUCSourceContact(SourceContact contact) {
        return contact instanceof ChatRoomSourceContact;
    }

    private class JoinChatRoomTask
    extends Thread {
        private final ChatRoomWrapperImpl chatRoomWrapper;
        private final String nickName;
        private final byte[] password;
        private final boolean rememberPassword;
        private final boolean isFirstAttempt;
        private final String subject;
        private ResourceManagementService resources = MUCActivator.getResources();

        JoinChatRoomTask(ChatRoomWrapperImpl chatRoomWrapper, String nickName, byte[] password, boolean rememberPassword, boolean isFirstAttempt, String subject) {
            String passString;
            this.chatRoomWrapper = chatRoomWrapper;
            this.nickName = nickName;
            this.isFirstAttempt = isFirstAttempt;
            this.subject = subject;
            this.password = password == null ? (Object)((passString = chatRoomWrapper.loadPassword()) != null ? passString.getBytes() : null) : password;
            this.rememberPassword = rememberPassword;
        }

        JoinChatRoomTask(ChatRoomWrapperImpl chatRoomWrapper, String nickName, byte[] password) {
            this(chatRoomWrapper, nickName, password, false, true, null);
        }

        JoinChatRoomTask(ChatRoomWrapperImpl chatRoomWrapper, String nickName, byte[] password, String subject) {
            this(chatRoomWrapper, nickName, password, false, true, subject);
        }

        @Override
        public void run() {
            ChatRoom chatRoom = this.chatRoomWrapper.getChatRoom();
            try {
                if (this.password != null && this.password.length > 0) {
                    chatRoom.joinAs(this.nickName, this.password);
                } else if (this.nickName != null) {
                    chatRoom.joinAs(this.nickName);
                } else {
                    chatRoom.join();
                }
                this.done("Success");
            }
            catch (OperationFailedException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Failed to join chat room: " + chatRoom.getName()), (Throwable)e);
                }
                switch (e.getErrorCode()) {
                    case 401: {
                        this.done("AuthenticationFailed");
                        break;
                    }
                    case 13: {
                        this.done("RegistrationRequired");
                        break;
                    }
                    case 3: {
                        this.done("ProviderNotRegistered");
                        break;
                    }
                    case 5: {
                        this.done("SubscriptionAlreadyExists");
                        break;
                    }
                    default: {
                        this.done("UnknownError");
                    }
                }
            }
        }

        private void done(String returnCode) {
            ConfigurationUtils.updateChatRoomStatus((ProtocolProviderService)this.chatRoomWrapper.getParentProvider().getProtocolProvider(), (String)this.chatRoomWrapper.getChatRoomID(), (String)"Online");
            String errorMessage = null;
            if ("AuthenticationFailed".equals(returnCode)) {
                this.chatRoomWrapper.removePassword();
                AuthenticationWindowService authWindowsService = (AuthenticationWindowService)ServiceUtils.getService((BundleContext)MUCActivator.bundleContext, AuthenticationWindowService.class);
                AuthenticationWindowService.AuthenticationWindow authWindow = authWindowsService.create(null, null, null, false, this.chatRoomWrapper.isPersistent(), (Object)AuthenticationWindow.getAuthenticationWindowIcon((ProtocolProviderService)this.chatRoomWrapper.getParentProvider().getProtocolProvider()), this.resources.getI18NString("service.gui.AUTHENTICATION_WINDOW_TITLE", new String[]{this.chatRoomWrapper.getParentProvider().getName()}), this.resources.getI18NString("service.gui.CHAT_ROOM_REQUIRES_PASSWORD", new String[]{this.chatRoomWrapper.getChatRoomName()}), "", null, this.isFirstAttempt ? null : this.resources.getI18NString("service.gui.AUTHENTICATION_FAILED", new String[]{this.chatRoomWrapper.getChatRoomName()}), null);
                authWindow.setVisible(true);
                if (!authWindow.isCanceled()) {
                    MUCServiceImpl.this.joinChatRoom(this.chatRoomWrapper, this.nickName, new String(authWindow.getPassword()).getBytes(), authWindow.isRememberPassword(), false, this.subject);
                }
            } else {
                errorMessage = "RegistrationRequired".equals(returnCode) ? this.resources.getI18NString("service.gui.CHAT_ROOM_REGISTRATION_REQUIRED", new String[]{this.chatRoomWrapper.getChatRoomName()}) : ("ProviderNotRegistered".equals(returnCode) ? this.resources.getI18NString("service.gui.CHAT_ROOM_NOT_CONNECTED", new String[]{this.chatRoomWrapper.getChatRoomName()}) : ("SubscriptionAlreadyExists".equals(returnCode) ? this.resources.getI18NString("service.gui.CHAT_ROOM_ALREADY_JOINED", new String[]{this.chatRoomWrapper.getChatRoomName()}) : this.resources.getI18NString("service.gui.FAILED_TO_JOIN_CHAT_ROOM", new String[]{this.chatRoomWrapper.getChatRoomName()})));
            }
            if (!"Success".equals(returnCode) && !"AuthenticationFailed".equals(returnCode)) {
                MUCActivator.getAlertUIService().showAlertPopup(this.resources.getI18NString("service.gui.ERROR"), errorMessage);
            }
            if ("Success".equals(returnCode)) {
                if (this.rememberPassword) {
                    this.chatRoomWrapper.savePassword(new String(this.password));
                }
                if (this.subject != null) {
                    try {
                        this.chatRoomWrapper.getChatRoom().setSubject(this.subject);
                    }
                    catch (OperationFailedException ex) {
                        logger.warn((Object)"Failed to set subject.");
                    }
                }
            }
            this.chatRoomWrapper.firePropertyChange(returnCode);
        }
    }
}

