/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NotNull;

public class ExecutorUtils {
    public static ExecutorService newCachedThreadPool(final boolean daemon, final String baseName) {
        return Executors.newCachedThreadPool(new ThreadFactory(){
            private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread t = this.defaultThreadFactory.newThread(r);
                if (t != null) {
                    t.setDaemon(daemon);
                    if (baseName != null && baseName.length() != 0) {
                        t.setName(baseName + "-" + t.getName());
                    }
                }
                return t;
            }
        });
    }
}

