/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.queue;

import java.util.concurrent.atomic.AtomicInteger;
import org.jitsi.utils.stats.RateStatistics;
import org.json.simple.JSONObject;

public class QueueStatistics {
    private static final int SCALE = 1000;
    private static final int INTERVAL_MS = 5000;
    private final RateStatistics addRate = new RateStatistics(5000, 1000.0f);
    private final RateStatistics removeRate = new RateStatistics(5000, 1000.0f);
    private final RateStatistics dropRate = new RateStatistics(5000, 1000.0f);
    private AtomicInteger totalPacketsAdded = new AtomicInteger();
    private AtomicInteger totalPacketsRemoved = new AtomicInteger();
    private AtomicInteger totalPacketsDropped = new AtomicInteger();
    private long firstPacketAddedMs = -1L;

    public JSONObject getStats() {
        JSONObject stats = new JSONObject();
        long now = System.currentTimeMillis();
        stats.put((Object)"added", (Object)this.totalPacketsAdded.get());
        stats.put((Object)"removed", (Object)this.totalPacketsRemoved.get());
        stats.put((Object)"dropped", (Object)this.totalPacketsDropped.get());
        stats.put((Object)"add_rate", (Object)this.addRate.getRate(now));
        stats.put((Object)"remove_rate", (Object)this.removeRate.getRate(now));
        stats.put((Object)"drop_rate", (Object)this.dropRate.getRate(now));
        double duration = (double)(now - this.firstPacketAddedMs) / 1000.0;
        stats.put((Object)"duration_s", (Object)duration);
        stats.put((Object)"average_remove_rate_pps", (Object)((double)this.totalPacketsRemoved.get() / duration));
        return stats;
    }

    public void add(long now) {
        if (this.firstPacketAddedMs < 0L) {
            this.firstPacketAddedMs = now;
        }
        this.addRate.update(1, now);
        this.totalPacketsAdded.incrementAndGet();
    }

    public void remove(long now) {
        this.removeRate.update(1, now);
        this.totalPacketsRemoved.incrementAndGet();
    }

    public void drop(long now) {
        this.dropRate.update(1, now);
        this.totalPacketsDropped.incrementAndGet();
    }
}

