/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.advancedconfig;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.advancedconfig.AdvancedConfigurationPanel;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;

public class AdvancedConfigActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(AdvancedConfigActivator.class);
    protected static BundleContext bundleContext;
    private static ResourceManagementService resourceService;
    private static ConfigurationService configurationService;
    private static final String DISABLED_PROP = "net.java.sip.communicator.plugin.advancedconfig.DISABLED";
    private static AdvancedConfigurationPanel panel;
    private static ServiceRegistration panelRegistration;

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        if (AdvancedConfigActivator.getConfigurationService().getBoolean(DISABLED_PROP, false)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("FORM_TYPE", "GENERAL_TYPE");
                panel = new AdvancedConfigurationPanel();
                bundleContext.addServiceListener((ServiceListener)panel);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        bundleContext.registerService(ConfigurationForm.class.getName(), (Object)panel, properties);
                    }
                }).start();
            }
        });
        if (logger.isInfoEnabled()) {
            logger.info((Object)"ADVANCED CONFIG PLUGIN... [REGISTERED]");
        }
    }

    public void stop(BundleContext bc) throws Exception {
        if (panel != null) {
            bc.removeServiceListener((ServiceListener)panel);
        }
        if (panelRegistration != null) {
            panelRegistration.unregister();
        }
    }

    public static ResourceManagementService getResources() {
        if (resourceService == null) {
            resourceService = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resourceService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configurationService;
    }
}

