/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.securityconfig.masterpassword;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.securityconfig.SecurityConfigActivator;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.credentialsstorage.MasterPasswordInputService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;

public class SavedPasswordsDialog
extends SIPCommDialog {
    private static Logger logger = Logger.getLogger(SavedPasswordsDialog.class);
    private static final long serialVersionUID = 0L;
    private JPanel mainPanel;
    private JButton closeButton;
    private static final CredentialsStorageService credentialsStorageService = SecurityConfigActivator.getCredentialsStorageService();
    private static final ResourceManagementService resources = SecurityConfigActivator.getResources();
    private static SavedPasswordsDialog dialog;

    private SavedPasswordsDialog() {
        super(false);
        this.initComponents();
        this.setTitle(resources.getI18NString("plugin.securityconfig.masterpassword.SAVED_PASSWORDS"));
        this.setMinimumSize(new Dimension(550, 300));
        this.setPreferredSize(new Dimension(550, 300));
        this.setResizable(false);
        this.getContentPane().add(this.mainPanel);
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 19;
        PasswordsPanel accPassPanel = new PasswordsPanel();
        this.add((Component)((Object)accPassPanel), c);
        c.gridy = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 26;
        this.closeButton = new JButton(resources.getI18NString("service.gui.CLOSE"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog = null;
                SavedPasswordsDialog.this.dispose();
            }
        });
        this.add(this.closeButton, c);
    }

    protected void close(boolean isEscaped) {
        this.closeButton.doClick();
    }

    public static SavedPasswordsDialog getInstance() {
        if (dialog == null) {
            dialog = new SavedPasswordsDialog();
        }
        return dialog;
    }

    private static class PasswordsPanel
    extends TransparentPanel {
        private static final long serialVersionUID = 0L;
        private boolean showPasswords = false;
        private JButton removeButton;
        private JButton removeAllButton;
        private JButton showPasswordsButton;
        private JTable accountsTable;

        public PasswordsPanel() {
            this.initComponents();
            this.initContent();
        }

        private PasswordsTableRow getSelectedAccountID() {
            PasswordsTableModel model = (PasswordsTableModel)this.accountsTable.getModel();
            int index = this.accountsTable.getSelectedRow();
            if (index < 0 || index > model.savedPasswords.size()) {
                return null;
            }
            return model.savedPasswords.get(index);
        }

        private void initComponents() {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), resources.getI18NString("plugin.securityconfig.masterpassword.STORED_ACCOUNT_PASSWORDS")));
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            this.accountsTable = new JTable();
            this.accountsTable.setModel(new PasswordsTableModel());
            this.accountsTable.setSelectionMode(0);
            this.accountsTable.setCellSelectionEnabled(false);
            this.accountsTable.setColumnSelectionAllowed(false);
            this.accountsTable.setRowSelectionAllowed(true);
            this.accountsTable.getColumnModel().getColumn(1).setPreferredWidth(270);
            this.accountsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    removeButton.setEnabled(true);
                }
            });
            JScrollPane pnlAccounts = new JScrollPane(this.accountsTable);
            this.add(pnlAccounts);
            TransparentPanel pnlButtons = new TransparentPanel();
            pnlButtons.setLayout(new BorderLayout());
            this.add((Component)pnlButtons);
            TransparentPanel leftButtons = new TransparentPanel();
            pnlButtons.add((Component)leftButtons, "West");
            this.removeButton = new JButton(resources.getI18NString("plugin.securityconfig.masterpassword.REMOVE_PASSWORD_BUTTON"));
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PasswordsTableRow selectedRow = this.getSelectedAccountID();
                    if (selectedRow != null) {
                        PasswordsTableModel model = (PasswordsTableModel)accountsTable.getModel();
                        this.removeSavedPassword(selectedRow.property);
                        model.savedPasswords.remove(selectedRow);
                        int selectedRowIx = accountsTable.getSelectedRow();
                        model.fireTableRowsDeleted(selectedRowIx, selectedRowIx);
                    }
                }
            });
            leftButtons.add(this.removeButton);
            this.removeAllButton = new JButton(resources.getI18NString("plugin.securityconfig.masterpassword.REMOVE_ALL_PASSWORDS_BUTTON"));
            this.removeAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PasswordsTableModel model = (PasswordsTableModel)accountsTable.getModel();
                    if (model.savedPasswords.isEmpty()) {
                        return;
                    }
                    int answer = SecurityConfigActivator.getUIService().getPopupDialog().showConfirmPopupDialog((Object)resources.getI18NString("plugin.securityconfig.masterpassword.REMOVE_ALL_CONFIRMATION"), resources.getI18NString("plugin.securityconfig.masterpassword.REMOVE_ALL_TITLE"), 0);
                    if (answer == 0) {
                        for (PasswordsTableRow row : model.savedPasswords) {
                            this.removeSavedPassword(row.property);
                        }
                        model.savedPasswords.clear();
                        model.fireTableDataChanged();
                    }
                }
            });
            leftButtons.add(this.removeAllButton);
            TransparentPanel rightButtons = new TransparentPanel();
            pnlButtons.add((Component)rightButtons, "East");
            this.showPasswordsButton = new JButton(resources.getI18NString("plugin.securityconfig.masterpassword.SHOW_PASSWORDS_BUTTON"));
            this.showPasswordsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (credentialsStorageService.isUsingMasterPassword() && !showPasswords) {
                        this.showOrHidePasswordsProtected();
                    } else {
                        this.showOrHidePasswords();
                    }
                }
            });
            rightButtons.add(this.showPasswordsButton);
        }

        private void initContent() {
            PasswordsTableModel model = (PasswordsTableModel)this.accountsTable.getModel();
            for (Map.Entry<AccountID, String> entry : SecurityConfigActivator.getAccountIDsWithSavedPasswords().entrySet()) {
                AccountID accID = entry.getKey();
                String protocol = accID.getAccountPropertyString((Object)"PROTOCOL_NAME");
                if (protocol == null) {
                    protocol = resources.getI18NString("plugin.securityconfig.masterpassword.PROTOCOL_UNKNOWN");
                }
                model.savedPasswords.add(new PasswordsTableRow(entry.getValue(), protocol, accID.getUserID()));
            }
            for (Map.Entry<Object, String> entry : SecurityConfigActivator.getChatRoomsWithSavedPasswords().entrySet()) {
                String description = (String)entry.getKey();
                model.savedPasswords.add(new PasswordsTableRow(entry.getValue(), resources.getI18NString("service.gui.CHAT_ROOM"), description));
            }
            String PROVISIONING_PROPERTIES_PREFIX = "net.java.sip.communicator.plugin.provisioning.auth";
            ConfigurationService configurationService = SecurityConfigActivator.getConfigurationService();
            String uname = configurationService.getString(PROVISIONING_PROPERTIES_PREFIX + ".USERNAME");
            if (uname != null && uname.length() > 0) {
                model.savedPasswords.add(new PasswordsTableRow(PROVISIONING_PROPERTIES_PREFIX, resources.getI18NString("plugin.provisioning.PROVISIONING"), uname));
            }
            String HTTP_PROPERTIES_PREFIX = "net.java.sip.communicator.util.http.credential";
            List httpPasses = configurationService.getPropertyNamesByPrefix(HTTP_PROPERTIES_PREFIX, false);
            int prefLen = HTTP_PROPERTIES_PREFIX.length() + 1;
            for (String prop : httpPasses) {
                if (prop.contains("PASSWORD") || prefLen > prop.length()) continue;
                model.savedPasswords.add(new PasswordsTableRow(prop, "http://" + prop.substring(prefLen), configurationService.getString(prop)));
            }
        }

        private void removeSavedPassword(String property) {
            credentialsStorageService.removePassword(property);
        }

        private void showOrHidePasswords() {
            this.showPasswords = !this.showPasswords;
            this.showPasswordsButton.setText(resources.getI18NString(this.showPasswords ? "plugin.securityconfig.masterpassword.HIDE_PASSWORDS_BUTTON" : "plugin.securityconfig.masterpassword.SHOW_PASSWORDS_BUTTON"));
            PasswordsTableModel model = (PasswordsTableModel)this.accountsTable.getModel();
            model.fireTableStructureChanged();
        }

        private void showOrHidePasswordsProtected() {
            String master;
            boolean correct = true;
            MasterPasswordInputService masterPasswordInputService = SecurityConfigActivator.getMasterPasswordInputService();
            if (masterPasswordInputService == null) {
                logger.error((Object)"Missing MasterPasswordInputService to show input dialog");
                return;
            }
            do {
                if ((master = masterPasswordInputService.showInputDialog(correct)) != null) continue;
                return;
            } while (!(correct = master.length() != 0 && credentialsStorageService.verifyMasterPassword(master)));
            this.showOrHidePasswords();
        }

        class PasswordsTableRow {
            private String property;
            private String type;
            private String name;

            PasswordsTableRow(String property, String type, String name) {
                this.property = property;
                this.type = type;
                this.name = name;
            }
        }

        private class PasswordsTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 0L;
            public static final int TYPE_INDEX = 0;
            public static final int USER_NAME_INDEX = 1;
            public static final int PASSWORD_INDEX = 2;
            public final List<PasswordsTableRow> savedPasswords = new ArrayList<PasswordsTableRow>();

            private PasswordsTableModel() {
            }

            @Override
            public String getColumnName(int column) {
                String key;
                switch (column) {
                    case 0: {
                        key = "plugin.securityconfig.masterpassword.COL_TYPE";
                        break;
                    }
                    case 1: {
                        key = "plugin.securityconfig.masterpassword.COL_NAME";
                        break;
                    }
                    case 2: {
                        key = "plugin.securityconfig.masterpassword.COL_PASSWORD";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return resources.getI18NString(key);
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row < 0) {
                    return null;
                }
                PasswordsTableRow savedPass = this.savedPasswords.get(row);
                switch (column) {
                    case 0: {
                        return savedPass.type;
                    }
                    case 1: {
                        return savedPass.name;
                    }
                    case 2: {
                        String pass = credentialsStorageService.loadPassword(savedPass.property);
                        return pass == null ? resources.getI18NString("plugin.securityconfig.masterpassword.CANNOT_DECRYPT") : pass;
                    }
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return this.savedPasswords.size();
            }

            @Override
            public int getColumnCount() {
                return PasswordsPanel.this.showPasswords ? 3 : 2;
            }
        }
    }
}

