/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cryptozrtp.agreement;

import djb.Curve25519;
import gnu.java.bigintcrypto.BigIntegerCrypto;
import java.util.Arrays;
import org.bouncycastle.cryptozrtp.BasicAgreement;
import org.bouncycastle.cryptozrtp.CipherParameters;
import org.bouncycastle.cryptozrtp.params.Djb25519PrivateKeyParameters;
import org.bouncycastle.cryptozrtp.params.Djb25519PublicKeyParameters;

public class Djb25519DHBasicAgreement
implements BasicAgreement {
    private Djb25519PrivateKeyParameters key;

    @Override
    public void init(CipherParameters key) {
        this.key = (Djb25519PrivateKeyParameters)key;
    }

    @Override
    public BigIntegerCrypto calculateAgreement(CipherParameters pubKey) {
        Djb25519PublicKeyParameters pub = (Djb25519PublicKeyParameters)pubKey;
        byte[] P = pub.getP();
        byte[] Z = new byte[32];
        Curve25519.curve(Z, this.key.getK(), P);
        return new BigIntegerCrypto(1, Z);
    }

    @Override
    public void clear() {
        Arrays.fill(this.key.getK(), (byte)0);
        this.key = null;
    }
}

