/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

public class Subscription
extends NodeExtension {
    protected String jid;
    protected String id;
    protected State state;
    protected boolean configRequired = false;

    public Subscription(String subscriptionJid) {
        this(subscriptionJid, null, null, null);
    }

    public Subscription(String subscriptionJid, String nodeId) {
        this(subscriptionJid, nodeId, null, null);
    }

    public Subscription(String jid, String nodeId, String subscriptionId, State state) {
        super(PubSubElementType.SUBSCRIPTION, nodeId);
        this.jid = jid;
        this.id = subscriptionId;
        this.state = state;
    }

    public Subscription(String jid, String nodeId, String subscriptionId, State state, boolean configRequired) {
        super(PubSubElementType.SUBSCRIPTION, nodeId);
        this.jid = jid;
        this.id = subscriptionId;
        this.state = state;
        this.configRequired = configRequired;
    }

    public String getJid() {
        return this.jid;
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public boolean isConfigRequired() {
        return this.configRequired;
    }

    @Override
    public String toXML() {
        StringBuilder builder = new StringBuilder("<subscription");
        Subscription.appendAttribute(builder, "jid", this.jid);
        if (this.getNode() != null) {
            Subscription.appendAttribute(builder, "node", this.getNode());
        }
        if (this.id != null) {
            Subscription.appendAttribute(builder, "subid", this.id);
        }
        if (this.state != null) {
            Subscription.appendAttribute(builder, "subscription", this.state.toString());
        }
        builder.append("/>");
        return builder.toString();
    }

    private static void appendAttribute(StringBuilder builder, String att, String value) {
        builder.append(' ');
        builder.append(att);
        builder.append("='");
        builder.append(value);
        builder.append('\'');
    }

    public static enum State {
        subscribed,
        unconfigured,
        pending,
        none;

    }
}

