/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import net.java.sip.communicator.impl.resources.ResourceManagementActivator;
import net.java.sip.communicator.impl.resources.util.SkinJarBuilder;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.resources.AbstractResourcesService;
import net.java.sip.communicator.service.resources.ImagePack;
import net.java.sip.communicator.service.resources.SkinPack;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;

public class ResourceManagementServiceImpl
extends AbstractResourcesService {
    private static final Logger logger = Logger.getLogger(ResourceManagementServiceImpl.class);
    private UIService uiService = null;

    ResourceManagementServiceImpl() {
        super(ResourceManagementActivator.bundleContext);
        UIService serv = this.getUIService();
        if (serv != null) {
            serv.repaintUI();
        }
    }

    private UIService getUIService() {
        if (this.uiService == null) {
            this.uiService = (UIService)ServiceUtils.getService((BundleContext)ResourceManagementActivator.bundleContext, UIService.class);
        }
        return this.uiService;
    }

    @Override
    public void serviceChanged(ServiceEvent event) {
        super.serviceChanged(event);
        Object sService = ResourceManagementActivator.bundleContext.getService(event.getServiceReference());
        if (sService instanceof UIService && this.uiService == null && event.getType() == 1) {
            this.uiService = (UIService)sService;
            this.uiService.repaintUI();
        } else if (sService instanceof UIService && event.getType() == 4 && this.uiService != null && this.uiService.equals(sService)) {
            this.uiService = null;
        }
    }

    @Override
    protected void onSkinPackChanged() {
        UIService serv = this.getUIService();
        if (serv != null) {
            serv.repaintUI();
        }
    }

    public int getColor(String key) {
        String res = this.getColorResources().get(key);
        if (res == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing color resource for key: " + key));
            }
            return 0xFFFFFF;
        }
        return Integer.parseInt(res, 16);
    }

    public String getColorString(String key) {
        String res = this.getColorResources().get(key);
        if (res == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing color resource for key: " + key));
            }
            return "0xFFFFFF";
        }
        return res;
    }

    public InputStream getImageInputStreamForPath(String path) {
        SkinPack skinPack = this.getSkinPack();
        if (skinPack != null && skinPack.getClass().getClassLoader().getResourceAsStream(path) != null) {
            return skinPack.getClass().getClassLoader().getResourceAsStream(path);
        }
        ImagePack imagePack = this.getImagePack();
        if (path != null && imagePack != null) {
            return imagePack.getClass().getClassLoader().getResourceAsStream(path);
        }
        return null;
    }

    public InputStream getImageInputStream(String streamKey) {
        String path = this.getImagePath(streamKey);
        if (path == null || path.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing resource for key: " + streamKey));
            }
            return null;
        }
        return this.getImageInputStreamForPath(path);
    }

    public URL getImageURL(String urlKey) {
        String path = this.getImagePath(urlKey);
        if (path == null || path.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing resource for key: " + urlKey));
            }
            return null;
        }
        return this.getImageURLForPath(path);
    }

    public URL getImageURLForPath(String path) {
        SkinPack skinPack = this.getSkinPack();
        if (skinPack != null && skinPack.getClass().getClassLoader().getResource(path) != null) {
            return skinPack.getClass().getClassLoader().getResource(path);
        }
        ImagePack imagePack = this.getImagePack();
        return imagePack.getClass().getClassLoader().getResource(path);
    }

    public URL getSoundURL(String urlKey) {
        String path = this.getSoundPath(urlKey);
        if (path == null || path.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing resource for key: " + urlKey));
            }
            return null;
        }
        return this.getSoundURLForPath(path);
    }

    public URL getSoundURLForPath(String path) {
        return this.getSoundPack().getClass().getClassLoader().getResource(path);
    }

    @Override
    public byte[] getImageInBytes(String imageID) {
        InputStream in = this.getImageInputStream(imageID);
        if (in == null) {
            return null;
        }
        byte[] image = null;
        try {
            image = new byte[in.available()];
            in.read(image);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load image:" + imageID), (Throwable)e);
        }
        return image;
    }

    @Override
    public ImageIcon getImage(String imageID) {
        URL imageURL = this.getImageURL(imageID);
        return imageURL == null ? null : new ImageIcon(imageURL);
    }

    public File prepareSkinBundleFromZip(File zipFile) throws Exception {
        return SkinJarBuilder.createBundleFromZip(zipFile, this.getImagePack());
    }

    @Override
    public String getSettingsString(String key) {
        Object configValue = ResourceManagementActivator.getConfigService().getProperty(key);
        if (configValue == null) {
            configValue = super.getSettingsString(key);
        }
        return configValue == null ? null : configValue.toString();
    }
}

