/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.thunderbird;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import mork.Dict;
import mork.MorkDocument;
import mork.Row;
import mork.Table;
import net.java.sip.communicator.plugin.thunderbird.ThunderbirdActivator;
import net.java.sip.communicator.plugin.thunderbird.ThunderbirdContactSourceService;
import net.java.sip.communicator.service.contactsource.AsyncContactQuery;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.GenericSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.StringUtils;

public class ThunderbirdContactQuery
extends AsyncContactQuery<ThunderbirdContactSourceService> {
    private static final Logger logger = Logger.getLogger(ThunderbirdContactQuery.class);

    public ThunderbirdContactQuery(ThunderbirdContactSourceService owner, Pattern query) {
        super((ContactSourceService)owner, query);
    }

    protected void run() {
        String filename = ((ThunderbirdContactSourceService)super.getContactSource()).getFilename();
        File file = new File(filename);
        try {
            if (file.lastModified() > ((ThunderbirdContactSourceService)this.getContactSource()).lastDatabaseFileChange) {
                InputStreamReader sr = new InputStreamReader(new FileInputStream(filename));
                MorkDocument morkDocument = new MorkDocument((Reader)sr);
                sr.close();
                HashMap<String, Map<String, Row>> db = new HashMap<String, Map<String, Row>>();
                for (Table t : morkDocument.getTables()) {
                    String tableId = t.getTableId() + "/" + t.getScopeName();
                    HashMap<String, Row> table = (HashMap<String, Row>)db.get(tableId);
                    if (table == null) {
                        table = new HashMap<String, Row>();
                        db.put(tableId, table);
                    }
                    for (Row r : t.getRows()) {
                        String scope = r.getScopeName();
                        if (scope == null) {
                            scope = t.getScopeName();
                        }
                        table.put(r.getRowId() + "/" + scope, r);
                    }
                }
                String defaultScope = ((Dict)morkDocument.getDicts().get(0)).dereference("^80");
                for (Row r : morkDocument.getRows()) {
                    String rowId;
                    String tableId;
                    HashMap<String, Row> table;
                    String scope = r.getScopeName();
                    if (scope == null) {
                        scope = defaultScope;
                    }
                    if ((table = (HashMap<String, Row>)db.get(tableId = "1/" + scope)) == null) {
                        table = new HashMap<String, Row>();
                        db.put(tableId, table);
                    }
                    if ((rowId = r.getRowId() + "/" + scope).startsWith("-")) {
                        rowId = rowId.substring(1);
                    }
                    table.put(rowId, r);
                }
                ((ThunderbirdContactSourceService)super.getContactSource()).database = db;
                ((ThunderbirdContactSourceService)super.getContactSource()).defaultScope = defaultScope;
                ((ThunderbirdContactSourceService)super.getContactSource()).lastDatabaseFileChange = file.lastModified();
            }
            for (Map.Entry entry : ((ThunderbirdContactSourceService)super.getContactSource()).database.entrySet()) {
                for (Map.Entry e : ((Map)entry.getValue()).entrySet()) {
                    if (!((String)e.getKey()).endsWith(((ThunderbirdContactSourceService)this.getContactSource()).defaultScope)) continue;
                    this.readEntry((Row)e.getValue());
                }
            }
            super.stopped(true);
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)"Could not open address book", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn((Object)("Could not parse " + file), (Throwable)e);
        }
    }

    private void readEntry(Row r) {
        boolean hadMatch = false;
        for (Object value : r.getAliases().values()) {
            if (value == null || !this.query.matcher(value.getValue()).find() && !super.phoneNumberMatches(value.getValue())) continue;
            hadMatch = true;
            break;
        }
        if (!hadMatch) {
            return;
        }
        LinkedList<ContactDetail> details = new LinkedList<ContactDetail>();
        for (String email : this.getPropertySet(r, "PrimaryEmail", "SecondEmail", "DefaultEmail")) {
            ContactDetail detail = new ContactDetail(email, ContactDetail.Category.Email);
            detail.addSupportedOpSet(OperationSetPersistentPresence.class);
            details.add(detail);
        }
        this.addPhoneDetail(details, r, "HomePhone", ContactDetail.SubCategory.Home);
        this.addPhoneDetail(details, r, "WorkPhone", ContactDetail.SubCategory.Work);
        this.addPhoneDetail(details, r, "CellularNumber", ContactDetail.SubCategory.Mobile);
        String displayName = r.getValue("DisplayName");
        if (StringUtils.isBlank((CharSequence)displayName)) {
            String firstName;
            displayName = r.getValue("LastName");
            if (displayName != null) {
                displayName = displayName.trim();
            }
            if (StringUtils.isNotBlank((CharSequence)(firstName = r.getValue("FirstName")))) {
                displayName = firstName + " " + displayName;
            }
        }
        GenericSourceContact sc = new GenericSourceContact(super.getContactSource(), displayName, details);
        this.addQueryResult((SourceContact)sc);
    }

    private void addPhoneDetail(List<ContactDetail> details, Row r, String property, ContactDetail.SubCategory category) {
        String phone = r.getValue(property);
        if (StringUtils.isBlank((CharSequence)phone)) {
            return;
        }
        phone = ThunderbirdActivator.getPhoneNumberI18nService().normalize(phone);
        ContactDetail detail = new ContactDetail(phone, ContactDetail.Category.Phone, new ContactDetail.SubCategory[]{category});
        detail.addSupportedOpSet(OperationSetBasicTelephony.class);
        detail.addSupportedOpSet(OperationSetPersistentPresence.class);
        details.add(detail);
    }

    private Set<String> getPropertySet(Row r, String ... properties) {
        HashSet<String> validValues = new HashSet<String>(properties.length);
        for (String prop : properties) {
            String value = r.getValue(prop);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            validValues.add(value);
        }
        return validValues;
    }
}

