/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.alaw;

import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractPacketizer;
import net.sf.fmj.utility.LoggerSingleton;

public class Packetizer
extends AbstractPacketizer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final int PACKET_SIZE = 480;
    protected Format[] outputFormats = new Format[]{new AudioFormat("ALAW/rtp", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)};

    public Packetizer() {
        this.inputFormats = new Format[]{new AudioFormat("alaw", -1.0, 8, 1, -1, -1, 8, -1.0, Format.byteArray)};
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "ALAW Packetizer";
    }

    @Override
    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (!(input instanceof AudioFormat)) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        AudioFormat inputCast = (AudioFormat)input;
        if (!inputCast.getEncoding().equals("alaw") || inputCast.getSampleSizeInBits() != 8 && inputCast.getSampleSizeInBits() != -1 || inputCast.getChannels() != 1 && inputCast.getChannels() != -1 || inputCast.getFrameSizeInBits() != 8 && inputCast.getFrameSizeInBits() != -1) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        AudioFormat result = new AudioFormat("ALAW/rtp", inputCast.getSampleRate(), 8, 1, inputCast.getEndian(), inputCast.getSigned(), 8, inputCast.getFrameRate(), inputCast.getDataType());
        return new Format[]{result};
    }

    @Override
    public void open() {
        this.setPacketSize(480);
    }

    @Override
    public Format setInputFormat(Format arg0) {
        return super.setInputFormat(arg0);
    }

    @Override
    public Format setOutputFormat(Format arg0) {
        return super.setOutputFormat(arg0);
    }
}

