/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.launcher;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import net.java.sip.communicator.launcher.SIPCommunicator;
import net.java.sip.communicator.util.FileHandler;
import net.java.sip.communicator.util.ScLogFormatter;

public class SIPCommunicatorJWS {
    public static void main(String[] args) throws Exception {
        int i;
        System.setSecurityManager(null);
        String chainMain = System.getProperty("chain.main.class");
        if (chainMain != null) {
            String chainArgs = System.getProperty("chain.main.args");
            if (chainArgs == null) {
                chainArgs = "";
            }
            final String[] _chainArgs = chainArgs.split("\\s");
            try {
                Class<?> c = Class.forName(chainMain);
                final Method m = c.getMethod("main", _chainArgs.getClass());
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            m.invoke(null, new Object[]{_chainArgs});
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            System.err.println("Exception running the chained main class, will continue anyway.");
                        }
                    }
                }.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("Exception finding the chained main class, will continue anyway.");
            }
        }
        SIPCommunicator.setScHomeDir(System.getProperty("os.name"));
        LogManager.getLogManager().readConfiguration(SIPCommunicatorJWS.class.getResourceAsStream("/logging.properties"));
        Handler[] hs = LogManager.getLogManager().getLogger("").getHandlers();
        for (int i2 = 0; i2 < hs.length; ++i2) {
            LogManager.getLogManager().getLogger("").removeHandler(hs[i2]);
        }
        LogManager.getLogManager().getLogger("").addHandler((Handler)new FileHandler());
        LogManager.getLogManager().getLogger("").addHandler(new ConsoleHandler());
        Handler[] h = LogManager.getLogManager().getLogger("").getHandlers();
        for (int i3 = 0; i3 < h.length; ++i3) {
            h[i3].setFormatter((Formatter)new ScLogFormatter());
        }
        Method findLibrary = SIPCommunicatorJWS.class.getClassLoader().getClass().getDeclaredMethod("findLibrary", String.class);
        findLibrary.setAccessible(true);
        File path = new File((String)findLibrary.invoke((Object)SIPCommunicatorJWS.class.getClassLoader(), "hid")).getParentFile();
        System.setProperty("java.library.path", System.getProperty("java.library.path") + File.pathSeparator + path.getAbsolutePath());
        Field sys_paths = ClassLoader.class.getDeclaredField("sys_paths");
        sys_paths.setAccessible(true);
        sys_paths.set(null, null);
        Properties pIn = new Properties();
        Properties pOut = new Properties();
        pIn.load(SIPCommunicatorJWS.class.getResourceAsStream(System.getProperty("felix.config.properties")));
        String baseServerUrl = System.getProperty("net.java.sip.communicator.SC_JWS_BASEDIR");
        ClassLoader cl = SIPCommunicatorJWS.class.getClassLoader();
        Method getJarFile = cl.getClass().getDeclaredMethod("getJarFile", URL.class);
        getJarFile.setAccessible(true);
        for (Map.Entry<Object, Object> e : pIn.entrySet()) {
            if (((String)e.getKey()).startsWith("felix.auto.start.")) {
                String[] refs = ((String)e.getValue()).split("\\s");
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < refs.length; ++i) {
                    String ref = refs[i];
                    JarFile localFile = (JarFile)getJarFile.invoke((Object)cl, new URL(baseServerUrl + ref.replace("@URL@", "")));
                    if (localFile == null) {
                        throw new Exception("ref <" + ref + "> not found in cache");
                    }
                    String localFileName = new File(localFile.getName()).toURI().toString();
                    sb.append("reference:");
                    sb.append(localFileName);
                    sb.append(" ");
                }
                pOut.put(e.getKey(), sb.toString());
                continue;
            }
            pOut.put(e.getKey(), e.getValue());
        }
        File jwsFelixConfig = File.createTempFile("jws", ".properties");
        jwsFelixConfig.deleteOnExit();
        pOut.store(new FileOutputStream(jwsFelixConfig), "--- autogenerated, do not edit! ---");
        System.setProperty("felix.config.properties", jwsFelixConfig.toURI().toString());
        try {
            if (System.getProperty("os.name").equals("Linux")) {
                File desktop = new File(System.getProperty("user.home") + "/Desktop");
                File[] files = desktop.listFiles();
                for (i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.getName().contains("jws_app_shortcut_")) continue;
                    file.setExecutable(true, false);
                }
            }
        }
        catch (Exception desktop) {
            // empty catch block
        }
        Vector<String> _args = new Vector<String>();
        for (int i4 = 0; i4 < args.length; ++i4) {
            String arg = args[i4];
            if (arg.equalsIgnoreCase("-open")) {
                if (i4 != args.length - 1 && (args[i4 + 1].length() <= 0 || "-/".indexOf(args[i4 + 1].charAt(0)) < 0)) continue;
                System.err.println("Command line argument '-open' requires a parameter, usually a URI");
                System.exit(1);
                continue;
            }
            _args.add(arg);
        }
        SIPCommunicator.main(_args.toArray(new String[_args.size()]));
    }
}

