/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.util.Iterator;
import javax.sip.Dialog;
import javax.sip.Transaction;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.service.protocol.ActiveCallsRepository;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.util.Logger;

public class ActiveCallsRepositorySipImpl
extends ActiveCallsRepository<CallSipImpl, OperationSetBasicTelephonySipImpl> {
    private static final Logger logger = Logger.getLogger(ActiveCallsRepositorySipImpl.class);

    public ActiveCallsRepositorySipImpl(OperationSetBasicTelephonySipImpl opSet) {
        super((OperationSetBasicTelephony)opSet);
    }

    public CallSipImpl findCall(Dialog dialog) {
        Iterator activeCalls = this.getActiveCalls();
        if (dialog == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cannot find a peer with a null dialog. Returning null");
            }
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Looking for peer with dialog: " + dialog + " among " + this.getActiveCallCount() + " calls"));
        }
        while (activeCalls.hasNext()) {
            CallSipImpl call = (CallSipImpl)((Object)activeCalls.next());
            if (!call.contains(dialog)) continue;
            return call;
        }
        return null;
    }

    public CallPeerSipImpl findCallPeer(Dialog dialog) {
        if (dialog == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cannot find a peer with a null dialog. Returning null");
            }
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Looking for peer with dialog: " + dialog + " among " + this.getActiveCallCount() + " calls"));
        }
        Iterator activeCalls = this.getActiveCalls();
        while (activeCalls.hasNext()) {
            CallSipImpl call = (CallSipImpl)((Object)activeCalls.next());
            CallPeerSipImpl callPeer = call.findCallPeer(dialog);
            if (callPeer == null) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Returning peer " + (Object)((Object)callPeer)));
            }
            return callPeer;
        }
        return null;
    }

    public CallPeerSipImpl findCallPeer(String callID, String localTag, String remoteTag) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Looking for call peer with callID " + callID + ", localTag " + localTag + ", and remoteTag " + remoteTag + " among " + this.getActiveCallCount() + " calls."));
        }
        Iterator activeCalls = this.getActiveCalls();
        while (activeCalls.hasNext()) {
            CallSipImpl call = (CallSipImpl)((Object)activeCalls.next());
            Iterator callPeerIter = call.getCallPeers();
            while (callPeerIter.hasNext()) {
                CallPeerSipImpl callPeer = (CallPeerSipImpl)((Object)callPeerIter.next());
                Dialog dialog = callPeer.getDialog();
                if (dialog == null || !callID.equals(dialog.getCallId().getCallId())) continue;
                String dialogLocalTag = dialog.getLocalTag();
                if (!(localTag == null || "0".equals(localTag) ? dialogLocalTag == null || "0".equals(dialogLocalTag) : localTag.equals(dialogLocalTag))) continue;
                String dialogRemoteTag = dialog.getRemoteTag();
                if (!(remoteTag == null || "0".equals(remoteTag) ? dialogRemoteTag == null || "0".equals(dialogRemoteTag) : remoteTag.equals(dialogRemoteTag))) continue;
                return callPeer;
            }
        }
        return null;
    }

    public CallPeerSipImpl findCallPeer(String branchID, String callID) {
        Iterator activeCallsIter = this.getActiveCalls();
        while (activeCallsIter.hasNext()) {
            CallSipImpl activeCall = (CallSipImpl)((Object)activeCallsIter.next());
            Iterator callPeersIter = activeCall.getCallPeers();
            while (callPeersIter.hasNext()) {
                CallPeerSipImpl cp = (CallPeerSipImpl)((Object)callPeersIter.next());
                Dialog cpDialog = cp.getDialog();
                Transaction cpTran = cp.getLatestInviteTransaction();
                if (cpDialog == null || cpDialog.getCallId() == null || cpTran == null || cp.getLatestInviteTransaction() == null || !cpDialog.getCallId().getCallId().equals(callID) || !branchID.equals(cpTran.getBranchId())) continue;
                return cp;
            }
        }
        return null;
    }

    public CallPeerSipImpl findCallPeer(String branchID, Header cidHeader) {
        if (cidHeader == null || !(cidHeader instanceof CallIdHeader)) {
            return null;
        }
        return this.findCallPeer(branchID, ((CallIdHeader)cidHeader).getCallId());
    }

    public CallSipImpl findCall(String callID, String localTag, String remoteTag) {
        CallPeerSipImpl peer = this.findCallPeer(callID, localTag, remoteTag);
        return peer == null ? null : (CallSipImpl)peer.getCall();
    }

    protected void fireCallEvent(int eventID, Call sourceCall, CallChangeEvent cause) {
        ((OperationSetBasicTelephonySipImpl)this.parentOperationSet).fireCallEvent(eventID, sourceCall);
    }
}

