/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.ContentType;
import java.net.InetSocketAddress;
import java.net.URL;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;
import javax.sip.header.ReasonHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.CallPeerMediaHandlerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.EventPackageUtils;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorListener;
import net.java.sip.communicator.impl.protocol.sip.OperationSetPresenceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.SipMessageFactory;
import net.java.sip.communicator.impl.protocol.sip.sdp.SdpUtils;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.media.AbstractOperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.utils.MediaType;

public class CallPeerSipImpl
extends MediaAwareCallPeer<CallSipImpl, CallPeerMediaHandlerSipImpl, ProtocolProviderServiceSipImpl> {
    private static final Logger logger = Logger.getLogger(CallPeerSipImpl.class);
    static final String PICTURE_FAST_UPDATE_CONTENT_SUB_TYPE = "media_control+xml";
    private Address peerAddress = null;
    private Dialog jainSipDialog = null;
    private Transaction latestInviteTransaction = null;
    private SipProvider jainSipProvider = null;
    private InetSocketAddress transportAddress = null;
    private final SipMessageFactory messageFactory;
    private final List<MethodProcessorListener> methodProcessorListeners = new LinkedList<MethodProcessorListener>();
    private boolean sendPictureFastUpdate = "signaling".equals(SipActivator.getConfigurationService().getString("net.java.sip.communicator.impl.neomedia.codec.video.h264.preferredKeyFrameRequester", "rtcp"));

    public CallPeerSipImpl(Address peerAddress, CallSipImpl owningCall, Transaction containingTransaction, SipProvider sourceProvider) {
        super((MediaAwareCall)owningCall);
        this.peerAddress = peerAddress;
        this.messageFactory = ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).getMessageFactory();
        super.setMediaHandler((CallPeerMediaHandler)new CallPeerMediaHandlerSipImpl(this){

            protected boolean requestKeyFrame() {
                return CallPeerSipImpl.this.requestKeyFrame();
            }
        });
        this.setDialog(containingTransaction.getDialog());
        this.setLatestInviteTransaction(containingTransaction);
        this.setJainSipProvider(sourceProvider);
    }

    public String getAddress() {
        SipURI sipURI = (SipURI)this.peerAddress.getURI();
        return sipURI.getUser() + "@" + sipURI.getHost();
    }

    public String getURI() {
        return this.getPeerAddress().getURI().toString();
    }

    public Address getPeerAddress() {
        Address remoteParty;
        Dialog dialog = this.getDialog();
        if (dialog != null && (remoteParty = dialog.getRemoteParty()) != null) {
            this.peerAddress = remoteParty;
        }
        return this.peerAddress;
    }

    public String getDisplayName() {
        String displayName = this.getPeerAddress().getDisplayName();
        if (displayName == null) {
            Contact contact = this.getContact();
            if (contact != null) {
                displayName = contact.getDisplayName();
            } else {
                String userName;
                URI peerURI = this.getPeerAddress().getURI();
                if (peerURI instanceof SipURI && (userName = ((SipURI)peerURI).getUser()) != null && userName.length() > 0) {
                    displayName = userName;
                }
                if (displayName == null) {
                    displayName = peerURI.toString();
                }
            }
        }
        if (displayName.startsWith("sip:")) {
            displayName = displayName.substring(4);
        }
        return displayName;
    }

    public void setDisplayName(String displayName) {
        String oldName = this.getDisplayName();
        try {
            this.peerAddress.setDisplayName(displayName);
        }
        catch (ParseException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.fireCallPeerChangeEvent("CallPeerDisplayNameChange", oldName, displayName);
    }

    public void setDialog(Dialog dialog) {
        this.jainSipDialog = dialog;
    }

    public Dialog getDialog() {
        return this.jainSipDialog;
    }

    public void setLatestInviteTransaction(Transaction transaction) {
        this.latestInviteTransaction = transaction;
    }

    public Transaction getLatestInviteTransaction() {
        return this.latestInviteTransaction;
    }

    public void setJainSipProvider(SipProvider jainSipProvider) {
        this.jainSipProvider = jainSipProvider;
    }

    public SipProvider getJainSipProvider() {
        return this.jainSipProvider;
    }

    public void setTransportAddress(InetSocketAddress transportAddress) {
        InetSocketAddress oldTransportAddress = this.transportAddress;
        this.transportAddress = transportAddress;
        this.fireCallPeerChangeEvent("CallPeerAddressChange", oldTransportAddress, transportAddress);
    }

    public Contact getContact() {
        if (this.getCall() == null) {
            return null;
        }
        ProtocolProviderServiceSipImpl pps = ((CallSipImpl)this.getCall()).getProtocolProvider();
        OperationSetPresenceSipImpl opSetPresence = (OperationSetPresenceSipImpl)pps.getOperationSet(OperationSetPresence.class);
        if (opSetPresence != null) {
            return opSetPresence.resolveContactID(this.getAddress());
        }
        return null;
    }

    public URL getCallInfoURL() {
        return ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).getCallInfoURL();
    }

    void processPictureFastUpdate(ClientTransaction clientTransaction, Response response) {
        if (response.getStatusCode() != 200 && this.sendPictureFastUpdate) {
            this.sendPictureFastUpdate = false;
        }
    }

    boolean processPictureFastUpdate(ServerTransaction serverTransaction, Request request) throws OperationFailedException {
        Response response;
        CallPeerMediaHandlerSipImpl mediaHandler = (CallPeerMediaHandlerSipImpl)this.getMediaHandler();
        boolean requested = mediaHandler == null ? false : mediaHandler.processKeyFrameRequest();
        try {
            response = ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).getMessageFactory().createResponse(200, request);
        }
        catch (ParseException pe) {
            throw new OperationFailedException("Failed to create OK Response.", 4, (Throwable)pe);
        }
        if (!requested) {
            ContentType ct = new ContentType("application", PICTURE_FAST_UPDATE_CONTENT_SUB_TYPE);
            String content = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<media_control>\r\n<general_error>\r\nFailed to process picture_fast_update request.\r\n</general_error>\r\n</media_control>";
            try {
                response.setContent((Object)content, (ContentTypeHeader)ct);
            }
            catch (ParseException pe) {
                throw new OperationFailedException("Failed to set content of OK Response.", 4, (Throwable)pe);
            }
        }
        try {
            serverTransaction.sendResponse(response);
        }
        catch (Exception e) {
            throw new OperationFailedException("Failed to send OK Response.", 4, (Throwable)e);
        }
        return true;
    }

    public void processReInvite(ServerTransaction serverTransaction) {
        Request invite = serverTransaction.getRequest();
        this.setLatestInviteTransaction((Transaction)serverTransaction);
        String sdpOffer = null;
        ContentLengthHeader cl = invite.getContentLength();
        if (cl != null && cl.getContentLength() > 0) {
            sdpOffer = SdpUtils.getContentAsString((Message)invite);
        }
        Response response = null;
        try {
            response = this.messageFactory.createResponse(200, invite);
            this.processExtraHeaders((Message)response);
            String sdpAnswer = sdpOffer != null ? ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).processOffer(sdpOffer) : ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).createOffer();
            response.setContent((Object)sdpAnswer, ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).getHeaderFactory().createContentTypeHeader("application", "sdp"));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("will send an OK response: " + response));
            }
            serverTransaction.sendResponse(response);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"OK response sent");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while trying to send a response", (Throwable)ex);
            this.setState(CallPeerState.FAILED, "Internal Error: " + ex.getMessage());
            ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).sayErrorSilently(serverTransaction, 500);
            return;
        }
        this.reevalRemoteHoldStatus();
        this.fireRequestProcessed(invite, response);
    }

    public void processBye(ServerTransaction byeTran) {
        boolean dialogIsAlive;
        Request byeRequest = byeTran.getRequest();
        Response ok = null;
        try {
            ok = this.messageFactory.createResponse(200, byeRequest);
        }
        catch (ParseException ex) {
            logger.error((Object)"Error while trying to send a response to a bye", (Throwable)ex);
        }
        if (ok != null) {
            try {
                byeTran.sendResponse(ok);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sent response " + ok));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to send an OK response to BYE request,exception was:\n", (Throwable)ex);
            }
        }
        try {
            dialogIsAlive = EventPackageUtils.processByeThenIsDialogAlive(byeTran.getDialog());
        }
        catch (SipException ex) {
            dialogIsAlive = false;
            logger.error((Object)"Failed to determine whether the dialog should stay alive.", (Throwable)ex);
        }
        if (dialogIsAlive) {
            ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).close();
        } else {
            ReasonHeader reasonHeader = (ReasonHeader)byeRequest.getHeader("Reason");
            if (reasonHeader != null) {
                this.setState(CallPeerState.DISCONNECTED, reasonHeader.getText(), reasonHeader.getCause());
            } else {
                this.setState(CallPeerState.DISCONNECTED);
            }
        }
    }

    public void processCancel(ServerTransaction serverTransaction) {
        Request cancel = serverTransaction.getRequest();
        try {
            Response ok = this.messageFactory.createResponse(200, cancel);
            serverTransaction.sendResponse(ok);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent an ok response to a CANCEL request:\n" + ok));
            }
        }
        catch (ParseException ex) {
            this.logAndFail("Failed to create an OK Response to a CANCEL.", ex);
            return;
        }
        catch (Exception ex) {
            this.logAndFail("Failed to send an OK Response to a CANCEL.", ex);
            return;
        }
        try {
            Transaction tran = this.getLatestInviteTransaction();
            if (!(tran instanceof ServerTransaction)) {
                logger.error((Object)"Received a misplaced CANCEL request!");
                return;
            }
            ServerTransaction inviteTran = (ServerTransaction)tran;
            Request invite = this.getLatestInviteTransaction().getRequest();
            Response requestTerminated = this.messageFactory.createResponse(487, invite);
            inviteTran.sendResponse(requestTerminated);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent request terminated response:\n" + requestTerminated));
            }
        }
        catch (ParseException ex) {
            logger.error((Object)"Failed to create a REQUEST_TERMINATED Response to an INVITE request.", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to send an REQUEST_TERMINATED Response to an INVITE request.", (Throwable)ex);
        }
        ReasonHeader reasonHeader = (ReasonHeader)cancel.getHeader("Reason");
        if (reasonHeader != null) {
            this.setState(CallPeerState.DISCONNECTED, reasonHeader.getText(), reasonHeader.getCause());
        } else {
            this.setState(CallPeerState.DISCONNECTED);
        }
    }

    public void processAck(ServerTransaction serverTransaction, Request ack) {
        CallPeerState peerState;
        ContentLengthHeader contentLength = ack.getContentLength();
        if (contentLength != null && contentLength.getContentLength() > 0) {
            try {
                ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).processAnswer(SdpUtils.getContentAsString((Message)ack));
            }
            catch (Exception exc) {
                this.logAndFail("There was an error parsing the SDP description of " + this.getDisplayName() + "(" + this.getAddress() + ")", exc);
                return;
            }
        }
        if (!CallPeerState.isOnHold((CallPeerState)(peerState = this.getState()))) {
            this.setState(CallPeerState.CONNECTED);
            ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).start();
            if (this.getCall() != null && this.isMute() != ((CallSipImpl)this.getCall()).isMute()) {
                this.setMute(((CallSipImpl)this.getCall()).isMute());
            }
        }
    }

    public void processSessionProgress(ClientTransaction tran, Response response) {
        if (response.getContentLength().getContentLength() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Ignoring a 183 with no content");
            }
            return;
        }
        ContentTypeHeader contentTypeHeader = (ContentTypeHeader)response.getHeader("Content-Type");
        if (!contentTypeHeader.getContentType().equalsIgnoreCase("application") || !contentTypeHeader.getContentSubType().equalsIgnoreCase("sdp")) {
            logger.warn((Object)"Ignoring invite 183 since call peer is already exchanging early media.");
            return;
        }
        try {
            ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).processAnswer(SdpUtils.getContentAsString((Message)response));
        }
        catch (Exception exc) {
            this.logAndFail("There was an error parsing the SDP description of " + this.getDisplayName() + "(" + this.getAddress() + ")", exc);
            return;
        }
        this.setState(CallPeerState.CONNECTING_WITH_EARLY_MEDIA);
        ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).start();
        this.setMute(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInviteOK(ClientTransaction clientTransaction, Response ok) {
        try {
            ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).sendAck(clientTransaction);
        }
        catch (InvalidArgumentException ex) {
            this.logAndFail("Error creating an ACK (CSeq?)", ex);
            return;
        }
        catch (SipException ex) {
            this.logAndFail("Failed to create ACK request!", ex);
            return;
        }
        try {
            if (!CallPeerState.CONNECTING_WITH_EARLY_MEDIA.equals(this.getState())) {
                ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).processAnswer(SdpUtils.getContentAsString((Message)ok));
            }
        }
        catch (Exception exc) {
            logger.error((Object)("There was an error parsing the SDP description of " + this.getDisplayName() + "(" + this.getAddress() + ")"), (Throwable)exc);
            try {
                this.setState(CallPeerState.CONNECTED, "Error:" + exc.getLocalizedMessage());
                this.hangup();
            }
            catch (Exception exception) {
            }
            finally {
                this.logAndFail("Remote party sent a faulty session description.", exc);
            }
            return;
        }
        if (!CallPeerState.isOnHold((CallPeerState)this.getState())) {
            this.setState(CallPeerState.CONNECTED);
            ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).start();
            if (this.getCall() != null && this.isMute() != ((CallSipImpl)this.getCall()).isMute()) {
                this.setMute(((CallSipImpl)this.getCall()).isMute());
            }
        }
        this.fireResponseProcessed(ok, null);
    }

    private void pictureFastUpdate() throws OperationFailedException {
        Request info = ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).getMessageFactory().createRequest(this.getDialog(), "INFO");
        ContentType ct = new ContentType("application", PICTURE_FAST_UPDATE_CONTENT_SUB_TYPE);
        String content = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<media_control>\r\n<vc_primitive>\r\n<to_encoder>\r\n<picture_fast_update/>\r\n</to_encoder>\r\n</vc_primitive>\r\n</media_control>";
        ContentLength cl = new ContentLength(content.length());
        info.setContentLength((ContentLengthHeader)cl);
        try {
            info.setContent((Object)content.getBytes(), (ContentTypeHeader)ct);
        }
        catch (ParseException ex) {
            logger.error((Object)"Failed to construct the INFO request", (Throwable)ex);
            throw new OperationFailedException("Failed to construct a client the INFO request", 4, (Throwable)ex);
        }
        ClientTransaction clientTransaction = null;
        try {
            clientTransaction = this.getJainSipProvider().getNewClientTransaction(info);
        }
        catch (TransactionUnavailableException ex) {
            logger.error((Object)"Failed to construct a client transaction from the INFO request", (Throwable)ex);
            throw new OperationFailedException("Failed to construct a client transaction from the INFO request", 4, (Throwable)ex);
        }
        try {
            if (this.getDialog().getState() == DialogState.TERMINATED) {
                logger.warn((Object)"Trying to send a dtmf tone inside a TERMINATED dialog.");
                return;
            }
            this.getDialog().sendRequest(clientTransaction);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent request:\n" + info));
            }
        }
        catch (SipException ex) {
            throw new OperationFailedException("Failed to send the INFO request", 2, (Throwable)ex);
        }
    }

    public void hangup() throws OperationFailedException {
        this.hangup(200, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void hangup(int reasonCode, String reason) throws OperationFailedException {
        if (CallPeerState.DISCONNECTED.equals(this.getState()) || CallPeerState.FAILED.equals(this.getState())) {
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)"Ignoring a request to hangup a call peer that is already DISCONNECTED");
            return;
        }
        boolean failed = reasonCode != 200;
        CallPeerState peerState = this.getState();
        if (peerState.equals(CallPeerState.CONNECTED) || CallPeerState.isOnHold((CallPeerState)peerState)) {
            try {
                boolean dialogIsAlive = this.sayBye(reasonCode, reason);
                if (dialogIsAlive) return;
                this.setDisconnectedState(failed, reason);
                return;
            }
            catch (Throwable ex) {
                logger.error((Object)"Error while trying to hangup, trying to handle!", ex);
                this.setDisconnectedState(true, null);
                if (!(ex instanceof OperationFailedException)) return;
                throw (OperationFailedException)ex;
            }
        } else if (CallPeerState.CONNECTING.equals(this.getState()) || CallPeerState.CONNECTING_WITH_EARLY_MEDIA.equals(this.getState()) || CallPeerState.ALERTING_REMOTE_SIDE.equals(this.getState())) {
            if (this.getLatestInviteTransaction() != null) {
                this.sayCancel();
            }
            this.setDisconnectedState(failed, reason);
            return;
        } else if (peerState.equals(CallPeerState.INCOMING_CALL)) {
            this.setDisconnectedState(failed, reason);
            this.sayBusyHere();
            return;
        } else if (peerState.equals(CallPeerState.BUSY)) {
            this.setDisconnectedState(failed, reason);
            return;
        } else if (peerState.equals(CallPeerState.FAILED)) {
            this.setDisconnectedState(failed, reason);
            return;
        } else {
            this.setDisconnectedState(failed, reason);
            logger.error((Object)"Could not determine call peer state!");
        }
    }

    private void sayBusyHere() throws OperationFailedException {
        if (!(this.getLatestInviteTransaction() instanceof ServerTransaction)) {
            logger.error((Object)"Cannot send BUSY_HERE in a client transaction");
            throw new OperationFailedException("Cannot send BUSY_HERE in a client transaction", 4);
        }
        Request request = this.getLatestInviteTransaction().getRequest();
        Response busyHere = null;
        try {
            busyHere = this.messageFactory.createResponse(486, request);
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create the BUSY_HERE response!", 4, ex, logger);
        }
        ServerTransaction serverTransaction = (ServerTransaction)this.getLatestInviteTransaction();
        try {
            serverTransaction.sendResponse(busyHere);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent response:\n" + busyHere));
            }
        }
        catch (Exception ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to send the BUSY_HERE response", 2, ex, logger);
        }
    }

    private void sayCancel() throws OperationFailedException {
        if (this.getLatestInviteTransaction() instanceof ServerTransaction) {
            logger.error((Object)"Cannot cancel a server transaction");
            throw new OperationFailedException("Cannot cancel a server transaction", 4);
        }
        ClientTransaction clientTransaction = (ClientTransaction)this.getLatestInviteTransaction();
        try {
            Request cancel = clientTransaction.createCancel();
            ClientTransaction cancelTransaction = this.getJainSipProvider().getNewClientTransaction(cancel);
            cancelTransaction.sendRequest();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent request:\n" + cancel));
            }
        }
        catch (SipException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to send the CANCEL request", 2, ex, logger);
        }
    }

    private boolean sayBye(int reasonCode, String reason) throws OperationFailedException {
        int sipCode;
        Dialog dialog = this.getDialog();
        Request bye = this.messageFactory.createRequest(dialog, "BYE");
        if (reasonCode != 200 && reason != null && (sipCode = CallPeerSipImpl.convertReasonCodeToSIPCode(reasonCode)) != -1) {
            try {
                ReasonHeader reasonHeader = ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).getHeaderFactory().createReasonHeader("SIP", sipCode, reason);
                bye.setHeader((Header)reasonHeader);
            }
            catch (Throwable e) {
                logger.error((Object)"Cannot set reason header", e);
            }
        }
        ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).sendInDialogRequest(this.getJainSipProvider(), bye, dialog);
        try {
            return EventPackageUtils.processByeThenIsDialogAlive(dialog);
        }
        catch (SipException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to determine whether the dialog should stay alive.", 4, ex, logger);
            return false;
        }
    }

    private static int convertReasonCodeToSIPCode(int reasonCode) {
        switch (reasonCode) {
            case 200: {
                return 202;
            }
            case 609: {
                return 606;
            }
            case 408: {
                return 408;
            }
            case 486: {
                return 486;
            }
        }
        return -1;
    }

    public synchronized void answer() throws OperationFailedException {
        Transaction transaction = this.getLatestInviteTransaction();
        if (transaction == null || !(transaction instanceof ServerTransaction)) {
            this.setState(CallPeerState.DISCONNECTED);
            throw new OperationFailedException("Failed to extract a ServerTransaction from the call's associated dialog!", 4);
        }
        CallPeerState peerState = this.getState();
        if (peerState.equals(CallPeerState.CONNECTED) || CallPeerState.isOnHold((CallPeerState)peerState)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Ignoring user request to answer a CallPeer that is already connected. CP:");
            }
            return;
        }
        ServerTransaction serverTransaction = (ServerTransaction)transaction;
        Request invite = serverTransaction.getRequest();
        Response ok = null;
        try {
            ok = this.messageFactory.createResponse(200, invite);
            this.processExtraHeaders((Message)ok);
        }
        catch (ParseException ex) {
            this.setState(CallPeerState.DISCONNECTED);
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to construct an OK response to an INVITE request", 4, ex, logger);
        }
        ContentTypeHeader contentTypeHeader = null;
        try {
            contentTypeHeader = ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).getHeaderFactory().createContentTypeHeader("application", "sdp");
        }
        catch (ParseException ex) {
            this.setState(CallPeerState.DISCONNECTED);
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create a content type header for the OK response", 4, ex, logger);
        }
        String sdpOffer = null;
        try {
            ContentLengthHeader cl = invite.getContentLength();
            if (cl != null && cl.getContentLength() > 0) {
                sdpOffer = SdpUtils.getContentAsString((Message)invite);
            }
            String sdp = sdpOffer != null && sdpOffer.length() > 0 ? ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).processOffer(sdpOffer) : ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).createOffer();
            ok.setContent((Object)sdp, contentTypeHeader);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to create an SDP description for an OK response to an INVITE request!", (Throwable)ex);
            ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).sayError(serverTransaction, 488);
            this.setState(CallPeerState.FAILED, ex.getMessage());
            return;
        }
        try {
            serverTransaction.sendResponse(ok);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent response\n" + ok));
            }
        }
        catch (Exception ex) {
            this.setState(CallPeerState.DISCONNECTED);
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to send an OK response to an INVITE request", 2, ex, logger);
        }
        this.fireRequestProcessed(invite, ok);
        if (CallPeerState.INCOMING_CALL.equals(this.getState())) {
            if (sdpOffer != null && sdpOffer.length() > 0) {
                this.setState(CallPeerState.CONNECTING_INCOMING_CALL_WITH_MEDIA);
            } else {
                this.setState(CallPeerState.CONNECTING_INCOMING_CALL);
            }
        }
    }

    public void putOnHold(boolean onHold) throws OperationFailedException {
        CallPeerMediaHandlerSipImpl mediaHandler = (CallPeerMediaHandlerSipImpl)this.getMediaHandler();
        mediaHandler.setLocallyOnHold(onHold);
        try {
            this.sendReInvite(mediaHandler.createOffer());
        }
        catch (Exception ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create SDP offer to hold.", 4, ex, logger);
        }
        this.reevalLocalHoldStatus();
    }

    void sendReInvite() throws OperationFailedException {
        this.sendReInvite(((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).createOffer());
    }

    private void sendReInvite(String sdpOffer) throws OperationFailedException {
        Dialog dialog = this.getDialog();
        Request invite = this.messageFactory.createRequest(dialog, "INVITE");
        try {
            invite.setContent((Object)sdpOffer, ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).getHeaderFactory().createContentTypeHeader("application", "sdp"));
            this.processExtraHeaders((Message)invite);
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to parse SDP offer for the new invite.", 4, ex, logger);
        }
        ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).sendInDialogRequest(this.getJainSipProvider(), invite, dialog);
    }

    public void invite() throws OperationFailedException {
        try {
            ClientTransaction inviteTran = (ClientTransaction)this.getLatestInviteTransaction();
            Request invite = inviteTran.getRequest();
            ContentTypeHeader contentTypeHeader = ((ProtocolProviderServiceSipImpl)this.getProtocolProvider()).getHeaderFactory().createContentTypeHeader("application", "sdp");
            invite.setContent((Object)((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).createOffer(), contentTypeHeader);
            this.processExtraHeaders((Message)invite);
            inviteTran.sendRequest();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent request:\n" + inviteTran.getRequest()));
            }
        }
        catch (Exception ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("An error occurred while sending invite request", 2, ex, logger);
        }
    }

    protected void processExtraHeaders(Message message) throws ParseException {
        this.reflectConferenceFocus(message);
    }

    private void reflectConferenceFocus(Message message) throws ParseException {
        ContactHeader contactHeader = (ContactHeader)message.getHeader("Contact");
        if (contactHeader != null) {
            if (this.getCall() != null && ((CallSipImpl)this.getCall()).isConferenceFocus()) {
                contactHeader.setParameter("isfocus", null);
            } else {
                contactHeader.removeParameter("isfocus");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMethodProcessorListener(MethodProcessorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<MethodProcessorListener> list = this.methodProcessorListeners;
        synchronized (list) {
            if (!this.methodProcessorListeners.contains(listener)) {
                this.methodProcessorListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRequestProcessed(Request request, Response response) {
        LinkedList<MethodProcessorListener> listeners;
        List<MethodProcessorListener> list = this.methodProcessorListeners;
        synchronized (list) {
            listeners = new LinkedList<MethodProcessorListener>(this.methodProcessorListeners);
        }
        for (MethodProcessorListener listener : listeners) {
            listener.requestProcessed(this, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireResponseProcessed(Response response, Request request) {
        LinkedList<MethodProcessorListener> listeners;
        List<MethodProcessorListener> list = this.methodProcessorListeners;
        synchronized (list) {
            listeners = new LinkedList<MethodProcessorListener>(this.methodProcessorListeners);
        }
        for (MethodProcessorListener listener : listeners) {
            listener.responseProcessed(this, response, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMethodProcessorListener(MethodProcessorListener listener) {
        if (listener != null) {
            List<MethodProcessorListener> list = this.methodProcessorListeners;
            synchronized (list) {
                this.methodProcessorListeners.remove(listener);
            }
        }
    }

    private boolean requestKeyFrame() {
        boolean requested = false;
        if (this.sendPictureFastUpdate) {
            try {
                this.pictureFastUpdate();
                requested = true;
            }
            catch (OperationFailedException operationFailedException) {
                // empty catch block
            }
        }
        return requested;
    }

    public void handleAuthenticationChallenge(ClientTransaction retryTran) {
        this.setDialog(retryTran.getDialog());
        this.setLatestInviteTransaction((Transaction)retryTran);
        this.setJainSipProvider(this.jainSipProvider);
    }

    private void setDisconnectedState(boolean failed, String reason) {
        if (failed) {
            this.setState(CallPeerState.FAILED, reason);
        } else {
            this.setState(CallPeerState.DISCONNECTED, reason);
        }
    }

    public String getEntity() {
        return AbstractOperationSetTelephonyConferencing.stripParametersFromAddress((String)this.getURI());
    }

    public MediaDirection getDirection(MediaType mediaType) {
        MediaStream stream = ((CallPeerMediaHandlerSipImpl)this.getMediaHandler()).getStream(mediaType);
        if (stream != null) {
            MediaDirection direction = stream.getDirection();
            return direction == null ? MediaDirection.INACTIVE : direction;
        }
        return MediaDirection.INACTIVE;
    }
}

