/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.ContentType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorAdapter;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipStackSharing;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetJitsiMeetTools;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class OperationSetJitsiMeetToolsSipImpl
extends MethodProcessorAdapter
implements OperationSetJitsiMeetTools {
    private final ProtocolProviderServiceSipImpl parentProvider;
    private static final String VIA_PARAMETER = "VIA";
    private static final String VIA_SIP_INFO = "SIP.INFO";
    public static final String DEFAULT_MIME_ENCODING = "UTF-8";
    public String JITSI_MEET_ROOM_HEADER = "Jitsi-Conference-Room";
    private static final String JITSI_MEET_ROOM_HEADER_PROPERTY = "JITSI_MEET_ROOM_HEADER_NAME";
    private static final Logger logger = Logger.getLogger(OperationSetJitsiMeetToolsSipImpl.class);
    private final List<OperationSetJitsiMeetTools.JitsiMeetRequestListener> requestHandlers = new CopyOnWriteArrayList<OperationSetJitsiMeetTools.JitsiMeetRequestListener>();

    public OperationSetJitsiMeetToolsSipImpl(ProtocolProviderServiceSipImpl parentProvider) {
        AccountID account = parentProvider.getAccountID();
        this.JITSI_MEET_ROOM_HEADER = account.getAccountPropertyString((Object)JITSI_MEET_ROOM_HEADER_PROPERTY, this.JITSI_MEET_ROOM_HEADER);
        this.parentProvider = parentProvider;
        this.parentProvider.registerMethodProcessor("INFO", this);
    }

    public void addRequestListener(OperationSetJitsiMeetTools.JitsiMeetRequestListener requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    public void removeRequestListener(OperationSetJitsiMeetTools.JitsiMeetRequestListener requestHandler) {
        this.requestHandlers.remove(requestHandler);
    }

    public void notifyJoinJitsiMeetRoom(Call call, Map<String, String> callHeaders) {
        String jitsiMeetRoom = callHeaders.get(this.JITSI_MEET_ROOM_HEADER);
        if (jitsiMeetRoom == null) {
            return;
        }
        boolean handled = false;
        for (OperationSetJitsiMeetTools.JitsiMeetRequestListener l : this.requestHandlers) {
            l.onJoinJitsiMeetRequest(call, jitsiMeetRoom, callHeaders);
            handled = true;
        }
        if (!handled) {
            logger.warn((Object)("Unhandled join Jitsi Meet request R:" + jitsiMeetRoom + " C: " + call));
        }
    }

    public void addSupportedFeature(String featureName) {
        throw new RuntimeException("Not implemented for SIP");
    }

    public void removeSupportedFeature(String featureName) {
        throw new RuntimeException("Not implemented for SIP");
    }

    public void sendPresenceExtension(ChatRoom chatRoom, ExtensionElement extension) {
        throw new RuntimeException("Not implemented for SIP");
    }

    public void removePresenceExtension(ChatRoom chatRoom, ExtensionElement extension) {
        throw new RuntimeException("Not implemented for SIP");
    }

    public void setPresenceStatus(ChatRoom chatRoom, String statusMessage) {
        throw new RuntimeException("Not implemented for SIP");
    }

    public void sendJSON(CallPeer callPeer, JSONObject jsonObject, Map<String, Object> params) throws OperationFailedException {
        block6: {
            try {
                boolean bViaParam = params.containsKey(VIA_PARAMETER);
                if (!bViaParam) {
                    throw new OperationFailedException("Unspecified VIA parameter!", 11);
                }
                String viaParam = (String)params.get(VIA_PARAMETER);
                if (viaParam.equalsIgnoreCase(VIA_SIP_INFO)) {
                    CallPeerSipImpl peer = (CallPeerSipImpl)callPeer;
                    Request info = this.parentProvider.getMessageFactory().createRequest(peer.getDialog(), "INFO");
                    ContentType ct = new ContentType("application", "json");
                    String content = jsonObject.toString();
                    ContentLength cl = new ContentLength(content.length());
                    info.setContentLength((ContentLengthHeader)cl);
                    info.setContent((Object)content.getBytes(), (ContentTypeHeader)ct);
                    ClientTransaction clientTransaction = peer.getJainSipProvider().getNewClientTransaction(info);
                    if (peer.getDialog().getState() == DialogState.TERMINATED) {
                        logger.warn((Object)"Trying to send a request using a TERMINATED dialog.");
                        return;
                    }
                    peer.getDialog().sendRequest(clientTransaction);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Request " + info.toString() + " sent."));
                    }
                    break block6;
                }
                throw new OperationFailedException("Unsupported VIA parameter by protocol!", 11);
            }
            catch (Exception ex) {
                throw new OperationFailedException(ex.getMessage(), 1);
            }
        }
    }

    @Override
    public boolean processRequest(RequestEvent requestEvent) {
        boolean requestHandled = false;
        try {
            Request request = requestEvent.getRequest();
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
            if (contentTypeHeader != null && contentTypeHeader.getContentType().equalsIgnoreCase("application") && contentTypeHeader.getContentSubType().equalsIgnoreCase("json")) {
                ServerTransaction serverTransaction;
                CallSipImpl call;
                requestHandled = true;
                String charset = contentTypeHeader.getParameter("charset");
                if (charset == null) {
                    charset = DEFAULT_MIME_ENCODING;
                }
                String contentString = new String(request.getRawContent(), charset);
                JSONObject receivedJson = (JSONObject)new JSONParser().parse(contentString);
                OperationSetBasicTelephonySipImpl telephony = (OperationSetBasicTelephonySipImpl)this.parentProvider.getOperationSet(OperationSetBasicTelephony.class);
                Dialog dialog = requestEvent.getDialog();
                CallPeerSipImpl callPeer = null;
                Iterator<CallSipImpl> activeCalls = telephony.getActiveCalls();
                while (activeCalls.hasNext() && (callPeer = (call = activeCalls.next()).findCallPeer(dialog)) == null) {
                }
                if (callPeer == null && logger.isTraceEnabled()) {
                    logger.trace((Object)("Could not find call peer for " + request.toString()));
                }
                HashMap<String, Object> params = new HashMap<String, Object>(){
                    {
                        this.put(OperationSetJitsiMeetToolsSipImpl.VIA_PARAMETER, OperationSetJitsiMeetToolsSipImpl.VIA_SIP_INFO);
                    }
                };
                boolean handled = false;
                for (OperationSetJitsiMeetTools.JitsiMeetRequestListener l : this.requestHandlers) {
                    l.onJSONReceived((CallPeer)callPeer, receivedJson, (Map)params);
                    handled = true;
                }
                if (!handled) {
                    logger.warn((Object)"Unhandled onJSONReceived Jitsi Meet Request!");
                }
                if ((serverTransaction = requestEvent.getServerTransaction()) == null && (serverTransaction = SipStackSharing.getOrCreateServerTransaction(requestEvent)) == null) {
                    logger.warn((Object)"No valid server transaction to send response!");
                    return true;
                }
                Response response = this.parentProvider.getMessageFactory().createResponse(200, serverTransaction.getRequest());
                serverTransaction.sendResponse(response);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Response " + response.toString() + " sent."));
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage());
        }
        return requestHandled;
    }
}

