/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.address.Address;
import javax.sip.header.EventHeader;
import javax.sip.message.Request;
import net.java.sip.communicator.impl.protocol.sip.EventPackageSubscriber;
import net.java.sip.communicator.impl.protocol.sip.EventPackageSupport;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorAdapter;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.TimerScheduler;
import net.java.sip.communicator.service.protocol.OperationSetMessageWaiting;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.MessageWaitingEvent;
import net.java.sip.communicator.service.protocol.event.MessageWaitingListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.StringUtils;

public class OperationSetMessageWaitingSipImpl
implements OperationSetMessageWaiting,
RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(OperationSetMessageWaitingSipImpl.class);
    private final ProtocolProviderServiceSipImpl provider;
    private final TimerScheduler timer = new TimerScheduler();
    static final String EVENT_PACKAGE = "message-summary";
    private static final String CONTENT_SUB_TYPE = "simple-message-summary";
    private static final int SUBSCRIPTION_DURATION = 3600;
    private EventPackageSubscriber messageWaitingSubscriber = null;
    private static final int REFRESH_MARGIN = 60;
    private final Map<OperationSetMessageWaiting.MessageType, List<MessageWaitingListener>> messageWaitingNotificationListeners = new HashMap<OperationSetMessageWaiting.MessageType, List<MessageWaitingListener>>();
    private int unreadMessages = 0;
    private int readMessages = 0;
    private int unreadUrgentMessages = 0;
    private int readUrgentMessages = 0;

    OperationSetMessageWaitingSipImpl(ProtocolProviderServiceSipImpl provider) {
        this.provider = provider;
        this.provider.addRegistrationStateChangeListener(this);
        this.provider.registerMethodProcessor("SUBSCRIBE", new MethodProcessorAdapter(){

            @Override
            public boolean processRequest(RequestEvent requestEvent) {
                return OperationSetMessageWaitingSipImpl.this.processRequest(requestEvent);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageWaitingNotificationListener(OperationSetMessageWaiting.MessageType type, MessageWaitingListener listener) {
        Map<OperationSetMessageWaiting.MessageType, List<MessageWaitingListener>> map = this.messageWaitingNotificationListeners;
        synchronized (map) {
            List<MessageWaitingListener> l = this.messageWaitingNotificationListeners.get(type);
            if (l == null) {
                l = new ArrayList<MessageWaitingListener>();
                this.messageWaitingNotificationListeners.put(type, l);
            }
            if (!l.contains(listener)) {
                l.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageWaitingNotificationListener(OperationSetMessageWaiting.MessageType type, MessageWaitingListener listener) {
        Map<OperationSetMessageWaiting.MessageType, List<MessageWaitingListener>> map = this.messageWaitingNotificationListeners;
        synchronized (map) {
            List<MessageWaitingListener> l = this.messageWaitingNotificationListeners.get(type);
            if (l != null) {
                l.remove(listener);
            }
        }
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
            Address subscribeAddress = null;
            try {
                subscribeAddress = this.getSubscribeAddress();
                if (subscribeAddress == null) {
                    return;
                }
            }
            catch (ParseException e) {
                logger.error((Object)"Failed to parse mailbox subscribe address.", (Throwable)e);
            }
            final MessageSummarySubscriber defaultSubscriber = new MessageSummarySubscriber(subscribeAddress);
            this.messageWaitingSubscriber = new EventPackageSubscriber(this.provider, EVENT_PACKAGE, 3600, CONTENT_SUB_TYPE, this.timer, 60){

                @Override
                protected EventPackageSubscriber.Subscription getSubscription(String callId) {
                    EventPackageSupport.Subscription[] subs;
                    EventPackageSubscriber.Subscription resultSub = super.getSubscription(callId);
                    if (resultSub != null) {
                        return resultSub;
                    }
                    for (EventPackageSupport.Subscription s : subs = this.getSubscriptions()) {
                        if (!(s instanceof MessageSummarySubscriber)) continue;
                        return (MessageSummarySubscriber)s;
                    }
                    return defaultSubscriber;
                }
            };
            if (subscribeAddress != null) {
                try {
                    this.messageWaitingSubscriber.subscribe(defaultSubscriber);
                }
                catch (Throwable e) {
                    logger.error((Object)"Error subscribing for mailbox", e);
                }
            }
        } else if (evt.getNewState().equals((Object)RegistrationState.UNREGISTERING) && this.messageWaitingSubscriber != null) {
            try {
                this.messageWaitingSubscriber.unsubscribe(this.getSubscribeAddress(), false);
            }
            catch (Throwable t) {
                logger.error((Object)"Error unsubscribing mailbox", t);
            }
        }
    }

    private Address getSubscribeAddress() throws ParseException {
        String vmAddressURI = this.provider.getAccountID().getAccountPropertyString((Object)"VOICEMAIL_URI");
        if (StringUtils.isEmpty((CharSequence)vmAddressURI)) {
            return this.provider.getRegistrarConnection().getAddressOfRecord();
        }
        return this.provider.parseAddressString(vmAddressURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVoicemailNotificationEvent(String msgTypeStr, String account, int unreadMessages, int readMessages, int unreadUrgentMessages, int readUrgentMessages) {
        ArrayList<MessageWaitingListener> listeners;
        OperationSetMessageWaitingSipImpl operationSetMessageWaitingSipImpl = this;
        synchronized (operationSetMessageWaitingSipImpl) {
            if (this.unreadMessages == unreadMessages && this.readMessages == readMessages && this.unreadUrgentMessages == unreadUrgentMessages && this.readUrgentMessages == readUrgentMessages) {
                return;
            }
            this.unreadMessages = unreadMessages;
            this.readMessages = readMessages;
            this.unreadUrgentMessages = unreadUrgentMessages;
            this.readUrgentMessages = readUrgentMessages;
        }
        OperationSetMessageWaiting.MessageType msgType = OperationSetMessageWaiting.MessageType.valueOfByType((String)msgTypeStr);
        MessageWaitingEvent event = new MessageWaitingEvent((ProtocolProviderService)this.provider, msgType, account, unreadMessages, readMessages, unreadUrgentMessages, readUrgentMessages);
        Map<OperationSetMessageWaiting.MessageType, List<MessageWaitingListener>> map = this.messageWaitingNotificationListeners;
        synchronized (map) {
            List<MessageWaitingListener> ls = this.messageWaitingNotificationListeners.get(msgType);
            if (ls == null) {
                return;
            }
            listeners = new ArrayList<MessageWaitingListener>(ls);
        }
        for (MessageWaitingListener listener : listeners) {
            listener.messageWaitingNotify(event);
        }
    }

    private boolean processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        EventHeader eventHeader = (EventHeader)request.getHeader("Event");
        if (eventHeader == null) {
            return false;
        }
        String eventType = eventHeader.getEventType();
        if (!EVENT_PACKAGE.equalsIgnoreCase(eventType)) {
            return false;
        }
        boolean processed = false;
        if ("SUBSCRIBE".equals(request.getMethod())) {
            processed = EventPackageSupport.sendNotImplementedResponse(this.provider, requestEvent);
        }
        return processed;
    }

    void shutdown() {
        this.provider.removeRegistrationStateChangeListener(this);
    }

    private class MessageSummarySubscriber
    extends EventPackageSubscriber.Subscription {
        private Pattern messageWaitingCountPattern;

        public MessageSummarySubscriber(Address toAddress) {
            super(toAddress);
            this.messageWaitingCountPattern = Pattern.compile("(\\d+)/(\\d+)( \\((\\d+)/(\\d+)\\))*");
        }

        @Override
        protected void processActiveRequest(RequestEvent requestEvent, byte[] rawContent) {
            if (rawContent == null || rawContent.length <= 0) {
                return;
            }
            try {
                String line;
                String messageAccount = OperationSetMessageWaitingSipImpl.this.provider.getAccountID().getAccountPropertyString((Object)"VOICEMAIL_CHECK_URI");
                BufferedReader input = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(rawContent)));
                boolean messageWaiting = false;
                boolean eventFired = false;
                while ((line = input.readLine()) != null) {
                    String lcaseLine = line.toLowerCase();
                    if (lcaseLine.startsWith("messages-waiting")) {
                        String messageWaitingStr = line.substring(line.indexOf(":") + 1).trim();
                        if (!messageWaitingStr.equalsIgnoreCase("yes")) continue;
                        messageWaiting = true;
                        continue;
                    }
                    if (lcaseLine.startsWith("message-account")) {
                        messageAccount = line.substring(line.indexOf(":") + 1).trim();
                        continue;
                    }
                    if (!lcaseLine.startsWith(OperationSetMessageWaiting.MessageType.VOICE.toString()) && !lcaseLine.startsWith(OperationSetMessageWaiting.MessageType.FAX.toString()) && !lcaseLine.startsWith(OperationSetMessageWaiting.MessageType.MULTIMEDIA.toString()) && !lcaseLine.startsWith(OperationSetMessageWaiting.MessageType.PAGER.toString()) && !lcaseLine.startsWith(OperationSetMessageWaiting.MessageType.TEXT.toString()) && !lcaseLine.startsWith(OperationSetMessageWaiting.MessageType.NONE.toString())) continue;
                    String msgType = lcaseLine.substring(0, line.indexOf(":")).trim();
                    String messagesCountValue = line.substring(line.indexOf(":") + 1).trim();
                    Matcher matcher = this.messageWaitingCountPattern.matcher(messagesCountValue);
                    if (!matcher.find()) continue;
                    String newM = matcher.group(1);
                    String oldM = matcher.group(2);
                    String urgentNew = matcher.group(4);
                    String urgentOld = matcher.group(5);
                    OperationSetMessageWaitingSipImpl.this.fireVoicemailNotificationEvent(msgType, messageAccount, Integer.valueOf(newM), Integer.valueOf(oldM), urgentNew == null ? 0 : Integer.valueOf(urgentNew), urgentOld == null ? 0 : Integer.valueOf(urgentOld));
                    eventFired = true;
                }
                if (messageWaiting && !eventFired) {
                    OperationSetMessageWaitingSipImpl.this.fireVoicemailNotificationEvent(OperationSetMessageWaiting.MessageType.VOICE.toString(), messageAccount, 1, 0, 0, 0);
                }
            }
            catch (IOException ex) {
                logger.error((Object)"Error processing message waiting info");
            }
        }

        @Override
        protected void processFailureResponse(ResponseEvent responseEvent, int statusCode) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing failed: " + statusCode));
            }
        }

        @Override
        protected void processSuccessResponse(ResponseEvent responseEvent, int statusCode) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cannot subscripe to presence watcher info!");
            }
        }

        @Override
        protected void processTerminatedRequest(RequestEvent requestEvent, String reasonCode) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing terminated: " + reasonCode));
            }
        }
    }
}

