/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.message.SIPMessage;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLHandshakeException;
import javax.sip.ClientTransaction;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.AllowHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.MinExpiresHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorAdapter;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.SipApplicationData;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.util.Logger;

public class SipRegistrarConnection
extends MethodProcessorAdapter {
    private static final Logger logger = Logger.getLogger(SipRegistrarConnection.class);
    private ProtocolProviderServiceSipImpl sipProvider = null;
    private SipURI registrarURI = null;
    private String registrarName = null;
    private static final String REGISTRATION_EXPIRATION = "net.java.sip.communicator.impl.protocol.sip.REGISTRATION_EXPIRATION";
    private static final int DEFAULT_REGISTRATION_EXPIRATION = 600;
    private int registrationsExpiration = 600;
    private RegistrationState currentRegistrationState = RegistrationState.UNREGISTERED;
    private Timer reRegisterTimer = new Timer();
    private Request registerRequest = null;
    private long nextCSeqValue = 1L;
    ClientTransaction regTrans = null;
    private static final String KEEP_ALIVE_METHOD = "KEEP_ALIVE_METHOD";
    private static final String KEEP_ALIVE_INTERVAL = "KEEP_ALIVE_INTERVAL";
    private static final int KEEP_ALIVE_INTERVAL_DEFAULT_VALUE = 25;
    private static final String FORCE_MESSAGING_PROP = "FORCE_MESSAGING";
    private boolean useRouteHeader = false;
    private Address ourSipAddressOfRecord = null;
    private CallIdHeader callIdHeader = null;
    private String registrationTransport = null;
    private int registrarPort = -1;
    private InetAddress lastRegisterAddressReceived = null;
    private int lastRegisterPortReceived = -1;

    public SipRegistrarConnection(String registrarName, int registrarPort, String registrationTransport, ProtocolProviderServiceSipImpl sipProviderCallback) {
        this.registrarPort = registrarPort;
        this.registrationTransport = registrationTransport;
        this.registrarName = registrarName;
        this.sipProvider = sipProviderCallback;
        this.registrationsExpiration = SipActivator.getConfigurationService().getInt(REGISTRATION_EXPIRATION, 600);
        this.getAddressOfRecord();
        sipProviderCallback.registerMethodProcessor("REGISTER", this);
    }

    protected SipRegistrarConnection() {
    }

    void setTransport(String newRegistrationTransport) {
        if (newRegistrationTransport.equals(this.registrationTransport)) {
            return;
        }
        this.registrationTransport = newRegistrationTransport;
        if (!this.registrationTransport.equals("UDP")) {
            this.registrarURI = null;
        }
    }

    void register() throws OperationFailedException {
        Request request;
        if (this.getRegistrationState() != RegistrationState.REGISTERED) {
            this.setRegistrationState(RegistrationState.REGISTERING, -1, null);
        }
        try {
            if (this.callIdHeader == null) {
                this.callIdHeader = this.getJainSipProvider().getNewCallId();
            }
            request = this.sipProvider.getMessageFactory().createRegisterRequest(this.getAddressOfRecord(), this.registrationsExpiration, this.callIdHeader, this.getNextCSeqValue());
        }
        catch (Exception exc) {
            if (exc.getCause() instanceof SocketException || exc.getCause() instanceof IOException || exc.getCause() instanceof SSLHandshakeException) {
                if (exc.getCause().getCause() instanceof CertificateException || exc.getCause().getMessage().startsWith("Received fatal alert")) {
                    this.setRegistrationState(RegistrationState.UNREGISTERED, 0, exc.getMessage());
                    return;
                }
                if (this.sipProvider.registerUsingNextAddress()) {
                    return;
                }
            }
            logger.error((Object)"Failed to create a Register request.", (Throwable)exc);
            this.setRegistrationState(RegistrationState.CONNECTION_FAILED, 6, exc.getMessage());
            if (exc instanceof OperationFailedException) {
                throw (OperationFailedException)((Object)exc);
            }
            throw new OperationFailedException("Failed to generate a from header for our register request.", 4, (Throwable)exc);
        }
        try {
            this.regTrans = this.getJainSipProvider().getNewClientTransaction(request);
        }
        catch (TransactionUnavailableException ex) {
            logger.error((Object)"Could not create a register transaction!\nCheck that the Registrar address is correct!", (Throwable)ex);
            this.setRegistrationState(RegistrationState.CONNECTION_FAILED, 6, ex.getMessage());
            throw new OperationFailedException("Could not create a register transaction!\nCheck that the Registrar address is correct!", 2, (Throwable)ex);
        }
        try {
            this.regTrans.sendRequest();
        }
        catch (Exception ex) {
            if ((ex.getCause() instanceof SocketException || ex.getCause() instanceof IOException) && this.sipProvider.registerUsingNextAddress()) {
                return;
            }
            logger.error((Object)"Could not send out the register request!", (Throwable)ex);
            this.setRegistrationState(RegistrationState.CONNECTION_FAILED, 6, ex.getMessage());
            throw new OperationFailedException("Could not send out the register request!", 2, (Throwable)ex);
        }
        this.registerRequest = request;
    }

    public void processOK(ClientTransaction clientTransatcion, Response response) {
        FromHeader fromHeader;
        ExpiresHeader expiresHeader;
        int requestedExpiration = 0;
        Request register = clientTransatcion.getRequest();
        ContactHeader contactHeader = (ContactHeader)register.getHeader("Contact");
        requestedExpiration = contactHeader != null ? contactHeader.getExpires() : 0;
        if (requestedExpiration <= 0 && (expiresHeader = register.getExpires()) != null) {
            requestedExpiration = expiresHeader.getExpires();
        }
        if ((fromHeader = (FromHeader)register.getHeader("From")) != null && fromHeader.getAddress() != null && this.sipProvider.setOurDisplayName(fromHeader.getAddress().getDisplayName())) {
            this.ourSipAddressOfRecord = null;
        }
        int grantedExpiration = -1;
        ContactHeader responseContactHdr = (ContactHeader)response.getHeader("Contact");
        if (responseContactHdr != null) {
            grantedExpiration = responseContactHdr.getExpires();
        }
        if (grantedExpiration < 0) {
            ExpiresHeader expiresHeader2 = response.getExpires();
            grantedExpiration = expiresHeader2 != null ? expiresHeader2.getExpires() : requestedExpiration;
        }
        if (grantedExpiration <= 0 || requestedExpiration <= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Account " + this.sipProvider.getAccountID().getDisplayName() + " unregistered!"));
            }
            Boolean userRequest = (Boolean)SipApplicationData.getApplicationData(register, "userRequest");
            boolean userRequestBool = false;
            if (userRequest != null && userRequest.booleanValue()) {
                userRequestBool = true;
            }
            this.setRegistrationState(RegistrationState.UNREGISTERED, 0, "Registration terminated.", userRequestBool);
        } else {
            int registrationInterval;
            int scheduleTime = grantedExpiration;
            String keepAliveMethod = this.sipProvider.getAccountID().getAccountPropertyString((Object)KEEP_ALIVE_METHOD);
            if (keepAliveMethod != null && keepAliveMethod.equalsIgnoreCase("register") && (registrationInterval = this.sipProvider.getAccountID().getAccountPropertyInt((Object)KEEP_ALIVE_INTERVAL, 25)) < grantedExpiration) {
                scheduleTime = registrationInterval;
            }
            this.lastRegisterAddressReceived = ((SIPMessage)response).getRemoteAddress();
            this.lastRegisterPortReceived = ((SIPMessage)response).getRemotePort();
            this.scheduleReRegistration(scheduleTime);
            ListIterator headerIter = response.getHeaders("Allow");
            if (headerIter != null && headerIter.hasNext()) {
                this.updateSupportedOperationSets(headerIter);
            }
            if (logger.isDebugEnabled() && this.getRegistrationState().equals((Object)RegistrationState.REGISTERING)) {
                logger.debug((Object)("Account " + this.sipProvider.getAccountID().getDisplayName() + " registered!"));
            }
            this.setRegistrationState(RegistrationState.REGISTERED, -1, null);
        }
    }

    public boolean isRequestFromSameConnection(Request request) {
        SIPMessage msg = (SIPMessage)request;
        return msg.getRemoteAddress() == null || this.lastRegisterAddressReceived == null || msg.getRemoteAddress().equals(this.lastRegisterAddressReceived) && msg.getRemotePort() == this.lastRegisterPortReceived;
    }

    public void unregister() throws OperationFailedException {
        this.unregisterInternal(true, false);
    }

    public void unregister(boolean userRequest) throws OperationFailedException {
        this.unregisterInternal(true, userRequest);
    }

    private void unregisterInternal(boolean sendUnregister, boolean userRequest) throws OperationFailedException {
        Request unregisterRequest;
        if (this.getRegistrationState() == RegistrationState.UNREGISTERED) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Trying to unregister when already unresgistered");
            }
            return;
        }
        this.cancelPendingRegistrations();
        if (this.registerRequest == null) {
            logger.error((Object)"Couldn't find the initial register request");
            this.setRegistrationState(RegistrationState.CONNECTION_FAILED, 6, "Could not find the initial regiest request.");
            throw new OperationFailedException("Could not find the initial register request.", 4);
        }
        this.setRegistrationState(RegistrationState.UNREGISTERING, 0, "");
        if (!sendUnregister) {
            return;
        }
        try {
            unregisterRequest = this.sipProvider.getMessageFactory().createUnRegisterRequest(this.registerRequest, this.getNextCSeqValue());
        }
        catch (InvalidArgumentException ex) {
            logger.error((Object)"Unable to create an unREGISTER request.", (Throwable)ex);
            this.setRegistrationState(RegistrationState.CONNECTION_FAILED, 6, "Unable to set Expires Header");
            throw new OperationFailedException("Unable to set Expires Header", 4, (Throwable)ex);
        }
        if (userRequest) {
            SipApplicationData.setApplicationData(unregisterRequest, "userRequest", userRequest);
        }
        ClientTransaction unregisterTransaction = null;
        try {
            unregisterTransaction = this.getJainSipProvider().getNewClientTransaction(unregisterRequest);
        }
        catch (TransactionUnavailableException ex) {
            logger.error((Object)"Unable to create a unregister transaction", (Throwable)ex);
            this.setRegistrationState(RegistrationState.CONNECTION_FAILED, 6, "Unable to create a unregister transaction");
            throw new OperationFailedException("Unable to create a unregister transaction", 4, (Throwable)ex);
        }
        try {
            this.callIdHeader = null;
            unregisterTransaction.sendRequest();
            if (!this.getRegistrationState().equals((Object)RegistrationState.REGISTERED) && !this.getRegistrationState().equals((Object)RegistrationState.UNREGISTERING)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Setting state to UNREGISTERED.");
                }
                this.setRegistrationState(RegistrationState.UNREGISTERED, 0, null);
                if (this.regTrans != null && this.regTrans.getState().getValue() <= TransactionState.PROCEEDING.getValue()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Will try to terminate reg tran ...");
                    }
                    this.regTrans.terminate();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Transaction terminated!");
                    }
                }
            }
        }
        catch (SipException ex) {
            logger.error((Object)"Failed to send unregister request", (Throwable)ex);
            this.setRegistrationState(RegistrationState.CONNECTION_FAILED, 6, "Unable to create a unregister transaction");
            throw new OperationFailedException("Failed to send unregister request", 4, (Throwable)ex);
        }
    }

    public RegistrationState getRegistrationState() {
        return this.currentRegistrationState;
    }

    public void setRegistrationState(RegistrationState newState, int reasonCode, String reason) {
        this.setRegistrationState(newState, reasonCode, reason, false);
    }

    public void setRegistrationState(RegistrationState newState, int reasonCode, String reason, boolean userRequest) {
        if (this.currentRegistrationState.equals((Object)newState)) {
            return;
        }
        RegistrationState oldState = this.currentRegistrationState;
        this.currentRegistrationState = newState;
        this.sipProvider.fireRegistrationStateChanged(oldState, newState, reasonCode, reason, userRequest);
    }

    private void cancelPendingRegistrations() {
        this.reRegisterTimer.cancel();
        this.reRegisterTimer = null;
        this.reRegisterTimer = new Timer();
    }

    private void scheduleReRegistration(int expires) {
        ReRegisterTask reRegisterTask = new ReRegisterTask();
        this.reRegisterTimer.schedule((TimerTask)reRegisterTask, expires * 900);
    }

    private long getNextCSeqValue() {
        return this.nextCSeqValue++;
    }

    public void processNotImplemented(ClientTransaction transatcion, Response response) {
        this.setRegistrationState(RegistrationState.CONNECTION_FAILED, -1, this.registrarName + " does not appear to be a sip registrar. (Returned a NOT_IMPLEMENTED response to a register request)");
    }

    private void updateSupportedOperationSets(ListIterator<AllowHeader> headerIter) {
        HashSet<String> set = new HashSet<String>();
        while (headerIter.hasNext()) {
            set.add(headerIter.next().getMethod());
        }
        if (!set.contains("MESSAGE") && !this.sipProvider.getAccountID().getAccountPropertyBoolean((Object)FORCE_MESSAGING_PROP, false)) {
            this.sipProvider.removeSupportedOperationSet(OperationSetBasicInstantMessaging.class);
        }
    }

    public SipProvider getJainSipProvider() {
        return this.sipProvider.getJainSipProvider(this.getTransport());
    }

    public String getTransport() {
        return this.registrationTransport;
    }

    @Override
    public boolean processResponse(ResponseEvent responseEvent) {
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        Response response = responseEvent.getResponse();
        SipProvider sourceProvider = (SipProvider)responseEvent.getSource();
        boolean processed = false;
        if (response.getStatusCode() == 200) {
            this.processOK(clientTransaction, response);
            processed = true;
        } else if (response.getStatusCode() == 501) {
            this.processNotImplemented(clientTransaction, response);
            processed = true;
        } else if (response.getStatusCode() != 100) {
            if (response.getStatusCode() == 401 || response.getStatusCode() == 407 || response.getStatusCode() == 403) {
                this.processAuthenticationChallenge(clientTransaction, response, sourceProvider);
                processed = true;
            } else if (response.getStatusCode() == 423) {
                this.processIntervalTooBrief(response);
                processed = true;
            } else if (response.getStatusCode() >= 400) {
                logger.error((Object)("Received an error response (" + response.getStatusCode() + ")"));
                int registrationStateReason = -1;
                if (response.getStatusCode() == 404) {
                    registrationStateReason = 3;
                }
                this.setRegistrationState(RegistrationState.CONNECTION_FAILED, registrationStateReason, "Received an error while trying to register. Server returned error:" + response.getReasonPhrase());
                processed = true;
            }
        }
        return processed;
    }

    private void processAuthenticationChallenge(ClientTransaction clientTransaction, Response response, SipProvider jainSipProvider) {
        try {
            ClientTransaction retryTran;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authenticating a Register request.");
            }
            if (response.getStatusCode() == 401 || response.getStatusCode() == 407) {
                retryTran = this.sipProvider.getSipSecurityManager().handleChallenge(response, clientTransaction, jainSipProvider);
            } else {
                String certId = this.sipProvider.getAccountID().getAccountPropertyString((Object)"CLIENT_TLS_CERTIFICATE");
                if (certId != null) {
                    this.setRegistrationState(RegistrationState.AUTHENTICATION_FAILED, 3, "We failed to authenticate with the server.");
                    return;
                }
                retryTran = this.sipProvider.getSipSecurityManager().handleForbiddenResponse(response, clientTransaction, jainSipProvider);
            }
            if (retryTran == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"No password supplied or error occured!");
                }
                this.unregister(false);
                return;
            }
            this.updateRegisterSequenceNumber(retryTran);
            retryTran.sendRequest();
            return;
        }
        catch (OperationFailedException exc) {
            if (exc.getErrorCode() == 15) {
                this.setRegistrationState(RegistrationState.UNREGISTERED, 0, "User has canceled the authentication process.");
            } else if (exc.getErrorCode() == 403) {
                this.setRegistrationState(RegistrationState.CONNECTION_FAILED, 1, exc.getMessage());
            } else {
                this.setRegistrationState(RegistrationState.AUTHENTICATION_FAILED, 1, "We failed to authenticate with the server.");
            }
        }
        catch (Exception exc) {
            logger.error((Object)"We failed to authenticate a Register request.", (Throwable)exc);
            this.setRegistrationState(RegistrationState.AUTHENTICATION_FAILED, 1, "We failed to authenticate with the server.");
        }
    }

    @Override
    public boolean processRequest(RequestEvent requestEvent) {
        return false;
    }

    @Override
    public boolean processTimeout(TimeoutEvent timeoutEvent) {
        if (this.sipProvider.registerUsingNextAddress()) {
            return false;
        }
        if (!this.getRegistrationState().equals((Object)RegistrationState.UNREGISTERED)) {
            this.setRegistrationState(RegistrationState.CONNECTION_FAILED, -1, "A timeout occurred while trying to connect to the server.");
        }
        return true;
    }

    @Override
    public boolean processIOException(IOExceptionEvent exceptionEvent) {
        this.setRegistrationState(RegistrationState.CONNECTION_FAILED, -1, "An error occurred while trying to connect to the server.[" + exceptionEvent.getHost() + "]:" + exceptionEvent.getPort() + "/" + exceptionEvent.getTransport());
        return true;
    }

    private void processIntervalTooBrief(Response response) {
        int expires;
        MinExpiresHeader header = (MinExpiresHeader)response.getHeader("Min-Expires");
        if (header != null && (expires = header.getExpires()) > this.registrationsExpiration) {
            this.registrationsExpiration = expires;
            try {
                this.register();
                return;
            }
            catch (Throwable e) {
                logger.error((Object)"Cannot send register!", e);
                this.setRegistrationState(RegistrationState.CONNECTION_FAILED, -1, "A timeout occurred while trying to connect to the server.");
                return;
            }
        }
        this.setRegistrationState(RegistrationState.CONNECTION_FAILED, -1, "Received an error while trying to register. Server returned error:" + response.getReasonPhrase());
    }

    public String toString() {
        String className = this.getClass().getName();
        try {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return className + "-[dn=" + this.sipProvider.getOurDisplayName() + " addr=" + this.getAddressOfRecord() + "]";
    }

    private void updateRegisterSequenceNumber(ClientTransaction lastClientTran) {
        Request req = lastClientTran.getRequest();
        CSeqHeader cSeqHeader = (CSeqHeader)req.getHeader("CSeq");
        long sequenceNumber = cSeqHeader.getSeqNumber();
        this.nextCSeqValue = sequenceNumber + 1L;
    }

    public boolean isRouteHeaderEnabled() {
        return this.useRouteHeader;
    }

    public boolean isRegistrarless() {
        return false;
    }

    public SipURI getRegistrarURI() throws ParseException {
        if (this.registrarURI == null) {
            this.registrarURI = this.sipProvider.getAddressFactory().createSipURI(null, this.registrarName);
            if (this.registrarPort != 5060) {
                this.registrarURI.setPort(this.registrarPort);
            }
            if (!this.registrationTransport.equals("UDP") && !this.registrationTransport.equals("TLS")) {
                this.registrarURI.setTransportParam(this.registrationTransport);
            }
        }
        return this.registrarURI;
    }

    public Address getAddressOfRecord() {
        if (this.ourSipAddressOfRecord != null) {
            return this.ourSipAddressOfRecord;
        }
        if (this.isRegistrarless()) {
            return null;
        }
        String ourUserID = this.sipProvider.getAccountID().getAccountPropertyString((Object)"USER_ID");
        String sipUriHost = null;
        if (ourUserID.indexOf("@") != -1 && ourUserID.indexOf("@") < ourUserID.length() - 1) {
            sipUriHost = ourUserID.substring(ourUserID.indexOf("@") + 1);
            ourUserID = ourUserID.substring(0, ourUserID.indexOf("@"));
        }
        if (sipUriHost == null) {
            sipUriHost = this.registrarName;
        }
        try {
            SipURI ourSipURI = this.sipProvider.getAddressFactory().createSipURI(ourUserID, sipUriHost);
            this.ourSipAddressOfRecord = this.sipProvider.getAddressFactory().createAddress(this.sipProvider.getOurDisplayName(), (URI)ourSipURI);
            this.ourSipAddressOfRecord.setDisplayName(this.sipProvider.getOurDisplayName());
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Could not create a SIP URI for user " + ourUserID + "@" + sipUriHost + " and registrar " + this.registrarName);
        }
        return this.ourSipAddressOfRecord;
    }

    private class ReRegisterTask
    extends TimerTask {
        @Override
        public void run() {
            try {
                if (SipRegistrarConnection.this.getRegistrationState() == RegistrationState.REGISTERED) {
                    SipRegistrarConnection.this.register();
                }
            }
            catch (OperationFailedException ex) {
                logger.error((Object)"Failed to reRegister", (Throwable)ex);
                SipRegistrarConnection.this.setRegistrationState(RegistrationState.CONNECTION_FAILED, 6, "Failed to re register with the SIP server.");
            }
        }
    }
}

