/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.net.AndroidNetworkLayer;
import net.java.sip.communicator.impl.protocol.sip.net.SslNetworkLayer;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.util.OSUtils;

public class SipStackProperties
extends Properties {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(SipStackProperties.class);
    private static final String NSPNAME_DEBUG_LOG = "gov.nist.javax.sip.DEBUG_LOG";
    private static String NSPVALUE_DEBUG_LOG = "log/sc-jainsipdebug.log";
    private static final String NSPNAME_LOG_MESSAGE_CONTENT = "gov.nist.javax.sip.LOG_MESSAGE_CONTENT";
    private static final String NSPVALUE_LOG_MESSAGE_CONTENT = "true";
    private static final String NSPNAME_STACK_LOGGER = "gov.nist.javax.sip.STACK_LOGGER";
    private static final String NSPVALUE_STACK_LOGGER = "net.java.sip.communicator.impl.protocol.sip.SipLogger";
    private static final String NSPNAME_SERVER_LOGGER = "gov.nist.javax.sip.SERVER_LOGGER";
    private static final String NSPVALUE_SERVER_LOGGER = "net.java.sip.communicator.impl.protocol.sip.SipLogger";
    private static final String NSPNAME_DEBUG_LOG_OVERWRITE = "gov.nist.javax.sip.DEBUG_LOG_OVERWRITE";
    private static final String NSPVALUE_DEBUG_LOG_OVERWRITE = "true";
    private static final String NSPNAME_SERVER_LOG_OVERWRITE = "gov.nist.javax.sip.SERVER_LOG_OVERWRITE";
    private static final String NSPVALUE_SERVER_LOG_OVERWRITE = "true";
    private static final String NSPNAME_CACHE_CLIENT_CONNECTIONS = "gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS";
    private static final String NSPVALUE_CACHE_CLIENT_CONNECTIONS = "true";
    private static final String NSPNAME_REENTRANT_LISTENER = "gov.nist.javax.sip.REENTRANT_LISTENER";
    private static final String NSPVALUE_REENTRANT_LISTENER = "true";
    private static final String NSPNAME_TRACE_LEVEL = "gov.nist.javax.sip.TRACE_LEVEL";
    private static final String NSPVALUE_DEFAULT_TRACE_LEVEL = "ERROR";
    private static final String NSPNAME_DELIVER_UNSOLICITED_NOTIFY = "gov.nist.javax.sip.DELIVER_UNSOLICITED_NOTIFY";
    private static final String NSPVALUE_DELIVER_UNSOLICITED_NOTIFY = "true";
    private static final String NSPNAME_USE_ROUTER_FOR_ALL_URIS = "javax.sip.USE_ROUTER_FOR_ALL_URIS";
    private static final String NSPVALUE_USE_ROUTER_FOR_ALL_URIS = "true";
    private static final String NSPNAME_ROUTER_PATH = "javax.sip.ROUTER_PATH";
    private static final String NSPVALUE_ROUTER_PATH = "net.java.sip.communicator.impl.protocol.sip.ProxyRouter";
    private static final String JSPNAME_STACK_NAME = "javax.sip.STACK_NAME";
    private static final String NSPNAME_TLS_CLIENT_PROTOCOLS = "gov.nist.javax.sip.TLS_CLIENT_PROTOCOLS";

    public SipStackProperties() {
        String logDir = SipActivator.getConfigurationService().getScHomeDirLocation() + System.getProperty("file.separator") + SipActivator.getConfigurationService().getScHomeDirName() + System.getProperty("file.separator");
        if (!NSPVALUE_DEBUG_LOG.startsWith(logDir)) {
            NSPVALUE_DEBUG_LOG = logDir + NSPVALUE_DEBUG_LOG;
        }
        this.setProperty(JSPNAME_STACK_NAME, "Sip Communicator");
        this.setProperty(NSPNAME_DEBUG_LOG, NSPVALUE_DEBUG_LOG);
        this.setProperty(NSPNAME_LOG_MESSAGE_CONTENT, "true");
        this.setProperty(NSPNAME_DEBUG_LOG_OVERWRITE, "true");
        this.setProperty(NSPNAME_SERVER_LOG_OVERWRITE, "true");
        this.setProperty(NSPNAME_CACHE_CLIENT_CONNECTIONS, "true");
        this.setProperty(NSPNAME_REENTRANT_LISTENER, "true");
        this.setProperty(NSPNAME_DELIVER_UNSOLICITED_NOTIFY, "true");
        this.setProperty(NSPNAME_USE_ROUTER_FOR_ALL_URIS, "true");
        this.setProperty(NSPNAME_ROUTER_PATH, NSPVALUE_ROUTER_PATH);
        System.setProperty("gov.nist.core.STRIP_ADDR_SCOPES", "true");
        String logLevel = LogManager.getLogManager().getProperty("gov.nist.level");
        String jainSipTraceLevel = null;
        jainSipTraceLevel = logLevel == null ? NSPVALUE_DEFAULT_TRACE_LEVEL : (logLevel.equals(Level.FINEST.getName()) ? "TRACE" : (logLevel.equals(Level.FINER.getName()) ? "DEBUG" : (logLevel.equals(Level.FINE.getName()) ? "INFO" : (logLevel.equals(Level.WARNING.getName()) || logLevel.equals(Level.SEVERE.getName()) ? NSPVALUE_DEFAULT_TRACE_LEVEL : (logLevel.equals(Level.OFF.getName()) ? "OFF" : logLevel)))));
        this.setProperty(NSPNAME_TRACE_LEVEL, jainSipTraceLevel);
        this.setProperty(NSPNAME_STACK_LOGGER, "net.java.sip.communicator.impl.protocol.sip.SipLogger");
        this.setProperty(NSPNAME_SERVER_LOGGER, "net.java.sip.communicator.impl.protocol.sip.SipLogger");
        if (OSUtils.IS_ANDROID) {
            this.setProperty("gov.nist.javax.sip.NETWORK_LAYER", AndroidNetworkLayer.class.getName());
        } else {
            this.setProperty("gov.nist.javax.sip.NETWORK_LAYER", SslNetworkLayer.class.getName());
        }
        try {
            String enabledSslProtocols = SipActivator.getConfigurationService().getString(NSPNAME_TLS_CLIENT_PROTOCOLS);
            if (StringUtils.isBlank((CharSequence)enabledSslProtocols)) {
                SSLSocket temp = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
                String[] enabledDefaultProtocols = temp.getEnabledProtocols();
                enabledSslProtocols = "";
                for (int i = 0; i < enabledDefaultProtocols.length; ++i) {
                    enabledSslProtocols = enabledSslProtocols + enabledDefaultProtocols[i];
                    if (i >= enabledDefaultProtocols.length - 1) continue;
                    enabledSslProtocols = enabledSslProtocols + ",";
                }
            }
            this.setProperty(NSPNAME_TLS_CLIENT_PROTOCOLS, enabledSslProtocols);
        }
        catch (IOException ex) {
            logger.error((Object)"Unable to obtain default SSL protocols from Java, using JSIP defaults.", (Throwable)ex);
        }
    }
}

