/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderFactorySipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.service.argdelegation.UriHandler;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.AccountManagerEvent;
import net.java.sip.communicator.service.protocol.event.AccountManagerListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class UriHandlerSipImpl
implements UriHandler,
ServiceListener,
AccountManagerListener {
    public static final String INITIAL_REGISTRATION_TIMEOUT_PROP = "net.java.sip.communicator.impl.protocol.sip.call.INITIAL_REGISTRATION_TIMEOUT";
    public static final long DEFAULT_INITIAL_REGISTRATION_TIMEOUT = 5000L;
    private static final Logger logger = Logger.getLogger(UriHandlerSipImpl.class);
    private final ProtocolProviderFactory protoFactory;
    private ServiceRegistration ourServiceRegistration = null;
    private final Object registrationLock = new Object();
    private AccountManager accountManager;
    private final boolean[] storedAccountsAreLoaded = new boolean[1];
    private List<String> uris;

    public UriHandlerSipImpl(ProtocolProviderFactorySipImpl protoFactory) throws NullPointerException {
        if (protoFactory == null) {
            throw new NullPointerException("The ProtocolProviderFactory that a UriHandler is created with  cannot be null.");
        }
        this.protoFactory = protoFactory;
        this.hookStoredAccounts();
        this.protoFactory.getBundleContext().addServiceListener((ServiceListener)this);
        this.registerHandlerService();
    }

    public void dispose() {
        this.protoFactory.getBundleContext().removeServiceListener((ServiceListener)this);
        this.unregisterHandlerService();
        this.unhookStoredAccounts();
    }

    private void hookStoredAccounts() {
        if (this.accountManager == null) {
            BundleContext bundleContext = this.protoFactory.getBundleContext();
            this.accountManager = (AccountManager)bundleContext.getService(bundleContext.getServiceReference(AccountManager.class.getName()));
            this.accountManager.addListener((AccountManagerListener)this);
        }
    }

    private void unhookStoredAccounts() {
        if (this.accountManager != null) {
            this.accountManager.removeListener((AccountManagerListener)this);
            this.accountManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleAccountManagerEvent(AccountManagerEvent event) {
        if (1 != event.getType() || this.protoFactory != event.getFactory()) return;
        List<String> uris = null;
        boolean[] blArray = this.storedAccountsAreLoaded;
        synchronized (this.storedAccountsAreLoaded) {
            this.storedAccountsAreLoaded[0] = true;
            if (this.uris != null) {
                uris = this.uris;
                this.uris = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.unhookStoredAccounts();
            if (uris == null) return;
            Iterator<String> uriIter = uris.iterator();
            while (uriIter.hasNext()) {
                this.handleUri(uriIter.next());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandlerService() {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.ourServiceRegistration != null) {
                return;
            }
            Hashtable<String, String> registrationProperties = new Hashtable<String, String>();
            for (String protocol : this.getProtocol()) {
                registrationProperties.put("ProtocolName", protocol);
            }
            this.ourServiceRegistration = SipActivator.bundleContext.registerService(UriHandler.class.getName(), (Object)this, registrationProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandlerService() {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.ourServiceRegistration != null) {
                this.ourServiceRegistration.unregister();
                this.ourServiceRegistration = null;
            }
        }
    }

    public String[] getProtocol() {
        return new String[]{"sip", "tel", "callto"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUri(final String uri) {
        boolean[] blArray = this.storedAccountsAreLoaded;
        synchronized (this.storedAccountsAreLoaded) {
            ProtocolProviderService provider;
            if (!this.storedAccountsAreLoaded[0]) {
                if (this.uris == null) {
                    this.uris = new LinkedList<String>();
                }
                this.uris.add(uri);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                provider = this.selectHandlingProvider(uri);
            }
            catch (OperationFailedException exc) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("User canceled handling of uri " + uri));
                }
                return;
            }
            if (provider == null) {
                this.showErrorMessage("You need to configure at least one SIP account \nto be able to call " + uri, null);
                return;
            }
            if (provider.getRegistrationState() == RegistrationState.REGISTERED) {
                this.handleUri(uri, provider);
            } else {
                long initialRegistrationTimeout = SipActivator.getConfigurationService().getLong(INITIAL_REGISTRATION_TIMEOUT_PROP, 5000L);
                final DelayRegistrationStateChangeListener listener = new DelayRegistrationStateChangeListener(uri, provider);
                provider.addRegistrationStateChangeListener((RegistrationStateChangeListener)listener);
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        provider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)listener);
                        if (provider.getRegistrationState() != RegistrationState.REGISTERED) {
                            UriHandlerSipImpl.this.handleUri(uri, provider);
                        }
                    }
                }, initialRegistrationTimeout);
            }
            return;
        }
    }

    protected void handleUri(String uri, ProtocolProviderService provider) {
        if (uri != null) {
            uri = uri.replace("sip://", "sip:");
        }
        OperationSetBasicTelephony telephonyOpSet = (OperationSetBasicTelephony)provider.getOperationSet(OperationSetBasicTelephony.class);
        OperationSetVideoTelephony videoTelephonyOpSet = (OperationSetVideoTelephony)provider.getOperationSet(OperationSetVideoTelephony.class);
        boolean videoCall = false;
        if (videoTelephonyOpSet != null && uri.contains("?")) {
            String params = uri.substring(uri.indexOf(63) + 1);
            uri = uri.substring(0, uri.indexOf(63));
            StringTokenizer paramTokens = new StringTokenizer(params, "&");
            while (paramTokens.hasMoreTokens()) {
                String tok = paramTokens.nextToken();
                String[] keyValue = tok.split("\\=");
                if (keyValue.length != 2 || !keyValue[0].equalsIgnoreCase("video") || !keyValue[1].equalsIgnoreCase("true")) continue;
                videoCall = true;
            }
        }
        try {
            if (videoCall) {
                videoTelephonyOpSet.createVideoCall(uri);
            } else {
                telephonyOpSet.createCall(uri);
            }
        }
        catch (OperationFailedException exc) {
            boolean handled = false;
            if (exc.getErrorCode() == 3) {
                handled = this.promptForRegistration(uri, provider);
            }
            if (!handled) {
                this.showErrorMessage("Failed to create a call to " + uri, (Exception)((Object)exc));
            }
        }
        catch (ParseException exc) {
            this.showErrorMessage(uri + " does not appear to be a valid SIP address", exc);
        }
    }

    private boolean promptForRegistration(String uri, ProtocolProviderService provider) {
        int answer = SipActivator.getUIService().getPopupDialog().showConfirmPopupDialog((Object)"You need to be online in order to make a call and your account is currently offline. Do want to connect now?", "Account is currently offline", 0);
        if (answer == 0) {
            new ProtocolRegistrationThread(uri, provider).start();
            return true;
        }
        return false;
    }

    public void serviceChanged(ServiceEvent event) {
        Object sourceService = SipActivator.bundleContext.getService(event.getServiceReference());
        if (sourceService != this.protoFactory) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                this.registerHandlerService();
                break;
            }
            case 4: {
                this.unregisterHandlerService();
                break;
            }
        }
    }

    private void showErrorMessage(String message, Exception exc) {
        SipActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)message, "Failed to create call!", 0);
        logger.error((Object)message, (Throwable)exc);
    }

    public ProtocolProviderService selectHandlingProvider(String uri) throws OperationFailedException {
        ArrayList registeredAccounts = this.protoFactory.getRegisteredAccounts();
        if (registeredAccounts.size() == 0) {
            return null;
        }
        if (registeredAccounts.size() == 1) {
            ServiceReference providerReference = this.protoFactory.getProviderForAccount((AccountID)registeredAccounts.get(0));
            ProtocolProviderService provider = (ProtocolProviderService)SipActivator.getBundleContext().getService(providerReference);
            return provider;
        }
        ArrayList<ProviderComboBoxEntry> providers = new ArrayList<ProviderComboBoxEntry>();
        for (AccountID accountID : registeredAccounts) {
            ServiceReference providerReference = this.protoFactory.getProviderForAccount(accountID);
            ProtocolProviderService provider = (ProtocolProviderService)SipActivator.getBundleContext().getService(providerReference);
            providers.add(new ProviderComboBoxEntry(provider));
        }
        Object result = SipActivator.getUIService().getPopupDialog().showInputPopupDialog((Object)("Please select the account that you would like \nto use to call " + uri), "Account Selection", 2, providers.toArray(), providers.get(0));
        if (result == null) {
            throw new OperationFailedException("Operation cancelled", 16);
        }
        return ((ProviderComboBoxEntry)result).provider;
    }

    private static class ProviderComboBoxEntry {
        public final ProtocolProviderService provider;

        public ProviderComboBoxEntry(ProtocolProviderService provider) {
            this.provider = provider;
        }

        public String toString() {
            return this.provider.getAccountID().getAccountAddress();
        }
    }

    private class ProtocolRegistrationThread
    extends Thread
    implements RegistrationStateChangeListener {
        private ProtocolProviderService handlerProvider;
        private String uri;

        public ProtocolRegistrationThread(String uri, ProtocolProviderService handlerProvider) {
            super("UriHandlerProviderRegistrationThread:uri=" + uri);
            this.handlerProvider = null;
            this.uri = null;
            this.uri = uri;
            this.handlerProvider = handlerProvider;
        }

        @Override
        public void run() {
            this.handlerProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
            try {
                this.handlerProvider.register(SipActivator.getUIService().getDefaultSecurityAuthority(this.handlerProvider));
            }
            catch (OperationFailedException exc) {
                logger.error((Object)"Failed to manually register provider.");
                logger.warn((Object)exc.getMessage(), (Throwable)exc);
            }
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                Thread uriRehandleThread = new Thread(){

                    @Override
                    public void run() {
                        UriHandlerSipImpl.this.handleUri(ProtocolRegistrationThread.this.uri);
                    }
                };
                uriRehandleThread.setName("UriRehandleThread:uri=" + this.uri);
                uriRehandleThread.start();
            }
            if (evt.getNewState() == RegistrationState.REGISTERING) {
                return;
            }
            this.handlerProvider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        }
    }

    private class DelayRegistrationStateChangeListener
    implements RegistrationStateChangeListener {
        private String uri;
        private ProtocolProviderService provider;
        private boolean handled = false;

        public DelayRegistrationStateChangeListener(String uri, ProtocolProviderService provider) {
            this.uri = uri;
            this.provider = provider;
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (evt.getNewState() == RegistrationState.REGISTERED && !this.handled) {
                this.provider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
                this.handled = true;
                UriHandlerSipImpl.this.handleUri(this.uri, this.provider);
            }
        }
    }
}

