/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.sdp;

import java.io.UnsupportedEncodingException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sdp.Attribute;
import javax.sdp.Connection;
import javax.sdp.MediaDescription;
import javax.sdp.Origin;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.sdp.TimeDescription;
import javax.sdp.URI;
import javax.sdp.Version;
import javax.sip.header.ContentTypeHeader;
import javax.sip.message.Message;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.media.DynamicPayloadTypeRegistry;
import net.java.sip.communicator.service.protocol.media.DynamicRTPExtensionsRegistry;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import org.apache.commons.lang3.StringUtils;
import org.ice4j.ice.sdp.IceSdpUtils;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.format.AudioMediaFormat;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.utils.MediaType;
import org.opentelecoms.javax.sdp.NistSdpFactory;

public class SdpUtils {
    private static final String EXTMAP_ATTR = "extmap";
    private static final Logger logger = Logger.getLogger(SdpUtils.class);
    private static final String RTCP_ATTR = "rtcp";
    private static final SdpFactory sdpFactory = new NistSdpFactory();
    public static final String ZRTP_HASH_ATTR = "zrtp-hash";

    public static boolean containsAttribute(MediaDescription description, String attributeName) throws IllegalArgumentException {
        try {
            Vector atts = description.getAttributes(false);
            for (Attribute a : atts) {
                if (!a.getName().equals(attributeName)) continue;
                return true;
            }
            return false;
        }
        catch (SdpException e) {
            String message = "Invalid media type in a= line: " + description;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)message, (Throwable)e);
            }
            throw new IllegalArgumentException(message, e);
        }
    }

    public static Attribute createAttribute(String name, String value) {
        return sdpFactory.createAttribute(name, value);
    }

    private static Attribute createDirectionAttribute(MediaDirection direction) {
        String dirStr;
        switch (direction) {
            case RECVONLY: {
                dirStr = "recvonly";
                break;
            }
            case SENDONLY: {
                dirStr = "sendonly";
                break;
            }
            case SENDRECV: {
                dirStr = "sendrecv";
                break;
            }
            default: {
                dirStr = "inactive";
            }
        }
        return sdpFactory.createAttribute(dirStr, null);
    }

    public static MediaDescription createDisablingAnswer(MediaDescription offer) throws IllegalArgumentException {
        try {
            String mediaType = offer.getMedia().getMediaType();
            Vector<String> formatsVec = offer.getMedia().getMediaFormats(true);
            if (formatsVec == null) {
                formatsVec = new Vector<String>();
                formatsVec.add(Integer.toString(0));
            }
            String[] formatsArray = new String[formatsVec.size()];
            return sdpFactory.createMediaDescription(mediaType, 0, 1, offer.getMedia().getProtocol(), formatsVec.toArray(formatsArray));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create a disabling answer", e);
        }
    }

    private static MediaFormat createFormat(byte payloadType, Attribute rtpmap, Attribute fmtp, float frameRate, List<Attribute> advp, DynamicPayloadTypeRegistry ptRegistry) throws SdpException {
        String encoding = null;
        double clockRate = -1.0;
        int numChannels = 1;
        if (rtpmap != null) {
            String rtpmapValue = rtpmap.getValue();
            StringTokenizer tokenizer = new StringTokenizer(rtpmapValue, " /", false);
            if (tokenizer.hasMoreTokens()) {
                tokenizer.nextToken();
            }
            if (tokenizer.hasMoreTokens()) {
                encoding = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreTokens()) {
                clockRate = Double.parseDouble(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                String nChansStr = tokenizer.nextToken();
                try {
                    numChannels = Integer.parseInt(nChansStr);
                }
                catch (NumberFormatException exc) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(nChansStr + " is not a valid number of channels."), (Throwable)exc);
                    }
                }
            }
        } else {
            MediaFormat fmt = ptRegistry.findFormat(payloadType);
            if (fmt != null) {
                return fmt;
            }
        }
        Map<String, String> fmtParamsMap = null;
        Map<String, String> advancedAttrMap = null;
        if (fmtp != null) {
            fmtParamsMap = SdpUtils.parseFmtpAttribute(fmtp);
        }
        if (advp != null) {
            advancedAttrMap = SdpUtils.parseAdvancedAttributes(advp);
        }
        if ("opus".equals(encoding)) {
            numChannels = 2;
        }
        MediaFormat format = SipActivator.getMediaService().getFormatFactory().createMediaFormat(payloadType, encoding, clockRate, numChannels, frameRate, fmtParamsMap, advancedAttrMap);
        if (payloadType >= 96 && payloadType <= 127 && format != null) {
            ptRegistry.addMapping(format, payloadType);
        }
        return format;
    }

    public static MediaDescription createMediaDescription(String transport, List<MediaFormat> formats, StreamConnector connector, MediaDirection direction, List<RTPExtension> rtpExtensions, DynamicPayloadTypeRegistry dynamicPayloadTypes, DynamicRTPExtensionsRegistry rtpExtensionsRegistry) throws OperationFailedException {
        int rtcpPort;
        int[] payloadTypesArray = new int[formats.size()];
        Vector<Attribute> mediaAttributes = new Vector<Attribute>(2 * payloadTypesArray.length + 1);
        MediaType mediaType = null;
        if (direction != MediaDirection.SENDRECV) {
            mediaAttributes.add(SdpUtils.createDirectionAttribute(direction));
        }
        for (int i = 0; i < payloadTypesArray.length; ++i) {
            int channels;
            byte payloadType;
            MediaFormat format = formats.get(i);
            MediaType fmtMediaType = format.getMediaType();
            if (mediaType == null) {
                mediaType = fmtMediaType;
            }
            if ((payloadType = format.getRTPPayloadType()) == -1) {
                try {
                    payloadType = dynamicPayloadTypes.obtainPayloadTypeNumber(format);
                }
                catch (IllegalStateException exception) {
                    throw new OperationFailedException("Failed to allocate a new dynamic PT number.", 4, (Throwable)exception);
                }
            }
            String numChannelsStr = "";
            if (format instanceof AudioMediaFormat && (channels = ((AudioMediaFormat)format).getChannels()) > 1) {
                numChannelsStr = "/" + channels;
            }
            Attribute rtpmap = sdpFactory.createAttribute("rtpmap", payloadType + " " + format.getEncoding() + "/" + format.getClockRateString() + numChannelsStr);
            mediaAttributes.add(rtpmap);
            if (format.getFormatParameters().size() > 0) {
                Attribute fmtp = sdpFactory.createAttribute("fmtp", payloadType + " " + SdpUtils.encodeFmtp(format));
                mediaAttributes.add(fmtp);
            }
            for (Map.Entry ntry : format.getAdvancedAttributes().entrySet()) {
                Attribute adv;
                switch ((String)ntry.getKey()) {
                    case "ptime": 
                    case "maxptime": {
                        adv = sdpFactory.createAttribute((String)ntry.getKey(), (String)ntry.getValue());
                        break;
                    }
                    default: {
                        adv = sdpFactory.createAttribute((String)ntry.getKey(), payloadType + " " + (String)ntry.getValue());
                    }
                }
                mediaAttributes.add(adv);
            }
            payloadTypesArray[i] = payloadType;
        }
        int rtpPort = connector.getDataSocket().getLocalPort();
        if (rtpPort + 1 != (rtcpPort = connector.getControlSocket().getLocalPort())) {
            Attribute rtcpAttr = sdpFactory.createAttribute(RTCP_ATTR, Integer.toString(rtcpPort));
            mediaAttributes.add(rtcpAttr);
        }
        if (rtpExtensions != null && rtpExtensions.size() > 0) {
            for (RTPExtension extension : rtpExtensions) {
                byte extID = rtpExtensionsRegistry.obtainExtensionMapping(extension);
                String uri = extension.getURI().toString();
                MediaDirection extDirection = extension.getDirection();
                String attributes = extension.getExtensionAttributes();
                String attrValue = Byte.toString(extID) + (extDirection == MediaDirection.SENDRECV ? "" : "/" + extDirection.toString()) + " " + uri + (attributes == null ? "" : " " + attributes);
                Attribute extMapAttr = sdpFactory.createAttribute(EXTMAP_ATTR, attrValue);
                mediaAttributes.add(extMapAttr);
            }
        }
        MediaDescription mediaDesc = null;
        try {
            mediaDesc = sdpFactory.createMediaDescription(mediaType.toString(), connector.getDataSocket().getLocalPort(), 1, transport, payloadTypesArray);
            mediaDesc.setAttributes(mediaAttributes);
        }
        catch (Exception cause) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create a media description", 4, cause, logger);
        }
        return mediaDesc;
    }

    public static SessionDescription createSessionDescription(InetAddress localAddress) throws OperationFailedException {
        return SdpUtils.createSessionDescription(localAddress, null, null);
    }

    public static SessionDescription createSessionDescription(InetAddress localAddress, String userName, List<MediaDescription> mediaDescriptions) throws OperationFailedException {
        SessionDescription sessDescr = null;
        try {
            sessDescr = sdpFactory.createSessionDescription();
            Version v = sdpFactory.createVersion(0);
            sessDescr.setVersion(v);
            sessDescr.setSessionName(sdpFactory.createSessionName("-"));
            TimeDescription t = sdpFactory.createTimeDescription();
            Vector<TimeDescription> timeDescs = new Vector<TimeDescription>();
            timeDescs.add(t);
            sessDescr.setTimeDescriptions(timeDescs);
            String addrType = localAddress instanceof Inet6Address ? "IP6" : "IP4";
            userName = StringUtils.isEmpty((CharSequence)userName) ? "jitsi.org" : userName + "-jitsi.org";
            Origin o = sdpFactory.createOrigin(userName, 0L, 0L, "IN", addrType, localAddress.getHostAddress());
            sessDescr.setOrigin(o);
            Connection c = sdpFactory.createConnection("IN", addrType, localAddress.getHostAddress());
            sessDescr.setConnection(c);
            if (mediaDescriptions != null) {
                sessDescr.setMediaDescriptions(new Vector<MediaDescription>(mediaDescriptions));
            }
            return sessDescr;
        }
        catch (SdpException exc) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("An error occurred while creating session description", 4, exc, logger);
            return sessDescr;
        }
    }

    public static SessionDescription createSessionUpdateDescription(SessionDescription descToUpdate, InetAddress newConnectionAddress, List<MediaDescription> newMediaDescriptions) throws OperationFailedException {
        SessionDescription update;
        block10: {
            block9: {
                update = SdpUtils.createSessionDescription(newConnectionAddress, null, newMediaDescriptions);
                try {
                    Origin o = (Origin)descToUpdate.getOrigin().clone();
                    long version = o.getSessionVersion();
                    o.setSessionVersion(version + 1L);
                    update.setOrigin(o);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block9;
                    logger.info((Object)"Something very odd just happened.", (Throwable)e);
                }
            }
            Vector<MediaDescription> prevMedias = SdpUtils.extractMediaDescriptions(descToUpdate);
            Vector<MediaDescription> completeMediaDescList = new Vector<MediaDescription>();
            newMediaDescriptions = new Vector<MediaDescription>(newMediaDescriptions);
            for (MediaDescription medToUpdate : prevMedias) {
                MediaDescription desc = null;
                try {
                    MediaType type = SdpUtils.getMediaType(medToUpdate);
                    desc = SdpUtils.removeMediaDesc(newMediaDescriptions, type);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (desc == null) {
                    desc = SdpUtils.createDisablingAnswer(medToUpdate);
                }
                completeMediaDescList.add(desc);
            }
            for (MediaDescription medToAdd : newMediaDescriptions) {
                completeMediaDescList.add(medToAdd);
            }
            try {
                update.setMediaDescriptions(completeMediaDescList);
            }
            catch (SdpException e) {
                if (!logger.isInfoEnabled()) break block10;
                logger.info((Object)"A crazy thing just happened.", (Throwable)e);
            }
        }
        return update;
    }

    private static InetSocketAddress determineRtcpAddress(String rtcpAttrValue, InetAddress defaultAddr, int defaultPort) throws IllegalArgumentException {
        int rtcpPort;
        if (rtcpAttrValue == null) {
            return new InetSocketAddress(defaultAddr, defaultPort);
        }
        if (rtcpAttrValue == null || rtcpAttrValue.trim().length() == 0) {
            return new InetSocketAddress(defaultAddr, defaultPort);
        }
        StringTokenizer rtcpTokenizer = new StringTokenizer(rtcpAttrValue.trim(), " ");
        int tokenCount = rtcpTokenizer.countTokens();
        try {
            rtcpPort = Integer.parseInt(rtcpTokenizer.nextToken());
        }
        catch (NumberFormatException exc) {
            throw new IllegalArgumentException("Error while parsing rtcp attribute: " + rtcpAttrValue, exc);
        }
        if (tokenCount == 1) {
            return new InetSocketAddress(defaultAddr, rtcpPort);
        }
        if (tokenCount == 4) {
            rtcpTokenizer.nextToken();
            rtcpTokenizer.nextToken();
            String rtcpAddrStr = rtcpTokenizer.nextToken();
            InetAddress rtcpAddress = null;
            try {
                rtcpAddress = NetworkUtils.getInetAddress((String)rtcpAddrStr);
            }
            catch (UnknownHostException exc) {
                throw new IllegalArgumentException("Failed to parse address " + rtcpAddress, exc);
            }
            return new InetSocketAddress(rtcpAddress, rtcpPort);
        }
        throw new IllegalArgumentException("Error while parsing rtcp attribute: " + rtcpAttrValue + ". Too many tokens! (" + tokenCount + ")");
    }

    private static String encodeFmtp(MediaFormat format) {
        Iterator formatParamsIter = format.getFormatParameters().entrySet().iterator();
        StringBuffer fmtpBuff = new StringBuffer();
        while (formatParamsIter.hasNext()) {
            Map.Entry ntry = formatParamsIter.next();
            fmtpBuff.append((String)ntry.getKey()).append("=").append((String)ntry.getValue());
            if (!formatParamsIter.hasNext()) continue;
            fmtpBuff.append(";");
        }
        return fmtpBuff.toString();
    }

    public static MediaStreamTarget extractDefaultTarget(MediaDescription mediaDesc, SessionDescription sessDesc) throws IllegalArgumentException {
        String rtcpAttributeValue;
        int rtpPort;
        String address;
        Connection conn = mediaDesc.getConnection();
        if (conn == null && (conn = sessDesc.getConnection()) == null) {
            throw new IllegalArgumentException("No \"c=\" field in the following media description nor in the enclosing session:\n" + mediaDesc.toString());
        }
        try {
            address = conn.getAddress();
        }
        catch (SdpParseException exc) {
            throw new IllegalArgumentException("Couldn't extract connection address.", exc);
        }
        InetAddress rtpAddress = null;
        try {
            rtpAddress = NetworkUtils.getInetAddress((String)address);
        }
        catch (UnknownHostException exc) {
            throw new IllegalArgumentException("Failed to parse address " + address, exc);
        }
        try {
            rtpPort = mediaDesc.getMedia().getMediaPort();
        }
        catch (SdpParseException exc) {
            throw new IllegalArgumentException("Couldn't extract port from a media description.", exc);
        }
        InetSocketAddress rtpTarget = new InetSocketAddress(rtpAddress, rtpPort);
        InetAddress rtcpAddress = rtpAddress;
        int rtcpPort = rtpPort + 1;
        try {
            rtcpAttributeValue = mediaDesc.getAttribute(RTCP_ATTR);
        }
        catch (SdpParseException exc) {
            throw new IllegalArgumentException("Couldn't extract attribute value.", exc);
        }
        InetSocketAddress rtcpTarget = SdpUtils.determineRtcpAddress(rtcpAttributeValue, rtcpAddress, rtcpPort);
        return new MediaStreamTarget(rtpTarget, rtcpTarget);
    }

    public static List<MediaFormat> extractFormats(MediaDescription mediaDesc, DynamicPayloadTypeRegistry ptRegistry) {
        Vector formatStrings;
        ArrayList<MediaFormat> mediaFmts = new ArrayList<MediaFormat>();
        try {
            formatStrings = mediaDesc.getMedia().getMediaFormats(true);
        }
        catch (SdpParseException exc) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"A funny thing just happened ...", (Throwable)exc);
            }
            return mediaFmts;
        }
        float frameRate = -1.0f;
        try {
            String frStr = mediaDesc.getAttribute("framerate");
            if (frStr != null) {
                frameRate = Float.parseFloat(frStr);
            }
        }
        catch (SdpParseException sdpParseException) {
            // empty catch block
        }
        for (String ptStr : formatStrings) {
            List<Attribute> advp;
            Attribute fmtp;
            Attribute rtpmap;
            byte pt;
            block19: {
                block18: {
                    block17: {
                        try {
                            pt = Byte.parseByte(ptStr);
                        }
                        catch (NumberFormatException e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)(ptStr + " is not a valid payload type"), (Throwable)e);
                            continue;
                        }
                        rtpmap = null;
                        try {
                            rtpmap = SdpUtils.findPayloadTypeSpecificAttribute(mediaDesc.getAttributes(false), "rtpmap", Byte.toString(pt));
                        }
                        catch (SdpException e) {
                            if (!logger.isDebugEnabled()) break block17;
                            logger.debug((Object)(rtpmap + " does not seem like a valid rtpmap: attribute"), (Throwable)e);
                        }
                    }
                    fmtp = null;
                    try {
                        fmtp = SdpUtils.findPayloadTypeSpecificAttribute(mediaDesc.getAttributes(false), "fmtp", ptStr);
                    }
                    catch (SdpException e) {
                        if (!logger.isDebugEnabled()) break block18;
                        logger.debug((Object)(fmtp + " does not seem like a valid fmtp: attribute"), (Throwable)e);
                    }
                }
                advp = null;
                try {
                    advp = SdpUtils.findAdvancedAttributes(mediaDesc.getAttributes(false), ptStr);
                }
                catch (SdpException e) {
                    if (!logger.isDebugEnabled()) break block19;
                    logger.debug((Object)"Problem parsing advanced attributes", (Throwable)e);
                }
            }
            MediaFormat mediaFormat = null;
            try {
                mediaFormat = SdpUtils.createFormat(pt, rtpmap, fmtp, frameRate, advp, ptRegistry);
            }
            catch (SdpException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"A funny thing just happened ...", (Throwable)e);
                continue;
            }
            if (mediaFormat == null) continue;
            mediaFmts.add(mediaFormat);
        }
        return mediaFmts;
    }

    public static Vector<MediaDescription> extractMediaDescriptions(SessionDescription sessionDescription) throws IllegalArgumentException {
        Vector remoteDescriptions = null;
        try {
            remoteDescriptions = sessionDescription.getMediaDescriptions(false);
        }
        catch (SdpException sdpException) {
            // empty catch block
        }
        if (remoteDescriptions == null || remoteDescriptions.size() == 0) {
            throw new IllegalArgumentException("Could not find any media descriptions.");
        }
        return remoteDescriptions;
    }

    public static List<RTPExtension> extractRTPExtensions(MediaDescription mediaDesc, DynamicRTPExtensionsRegistry extMap) {
        ArrayList<RTPExtension> extensionsList = new ArrayList<RTPExtension>();
        Vector mediaAttributes = mediaDesc.getAttributes(false);
        if (mediaAttributes == null || mediaAttributes.size() == 0) {
            return null;
        }
        for (Attribute attr : mediaAttributes) {
            RTPExtension rtpExtension;
            String attrValue;
            try {
                if (!EXTMAP_ATTR.equals(attr.getName())) continue;
                attrValue = attr.getValue();
            }
            catch (SdpException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"A funny thing just happened ...", (Throwable)e);
                continue;
            }
            if (attrValue == null || (rtpExtension = SdpUtils.parseRTPExtensionAttribute(attrValue = attrValue.trim(), extMap)) == null) continue;
            extensionsList.add(rtpExtension);
        }
        return extensionsList;
    }

    private static List<Attribute> findAdvancedAttributes(Vector<Attribute> mediaAttributes, String payloadType) throws SdpException {
        if (mediaAttributes == null || mediaAttributes.size() == 0) {
            return null;
        }
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        for (Attribute attr : mediaAttributes) {
            String attrName = attr.getName();
            String attrValue = attr.getValue();
            if (attrName.equals("rtpmap") || attrName.equals("fmtp") || attrValue == null) continue;
            attrValue = attrValue.trim();
            ret.add(attr);
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    private static Attribute findPayloadTypeSpecificAttribute(Vector<Attribute> mediaAttributes, String attributeName, String payloadType) throws SdpException {
        if (mediaAttributes == null || mediaAttributes.size() == 0) {
            return null;
        }
        for (Attribute attr : mediaAttributes) {
            String attrValue;
            if (!attributeName.equals(attr.getName()) || (attrValue = attr.getValue()) == null || !(attrValue = attrValue.trim()).startsWith(payloadType + " ")) continue;
            return attr;
        }
        return null;
    }

    public static URL getCallInfoURL(SessionDescription sessDesc) {
        URI sdpUriField = sessDesc.getURI();
        if (sdpUriField == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Call URI was null.");
            }
            return null;
        }
        try {
            return sdpUriField.get();
        }
        catch (SdpParseException exc) {
            logger.warn((Object)"Failed to parse SDP URI.", (Throwable)exc);
            return null;
        }
    }

    public static String getContentAsString(Message message) {
        byte[] rawContent = message.getRawContent();
        ContentTypeHeader contentTypeHeader = (ContentTypeHeader)message.getHeader("Content-Type");
        String charset = null;
        if (contentTypeHeader != null) {
            charset = contentTypeHeader.getParameter("charset");
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            return new String(rawContent, charset);
        }
        catch (UnsupportedEncodingException uee) {
            logger.warn((Object)"SIP message with unsupported charset of its content", (Throwable)uee);
            return new String(rawContent);
        }
    }

    public static MediaDirection getDirection(MediaDescription mediaDesc) {
        Vector attributes = mediaDesc.getAttributes(false);
        if (attributes == null) {
            return MediaDirection.SENDRECV;
        }
        for (Attribute attribute : attributes) {
            String attrName;
            block5: {
                attrName = null;
                try {
                    attrName = attribute.getName();
                }
                catch (SdpParseException e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)"The impossible has just occurred!", (Throwable)e);
                }
            }
            for (MediaDirection value : MediaDirection.values()) {
                if (!value.toString().equals(attrName)) continue;
                return value;
            }
        }
        return MediaDirection.SENDRECV;
    }

    public static MediaType getMediaType(MediaDescription description) throws IllegalArgumentException {
        try {
            return MediaType.parseString((String)description.getMedia().getMediaType());
        }
        catch (SdpException e) {
            String message = "Invalid media type in m= line: " + description;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)message, (Throwable)e);
            }
            throw new IllegalArgumentException(message, e);
        }
    }

    private static Map<String, String> parseAdvancedAttributes(List<Attribute> attrs) {
        if (attrs == null) {
            return null;
        }
        Hashtable<String, String> ret = new Hashtable<String, String>();
        for (Attribute attr : attrs) {
            String attrVal;
            String attrName;
            try {
                attrName = attr.getName();
                attrVal = attr.getValue();
            }
            catch (SdpParseException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"The impossible has just occurred!", (Throwable)e);
                }
                return null;
            }
            int idx = attrVal.indexOf(" ");
            if (idx != -1) {
                attrVal = attrVal.substring(idx + 1);
            }
            ret.put(attrName, attrVal);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    private static Map<String, String> parseFmtpAttribute(Attribute fmtpAttr) throws SdpException {
        Hashtable<String, String> fmtpMap = new Hashtable<String, String>();
        String fmtpValue = fmtpAttr.getValue();
        StringTokenizer tokenizer = new StringTokenizer(fmtpValue, " ;", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int indexOfEq = token.indexOf("=");
            if (indexOfEq == -1 || indexOfEq == token.length() - 1) continue;
            String paramName = token.substring(0, indexOfEq);
            String paramValue = token.substring(indexOfEq + 1);
            fmtpMap.put(paramName, paramValue);
        }
        if (fmtpMap.isEmpty()) {
            return null;
        }
        return fmtpMap;
    }

    private static RTPExtension parseRTPExtensionAttribute(String extmapAttr, DynamicRTPExtensionsRegistry extMap) {
        java.net.URI uri;
        String extIDStr;
        StringTokenizer tokenizer = new StringTokenizer(extmapAttr, " ");
        if (!tokenizer.hasMoreElements()) {
            return null;
        }
        String idAndDirection = tokenizer.nextToken();
        MediaDirection direction = MediaDirection.SENDRECV;
        if (idAndDirection.contains("/")) {
            StringTokenizer idAndDirTokenizer = new StringTokenizer(idAndDirection, "/");
            if (!idAndDirTokenizer.hasMoreElements()) {
                return null;
            }
            extIDStr = idAndDirTokenizer.nextToken();
            if (!idAndDirTokenizer.hasMoreTokens()) {
                return null;
            }
            direction = MediaDirection.parseString((String)idAndDirTokenizer.nextToken());
        } else {
            extIDStr = idAndDirection;
        }
        if (!tokenizer.hasMoreElements()) {
            return null;
        }
        String uriStr = tokenizer.nextToken();
        try {
            uri = new java.net.URI(uriStr);
        }
        catch (URISyntaxException e) {
            return null;
        }
        String extensionAttributes = null;
        if (tokenizer.hasMoreElements()) {
            extensionAttributes = tokenizer.nextToken();
        }
        RTPExtension rtpExtension = new RTPExtension(uri, direction, extensionAttributes);
        byte extID = Byte.parseByte(extIDStr);
        if (extMap.findExtension(extID) == null) {
            extMap.addMapping(rtpExtension, extID);
        }
        return rtpExtension;
    }

    public static SessionDescription parseSdpString(String sdp) throws IllegalArgumentException {
        try {
            return sdpFactory.createSessionDescription(sdp);
        }
        catch (SdpParseException ex) {
            throw new IllegalArgumentException("Failed to parse the SDP description of the peer.", ex);
        }
    }

    private static MediaDescription removeMediaDesc(List<MediaDescription> descs, MediaType type) {
        Iterator<MediaDescription> i = descs.iterator();
        while (i.hasNext()) {
            MediaDescription mDesc = i.next();
            if (SdpUtils.getMediaType(mDesc) != type) continue;
            i.remove();
            return mDesc;
        }
        return null;
    }

    public static void setIceCredentials(SessionDescription sDes, String uFrag, String pwd) {
        IceSdpUtils.setIceCredentials((SessionDescription)sDes, (String)uFrag, (String)pwd);
    }

    public static void setSessionDirection(SessionDescription sdp) {
        MediaDirection direction = MediaDirection.INACTIVE;
        try {
            Vector mds = sdp.getMediaDescriptions(false);
            if (mds != null) {
                for (Object o : mds) {
                    MediaDescription md;
                    if (!(o instanceof MediaDescription) || (md = (MediaDescription)o).getMedia().getMediaPort() == 0) continue;
                    direction = direction.or(SdpUtils.getDirection(md));
                }
            }
        }
        catch (SdpException e) {
            logger.warn((Object)"Failed to get media descriptions.");
        }
        Vector attributes = sdp.getAttributes(true);
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Object o;
            o = i.next();
            if (!(o instanceof Attribute)) continue;
            try {
                String name = ((Attribute)o).getName();
                if (!"inactive".equals(name) && !"recvonly".equals(name) && !"sendonly".equals(name) && !"sendrecv".equals(name)) continue;
                i.remove();
            }
            catch (SdpException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Failed to get attribute name: ", (Throwable)e);
            }
        }
        if (!MediaDirection.SENDRECV.equals((Object)direction)) {
            attributes.add(SdpUtils.createDirectionAttribute(direction));
        }
        try {
            sdp.setAttributes(attributes);
        }
        catch (SdpException e) {
            logger.warn((Object)"Failed to set session direction attribute.");
        }
    }
}

