/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.xcap;

import java.io.IOException;
import java.net.URI;
import javax.sip.address.Address;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.xcap.BaseHttpXCapClient;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapClient;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapException;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapHttpResponse;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapResource;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapResourceId;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.ParsingException;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.CommonPolicyParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.RulesetType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.ContentType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.DataType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.PresContentParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ListType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ResourceListsParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ResourceListsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.XCapCapsParser;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.XCapCapsType;
import net.java.sip.communicator.util.Base64;
import org.apache.commons.lang3.StringUtils;

public class XCapClientImpl
extends BaseHttpXCapClient
implements XCapClient {
    private XCapCapsType xCapCaps;
    private boolean resourceListsSupported;
    private boolean presRulesSupported;
    private boolean presContentSupported;

    @Override
    public void connect(URI uri, Address userAddress, String username, String password) throws XCapException {
        super.connect(uri, userAddress, username, password);
        try {
            this.xCapCaps = this.loadXCapCaps();
        }
        catch (XCapException e) {
            this.disconnect();
            throw e;
        }
        for (String namespace : this.xCapCaps.getNamespaces().getNamespace()) {
            if ("urn:ietf:params:xml:ns:xcap-caps".equals(namespace)) {
                this.resourceListsSupported = true;
            }
            if ("urn:ietf:params:xml:ns:pres-rules".equals(namespace)) {
                this.presRulesSupported = true;
            }
            if (!"urn:oma:xml:prs:pres-content".equals(namespace)) continue;
            this.presContentSupported = true;
        }
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.xCapCaps = null;
        this.resourceListsSupported = false;
    }

    @Override
    public void putResourceLists(ResourceListsType resourceLists) throws XCapException {
        this.assertConnected();
        this.assertResourceListsSupported();
        String resourceListsDocument = this.getResourceListsDocument();
        XCapResourceId resourceId = new XCapResourceId(resourceListsDocument);
        try {
            if (resourceLists.getList().size() == 0) {
                this.deleteResourceLists();
                return;
            }
            String xml = ResourceListsParser.toXml(resourceLists);
            XCapResource resource = new XCapResource(resourceId, xml, "application/resource-lists+xml");
            this.putResource(resource);
        }
        catch (ParsingException e) {
            throw new XCapException("ResourceLists cannot be parsed", e);
        }
    }

    @Override
    public ResourceListsType getResourceLists() throws XCapException {
        this.assertConnected();
        this.assertResourceListsSupported();
        String resourceListsDocument = this.getResourceListsDocument();
        XCapResourceId resourceId = new XCapResourceId(resourceListsDocument);
        try {
            String xml = this.getResource(resourceId, "application/resource-lists+xml");
            if (xml == null) {
                return new ResourceListsType();
            }
            return ResourceListsParser.fromXml(xml);
        }
        catch (ParsingException e) {
            throw new XCapException("ResourceLists cannot be parsed", e);
        }
    }

    @Override
    public void deleteResourceLists() throws XCapException {
        this.assertConnected();
        this.assertResourceListsSupported();
        String resourceListsDocument = this.getResourceListsDocument();
        XCapResourceId resourceId = new XCapResourceId(resourceListsDocument);
        this.deleteResource(resourceId);
    }

    @Override
    public ListType getList(String anchor) throws XCapException {
        this.assertConnected();
        this.assertResourceListsSupported();
        return null;
    }

    @Override
    public XCapCapsType getXCapCaps() throws XCapException {
        this.assertConnected();
        return this.xCapCaps;
    }

    private XCapCapsType loadXCapCaps() throws XCapException {
        String xCapCapsDocument = this.getXCapCapsDocument();
        XCapResourceId resourceId = new XCapResourceId(xCapCapsDocument);
        try {
            String xml = this.getResource(resourceId, "application/xcap-caps+xml");
            if (xml == null) {
                throw new XCapException("Server xcap-caps wasn't find");
            }
            return XCapCapsParser.fromXml(xml);
        }
        catch (ParsingException e) {
            throw new XCapException("XCapCapsType cannot be parsed", e);
        }
    }

    @Override
    public RulesetType getPresRules() throws XCapException {
        this.assertConnected();
        this.assertPresRulesSupported();
        String presRulesDocument = this.getPresRulesDocument();
        XCapResourceId resourceId = new XCapResourceId(presRulesDocument);
        try {
            String xml = this.getResource(resourceId, "application/auth-policy+xml");
            if (xml == null) {
                return new RulesetType();
            }
            return CommonPolicyParser.fromXml(xml);
        }
        catch (Exception e) {
            throw new XCapException("PresRules cannot be parsed", e);
        }
    }

    @Override
    public void putPresRules(RulesetType presRules) throws XCapException {
        this.assertConnected();
        this.assertPresRulesSupported();
        String resourceListsDocument = this.getPresRulesDocument();
        XCapResourceId resourceId = new XCapResourceId(resourceListsDocument);
        try {
            String xml = CommonPolicyParser.toXml(presRules);
            XCapResource resource = new XCapResource(resourceId, xml, "application/auth-policy+xml");
            this.putResource(resource);
        }
        catch (ParsingException e) {
            throw new XCapException("PresRules cannot be parsed", e);
        }
    }

    @Override
    public void deletePresRules() throws XCapException {
        this.assertConnected();
        this.assertResourceListsSupported();
        String presRulesDocument = this.getPresRulesDocument();
        XCapResourceId resourceId = new XCapResourceId(presRulesDocument);
        this.deleteResource(resourceId);
    }

    @Override
    public void putPresContent(ContentType content, String imageName) throws XCapException {
        this.assertConnected();
        this.assertPresContentSupported();
        String presContentDocument = this.getPresContentDocument(imageName);
        XCapResourceId resourceId = new XCapResourceId(presContentDocument);
        try {
            String xml = PresContentParser.toXml(content);
            XCapResource resource = new XCapResource(resourceId, xml, "application/vnd.oma.pres-content+xml");
            this.putResource(resource);
        }
        catch (ParsingException e) {
            throw new XCapException("ContentType cannot be parsed", e);
        }
    }

    @Override
    public ContentType getPresContent(String imageName) throws XCapException {
        this.assertConnected();
        this.assertPresContentSupported();
        String presContentDocument = this.getPresContentDocument(imageName);
        XCapResourceId resourceId = new XCapResourceId(presContentDocument);
        try {
            XCapHttpResponse response = this.get(resourceId);
            int httpCode = response.getHttpCode();
            String contentType = response.getContentType();
            byte[] content = response.getContent();
            if (httpCode != 200) {
                if (httpCode == 404) {
                    return null;
                }
                String errorMessage = String.format("Error %1s while getting %1s PresContent from XCAP server", httpCode, resourceId.toString());
                throw new XCapException(errorMessage);
            }
            if (!contentType.startsWith("application/vnd.oma.pres-content+xml")) {
                String errorMessage = String.format("XCAP server returns invalid PresContent content type: %1s", contentType);
                throw new XCapException(errorMessage);
            }
            if (content == null || content.length == 0) {
                throw new XCapException("XCAP server returns invalid PresContent content");
            }
            try {
                return PresContentParser.fromXml(new String(content, "UTF-8"));
            }
            catch (ParsingException e) {
                ContentType presContent = new ContentType();
                DataType data = new DataType();
                data.setValue(new String(Base64.encode((byte[])content)));
                presContent.setData(data);
                return presContent;
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("%1s resource cannot be read", resourceId.toString());
            throw new XCapException(errorMessage, e);
        }
    }

    @Override
    public void deletePresContent(String imageName) throws XCapException {
        this.assertConnected();
        this.assertPresContentSupported();
        String presContentDocument = this.getPresContentDocument(imageName);
        XCapResourceId resourceId = new XCapResourceId(presContentDocument);
        this.deleteResource(resourceId);
    }

    @Override
    public URI getPresContentImageUri(String imageName) {
        this.assertConnected();
        String presContentDocument = this.getPresContentDocument(imageName);
        XCapResourceId resourceId = new XCapResourceId(presContentDocument);
        return this.getResourceURI(resourceId);
    }

    @Override
    public byte[] getImage(URI imageUri) throws XCapException {
        this.assertConnected();
        XCapHttpResponse response = this.get(imageUri);
        int httpCode = response.getHttpCode();
        byte[] content = response.getContent();
        if (httpCode != 200) {
            String errorMessage = String.format("Error %1s while getting %2s image from the server", httpCode, imageUri);
            throw new XCapException(errorMessage);
        }
        return content;
    }

    protected void assertResourceListsSupported() {
        if (!this.resourceListsSupported) {
            throw new IllegalStateException("XCAP server doesn't support resource-lists");
        }
    }

    protected void assertPresRulesSupported() {
        if (!this.presRulesSupported) {
            throw new IllegalStateException("XCAP server doesn't support pres-rules");
        }
    }

    protected void assertPresContentSupported() {
        if (!this.presContentSupported) {
            throw new IllegalStateException("XCAP server doesn't support pres-content");
        }
    }

    private void putResource(XCapResource resource) throws XCapException {
        XCapHttpResponse response = this.put(resource);
        int httpCode = response.getHttpCode();
        if (httpCode != 200 && httpCode != 201) {
            String xCapErrorMessage = this.getXCapErrorMessage(response);
            String errorMessage = xCapErrorMessage != null ? String.format("Error %1s while putting %2s to XCAP server. %3s", httpCode, resource.getId().toString(), xCapErrorMessage) : String.format("Error %1s while putting %2s to XCAP server", httpCode, resource.getId().toString());
            throw new XCapException(errorMessage);
        }
    }

    private String getResource(XCapResourceId resourceId, String contentType) throws XCapException {
        try {
            XCapHttpResponse response = this.get(resourceId);
            int httpCode = response.getHttpCode();
            byte[] content = response.getContent();
            if (httpCode != 200) {
                if (httpCode == 404) {
                    return null;
                }
                String xCapErrorMessage = this.getXCapErrorMessage(response);
                String errorMessage = xCapErrorMessage != null ? String.format("Error %1s while getting %2s from XCAP server. %3s", httpCode, resourceId.toString(), xCapErrorMessage) : String.format("Error %1s while getting %2s from XCAP server", httpCode, resourceId.toString());
                if (httpCode == 401 || httpCode == 407) {
                    String displayName = this.userAddress.getDisplayName();
                    if (StringUtils.isEmpty((CharSequence)displayName)) {
                        displayName = this.userAddress.toString();
                    }
                    XCapClientImpl.showError(null, null, SipActivator.getResources().getI18NString("impl.protocol.sip.XCAP_ERROR_UNAUTHORIZED", new String[]{displayName}));
                }
                throw new XCapException(errorMessage);
            }
            if (StringUtils.isEmpty((CharSequence)response.getContentType()) || content == null || content.length == 0) {
                return null;
            }
            if (!response.getContentType().startsWith(contentType)) {
                String errorMessage = String.format("XCAP server returns invalid content type: %1s", response.getContentType());
                throw new XCapException(errorMessage);
            }
            return new String(content, "UTF-8");
        }
        catch (IOException e) {
            String errorMessage = String.format("%1s resource cannot be read", resourceId.toString());
            throw new XCapException(errorMessage, e);
        }
    }

    private void deleteResource(XCapResourceId resourceId) throws XCapException {
        XCapHttpResponse response = this.delete(resourceId);
        int httpCode = response.getHttpCode();
        if (httpCode != 200 && httpCode != 404) {
            String xCapErrorMessage = this.getXCapErrorMessage(response);
            String errorMessage = xCapErrorMessage != null ? String.format("Error %1s while deleting %2s resource from XCAP server. %3s", httpCode, resourceId.toString(), xCapErrorMessage) : String.format("Error %1s while deleting %2s resource from XCAP server", httpCode, resourceId.toString());
            throw new XCapException(errorMessage);
        }
    }

    private String getResourceListsDocument() {
        return String.format("resource-lists/users/%2s/index", this.userAddress.getURI().toString());
    }

    private String getXCapCapsDocument() {
        return "xcap-caps/global/index";
    }

    private String getPresRulesDocument() {
        return String.format("pres-rules/users/%2s/presrules", this.userAddress.getURI().toString());
    }

    private String getPresContentDocument(String imageName) {
        return String.format("oma_status-icon/users/%1s/%2s", this.userAddress.getURI().toString(), imageName);
    }

    @Override
    public boolean isResourceListsSupported() {
        this.assertConnected();
        return this.resourceListsSupported;
    }

    @Override
    public boolean isPresRulesSupported() {
        this.assertConnected();
        return this.presRulesSupported;
    }

    @Override
    public boolean isPresContentSupported() {
        return this.presContentSupported;
    }
}

