/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy;

import java.util.ArrayList;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.ParsingException;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.XmlUtils;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.ConditionsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.ExceptType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.IdentityType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.ManyType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.OneType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.RuleType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.RulesetType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.SphereType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.ValidityType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.PresRulesParser;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CommonPolicyParser {
    public static String NAMESPACE = "urn:ietf:params:xml:ns:common-policy";
    public static String RULESET_ELEMENT = "ruleset";
    public static String RULE_ELEMENT = "rule";
    public static String RULE_ID_ATTR = "id";
    public static String CONDITIONS_ELEMENT = "conditions";
    public static String ACTIONS_ELEMENT = "actions";
    public static String TRANSFORMATIONS_ELEMENT = "transformations";
    public static String IDENTITY_ELEMENT = "identity";
    public static String SPHERE_ELEMENT = "sphere";
    public static String SPHERE_VALUE_ATTR = "value";
    public static String VALIDITY_ELEMENT = "validity";
    public static String VALIDITY_FROM_ELEMENT = "from";
    public static String VALIDITY_UNTIL_ELEMENT = "until";
    public static String ONE_ELEMENT = "one";
    public static String ONE_ID_ATTR = "id";
    public static String MANY_ELEMENT = "many";
    public static String MANY_DOMAIN_ATTR = "domain";
    public static String EXCEPT_ELEMENT = "except";
    public static String EXCEPT_ID_ATTR = "id";
    public static String EXCEPT_DOMAIN_ATTR = "domain";

    private CommonPolicyParser() {
    }

    public static RulesetType fromXml(String xml) throws ParsingException {
        if (StringUtils.isEmpty((CharSequence)xml)) {
            throw new IllegalArgumentException("XML cannot be null or empty");
        }
        try {
            RulesetType ruleset = new RulesetType();
            Document document = XMLUtils.createDocument((String)xml);
            Element rulesetElement = document.getDocumentElement();
            if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)rulesetElement)) || !RULESET_ELEMENT.equals(rulesetElement.getLocalName())) {
                throw new Exception("Document doesn't contain ruleset element");
            }
            NamedNodeMap attributes = rulesetElement.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
                if (namespaceUri == null) {
                    throw new Exception("ruleset element is invalid");
                }
                if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
                throw new Exception("ruleset element is invalid");
            }
            NodeList childNodes = rulesetElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element childElement = (Element)node;
                ruleset.getRules().add(CommonPolicyParser.ruleFromElement(childElement));
            }
            return ruleset;
        }
        catch (Exception ex) {
            throw new ParsingException(ex);
        }
    }

    public static String toXml(RulesetType ruleset) throws ParsingException {
        if (ruleset == null) {
            throw new IllegalArgumentException("ruleset cannot be null");
        }
        try {
            Document document = XMLUtils.createDocument();
            Element rulesetElement = document.createElementNS(NAMESPACE, RULESET_ELEMENT);
            for (RuleType rule : ruleset.getRules()) {
                rulesetElement.appendChild(CommonPolicyParser.elementFromRule(document, rule));
            }
            document.appendChild(rulesetElement);
            return XMLUtils.createXml((Document)document);
        }
        catch (Exception ex) {
            throw new ParsingException(ex);
        }
    }

    private static RuleType ruleFromElement(Element element) throws Exception {
        RuleType rule = new RuleType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !RULE_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("rule element is invalid");
        }
        String id = null;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("rule element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (!NAMESPACE.equals(namespaceUri) || !RULE_ID_ATTR.equals(attribute.getLocalName()) || id != null) {
                throw new Exception("rule element is invalid");
            }
            id = attribute.getValue();
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (!NAMESPACE.equals(namespaceUri)) {
                throw new Exception("rule element is invalid");
            }
            if (CONDITIONS_ELEMENT.equals(localName)) {
                rule.setConditions(CommonPolicyParser.conditionsFromElement(childElement));
                continue;
            }
            if (ACTIONS_ELEMENT.equals(localName)) {
                rule.setActions(PresRulesParser.actionsFromElement(childElement));
                continue;
            }
            if (TRANSFORMATIONS_ELEMENT.equals(localName)) {
                rule.setTransformations(PresRulesParser.transformationsFromElement(childElement));
                continue;
            }
            throw new Exception("rule element is invalid");
        }
        if (id == null) {
            throw new Exception("rule id attribute is missed");
        }
        rule.setId(id);
        return rule;
    }

    private static Element elementFromRule(Document document, RuleType rule) throws Exception {
        Element element = document.createElementNS(NAMESPACE, RULE_ELEMENT);
        if (StringUtils.isEmpty((CharSequence)rule.getId())) {
            throw new Exception("rule element is invalid");
        }
        element.setAttribute(RULE_ID_ATTR, rule.getId());
        if (rule.getConditions() != null) {
            element.appendChild(CommonPolicyParser.elementFromConditions(document, rule.getConditions()));
        }
        if (rule.getActions() != null) {
            element.appendChild(PresRulesParser.elementFromActions(document, rule.getActions()));
        }
        if (rule.getTransformations() != null) {
            element.appendChild(PresRulesParser.elementFromTransfomations(document, rule.getTransformations()));
        }
        return element;
    }

    private static ConditionsType conditionsFromElement(Element element) throws Exception {
        ConditionsType conditions = new ConditionsType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !CONDITIONS_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("conditions element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("conditions element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("conditions element is invalid");
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (NAMESPACE.equals(namespaceUri)) {
                if (IDENTITY_ELEMENT.equals(localName)) {
                    conditions.getIdentities().add(CommonPolicyParser.identityFromElement(childElement));
                    continue;
                }
                if (SPHERE_ELEMENT.equals(localName)) {
                    conditions.getSpheres().add(CommonPolicyParser.sphereFromElement(childElement));
                    continue;
                }
                if (VALIDITY_ELEMENT.equals(localName)) {
                    conditions.getValidities().add(CommonPolicyParser.validityFromElement(childElement));
                    continue;
                }
                throw new Exception("conditions element is invalid");
            }
            conditions.getAny().add(childElement);
        }
        return conditions;
    }

    private static Element elementFromConditions(Document document, ConditionsType conditions) throws Exception {
        Element element = document.createElementNS(NAMESPACE, CONDITIONS_ELEMENT);
        for (IdentityType identity : conditions.getIdentities()) {
            element.appendChild(CommonPolicyParser.elementFromIdentity(document, identity));
        }
        for (SphereType sphere : conditions.getSpheres()) {
            element.appendChild(CommonPolicyParser.elementFromSphere(document, sphere));
        }
        for (ValidityType validity : conditions.getValidities()) {
            element.appendChild(CommonPolicyParser.elementFromValidity(document, validity));
        }
        XmlUtils.processAny(element, conditions.getAny());
        return element;
    }

    private static ValidityType validityFromElement(Element element) throws Exception {
        ValidityType validity = new ValidityType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !VALIDITY_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("validity element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("sphere element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("validity element is invalid");
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (!NAMESPACE.equals(namespaceUri)) {
                throw new Exception("sphere element is invalid");
            }
            if (VALIDITY_FROM_ELEMENT.equals(localName)) {
                validity.getFromList().add(childElement.getTextContent());
                continue;
            }
            if (VALIDITY_UNTIL_ELEMENT.equals(localName)) {
                validity.getUntilList().add(childElement.getTextContent());
                continue;
            }
            throw new Exception("sphere element is invalid");
        }
        return validity;
    }

    private static Element elementFromValidity(Document document, ValidityType validity) throws Exception {
        Element element = document.createElementNS(NAMESPACE, VALIDITY_ELEMENT);
        for (String from : validity.getFromList()) {
            Element fromElement = document.createElementNS(NAMESPACE, VALIDITY_FROM_ELEMENT);
            fromElement.setTextContent(from);
            element.appendChild(fromElement);
        }
        for (String until : validity.getUntilList()) {
            Element untilElement = document.createElementNS(NAMESPACE, VALIDITY_UNTIL_ELEMENT);
            untilElement.setTextContent(until);
            element.appendChild(untilElement);
        }
        return element;
    }

    private static SphereType sphereFromElement(Element element) throws Exception {
        SphereType sphere = new SphereType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !SPHERE_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("sphere element is invalid");
        }
        String value = null;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("sphere element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (!NAMESPACE.equals(namespaceUri) || !SPHERE_VALUE_ATTR.equals(attribute.getLocalName()) || value != null) {
                throw new Exception("sphere element is invalid");
            }
            value = attribute.getValue();
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            throw new Exception("sphere element is invalid");
        }
        if (value == null) {
            throw new Exception("sphere value attribute is missed");
        }
        sphere.setValue(value);
        return sphere;
    }

    private static Element elementFromSphere(Document document, SphereType sphere) throws Exception {
        Element element = document.createElementNS(NAMESPACE, SPHERE_ELEMENT);
        if (StringUtils.isEmpty((CharSequence)sphere.getValue())) {
            throw new Exception("sphere value attribute is missed");
        }
        element.setAttribute(SPHERE_VALUE_ATTR, sphere.getValue());
        return element;
    }

    private static IdentityType identityFromElement(Element element) throws Exception {
        IdentityType identity = new IdentityType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !IDENTITY_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("identity element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("identity element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("identity element is invalid");
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (NAMESPACE.equals(namespaceUri)) {
                if (ONE_ELEMENT.equals(localName)) {
                    identity.getOneList().add(CommonPolicyParser.oneFromElement(childElement));
                    continue;
                }
                if (MANY_ELEMENT.equals(localName)) {
                    identity.getManyList().add(CommonPolicyParser.manyFromElement(childElement));
                    continue;
                }
                throw new Exception("identity element is invalid");
            }
            identity.getAny().add(childElement);
        }
        return identity;
    }

    private static Element elementFromIdentity(Document document, IdentityType identity) throws Exception {
        Element element = document.createElementNS(NAMESPACE, IDENTITY_ELEMENT);
        for (OneType one : identity.getOneList()) {
            element.appendChild(CommonPolicyParser.elementFromOne(document, one));
        }
        for (ManyType many : identity.getManyList()) {
            element.appendChild(CommonPolicyParser.elementFromMany(document, many));
        }
        XmlUtils.processAny(element, identity.getAny());
        return element;
    }

    private static OneType oneFromElement(Element element) throws Exception {
        OneType one = new OneType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !ONE_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("one element is invalid");
        }
        String id = null;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("one element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (!NAMESPACE.equals(namespaceUri) || !ONE_ID_ATTR.equals(attribute.getLocalName()) || id != null) {
                throw new Exception("one element is invalid");
            }
            id = attribute.getValue();
        }
        Element any = null;
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            if (NAMESPACE.equals(namespaceUri) || any != null) {
                throw new Exception("one element is invalid");
            }
            any = childElement;
        }
        if (id == null) {
            throw new Exception("one id attribute is missed");
        }
        one.setId(id);
        one.setAny(any);
        return one;
    }

    private static Element elementFromOne(Document document, OneType one) throws Exception {
        Element element = document.createElementNS(NAMESPACE, ONE_ELEMENT);
        if (StringUtils.isEmpty((CharSequence)one.getId())) {
            throw new Exception("one id attribute is missed");
        }
        element.setAttribute(ONE_ID_ATTR, one.getId());
        if (one.getAny() != null) {
            ArrayList<Element> any = new ArrayList<Element>();
            any.add(one.getAny());
            XmlUtils.processAny(element, any);
        }
        return element;
    }

    private static ManyType manyFromElement(Element element) throws Exception {
        ManyType many = new ManyType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !MANY_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("many element is invalid");
        }
        String domain = null;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("many element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (!NAMESPACE.equals(namespaceUri) || !MANY_DOMAIN_ATTR.equals(attribute.getLocalName()) || domain != null) {
                throw new Exception("many element is invalid");
            }
            domain = attribute.getValue();
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)childElement);
            String localName = childElement.getLocalName();
            if (NAMESPACE.equals(namespaceUri)) {
                if (EXCEPT_ELEMENT.equals(localName)) {
                    many.getExcepts().add(CommonPolicyParser.exceptFromElement(childElement));
                    continue;
                }
                throw new Exception("many element is invalid");
            }
            many.getAny().add(childElement);
        }
        many.setDomain(domain);
        return many;
    }

    private static Element elementFromMany(Document document, ManyType many) throws Exception {
        Element element = document.createElementNS(NAMESPACE, MANY_ELEMENT);
        if (many.getDomain() != null) {
            element.setAttribute(MANY_DOMAIN_ATTR, many.getDomain());
        }
        for (ExceptType except : many.getExcepts()) {
            element.appendChild(CommonPolicyParser.elementFromExept(document, except));
        }
        XmlUtils.processAny(element, many.getAny());
        return element;
    }

    private static ExceptType exceptFromElement(Element element) throws Exception {
        ExceptType except = new ExceptType();
        if (!NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element)) || !EXCEPT_ELEMENT.equals(element.getLocalName())) {
            throw new Exception("except element is invalid");
        }
        String id = null;
        String domain = null;
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("except element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (!NAMESPACE.equals(namespaceUri)) {
                throw new Exception("except element is invalid");
            }
            if (EXCEPT_ID_ATTR.equals(attribute.getLocalName()) && id == null) {
                id = attribute.getValue();
                continue;
            }
            if (EXCEPT_DOMAIN_ATTR.equals(attribute.getLocalName()) && domain == null) {
                domain = attribute.getValue();
                continue;
            }
            throw new Exception("except element is invalid");
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            throw new Exception("except element is invalid");
        }
        except.setId(id);
        except.setDomain(domain);
        return except;
    }

    private static Element elementFromExept(Document document, ExceptType except) throws Exception {
        Element element = document.createElementNS(NAMESPACE, EXCEPT_ELEMENT);
        if (except.getId() != null) {
            element.setAttribute(EXCEPT_ID_ATTR, except.getId());
        }
        if (except.getDomain() != null) {
            element.setAttribute(EXCEPT_DOMAIN_ATTR, except.getDomain());
        }
        return element;
    }
}

