/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent;

import java.util.Map;
import javax.xml.namespace.QName;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.ParsingException;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.XmlUtils;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.ContentType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.DataType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.DescriptionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.EncodingType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.MimeType;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PresContentParser {
    private static String NAMESPACE = "urn:oma:xml:prs:pres-content";
    private static String CONTENT_ELEMENT = "content";
    private static String MIMETYPE_ELEMENT = "mime-type";
    private static String ENCODING_ELEMENT = "encoding";
    private static String DESCRIPTION_ELEMENT = "description";
    private static String DESCRIPTION_LANG_ATTR = "lang";
    private static String DATA_ELEMENT = "data";

    public static ContentType fromXml(String xml) throws ParsingException {
        if (StringUtils.isEmpty((CharSequence)xml)) {
            throw new IllegalArgumentException("XML cannot be null or empty");
        }
        try {
            ContentType content = new ContentType();
            Document document = XMLUtils.createDocument((String)xml);
            Element contentElement = document.getDocumentElement();
            if (!NAMESPACE.equals(contentElement.getNamespaceURI()) || !CONTENT_ELEMENT.equals(contentElement.getLocalName())) {
                throw new Exception("Document doesn't contain content element");
            }
            NamedNodeMap attributes = contentElement.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
                if (namespaceUri == null) {
                    throw new Exception("content element is invalid");
                }
                if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
                if (NAMESPACE.equals(namespaceUri)) {
                    throw new Exception("content element is invalid");
                }
                QName qName = new QName(namespaceUri, attribute.getLocalName(), attribute.getPrefix() == null ? "" : attribute.getPrefix());
                content.getAnyAttributes().put(qName, attribute.getValue());
            }
            NodeList childNodes = contentElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String namespaceUri = XMLUtils.getNamespaceUri((Node)element);
                if (namespaceUri == null) {
                    throw new Exception("content element is invalid");
                }
                String localName = node.getLocalName();
                if (NAMESPACE.equals(namespaceUri)) {
                    if (DATA_ELEMENT.equals(localName)) {
                        content.setData(PresContentParser.dataFromElement(element));
                        continue;
                    }
                    if (MIMETYPE_ELEMENT.equals(localName)) {
                        content.setMimeType(PresContentParser.mimeTypeFromElement(element));
                        continue;
                    }
                    if (ENCODING_ELEMENT.equals(localName)) {
                        content.setEncoding(PresContentParser.encodingFromElement(element));
                        continue;
                    }
                    if (DESCRIPTION_ELEMENT.equals(localName)) {
                        content.getDescription().add(PresContentParser.descriptionFromElement(element));
                        continue;
                    }
                    throw new Exception("content element is invalid");
                }
                content.getAny().add(element);
            }
            return content;
        }
        catch (Exception ex) {
            throw new ParsingException(ex);
        }
    }

    public static String toXml(ContentType content) throws ParsingException {
        if (content == null) {
            throw new IllegalArgumentException("pres-content cannot be null");
        }
        try {
            Document document = XMLUtils.createDocument();
            Element presContentElement = document.createElementNS(NAMESPACE, CONTENT_ELEMENT);
            if (content.getData() != null) {
                presContentElement.appendChild(PresContentParser.elementFromValue(document, DATA_ELEMENT, content.getData().getValue(), content.getData().getAnyAttributes()));
            }
            if (content.getEncoding() != null) {
                presContentElement.appendChild(PresContentParser.elementFromValue(document, ENCODING_ELEMENT, content.getEncoding().getValue(), content.getEncoding().getAnyAttributes()));
            }
            if (content.getMimeType() != null) {
                presContentElement.appendChild(PresContentParser.elementFromValue(document, MIMETYPE_ELEMENT, content.getMimeType().getValue(), content.getMimeType().getAnyAttributes()));
            }
            for (DescriptionType description : content.getDescription()) {
                presContentElement.appendChild(PresContentParser.elementFromDescription(document, description));
            }
            XmlUtils.processAnyAttributes(presContentElement, content.getAnyAttributes());
            XmlUtils.processAny(presContentElement, content.getAny());
            document.appendChild(presContentElement);
            return XMLUtils.createXml((Document)document);
        }
        catch (Exception ex) {
            throw new ParsingException(ex);
        }
    }

    private static Element elementFromValue(Document document, String nodeName, String value, Map<QName, String> anyAttributes) {
        Element element = document.createElementNS(NAMESPACE, nodeName);
        if (value != null) {
            element.setTextContent(value);
        }
        XmlUtils.processAnyAttributes(element, anyAttributes);
        return element;
    }

    private static Element elementFromDescription(Document document, DescriptionType description) throws Exception {
        Element element = document.createElementNS(NAMESPACE, DESCRIPTION_ELEMENT);
        if (description.getLang() != null) {
            element.setAttribute("xml:" + DESCRIPTION_LANG_ATTR, description.getLang());
        }
        if (description.getValue() != null) {
            element.setTextContent(description.getValue());
        }
        XmlUtils.processAnyAttributes(element, description.getAnyAttributes());
        return element;
    }

    private static DataType dataFromElement(Element element) throws Exception {
        DataType result = new DataType();
        if (!DATA_ELEMENT.equals(element.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element))) {
            throw new Exception("data element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("data element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (NAMESPACE.equals(namespaceUri)) {
                throw new Exception("data element is invalid");
            }
            QName qName = new QName(namespaceUri, attribute.getLocalName(), attribute.getPrefix() == null ? "" : attribute.getPrefix());
            result.getAnyAttributes().put(qName, attribute.getValue());
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            throw new Exception("data element is invalid");
        }
        result.setValue(element.getTextContent());
        return result;
    }

    private static EncodingType encodingFromElement(Element element) throws Exception {
        EncodingType result = new EncodingType();
        if (!ENCODING_ELEMENT.equals(element.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element))) {
            throw new Exception("encoding element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("encoding element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (NAMESPACE.equals(namespaceUri)) {
                throw new Exception("encoding element is invalid");
            }
            QName qName = new QName(namespaceUri, attribute.getLocalName(), attribute.getPrefix() == null ? "" : attribute.getPrefix());
            result.getAnyAttributes().put(qName, attribute.getValue());
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            throw new Exception("encoding element is invalid");
        }
        result.setValue(element.getTextContent());
        return result;
    }

    private static MimeType mimeTypeFromElement(Element element) throws Exception {
        MimeType result = new MimeType();
        if (!MIMETYPE_ELEMENT.equals(element.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element))) {
            throw new Exception("mime-type element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("mime-type element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri) || !NAMESPACE.equals(namespaceUri)) continue;
            throw new Exception("mime-type element is invalid");
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            throw new Exception("encoding element is invalid");
        }
        result.setValue(element.getTextContent());
        return result;
    }

    private static DescriptionType descriptionFromElement(Element element) throws Exception {
        DescriptionType result = new DescriptionType();
        if (!DESCRIPTION_ELEMENT.equals(element.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)element))) {
            throw new Exception("description element is invalid");
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("description element is invalid");
            }
            if (DESCRIPTION_LANG_ATTR.equals(attribute.getLocalName()) && "http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
                result.setLang(attribute.getValue());
                continue;
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (NAMESPACE.equals(namespaceUri)) {
                throw new Exception("description element is invalid");
            }
            QName qName = new QName(namespaceUri, attribute.getLocalName(), attribute.getPrefix() == null ? "" : attribute.getPrefix());
            result.getAnyAttributes().put(qName, attribute.getValue());
        }
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            throw new Exception("description element is invalid");
        }
        result.setValue(element.getTextContent());
        return result;
    }
}

