/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists;

import javax.xml.namespace.QName;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.ParsingException;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.XmlUtils;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.DisplayNameType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.EntryRefType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.EntryType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ExternalType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ListType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ResourceListsType;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ResourceListsParser {
    private static String NAMESPACE = "urn:ietf:params:xml:ns:resource-lists";
    private static String RESOURCE_LISTS_ELEMENT = "resource-lists";
    private static String LIST_ELEMENT = "list";
    private static String LIST_NAME_ATTR = "name";
    private static String ENTRY_ELEMENT = "entry";
    private static String ENTRY_URI_ATTR = "uri";
    private static String ENTRYREF_ELEMENT = "entry-ref";
    private static String ENTRYREF_REF_ATTR = "ref";
    private static String EXTERNAL_ELEMENT = "external";
    private static String EXTERNAL_ANCHOR_ATTR = "anchor";
    private static String DISPALY_NAME_ELEMENT = "display-name";
    private static String DISPALY_NAME_LANG_ATTR = "lang";

    private ResourceListsParser() {
    }

    public static ResourceListsType fromXml(String xml) throws ParsingException {
        if (StringUtils.isEmpty((CharSequence)xml)) {
            throw new IllegalArgumentException("XML cannot be null or empty");
        }
        try {
            ResourceListsType resourceLists = new ResourceListsType();
            Document document = XMLUtils.createDocument((String)xml);
            Element resourceListsElement = document.getDocumentElement();
            String localName = resourceListsElement.getLocalName();
            if (!NAMESPACE.equals(resourceListsElement.getNamespaceURI()) || !RESOURCE_LISTS_ELEMENT.equals(localName)) {
                throw new Exception("Document doesn't contain resource-lists element");
            }
            NamedNodeMap attributes = resourceListsElement.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
                if (namespaceUri == null) {
                    throw new Exception("resource-lists element is invalid");
                }
                if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
                throw new Exception("resource-lists element is invalid");
            }
            NodeList childNodes = resourceListsElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element listElement = (Element)node;
                resourceLists.getList().add(ResourceListsParser.listFromElement(listElement));
            }
            return resourceLists;
        }
        catch (Exception ex) {
            throw new ParsingException(ex);
        }
    }

    public static String toXml(ResourceListsType resourceLists) throws ParsingException {
        if (resourceLists == null) {
            throw new IllegalArgumentException("resource-lists cannot be null");
        }
        try {
            Document document = XMLUtils.createDocument();
            Element resourceListsElement = document.createElementNS(NAMESPACE, RESOURCE_LISTS_ELEMENT);
            for (ListType list : resourceLists.getList()) {
                resourceListsElement.appendChild(ResourceListsParser.elementFromList(document, list));
            }
            document.appendChild(resourceListsElement);
            return XMLUtils.createXml((Document)document);
        }
        catch (Exception ex) {
            throw new ParsingException(ex);
        }
    }

    private static ListType listFromElement(Element listElement) throws Exception {
        ListType list = new ListType();
        if (!LIST_ELEMENT.equals(listElement.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)listElement))) {
            throw new Exception("list element is invalid");
        }
        NamedNodeMap attributes = listElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("list element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (NAMESPACE.equals(namespaceUri)) {
                if (LIST_NAME_ATTR.equals(attribute.getLocalName())) {
                    list.setName(attribute.getValue());
                    continue;
                }
                throw new Exception("list element is invalid");
            }
            QName qName = new QName(namespaceUri, attribute.getLocalName(), attribute.getPrefix() == null ? "" : attribute.getPrefix());
            list.getAnyAttributes().put(qName, attribute.getValue());
        }
        NodeList childNodes = listElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String localName = element.getLocalName();
            String namespaceUri = XMLUtils.getNamespaceUri((Node)element);
            if (NAMESPACE.equals(namespaceUri)) {
                if (DISPALY_NAME_ELEMENT.equals(localName)) {
                    list.setDisplayName(ResourceListsParser.displayNameFromElement(element));
                    continue;
                }
                if (ENTRY_ELEMENT.equals(localName)) {
                    list.getEntries().add(ResourceListsParser.entryFromElement(element));
                    continue;
                }
                if (ENTRYREF_ELEMENT.equals(localName)) {
                    list.getEntryRefs().add(ResourceListsParser.entryRefFromElement(element));
                    continue;
                }
                if (LIST_ELEMENT.equals(localName)) {
                    list.getLists().add(ResourceListsParser.listFromElement(element));
                    continue;
                }
                if (EXTERNAL_ELEMENT.equals(localName)) {
                    list.getExternals().add(ResourceListsParser.externalFromElement(element));
                    continue;
                }
                throw new Exception("list element is invalid");
            }
            list.getAny().add(element);
        }
        return list;
    }

    private static Element elementFromList(Document document, ListType list) throws Exception {
        Element listElement = document.createElementNS(NAMESPACE, LIST_ELEMENT);
        if (list.getName() != null) {
            listElement.setAttribute(LIST_NAME_ATTR, list.getName());
        }
        if (list.getDisplayName() != null) {
            listElement.appendChild(ResourceListsParser.elementFromDisplayName(document, list.getDisplayName()));
        }
        for (EntryType entry : list.getEntries()) {
            listElement.appendChild(ResourceListsParser.elementFromEntry(document, entry));
        }
        for (EntryRefType entryRef : list.getEntryRefs()) {
            listElement.appendChild(ResourceListsParser.elementFromEntryRef(document, entryRef));
        }
        for (ListType subList : list.getLists()) {
            listElement.appendChild(ResourceListsParser.elementFromList(document, subList));
        }
        for (ExternalType external : list.getExternals()) {
            listElement.appendChild(ResourceListsParser.elementFromExternal(document, external));
        }
        XmlUtils.processAnyAttributes(listElement, list.getAnyAttributes());
        XmlUtils.processAny(listElement, list.getAny());
        return listElement;
    }

    private static Element elementFromEntry(Document document, EntryType entry) throws Exception {
        Element entryElement = document.createElementNS(NAMESPACE, ENTRY_ELEMENT);
        if (StringUtils.isEmpty((CharSequence)entry.getUri())) {
            throw new Exception("entry uri attribute is missed");
        }
        entryElement.setAttribute(ENTRY_URI_ATTR, entry.getUri());
        if (entry.getDisplayName() != null) {
            entryElement.appendChild(ResourceListsParser.elementFromDisplayName(document, entry.getDisplayName()));
        }
        XmlUtils.processAnyAttributes(entryElement, entry.getAnyAttributes());
        XmlUtils.processAny(entryElement, entry.getAny());
        return entryElement;
    }

    private static Element elementFromEntryRef(Document document, EntryRefType entryRef) throws Exception {
        Element entryRefElement = document.createElementNS(NAMESPACE, ENTRYREF_ELEMENT);
        if (StringUtils.isEmpty((CharSequence)entryRef.getRef())) {
            throw new Exception("entry-ref ref attribute is missed");
        }
        entryRefElement.setAttribute(ENTRYREF_REF_ATTR, entryRef.getRef());
        if (entryRef.getDisplayName() != null) {
            entryRefElement.appendChild(ResourceListsParser.elementFromDisplayName(document, entryRef.getDisplayName()));
        }
        XmlUtils.processAnyAttributes(entryRefElement, entryRef.getAnyAttributes());
        XmlUtils.processAny(entryRefElement, entryRef.getAny());
        return entryRefElement;
    }

    private static Element elementFromExternal(Document document, ExternalType external) throws Exception {
        Element externalElement = document.createElementNS(NAMESPACE, EXTERNAL_ELEMENT);
        if (StringUtils.isNotEmpty((CharSequence)external.getAnchor())) {
            externalElement.setAttribute(EXTERNAL_ANCHOR_ATTR, external.getAnchor());
        }
        if (external.getDisplayName() != null) {
            externalElement.appendChild(ResourceListsParser.elementFromDisplayName(document, external.getDisplayName()));
        }
        XmlUtils.processAnyAttributes(externalElement, external.getAnyAttributes());
        XmlUtils.processAny(externalElement, external.getAny());
        return externalElement;
    }

    private static Element elementFromDisplayName(Document document, DisplayNameType displayName) throws Exception {
        Element displayNameElement = document.createElementNS(NAMESPACE, DISPALY_NAME_ELEMENT);
        if (displayName.getLang() != null) {
            displayNameElement.setAttribute("xml:" + DISPALY_NAME_LANG_ATTR, displayName.getLang());
        }
        if (displayName.getValue() != null) {
            displayNameElement.setTextContent(displayName.getValue());
        }
        return displayNameElement;
    }

    private static EntryType entryFromElement(Element entryElement) throws Exception {
        EntryType entry = new EntryType();
        if (!ENTRY_ELEMENT.equals(entryElement.getNodeName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)entryElement))) {
            throw new Exception("entry element is invalid");
        }
        String uri = null;
        NamedNodeMap attributes = entryElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("entry element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (NAMESPACE.equals(namespaceUri)) {
                if (ENTRY_URI_ATTR.equals(attribute.getLocalName())) {
                    uri = attribute.getValue();
                    continue;
                }
                throw new Exception("entry element is invalid");
            }
            QName qName = new QName(namespaceUri, attribute.getLocalName(), attribute.getPrefix() == null ? "" : attribute.getPrefix());
            entry.getAnyAttributes().put(qName, attribute.getValue());
        }
        if (uri == null) {
            throw new Exception("entry uri attribute is missed");
        }
        entry.setUri(uri);
        NodeList childNodes = entryElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)element);
            if (namespaceUri == null) {
                throw new Exception("entry element is invalid");
            }
            if (NAMESPACE.equals(namespaceUri)) {
                if (DISPALY_NAME_ELEMENT.equals(element.getLocalName())) {
                    entry.setDisplayName(ResourceListsParser.displayNameFromElement(element));
                    continue;
                }
                throw new Exception("entry element is invalid");
            }
            entry.getAny().add(element);
        }
        return entry;
    }

    private static EntryRefType entryRefFromElement(Element entryRefElement) throws Exception {
        EntryRefType entryRef = new EntryRefType();
        if (!ENTRYREF_ELEMENT.equals(entryRefElement.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)entryRefElement))) {
            throw new Exception("entry-ref element is invalid");
        }
        String ref = null;
        NamedNodeMap attributes = entryRefElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("entry-ref element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (NAMESPACE.equals(namespaceUri)) {
                if (ENTRYREF_REF_ATTR.equals(attribute.getLocalName())) {
                    ref = attribute.getValue();
                    continue;
                }
                throw new Exception("entry-ref element is invalid");
            }
            QName qName = new QName(attribute.getNamespaceURI(), attribute.getName(), attribute.getPrefix() == null ? "" : attribute.getPrefix());
            entryRef.getAnyAttributes().put(qName, attribute.getValue());
        }
        if (ref == null) {
            throw new Exception("entry-ref ref attribute is missed");
        }
        entryRef.setRef(ref);
        NodeList childNodes = entryRefElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)element);
            if (namespaceUri == null) {
                throw new Exception("entry-ref element is invalid");
            }
            if (NAMESPACE.equals(namespaceUri)) {
                if (DISPALY_NAME_ELEMENT.equals(element.getLocalName())) {
                    entryRef.setDisplayName(ResourceListsParser.displayNameFromElement(element));
                    continue;
                }
                throw new Exception("entry-ref element is invalid");
            }
            entryRef.getAny().add(element);
        }
        return entryRef;
    }

    private static ExternalType externalFromElement(Element entryElement) throws Exception {
        ExternalType external = new ExternalType();
        if (!EXTERNAL_ELEMENT.equals(entryElement.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)entryElement))) {
            throw new Exception("external element is invalid");
        }
        NamedNodeMap attributes = entryElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("external element is invalid");
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            if (NAMESPACE.equals(namespaceUri)) {
                if (EXTERNAL_ANCHOR_ATTR.equals(attribute.getLocalName())) {
                    external.setAnchor(attribute.getValue());
                    continue;
                }
                throw new Exception("external element is invalid");
            }
            QName qName = new QName(attribute.getNamespaceURI(), attribute.getName(), attribute.getPrefix() == null ? "" : attribute.getPrefix());
            external.getAnyAttributes().put(qName, attribute.getValue());
        }
        NodeList childNodes = entryElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)element);
            if (namespaceUri == null) {
                throw new Exception("external element is invalid");
            }
            if (NAMESPACE.equals(namespaceUri)) {
                if (DISPALY_NAME_ELEMENT.equals(element.getLocalName())) {
                    external.setDisplayName(ResourceListsParser.displayNameFromElement(element));
                    continue;
                }
                throw new Exception("external element is invalid");
            }
            external.getAny().add(element);
        }
        return external;
    }

    private static DisplayNameType displayNameFromElement(Element displayNameElement) throws Exception {
        DisplayNameType displayName = new DisplayNameType();
        if (!DISPALY_NAME_ELEMENT.equals(displayNameElement.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)displayNameElement))) {
            throw new Exception("display-name element is invalid");
        }
        NamedNodeMap attributes = displayNameElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri == null) {
                throw new Exception("display-name element is invalid");
            }
            if (DISPALY_NAME_LANG_ATTR.equals(attribute.getLocalName()) && "http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
                displayName.setLang(attribute.getValue());
                continue;
            }
            if (XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("display-name element is invalid");
        }
        NodeList childNodes = displayNameElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            throw new Exception("display-name element is invalid");
        }
        displayName.setValue(displayNameElement.getTextContent());
        return displayName;
    }
}

