/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps;

import net.java.sip.communicator.impl.protocol.sip.xcap.model.ParsingException;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.AuidsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.ExtensionsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.NamespacesType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.xcapcaps.XCapCapsType;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XCapCapsParser {
    private static final String NAMESPACE = "urn:ietf:params:xml:ns:xcap-caps";
    private static String XCAPCAPS_ELEMENT = "xcap-caps";
    private static String AUIDS_ELEMENT = "auids";
    private static String AUID_ELEMENT = "auid";
    private static String NAMESPACES_ELEMENT = "namespaces";
    private static String NAMESPACE_ELEMENT = "namespace";
    private static String EXTENSIONS_ELEMENT = "extensions";
    private static String EXTENSION_ELEMENT = "extension";

    public static XCapCapsType fromXml(String xml) throws ParsingException {
        if (StringUtils.isEmpty((CharSequence)xml)) {
            throw new IllegalArgumentException("XML cannot be null or empty");
        }
        try {
            XCapCapsType xCapCaps = new XCapCapsType();
            Document document = XMLUtils.createDocument((String)xml);
            Element xCapCapsElement = document.getDocumentElement();
            if (XCAPCAPS_ELEMENT.equals(xCapCapsElement.getLocalName()) && !NAMESPACE.equals(xCapCapsElement.getNamespaceURI())) {
                throw new Exception("Document doesn't contain xcap-caps element");
            }
            boolean auidsFound = false;
            boolean namespacesFound = false;
            NamedNodeMap attributes = xCapCapsElement.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
                if (namespaceUri != null && XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
                throw new Exception("xcap-caps element is invalid");
            }
            NodeList childNodes = xCapCapsElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String namespaceUri = XMLUtils.getNamespaceUri((Node)element);
                if (namespaceUri == null) {
                    throw new Exception("xcap-caps element is invalid");
                }
                String localName = node.getLocalName();
                if (NAMESPACE.equals(namespaceUri)) {
                    if (AUIDS_ELEMENT.equals(localName)) {
                        xCapCaps.setAuids(XCapCapsParser.auidsFromElement(element));
                        auidsFound = true;
                        continue;
                    }
                    if (NAMESPACES_ELEMENT.equals(localName)) {
                        xCapCaps.setNamespaces(XCapCapsParser.namespacesFromElement(element));
                        namespacesFound = true;
                        continue;
                    }
                    if (EXTENSIONS_ELEMENT.equals(localName)) {
                        xCapCaps.setExtensions(XCapCapsParser.extensionsFromElement(element));
                        continue;
                    }
                    throw new Exception("xcap-caps element is invalid");
                }
                xCapCaps.getAny().add(element);
            }
            if (!auidsFound) {
                throw new ParsingException("xcap-caps auids element is missed");
            }
            if (!namespacesFound) {
                throw new ParsingException("xcap-caps namespaces element is missed");
            }
            return xCapCaps;
        }
        catch (Exception ex) {
            throw new ParsingException(ex);
        }
    }

    private static AuidsType auidsFromElement(Element auidsElement) throws Exception {
        AuidsType auidsType = new AuidsType();
        if (!AUIDS_ELEMENT.equals(auidsElement.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)auidsElement))) {
            throw new Exception("auids element is invalid");
        }
        NamedNodeMap attributes = auidsElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri != null && XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("auids element is invalid");
        }
        NodeList childNodes = auidsElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)element);
            if (namespaceUri == null) {
                throw new Exception("auids element is invalid");
            }
            if (NAMESPACE.equals(namespaceUri) && AUID_ELEMENT.equals(element.getLocalName())) {
                auidsType.getAuid().add(element.getTextContent());
                continue;
            }
            throw new Exception("auids element is invalid");
        }
        return auidsType;
    }

    private static NamespacesType namespacesFromElement(Element namespacesElement) throws Exception {
        NamespacesType namespaces = new NamespacesType();
        if (!NAMESPACES_ELEMENT.equals(namespacesElement.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)namespacesElement))) {
            throw new Exception("namespaces element is invalid");
        }
        NamedNodeMap attributes = namespacesElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri != null && XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("namespaces element is invalid");
        }
        NodeList childNodes = namespacesElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)element);
            if (namespaceUri == null) {
                throw new Exception("namespaces element is invalid");
            }
            if (NAMESPACE.equals(namespaceUri) && NAMESPACE_ELEMENT.equals(element.getLocalName())) {
                namespaces.getNamespace().add(element.getTextContent());
                continue;
            }
            throw new Exception("namespaces element is invalid");
        }
        return namespaces;
    }

    private static ExtensionsType extensionsFromElement(Element extensionsElement) throws Exception {
        ExtensionsType extensions = new ExtensionsType();
        if (!EXTENSIONS_ELEMENT.equals(extensionsElement.getLocalName()) || !NAMESPACE.equals(XMLUtils.getNamespaceUri((Node)extensionsElement))) {
            throw new Exception("extensions element is invalid");
        }
        NamedNodeMap attributes = extensionsElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String namespaceUri = XMLUtils.getNamespaceUri((Node)attribute);
            if (namespaceUri != null && XMLUtils.isStandartXmlNamespace((String)namespaceUri)) continue;
            throw new Exception("extensions element is invalid");
        }
        NodeList childNodes = extensionsElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String namespaceUri = XMLUtils.getNamespaceUri((Node)element);
            if (namespaceUri == null) {
                throw new Exception("extensions element is invalid");
            }
            if (NAMESPACE.equals(namespaceUri) && EXTENSION_ELEMENT.equals(element.getLocalName())) {
                extensions.getExtension().add(element.getTextContent());
                continue;
            }
            throw new Exception("extensions element is invalid");
        }
        return extensions;
    }
}

