/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.youtube;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.util.Logger;

public class ReplacementServiceYoutubeImpl
implements ReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceYoutubeImpl.class);
    public static final String YOUTUBE_PATTERN = "(https?\\:\\/\\/(www\\.)*?youtube\\.com\\/watch\\?v=([a-zA-Z0-9_\\-]+))([?&]\\w+=[\\w-]+)*";
    public static final String YOUTUBE_CONFIG_LABEL = "YouTube";
    public static final String SOURCE_NAME = "YOUTUBE";

    public ReplacementServiceYoutubeImpl() {
        logger.trace((Object)"Creating a Youtube Source.");
    }

    public String getReplacement(String sourceString) {
        String pattern = "https?:\\/\\/(?:[0-9A-Z-]+\\.)?(?:youtu\\.be\\/|youtube\\.com\\S*[^\\w\\-\\s])([\\w\\-]{11})(?=[^\\w\\-]|$)(?![?=&+%\\w]*(?:['\"][^<>]*>|<\\/a>))[?=&+%\\w]*";
        Pattern compiledPattern = Pattern.compile("https?:\\/\\/(?:[0-9A-Z-]+\\.)?(?:youtu\\.be\\/|youtube\\.com\\S*[^\\w\\-\\s])([\\w\\-]{11})(?=[^\\w\\-]|$)(?![?=&+%\\w]*(?:['\"][^<>]*>|<\\/a>))[?=&+%\\w]*", 2);
        Matcher matcher = compiledPattern.matcher(sourceString);
        String thumbUrl = sourceString;
        while (matcher.find()) {
            String videoID = "";
            try {
                videoID = matcher.group(1);
            }
            catch (Exception e) {
                logger.debug((Object)("Replacement failed for " + this.getSourceName()), (Throwable)e);
                return thumbUrl;
            }
            thumbUrl = "https://img.youtube.com/vi/" + videoID + "/3.jpg";
        }
        return thumbUrl;
    }

    public String getSourceName() {
        return SOURCE_NAME;
    }

    public String getPattern() {
        return YOUTUBE_PATTERN;
    }
}

