/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.generalconfig;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.generalconfig.GeneralConfigPluginActivator;
import net.java.sip.communicator.plugin.generalconfig.Resources;
import net.java.sip.communicator.plugin.generalconfig.WindowsStartup;
import net.java.sip.communicator.plugin.generalconfig.autoaway.AutoAwayConfigurationPanel;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.resources.LanguagePack;
import net.java.sip.communicator.service.systray.PopupMessageHandler;
import net.java.sip.communicator.service.systray.SystrayService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import net.java.sip.communicator.util.UtilActivator;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class GeneralConfigurationPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private final Logger logger = Logger.getLogger(GeneralConfigurationPanel.class);
    private static final String STARTUP_CONFIG_DISABLED_PROP = "net.java.sip.communicator.plugin.generalconfig.startupconfig.DISABLED";
    private static final String MESSAGE_CONFIG_DISABLED_PROP = "net.java.sip.communicator.plugin.generalconfig.messageconfig.DISABLED";
    private static final String AUTO_AWAY_CONFIG_DISABLED_PROP = "net.java.sip.communicator.plugin.generalconfig.autoawayconfig.DISABLED";
    private static final String NOTIFICATION_CONFIG_DISABLED_PROP = "net.java.sip.communicator.plugin.generalconfig.notificationconfig.DISABLED";
    private static final String LOCALE_CONFIG_DISABLED_PROP = "net.java.sip.communicator.plugin.generalconfig.localeconfig.DISABLED";
    private static final String SYSTRAY_CONFIG_DISABLED_PROP = "net.java.sip.communicator.plugin.generalconfig.systrayconfig.DISABLED";
    private static final String CALL_CONFIG_DISABLED_PROP = "net.java.sip.communicator.plugin.generalconfig.callconfig.DISABLED";

    public GeneralConfigurationPanel() {
        super((LayoutManager)new BorderLayout());
        Component notifConfigPanel;
        Component startupConfigPanel;
        TransparentPanel mainPanel = new TransparentPanel();
        BoxLayout boxLayout = new BoxLayout((Container)mainPanel, 1);
        mainPanel.setLayout((LayoutManager)boxLayout);
        mainPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        final JScrollPane scroller = new JScrollPane((Component)mainPanel);
        scroller.setOpaque(false);
        scroller.getViewport().setOpaque(false);
        scroller.setPreferredSize(new Dimension(500, 420));
        scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add(scroller, "Center");
        if (!GeneralConfigPluginActivator.getConfigurationService().getBoolean(STARTUP_CONFIG_DISABLED_PROP, false) && (startupConfigPanel = this.createStartupConfigPanel()) != null) {
            mainPanel.add(startupConfigPanel);
            mainPanel.add(Box.createVerticalStrut(10));
        }
        if (!GeneralConfigPluginActivator.getConfigurationService().getBoolean(MESSAGE_CONFIG_DISABLED_PROP, false)) {
            mainPanel.add(this.createMessageConfigPanel());
            mainPanel.add(Box.createVerticalStrut(10));
        }
        if (!GeneralConfigPluginActivator.getConfigurationService().getBoolean(AUTO_AWAY_CONFIG_DISABLED_PROP, false)) {
            mainPanel.add((Component)((Object)new AutoAwayConfigurationPanel()));
            mainPanel.add(Box.createVerticalStrut(10));
        }
        if (!GeneralConfigPluginActivator.getConfigurationService().getBoolean(NOTIFICATION_CONFIG_DISABLED_PROP, false) && (notifConfigPanel = this.createNotificationConfigPanel()) != null) {
            mainPanel.add(notifConfigPanel);
            mainPanel.add(Box.createVerticalStrut(10));
        }
        if (!GeneralConfigPluginActivator.getConfigurationService().getBoolean(LOCALE_CONFIG_DISABLED_PROP, false)) {
            mainPanel.add(this.createLocaleConfigPanel());
            mainPanel.add(Box.createVerticalStrut(10));
        }
        if (!GeneralConfigPluginActivator.getConfigurationService().getBoolean(SYSTRAY_CONFIG_DISABLED_PROP, false)) {
            mainPanel.add(this.createSystrayeConfigPanel());
            mainPanel.add(Box.createVerticalStrut(10));
        }
        if (!GeneralConfigPluginActivator.getConfigurationService().getBoolean(CALL_CONFIG_DISABLED_PROP, false)) {
            mainPanel.add(this.createCallConfigPanel());
            mainPanel.add(Box.createVerticalStrut(10));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                scroller.getVerticalScrollBar().setValue(0);
                scroller.revalidate();
                scroller.repaint();
            }
        });
    }

    private String getApplicationName() {
        return Resources.getSettingsString("service.gui.APPLICATION_NAME");
    }

    private Component createAutoStartCheckBox() {
        SIPCommCheckBox autoStartCheckBox = new SIPCommCheckBox();
        String label = Resources.getString("plugin.generalconfig.AUTO_START", new String[]{this.getApplicationName()});
        autoStartCheckBox.setText(label);
        autoStartCheckBox.setToolTipText(label);
        autoStartCheckBox.addActionListener(new ActionListener((JCheckBox)autoStartCheckBox){
            final /* synthetic */ JCheckBox val$autoStartCheckBox;
            {
                this.val$autoStartCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GeneralConfigurationPanel.this.setAutostart(this.val$autoStartCheckBox.isSelected());
                }
                catch (Exception ex) {
                    GeneralConfigurationPanel.this.logger.error((Object)"Cannot create/delete startup shortcut", (Throwable)ex);
                }
            }
        });
        try {
            autoStartCheckBox.setSelected(WindowsStartup.isStartupEnabled(this.getApplicationName()));
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return autoStartCheckBox;
    }

    public Component createMinimzeInsteadOfHideCheckBox() {
        SIPCommCheckBox chk = new SIPCommCheckBox();
        chk.setText(Resources.getString("plugin.generalconfig.MINIMIZE_NOT_HIDE"));
        chk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean value = ((JCheckBox)e.getSource()).isSelected();
                ConfigurationUtils.setIsMinimizeInsteadOfHide((boolean)value);
                UtilActivator.getUIService().setMainWindowCanHide(UtilActivator.getSystrayService().checkInitialized());
            }
        });
        chk.setSelected(ConfigurationUtils.isMinimizeInsteadOfHide());
        return chk;
    }

    private Component createMessageConfigPanel() {
        JPanel configPanel = GeneralConfigPluginActivator.createConfigSectionComponent(Resources.getString("service.gui.MESSAGE"));
        configPanel.add(this.createGroupMessagesCheckbox());
        configPanel.add(this.createHistoryPanel());
        configPanel.add(this.createSendMessagePanel());
        configPanel.add(this.createTypingNitificationsCheckBox());
        configPanel.add(this.createBringToFrontCheckBox());
        configPanel.add(this.createChatAlertsOnMessageCheckbox());
        configPanel.add(this.createMultichatCheckbox());
        configPanel.add(this.createRecentMessagesCheckbox());
        return configPanel;
    }

    private Component createGroupMessagesCheckbox() {
        SIPCommCheckBox groupMessagesCheckBox = new SIPCommCheckBox();
        groupMessagesCheckBox.setText(Resources.getString("plugin.generalconfig.GROUP_CHAT_MESSAGES"));
        groupMessagesCheckBox.setAlignmentX(0.0f);
        groupMessagesCheckBox.setSelected(ConfigurationUtils.isMultiChatWindowEnabled());
        groupMessagesCheckBox.addActionListener(new ActionListener((JCheckBox)groupMessagesCheckBox){
            final /* synthetic */ JCheckBox val$groupMessagesCheckBox;
            {
                this.val$groupMessagesCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationUtils.setMultiChatWindowEnabled((boolean)this.val$groupMessagesCheckBox.isSelected());
            }
        });
        return groupMessagesCheckBox;
    }

    private Component createChatAlertsOnMessageCheckbox() {
        SIPCommCheckBox chatAlertOnMessageCheckBox = new SIPCommCheckBox();
        chatAlertOnMessageCheckBox.setText(Resources.getString("plugin.generalconfig.CHATALERTS_ON_MESSAGE"));
        chatAlertOnMessageCheckBox.setAlignmentX(0.0f);
        chatAlertOnMessageCheckBox.setSelected(ConfigurationUtils.isAlerterEnabled());
        chatAlertOnMessageCheckBox.addActionListener(new ActionListener((JCheckBox)chatAlertOnMessageCheckBox){
            final /* synthetic */ JCheckBox val$chatAlertOnMessageCheckBox;
            {
                this.val$chatAlertOnMessageCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationUtils.setAlerterEnabled((boolean)this.val$chatAlertOnMessageCheckBox.isSelected());
            }
        });
        return chatAlertOnMessageCheckBox;
    }

    private Component createMultichatCheckbox() {
        SIPCommCheckBox leaveChatroomCheckBox = new SIPCommCheckBox();
        leaveChatroomCheckBox.setText(Resources.getString("plugin.generalconfig.LEAVE_CHATROOM_ON_WINDOW_CLOSE"));
        leaveChatroomCheckBox.setAlignmentX(0.0f);
        leaveChatroomCheckBox.setSelected(ConfigurationUtils.isLeaveChatRoomOnWindowCloseEnabled());
        leaveChatroomCheckBox.addActionListener(new ActionListener((JCheckBox)leaveChatroomCheckBox){
            final /* synthetic */ JCheckBox val$leaveChatroomCheckBox;
            {
                this.val$leaveChatroomCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationUtils.setLeaveChatRoomOnWindowClose((boolean)this.val$leaveChatroomCheckBox.isSelected());
            }
        });
        return leaveChatroomCheckBox;
    }

    private Component createRecentMessagesCheckbox() {
        SIPCommCheckBox recentMessagesCheckBox = new SIPCommCheckBox();
        recentMessagesCheckBox.setText(Resources.getString("plugin.generalconfig.SHOW_RECENT_MESSAGES"));
        recentMessagesCheckBox.setAlignmentX(0.0f);
        recentMessagesCheckBox.setSelected(ConfigurationUtils.isRecentMessagesShown());
        recentMessagesCheckBox.addActionListener(new ActionListener((JCheckBox)recentMessagesCheckBox){
            final /* synthetic */ JCheckBox val$recentMessagesCheckBox;
            {
                this.val$recentMessagesCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationUtils.setRecentMessagesShown((boolean)this.val$recentMessagesCheckBox.isSelected());
            }
        });
        return recentMessagesCheckBox;
    }

    private Component createHistoryPanel() {
        TransparentPanel logHistoryPanel = new TransparentPanel();
        logHistoryPanel.setLayout(new BorderLayout());
        logHistoryPanel.setAlignmentX(0.0f);
        SIPCommCheckBox logHistoryCheckBox = new SIPCommCheckBox();
        logHistoryPanel.add((Component)logHistoryCheckBox, "North");
        final MessageHistoryService mhs = GeneralConfigPluginActivator.getMessageHistoryService();
        logHistoryCheckBox.setText(Resources.getString("plugin.generalconfig.LOG_HISTORY"));
        logHistoryCheckBox.setSelected(mhs.isHistoryLoggingEnabled());
        logHistoryCheckBox.addActionListener(new ActionListener((JCheckBox)logHistoryCheckBox){
            final /* synthetic */ JCheckBox val$logHistoryCheckBox;
            {
                this.val$logHistoryCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                mhs.setHistoryLoggingEnabled(this.val$logHistoryCheckBox.isSelected());
            }
        });
        GeneralConfigPluginActivator.getConfigurationService().addPropertyChangeListener("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED", new PropertyChangeListener((JCheckBox)logHistoryCheckBox, mhs){
            final /* synthetic */ JCheckBox val$logHistoryCheckBox;
            final /* synthetic */ MessageHistoryService val$mhs;
            {
                this.val$logHistoryCheckBox = jCheckBox;
                this.val$mhs = messageHistoryService;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.val$logHistoryCheckBox.setSelected(this.val$mhs.isHistoryLoggingEnabled());
            }
        });
        TransparentPanel showHistoryPanel = new TransparentPanel();
        showHistoryPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        logHistoryPanel.add((Component)showHistoryPanel, "South");
        SIPCommCheckBox showHistoryCheckBox = new SIPCommCheckBox();
        showHistoryPanel.add((Component)showHistoryCheckBox);
        showHistoryCheckBox.setText(Resources.getString("plugin.generalconfig.SHOW_HISTORY"));
        showHistoryCheckBox.setSelected(ConfigurationUtils.isHistoryShown());
        showHistoryCheckBox.addActionListener(new ActionListener((JCheckBox)showHistoryCheckBox){
            final /* synthetic */ JCheckBox val$showHistoryCheckBox;
            {
                this.val$showHistoryCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationUtils.setHistoryShown((boolean)this.val$showHistoryCheckBox.isSelected());
            }
        });
        SpinnerNumberModel historySizeSpinnerModel = new SpinnerNumberModel(0, 0, 140, 1);
        final JSpinner historySizeSpinner = new JSpinner();
        showHistoryPanel.add(historySizeSpinner);
        historySizeSpinner.setModel(historySizeSpinnerModel);
        historySizeSpinner.setValue(ConfigurationUtils.getChatHistorySize());
        logHistoryCheckBox.addChangeListener(new ChangeListener((JCheckBox)showHistoryCheckBox, (JCheckBox)logHistoryCheckBox, historySizeSpinner){
            final /* synthetic */ JCheckBox val$showHistoryCheckBox;
            final /* synthetic */ JCheckBox val$logHistoryCheckBox;
            final /* synthetic */ JSpinner val$historySizeSpinner;
            {
                this.val$showHistoryCheckBox = jCheckBox;
                this.val$logHistoryCheckBox = jCheckBox2;
                this.val$historySizeSpinner = jSpinner;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.val$showHistoryCheckBox.setEnabled(this.val$logHistoryCheckBox.isSelected());
                this.val$historySizeSpinner.setEnabled(this.val$logHistoryCheckBox.isSelected());
            }
        });
        showHistoryCheckBox.addChangeListener(new ChangeListener((JCheckBox)showHistoryCheckBox){
            final /* synthetic */ JCheckBox val$showHistoryCheckBox;
            {
                this.val$showHistoryCheckBox = jCheckBox;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                historySizeSpinner.setEnabled(this.val$showHistoryCheckBox.isSelected());
            }
        });
        historySizeSpinnerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConfigurationUtils.setChatHistorySize((int)((Integer)historySizeSpinner.getValue()));
            }
        });
        JLabel historySizeLabel = new JLabel();
        showHistoryPanel.add(historySizeLabel);
        historySizeLabel.setText(Resources.getString("plugin.generalconfig.HISTORY_SIZE"));
        if (!mhs.isHistoryLoggingEnabled()) {
            showHistoryCheckBox.setEnabled(false);
            historySizeSpinner.setEnabled(false);
        }
        if (!ConfigurationUtils.isHistoryShown()) {
            historySizeSpinner.setEnabled(false);
        }
        return logHistoryPanel;
    }

    private Component createSendMessagePanel() {
        TransparentPanel sendMessagePanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        sendMessagePanel.setAlignmentX(0.0f);
        JLabel sendMessageLabel = new JLabel();
        sendMessagePanel.add((Component)sendMessageLabel, (Object)"West");
        sendMessageLabel.setText(Resources.getString("plugin.generalconfig.SEND_MESSAGES_WITH"));
        DefaultComboBoxModel<String> sendMessageComboBoxModel = new DefaultComboBoxModel<String>(new String[]{"Enter", "Ctrl-Enter"});
        final JComboBox<String> sendMessageComboBox = new JComboBox<String>();
        sendMessagePanel.add(sendMessageComboBox);
        sendMessageComboBox.setModel(sendMessageComboBoxModel);
        sendMessageComboBox.setSelectedItem(ConfigurationUtils.getSendMessageCommand());
        sendMessageComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                ConfigurationUtils.setSendMessageCommand((String)((String)sendMessageComboBox.getSelectedItem()));
            }
        });
        return sendMessagePanel;
    }

    private Component createTypingNitificationsCheckBox() {
        SIPCommCheckBox enableTypingNotifiCheckBox = new SIPCommCheckBox();
        enableTypingNotifiCheckBox.setLayout(null);
        enableTypingNotifiCheckBox.setAlignmentX(0.0f);
        enableTypingNotifiCheckBox.setText(Resources.getString("service.gui.ENABLE_TYPING_NOTIFICATIONS"));
        enableTypingNotifiCheckBox.setPreferredSize(new Dimension(253, 20));
        enableTypingNotifiCheckBox.setSelected(ConfigurationUtils.isSendTypingNotifications());
        enableTypingNotifiCheckBox.addActionListener(new ActionListener((JCheckBox)enableTypingNotifiCheckBox){
            final /* synthetic */ JCheckBox val$enableTypingNotifiCheckBox;
            {
                this.val$enableTypingNotifiCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationUtils.setSendTypingNotifications((boolean)this.val$enableTypingNotifiCheckBox.isSelected());
            }
        });
        return enableTypingNotifiCheckBox;
    }

    private Component createBringToFrontCheckBox() {
        SIPCommCheckBox bringToFrontCheckBox = new SIPCommCheckBox();
        bringToFrontCheckBox.setText(Resources.getString("plugin.generalconfig.BRING_WINDOW_TO_FRONT"));
        bringToFrontCheckBox.setAlignmentX(0.0f);
        bringToFrontCheckBox.setSelected(ConfigurationUtils.isAutoPopupNewMessage());
        bringToFrontCheckBox.addActionListener(new ActionListener((JCheckBox)bringToFrontCheckBox){
            final /* synthetic */ JCheckBox val$bringToFrontCheckBox;
            {
                this.val$bringToFrontCheckBox = jCheckBox;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationUtils.setAutoPopupNewMessage((boolean)this.val$bringToFrontCheckBox.isSelected());
            }
        });
        return bringToFrontCheckBox;
    }

    private Component createNotificationConfigPanel() {
        ServiceReference[] handlerRefs = null;
        BundleContext bc = GeneralConfigPluginActivator.bundleContext;
        try {
            handlerRefs = bc.getServiceReferences(PopupMessageHandler.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            this.logger.warn((Object)"Error while retrieving service refs", (Throwable)ex);
        }
        if (handlerRefs == null) {
            return null;
        }
        JPanel notifConfigPanel = GeneralConfigPluginActivator.createConfigSectionComponent(Resources.getString("plugin.notificationconfig.POPUP_NOTIF_HANDLER"));
        final JComboBox<Object> notifConfigComboBox = new JComboBox<Object>();
        String configuredHandler = (String)GeneralConfigPluginActivator.getConfigurationService().getProperty("systray.POPUP_HANDLER");
        for (ServiceReference ref : handlerRefs) {
            PopupMessageHandler handler = (PopupMessageHandler)bc.getService(ref);
            notifConfigComboBox.addItem(handler);
            if (configuredHandler == null || !configuredHandler.equals(handler.getClass().getName())) continue;
            notifConfigComboBox.setSelectedItem(handler);
        }
        String auto = "Auto";
        notifConfigComboBox.addItem(auto);
        if (configuredHandler == null) {
            notifConfigComboBox.setSelectedItem(auto);
        }
        notifConfigComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (notifConfigComboBox.getSelectedItem() instanceof String) {
                    ConfigurationUtils.setPopupHandlerConfig(null);
                    GeneralConfigPluginActivator.getSystrayService().selectBestPopupMessageHandler();
                } else {
                    PopupMessageHandler handler = (PopupMessageHandler)notifConfigComboBox.getSelectedItem();
                    ConfigurationUtils.setPopupHandlerConfig((String)handler.getClass().getName());
                    GeneralConfigPluginActivator.getSystrayService().setActivePopupMessageHandler(handler);
                }
            }
        });
        notifConfigPanel.add(notifConfigComboBox);
        return notifConfigPanel;
    }

    private Component createLocaleConfigPanel() {
        JPanel localeConfigPanel = GeneralConfigPluginActivator.createConfigSectionComponent(Resources.getString("plugin.generalconfig.DEFAULT_LANGUAGE"));
        LanguagePack lp = (LanguagePack)ServiceUtils.getService((BundleContext)GeneralConfigPluginActivator.bundleContext, LanguagePack.class);
        Map defaultRes = lp.getResources(Locale.ENGLISH);
        Locale currentLocale = ConfigurationUtils.getCurrentLanguage();
        LocaleItem currentLocaleItem = null;
        ArrayList<LocaleItem> languages = new ArrayList<LocaleItem>();
        Iterator iter = Resources.getResources().getAvailableLocales();
        while (iter.hasNext()) {
            Locale locale = (Locale)iter.next();
            Set res = lp.getResourceKeys(locale);
            int count = 0;
            for (String key : defaultRes.keySet()) {
                if (!res.contains(key)) continue;
                ++count;
            }
            LocaleItem li = new LocaleItem(locale, count * 100 / defaultRes.size());
            languages.add(li);
            if (!locale.equals(currentLocale)) continue;
            currentLocaleItem = li;
        }
        Collections.sort(languages);
        final JComboBox<LocaleItem> localesConfigComboBox = new JComboBox<LocaleItem>();
        localesConfigComboBox.setRenderer(new LanguageDropDownRenderer());
        for (LocaleItem li : languages) {
            localesConfigComboBox.addItem(li);
        }
        localesConfigComboBox.setSelectedItem(currentLocaleItem);
        localesConfigComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralConfigPluginActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)Resources.getString("plugin.generalconfig.DEFAULT_LANGUAGE_RESTART_WARN"));
                LocaleItem li = (LocaleItem)localesConfigComboBox.getSelectedItem();
                ConfigurationUtils.setLanguage((Locale)li.locale);
            }
        });
        localeConfigPanel.add(localesConfigComboBox);
        String label = "* " + Resources.getString("plugin.generalconfig.DEFAULT_LANGUAGE_RESTART_WARN");
        JLabel warnLabel = new JLabel(label);
        warnLabel.setToolTipText(label);
        warnLabel.setForeground(Color.GRAY);
        warnLabel.setFont(warnLabel.getFont().deriveFont(8));
        warnLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        warnLabel.setHorizontalAlignment(4);
        localeConfigPanel.add(warnLabel);
        return localeConfigPanel;
    }

    private Component createSystrayeConfigPanel() {
        JPanel panel = GeneralConfigPluginActivator.createConfigSectionComponent(Resources.getString("service.systray.MODE"));
        final JComboBox<Item> systrayModes = new JComboBox<Item>();
        SystrayService ss = GeneralConfigPluginActivator.getSystrayService();
        for (Map.Entry mode : ss.getSystrayModes().entrySet()) {
            Item i = new Item((String)mode.getKey(), (String)mode.getValue());
            systrayModes.addItem(i);
            if (!((String)mode.getKey()).equals(ss.getActiveSystrayMode())) continue;
            systrayModes.setSelectedItem(i);
        }
        systrayModes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralConfigPluginActivator.getConfigurationService().setProperty("net.java.sip.communicator.osdependent.systemtray.MODE", (Object)((Item)systrayModes.getSelectedItem()).key);
            }
        });
        panel.add(systrayModes);
        String label = "<html><body style='width:350px'>* " + Resources.getString("service.systray.CLI_NOTE", new String[]{Resources.getSettingsString("service.gui.APPLICATION_NAME")}) + "</body></html>";
        JLabel warnLabel = new JLabel(label);
        warnLabel.setToolTipText(label);
        warnLabel.setForeground(Color.GRAY);
        warnLabel.setFont(warnLabel.getFont().deriveFont(8));
        warnLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        panel.add(warnLabel);
        return panel;
    }

    private Component createCallConfigPanel() {
        JPanel callConfigPanel = GeneralConfigPluginActivator.createConfigSectionComponent(Resources.getString("service.gui.CALL"));
        callConfigPanel.add(this.createNormalizeNumberCheckBox());
        callConfigPanel.add(this.createAcceptPhoneNumberWithAlphaCharCheckBox());
        return callConfigPanel;
    }

    private Component createNormalizeNumberCheckBox() {
        SIPCommCheckBox formatPhoneNumber = new SIPCommCheckBox(GeneralConfigPluginActivator.getResources().getI18NString("plugin.generalconfig.REMOVE_SPECIAL_PHONE_SYMBOLS"), ConfigurationUtils.isNormalizePhoneNumber());
        formatPhoneNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationUtils.setNormalizePhoneNumber((boolean)((JCheckBox)e.getSource()).isSelected());
            }
        });
        return formatPhoneNumber;
    }

    private Component createAcceptPhoneNumberWithAlphaCharCheckBox() {
        TransparentPanel checkBoxPanel = new TransparentPanel();
        checkBoxPanel.setLayout(new BoxLayout((Container)checkBoxPanel, 1));
        SIPCommCheckBox alphaCharNumbers = new SIPCommCheckBox(GeneralConfigPluginActivator.getResources().getI18NString("plugin.generalconfig.ACCEPT_PHONE_NUMBER_WITH_ALPHA_CHARS"), ConfigurationUtils.acceptPhoneNumberWithAlphaChars());
        alphaCharNumbers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurationUtils.setAcceptPhoneNumberWithAlphaChars((boolean)((JCheckBox)e.getSource()).isSelected());
            }
        });
        String label = "* " + Resources.getString("plugin.generalconfig.ACCEPT_PHONE_NUMBER_WITH_ALPHA_CHARS_EXAMPLE");
        JLabel exampleLabel = new JLabel(label);
        exampleLabel.setToolTipText(label);
        exampleLabel.setForeground(Color.GRAY);
        exampleLabel.setFont(exampleLabel.getFont().deriveFont(8));
        exampleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        exampleLabel.setHorizontalAlignment(2);
        checkBoxPanel.add((Component)alphaCharNumbers);
        checkBoxPanel.add(exampleLabel);
        return checkBoxPanel;
    }

    public Component createStartupConfigPanel() {
        JPanel updateConfigPanel = GeneralConfigPluginActivator.createConfigSectionComponent(Resources.getString("plugin.generalconfig.STARTUP_CONFIG"));
        updateConfigPanel.add(this.createMinimzeInsteadOfHideCheckBox());
        if (OSUtils.IS_WINDOWS) {
            updateConfigPanel.add(this.createAutoStartCheckBox());
            updateConfigPanel.add(this.createUpdateCheckBox());
        }
        return updateConfigPanel;
    }

    public Component createUpdateCheckBox() {
        SIPCommCheckBox updateCheckBox = new SIPCommCheckBox();
        updateCheckBox.setText(Resources.getString("plugin.generalconfig.CHECK_FOR_UPDATES"));
        updateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralConfigPluginActivator.getConfigurationService().setProperty("net.java.sip.communicator.plugin.updatechecker.ENABLED", (Object)Boolean.toString(((JCheckBox)e.getSource()).isSelected()));
            }
        });
        updateCheckBox.setSelected(GeneralConfigPluginActivator.getConfigurationService().getBoolean("net.java.sip.communicator.plugin.updatechecker.ENABLED", true));
        return updateCheckBox;
    }

    private void setAutostart(boolean isAutoStart) throws Exception {
        String workingDir = new File(".").getCanonicalPath();
        WindowsStartup.setAutostart(this.getApplicationName(), workingDir, isAutoStart);
    }

    private static class Item {
        public String key;
        public String value;

        public Item(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return GeneralConfigPluginActivator.getResources().getI18NString(this.value);
        }
    }

    private static class LanguageDropDownRenderer
    extends JPanel
    implements ListCellRenderer {
        JLabel[] labels = new JLabel[3];

        public LanguageDropDownRenderer() {
            this.setLayout(new GridLayout(0, 3));
            for (int i = 0; i < this.labels.length; ++i) {
                this.labels[i] = new JLabel();
                this.add(this.labels[i]);
            }
            this.labels[2].setHorizontalAlignment(4);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            LocaleItem lm = (LocaleItem)value;
            if (value != null) {
                this.labels[0].setText(lm.locale.getDisplayName());
                this.labels[1].setText(lm.locale.getDisplayName(lm.locale));
                this.labels[2].setText(Resources.getString("plugin.generalconfig.DEFAULT_LANGUAGE_TRANSLATED", new String[]{Integer.toString(lm.translated)}));
            } else {
                this.labels[0].setText("");
                this.labels[1].setText("");
                this.labels[2].setText("");
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }

    private static class LocaleItem
    implements Comparable<LocaleItem> {
        private Locale locale;
        private int translated;

        public LocaleItem(Locale locale, int translated) {
            this.locale = locale;
            this.translated = translated;
        }

        @Override
        public int compareTo(LocaleItem o) {
            return this.locale.getDisplayLanguage().compareTo(o.locale.getDisplayLanguage());
        }
    }
}

