/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.notificationconfiguration;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.java.sip.communicator.plugin.notificationconfiguration.NotificationConfigurationActivator;
import net.java.sip.communicator.plugin.notificationconfiguration.NotificationConfigurationPanel;
import net.java.sip.communicator.plugin.notificationconfiguration.NotificationEntry;
import net.java.sip.communicator.plugin.notificationconfiguration.Resources;
import net.java.sip.communicator.plugin.notificationconfiguration.StringTableRenderer;
import net.java.sip.communicator.plugin.notificationconfiguration.TableHeaderRenderer;
import net.java.sip.communicator.service.notification.CommandNotificationAction;
import net.java.sip.communicator.service.notification.NotificationAction;
import net.java.sip.communicator.service.notification.NotificationChangeListener;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.notification.PopupMessageNotificationAction;
import net.java.sip.communicator.service.notification.SoundNotificationAction;
import net.java.sip.communicator.service.notification.event.NotificationActionTypeEvent;
import net.java.sip.communicator.service.notification.event.NotificationEventTypeEvent;

public class NotificationsTable
extends JScrollPane
implements NotificationChangeListener {
    private static final long serialVersionUID = 0L;
    public static final String ENABLED = "Enabled";
    public static final String DISABLED = "Disabled";
    private final NotificationTable notifTable;
    private final NotificationsTableModel model;
    private final NotificationConfigurationPanel configPanel;
    private NotificationService notificationService = null;

    NotificationsTable(Object[] columns, String[] columnToolTips, NotificationConfigurationPanel panel) {
        this.configPanel = panel;
        this.notificationService = NotificationConfigurationActivator.getNotificationService();
        this.notificationService.addNotificationChangeListener((NotificationChangeListener)this);
        String strTmp = new String();
        this.model = new NotificationsTableModel(columns, 0);
        this.notifTable = new NotificationTable((TableModel)this.model, columnToolTips);
        this.notifTable.setRowSelectionAllowed(true);
        this.notifTable.getTableHeader().setReorderingAllowed(false);
        this.notifTable.setSelectionMode(0);
        this.notifTable.addMouseListener(new NotificationsCellListener());
        this.notifTable.setDefaultRenderer(String.class, new StringTableRenderer());
        this.notifTable.setDefaultRenderer(NotificationEntry.class, new StringTableRenderer());
        this.notifTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row;
                if (!e.getValueIsAdjusting() && (row = NotificationsTable.this.notifTable.getSelectedRow()) > -1) {
                    NotificationsTable.this.configPanel.setNotificationEntry(NotificationsTable.this.getNotificationEntry(row));
                }
            }
        });
        this.initTableData();
        if (columns.length != 0) {
            TableRowSorter<NotificationsTableModel> sorter = new TableRowSorter<NotificationsTableModel>(this.model);
            int column = columns.length - 1;
            List<RowSorter.SortKey> sortKeys = Arrays.asList(new RowSorter.SortKey(column, SortOrder.ASCENDING));
            sorter.setComparator(column, new Comparator<NotificationEntry>(){

                @Override
                public int compare(NotificationEntry ne1, NotificationEntry ne2) {
                    String s1 = Resources.getString("plugin.notificationconfig.event." + ne1.getEvent());
                    String s2 = Resources.getString("plugin.notificationconfig.event." + ne2.getEvent());
                    if (s1 == null) {
                        return s2 == null ? 0 : -1;
                    }
                    return s2 == null ? 1 : s1.compareTo(s2);
                }
            });
            sorter.setSortKeys(sortKeys);
            this.notifTable.setRowSorter(sorter);
        }
        for (int i = 0; i < columns.length; ++i) {
            TableColumn tmp = this.notifTable.getColumnModel().getColumn(i);
            if (columns[i].getClass() != strTmp.getClass()) {
                tmp.setHeaderRenderer(new TableHeaderRenderer((JLabel)columns[i]));
                tmp.setHeaderValue("");
            } else {
                tmp.setHeaderValue(columns[i]);
            }
            if (i >= columns.length - 1) continue;
            tmp.setMaxWidth(25);
            tmp.setMinWidth(25);
            tmp.setPreferredWidth(25);
        }
        this.getViewport().add(this.notifTable);
    }

    private void initTableData() {
        for (String eventType : this.notificationService.getRegisteredEvents()) {
            PopupMessageNotificationAction popupHandler = (PopupMessageNotificationAction)this.notificationService.getEventNotificationAction(eventType, "PopupMessageAction");
            CommandNotificationAction programHandler = (CommandNotificationAction)this.notificationService.getEventNotificationAction(eventType, "CommandAction");
            SoundNotificationAction soundHandler = (SoundNotificationAction)this.notificationService.getEventNotificationAction(eventType, "SoundAction");
            NotificationEntry entry = new NotificationEntry(this.notificationService.isActive(eventType), programHandler != null && programHandler.isEnabled(), programHandler != null ? programHandler.getDescriptor() : null, popupHandler != null && popupHandler.isEnabled(), soundHandler != null && soundHandler.isEnabled() && soundHandler.isSoundNotificationEnabled(), soundHandler != null && soundHandler.isEnabled() && soundHandler.isSoundPlaybackEnabled(), soundHandler != null && soundHandler.isEnabled() && soundHandler.isSoundPCSpeakerEnabled(), soundHandler != null ? soundHandler.getDescriptor() : null, eventType);
            this.addEntry(entry);
        }
    }

    private void addEntry(NotificationEntry entry) {
        Object[] row = new Object[]{entry.getEnabled(), entry.getProgram() ? ENABLED : DISABLED, entry.getPopup() ? ENABLED : DISABLED, entry.getSoundNotification() ? ENABLED : DISABLED, entry.getSoundPlayback() ? ENABLED : DISABLED, entry.getSoundPCSpeaker() ? ENABLED : DISABLED, entry};
        this.addLine(row);
    }

    private void setEntry(NotificationEntry entry) {
        int row = this.indexOfEntry(entry);
        this.notifTable.setValueAt(new Boolean(entry.getEnabled()), row, 0);
        this.notifTable.setValueAt(entry.getProgram() ? ENABLED : DISABLED, row, 1);
        this.notifTable.setValueAt(entry.getPopup() ? ENABLED : DISABLED, row, 2);
        this.notifTable.setValueAt(entry.getSoundNotification() ? ENABLED : DISABLED, row, 3);
        this.notifTable.setValueAt(entry.getSoundPlayback() ? ENABLED : DISABLED, row, 4);
        this.notifTable.setValueAt(entry.getSoundPCSpeaker() ? ENABLED : DISABLED, row, 5);
        this.notifTable.setValueAt(entry, row, 6);
    }

    private void removeEntry(NotificationEntry entry) {
        int row = this.indexOfEntry(entry);
        this.notifTable.removeRowSelectionInterval(row, row);
    }

    private void addLine(Object[] data) {
        if (data.length == this.model.getColumnCount()) {
            this.model.addRow(data);
        }
    }

    public int getSelectedRow() {
        return this.notifTable.getSelectedRow();
    }

    public int getRowCount() {
        return this.notifTable.getRowCount();
    }

    public void setSelectedRow(int row) {
        this.notifTable.setRowSelectionInterval(row, row);
    }

    public NotificationEntry getNotificationEntry(int row) {
        return (NotificationEntry)this.notifTable.getValueAt(row, this.notifTable.getColumnCount() - 1);
    }

    private NotificationEntry getNotificationEntry(String eventName) {
        for (int row = 0; row < this.notifTable.getRowCount(); ++row) {
            NotificationEntry entry = this.getNotificationEntry(row);
            if (entry.getEvent() != eventName) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.notifTable.addMouseListener(l);
    }

    public int rowAtPoint(Point point) {
        return this.notifTable.rowAtPoint(point);
    }

    private int indexOfEntry(NotificationEntry entry) {
        for (int row = 0; row < this.notifTable.getRowCount(); ++row) {
            NotificationEntry e = this.getNotificationEntry(row);
            if (!e.equals(entry)) continue;
            return row;
        }
        return -1;
    }

    public static Icon getColumnIconValue(int column) {
        if (column == 1) {
            return new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.PROG_ICON"));
        }
        if (column == 2) {
            return new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.POPUP_ICON"));
        }
        if (column == 3) {
            return new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.SOUND_ICON_NOTIFY"));
        }
        if (column == 4) {
            return new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.SOUND_ICON_PLAYBACK"));
        }
        if (column == 5) {
            return new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.SOUND_ICON"));
        }
        return null;
    }

    public void actionAdded(NotificationActionTypeEvent event) {
        boolean isActionEnabled;
        String eventName = event.getSourceEventType();
        NotificationEntry entry = this.getNotificationEntry(eventName);
        NotificationAction handler = event.getActionHandler();
        boolean bl = isActionEnabled = handler != null && handler.isEnabled();
        if (entry == null) {
            entry = new NotificationEntry();
            this.addEntry(entry);
        }
        entry.setEvent(eventName);
        if (event.getActionHandler().getActionType().equals("PopupMessageAction")) {
            entry.setPopup(isActionEnabled);
        } else if (event.getActionHandler().getActionType().equals("CommandAction")) {
            entry.setProgram(isActionEnabled);
            entry.setProgramFile(((CommandNotificationAction)event.getActionHandler()).getDescriptor());
        } else if (event.getActionHandler().getActionType().equals("SoundAction")) {
            entry.setSoundNotification(isActionEnabled);
            entry.setSoundPlayback(isActionEnabled);
            entry.setSoundFile(((SoundNotificationAction)event.getActionHandler()).getDescriptor());
        }
        entry.setEnabled(this.notificationService.isActive(eventName));
        this.setEntry(entry);
        this.notifTable.repaint();
    }

    public void actionRemoved(NotificationActionTypeEvent event) {
        String eventName = event.getSourceEventType();
        NotificationEntry entry = this.getNotificationEntry(eventName);
        if (entry == null) {
            return;
        }
        if (event.getActionHandler().getActionType().equals("PopupMessageAction")) {
            entry.setPopup(false);
        } else if (event.getActionHandler().getActionType().equals("CommandAction")) {
            entry.setProgram(false);
            entry.setProgramFile("");
        } else if (event.getActionHandler().getActionType().equals("SoundAction")) {
            entry.setSoundNotification(false);
            entry.setSoundPlayback(false);
            entry.setSoundPCSpeaker(false);
            entry.setSoundFile("");
        }
        this.setEntry(entry);
        this.notifTable.repaint();
    }

    public void actionChanged(NotificationActionTypeEvent event) {
        String eventName = event.getSourceEventType();
        NotificationEntry entry = this.getNotificationEntry(eventName);
        if (entry == null) {
            return;
        }
        if (event.getActionHandler().getActionType().equals("CommandAction")) {
            entry.setProgramFile(((CommandNotificationAction)event.getActionHandler()).getDescriptor());
        } else if (event.getActionHandler().getActionType().equals("SoundAction")) {
            entry.setSoundFile(((SoundNotificationAction)event.getActionHandler()).getDescriptor());
        }
        entry.setEnabled(this.notificationService.isActive(eventName));
        this.setEntry(entry);
        this.notifTable.repaint();
    }

    public void eventTypeAdded(NotificationEventTypeEvent event) {
        String eventName = event.getSourceEventType();
        NotificationEntry entry = this.getNotificationEntry(eventName);
        if (entry == null) {
            PopupMessageNotificationAction popupHandler = (PopupMessageNotificationAction)this.notificationService.getEventNotificationAction(eventName, "PopupMessageAction");
            CommandNotificationAction programHandler = (CommandNotificationAction)this.notificationService.getEventNotificationAction(eventName, "CommandAction");
            SoundNotificationAction soundHandler = (SoundNotificationAction)this.notificationService.getEventNotificationAction(eventName, "SoundAction");
            entry = new NotificationEntry(this.notificationService.isActive(event.getSourceEventType()), programHandler != null && programHandler.isEnabled(), programHandler != null ? programHandler.getDescriptor() : null, popupHandler != null && popupHandler.isEnabled(), soundHandler != null && soundHandler.isSoundNotificationEnabled(), soundHandler != null && soundHandler.isSoundPlaybackEnabled(), soundHandler != null && soundHandler.isSoundPCSpeakerEnabled(), soundHandler != null ? soundHandler.getDescriptor() : null, eventName);
            this.addEntry(entry);
            this.notifTable.repaint();
        }
    }

    public void eventTypeRemoved(NotificationEventTypeEvent event) {
        String eventName = event.getSourceEventType();
        NotificationEntry entry = this.getNotificationEntry(eventName);
        if (entry != null) {
            this.removeEntry(entry);
        }
        this.notifTable.repaint();
    }

    public void clear() {
        int numrows = this.model.getRowCount();
        for (int i = numrows - 1; i >= 0; --i) {
            this.model.removeRow(i);
        }
    }

    private class NotificationsCellListener
    extends MouseAdapter {
        private NotificationsCellListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row = NotificationsTable.this.notifTable.rowAtPoint(e.getPoint());
            int col = NotificationsTable.this.notifTable.columnAtPoint(e.getPoint());
            Object o = NotificationsTable.this.notifTable.getValueAt(row, col);
            if (col > 0 && col < 6) {
                if (o.equals(NotificationsTable.ENABLED)) {
                    NotificationsTable.this.notifTable.setValueAt(NotificationsTable.DISABLED, row, col);
                } else {
                    NotificationsTable.this.notifTable.setValueAt(NotificationsTable.ENABLED, row, col);
                }
            }
            NotificationEntry entry = NotificationsTable.this.getNotificationEntry(row);
            switch (col) {
                case 0: {
                    boolean isActive = NotificationsTable.this.notifTable.getValueAt(row, 0).equals(Boolean.TRUE);
                    entry.setEnabled(isActive);
                    NotificationsTable.this.notificationService.setActive(entry.getEvent(), isActive);
                    NotificationsTable.this.notifTable.repaint();
                    break;
                }
                case 1: {
                    boolean isProgram = NotificationsTable.this.notifTable.getValueAt(row, 1).equals(NotificationsTable.ENABLED);
                    entry.setProgram(isProgram);
                    if (isProgram) {
                        NotificationsTable.this.notificationService.registerNotificationForEvent(entry.getEvent(), "CommandAction", entry.getProgramFile(), "");
                        break;
                    }
                    NotificationsTable.this.notificationService.removeEventNotificationAction(entry.getEvent(), "CommandAction");
                    break;
                }
                case 2: {
                    boolean isPopup = NotificationsTable.this.notifTable.getValueAt(row, 2).equals(NotificationsTable.ENABLED);
                    entry.setPopup(isPopup);
                    if (isPopup) {
                        NotificationsTable.this.notificationService.registerNotificationForEvent(entry.getEvent(), "PopupMessageAction", "", "");
                        break;
                    }
                    NotificationsTable.this.notificationService.removeEventNotificationAction(entry.getEvent(), "PopupMessageAction");
                    break;
                }
                case 3: {
                    boolean isSoundNotification = NotificationsTable.this.notifTable.getValueAt(row, 3).equals(NotificationsTable.ENABLED);
                    entry.setSoundNotification(isSoundNotification);
                    SoundNotificationAction soundNotificationAction = (SoundNotificationAction)NotificationsTable.this.notificationService.getEventNotificationAction(entry.getEvent(), "SoundAction");
                    soundNotificationAction.setSoundNotificationEnabled(isSoundNotification);
                    NotificationsTable.this.notificationService.registerNotificationForEvent(entry.getEvent(), (NotificationAction)soundNotificationAction);
                    break;
                }
                case 4: {
                    boolean isSoundPlayback = NotificationsTable.this.notifTable.getValueAt(row, 4).equals(NotificationsTable.ENABLED);
                    entry.setSoundPlayback(isSoundPlayback);
                    SoundNotificationAction soundPlaybackAction = (SoundNotificationAction)NotificationsTable.this.notificationService.getEventNotificationAction(entry.getEvent(), "SoundAction");
                    soundPlaybackAction.setSoundPlaybackEnabled(isSoundPlayback);
                    NotificationsTable.this.notificationService.registerNotificationForEvent(entry.getEvent(), (NotificationAction)soundPlaybackAction);
                    break;
                }
                case 5: {
                    boolean isPCSpeakerSound = NotificationsTable.this.notifTable.getValueAt(row, 5).equals(NotificationsTable.ENABLED);
                    entry.setSoundPCSpeaker(isPCSpeakerSound);
                    SoundNotificationAction soundPCSpeakerAction = (SoundNotificationAction)NotificationsTable.this.notificationService.getEventNotificationAction(entry.getEvent(), "SoundAction");
                    soundPCSpeakerAction.setSoundPCSpeakerEnabled(isPCSpeakerSound);
                    NotificationsTable.this.notificationService.registerNotificationForEvent(entry.getEvent(), (NotificationAction)soundPCSpeakerAction);
                }
            }
            NotificationsTable.this.configPanel.setNotificationEntry(entry);
        }
    }

    private class NotificationsTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 0L;

        NotificationsTableModel(Object[] columns, int rowCount) {
            super(columns, rowCount);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }
    }

    static class NotificationTable
    extends JTable {
        private static final long serialVersionUID = 0L;
        private String[] columnToolTips;

        NotificationTable(TableModel model, String[] toolTips) {
            super(model);
            this.columnToolTips = toolTips;
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){
                private static final long serialVersionUID = 0L;

                @Override
                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int index = this.columnModel.getColumnIndexAtX(p.x);
                    int realIndex = this.columnModel.getColumn(index).getModelIndex();
                    return Resources.getString(columnToolTips[realIndex]);
                }
            };
        }
    }
}

